/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualPath
implements Cloneable {
    private static final Pattern VOLNAME = Pattern.compile("([A-Za-z]:)[/\\\\](.*)");
    private static final Pattern PROTOCOL = Pattern.compile("([A-Za-z]*://)(.*)");
    private LinkedList<String> segments;
    private String device;
    private char sepChar;

    public VirtualPath(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (path.startsWith("\\\\")) {
            this.sepChar = (char)92;
            this.device = "\\\\";
            path = path.substring(2);
        }
        if (path.startsWith("\\")) {
            this.sepChar = (char)92;
            this.device = "\\";
            path = path.substring(1);
        } else {
            Matcher m = VOLNAME.matcher(path);
            if (m.matches()) {
                this.sepChar = (char)92;
                this.device = String.valueOf(m.group(1)) + "\\";
                path = m.group(2);
            } else if (path.startsWith("/")) {
                this.sepChar = (char)47;
                this.device = "/";
            } else {
                m = PROTOCOL.matcher(path);
                if (m.matches()) {
                    this.sepChar = (char)47;
                    this.device = m.group(1);
                    path = m.group(2);
                } else {
                    throw new IllegalArgumentException("Illegal or not full path: " + path);
                }
            }
        }
        StringTokenizer st = new StringTokenizer(path, "/\\");
        this.segments = new LinkedList();
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (segment.length() <= 0) continue;
            this.segments.add(segment);
        }
    }

    public static boolean isAbsolute(String path) {
        return path.startsWith("\\\\") || VOLNAME.matcher(path).matches() || path.startsWith("/") || PROTOCOL.matcher(path).matches();
    }

    protected VirtualPath(String device, char sepChar, LinkedList<String> segments) {
        this.device = device;
        this.sepChar = sepChar;
        this.segments = segments;
    }

    public String getLastSegment() {
        return this.segments.getLast();
    }

    public int getSegmentsCount() {
        return this.segments.size();
    }

    public String removeFirstSegment() {
        return this.segments.removeFirst();
    }

    public String removeLastSegment() {
        return this.segments.removeLast();
    }

    public void addLastSegment(String segment) {
        this.segments.addLast(segment);
    }

    public String[] getSegments() {
        return this.segments.toArray(new String[this.segments.size()]);
    }

    public char getSeparatorChar() {
        return this.sepChar;
    }

    public boolean isPrefixOf(VirtualPath path) {
        Iterator i1 = this.segments.iterator();
        Iterator i2 = path.segments.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (((String)i1.next()).equals(i2.next())) continue;
            return false;
        }
        return !i1.hasNext();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.device);
        Iterator i = this.segments.iterator();
        while (i.hasNext()) {
            buf.append((String)i.next());
            if (!i.hasNext()) continue;
            buf.append(this.sepChar);
        }
        return buf.toString();
    }

    public VirtualPath clone() {
        LinkedList<String> segments = new LinkedList<String>();
        Iterator i = this.segments.iterator();
        while (i.hasNext()) {
            segments.add((String)i.next());
        }
        VirtualPath path = new VirtualPath(this.device, this.sepChar, segments);
        return path;
    }

    public int hashCode() {
        return this.device.hashCode() + 13 * this.segments.hashCode() + 31 * this.sepChar;
    }

    public boolean equals(Object obj) {
        boolean segmentsEqual;
        if (!(obj instanceof VirtualPath)) {
            return false;
        }
        VirtualPath other = (VirtualPath)obj;
        boolean bl = segmentsEqual = other.segments.size() == this.segments.size();
        if (segmentsEqual) {
            Iterator i = this.segments.iterator();
            Iterator j = other.segments.iterator();
            while (segmentsEqual && i.hasNext() && j.hasNext()) {
                segmentsEqual &= ((String)i.next()).equalsIgnoreCase((String)j.next());
            }
        }
        return other.device.equalsIgnoreCase(this.device) && segmentsEqual && other.sepChar == this.sepChar;
    }
}

