/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

public class PathEntry {
    private Object container;
    private VirtualPath abstractPath;
    private Type type;

    public PathEntry(String path, Type type, Object container) {
        this(new VirtualPath(path), type, container);
    }

    public PathEntry(VirtualPath path, Type type, Object container) {
        this.abstractPath = path;
        this.type = type;
        this.container = container;
    }

    public VirtualPath getAbstractPath() {
        return this.abstractPath;
    }

    public Type getType() {
        return this.type;
    }

    public Object getContainer() {
        return this.container;
    }

    public String getPath() {
        return this.abstractPath.toString();
    }

    public String getResolvedPath() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathEntry)) {
            return false;
        }
        PathEntry other = (PathEntry)obj;
        return other.abstractPath.equals(this.abstractPath) && other.type == this.type;
    }

    public int hashCode() {
        return this.abstractPath.hashCode() + 13 * this.type.ordinal();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Path Entry: ");
        buf.append(this.abstractPath).append(" (").append((Object)this.type).append(")");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        WORKSPACE("Workspace File"),
        INCLUDE_VAR("Include Path Variable"),
        INCLUDE_FOLDER("Include Path Folder"),
        EXTERNAL("External File");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

