/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class FormalParameter
extends Argument {
    private final SimpleReference parameterType;
    private final VariableReference parameterName;
    private final boolean isMandatory;

    private FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName, Expression defaultValue, boolean isMandatory) {
        super((SimpleReference)parameterName, start, end, (ASTNode)defaultValue, 0);
        SimpleReference ref = this.getRef();
        if (ref != null) {
            ref.setStart(parameterName.sourceStart());
            ref.setEnd(parameterName.sourceEnd());
        }
        assert (parameterName != null);
        this.parameterType = type;
        this.parameterName = parameterName;
        this.isMandatory = isMandatory;
    }

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName, Expression defaultValue) {
        this(start, end, type, parameterName, defaultValue, false);
    }

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName, boolean isMandatory) {
        this(start, end, type, parameterName, null, isMandatory);
    }

    public FormalParameter(int start, int end, SimpleReference type, VariableReference parameterName) {
        this(start, end, type, parameterName, null, true);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            if (this.parameterType != null) {
                this.parameterType.traverse(visitor);
            }
            this.parameterName.traverse(visitor);
            Expression defaultValue = (Expression)this.getInitialization();
            if (defaultValue != null) {
                defaultValue.traverse(visitor);
            }
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 27;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public VariableReference getParameterName() {
        return this.parameterName;
    }

    public SimpleReference getParameterType() {
        return this.parameterType;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

