/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class TypeBinding
implements ITypeBinding {
    private IEvaluatedType type;
    private IModelElement[] elements;
    private BindingResolver resolver;
    private IType[] superTypes;
    private ITypeBinding superClass;
    private ITypeBinding[] interfaces;
    private IVariableBinding[] fields;
    private IMethodBinding[] methods;
    private Map<IType, ITypeHierarchy> hierarchy = new HashMap<IType, ITypeHierarchy>();

    public TypeBinding(BindingResolver resolver, IEvaluatedType type, IModelElement[] elements) {
        this.resolver = resolver;
        this.type = type;
        if (elements != null && elements.length > 0) {
            int length = elements.length;
            this.elements = new IModelElement[length];
            System.arraycopy(elements, 0, this.elements, 0, length);
        } else {
            this.elements = new IModelElement[0];
        }
    }

    public TypeBinding(BindingResolver resolver, IEvaluatedType type, IModelElement element) {
        this.resolver = resolver;
        this.type = type;
        this.elements = element != null ? new IModelElement[]{element} : new IModelElement[0];
    }

    public ITypeBinding createArrayType(int dimension) {
        return null;
    }

    public String getBinaryName() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0].getHandleIdentifier();
    }

    public ITypeBinding getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return null;
    }

    public IVariableBinding[] getDeclaredFields() {
        if (this.isUnknown()) {
            return new IVariableBinding[0];
        }
        if (this.fields == null) {
            if (this.isClass()) {
                ArrayList<IVariableBinding> variableBindings = new ArrayList<IVariableBinding>();
                IModelElement[] iModelElementArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        IModelElement element = iModelElementArray[n2];
                        IType type = (IType)element;
                        try {
                            IField[] fields = type.getFields();
                            int i = 0;
                            while (i < fields.length) {
                                IVariableBinding variableBinding = this.resolver.getVariableBinding(fields[i]);
                                if (variableBinding != null) {
                                    variableBindings.add(variableBinding);
                                }
                                ++i;
                            }
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block9;
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                this.fields = variableBindings.toArray(new IVariableBinding[variableBindings.size()]);
            } else {
                this.fields = new IVariableBinding[0];
            }
        }
        return this.fields;
    }

    public IMethodBinding[] getDeclaredMethods() {
        if (this.isUnknown()) {
            return new IMethodBinding[0];
        }
        if (this.methods == null) {
            if (this.isClass()) {
                ArrayList<IMethodBinding> methodBindings = new ArrayList<IMethodBinding>();
                IModelElement[] iModelElementArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        IModelElement element = iModelElementArray[n2];
                        IType type = (IType)element;
                        try {
                            IMethod[] methods = type.getMethods();
                            if (methods != null) {
                                int i = 0;
                                while (i < methods.length) {
                                    IMethodBinding methodBinding = this.resolver.getMethodBinding(methods[i]);
                                    methodBindings.add(methodBinding);
                                    ++i;
                                }
                            }
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block9;
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                this.methods = methodBindings.toArray(new IMethodBinding[methodBindings.size()]);
            } else {
                this.methods = new IMethodBinding[0];
            }
        }
        return this.methods;
    }

    public int getModifiers() {
        this.isClass();
        return -1;
    }

    public int getDimensions() {
        return 0;
    }

    public ITypeBinding getElementType() {
        if (this.elements == null || this.elements.length != 1) {
            return null;
        }
        return null;
    }

    public ITypeBinding[] getInterfaces() {
        if (this.isUnknown()) {
            return new ITypeBinding[0];
        }
        if (this.interfaces == null) {
            IType[] types = this.getSuperTypes();
            LinkedList<ITypeBinding> interfaces = new LinkedList<ITypeBinding>();
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IType type = iTypeArray[n2];
                    try {
                        if (PHPFlags.isInterface((int)type.getFlags())) {
                            interfaces.add(this.resolver.getTypeBinding(type));
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            this.interfaces = interfaces.toArray(new ITypeBinding[interfaces.size()]);
        }
        return this.interfaces;
    }

    public String getName() {
        return this.isUnknown() ? null : this.type.getTypeName();
    }

    protected IType[] getSuperTypes() {
        if (this.superTypes == null) {
            if (this.elements != null && this.elements.length > 0) {
                SearchEngine.createSearchScope((IModelElement)this.elements[0].getScriptProject());
                HashSet<String> superTypeNames = new HashSet<String>();
                IModelElement[] iModelElementArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block13: {
                        IModelElement element = iModelElementArray[n2];
                        IType type = (IType)element;
                        try {
                            String[] superClassNames = type.getSuperClasses();
                            if (superClassNames != null) {
                                String[] stringArray = superClassNames;
                                int n3 = superClassNames.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String name = stringArray[n4];
                                    if (!superTypeNames.contains(name)) {
                                        superTypeNames.add(name);
                                    }
                                    ++n4;
                                }
                            }
                        }
                        catch (CoreException e) {
                            if (!DLTKCore.DEBUG) break block13;
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                ArrayList<IType> typeList = new ArrayList<IType>();
                List<IModelElement> elementList = Arrays.asList(this.elements);
                for (String superTypeName : superTypeNames) {
                    try {
                        ISourceModule sourceModule = (ISourceModule)this.elements[0].getAncestor(5);
                        String typeName = PHPModelUtils.extractElementName(superTypeName);
                        String nameSpace = PHPModelUtils.extractNameSapceName(superTypeName);
                        Collection<IType> types = this.resolver.getModelAccessCache().getClassesOrInterfaces(sourceModule, typeName, nameSpace, null);
                        if (types == null) continue;
                        for (IType type : types) {
                            if (elementList.contains(type)) continue;
                            typeList.add(type);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) continue;
                        e.printStackTrace();
                    }
                }
                this.superTypes = typeList.size() > 0 ? typeList.toArray(new IType[typeList.size()]) : new IType[0];
            } else {
                this.superTypes = new IType[0];
            }
        }
        return this.superTypes;
    }

    public ITypeBinding getSuperclass() {
        if (this.isUnknown()) {
            return null;
        }
        if (this.superClass == null) {
            IType[] types = this.getSuperTypes();
            LinkedList<IType> superClasses = new LinkedList<IType>();
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IType type = iTypeArray[n2];
                    try {
                        if (!PHPFlags.isInterface((int)type.getFlags())) {
                            superClasses.add(type);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            this.superClass = this.resolver.getTypeBinding(superClasses.toArray(new IType[superClasses.size()]));
        }
        return this.superClass;
    }

    public ITypeBinding getTypeDeclaration() {
        return null;
    }

    public boolean isArray() {
        return this.type.getClass() == MultiTypeType.class;
    }

    public boolean isClass() {
        if (this.isUnknown()) {
            return false;
        }
        return this.type.getClass() == PHPClassType.class;
    }

    public boolean isInterface() {
        if (this.isUnknown()) {
            return false;
        }
        boolean result = true;
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IModelElement element = iModelElementArray[n2];
                IType member = (IType)element;
                try {
                    result &= (member.getFlags() & 8) != 0;
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return result;
    }

    public boolean isNullType() {
        if (this.type instanceof SimpleType) {
            return ((SimpleType)this.type).getType() == 8;
        }
        return false;
    }

    public boolean isPrimitive() {
        return this.type.getClass() == SimpleType.class && !this.isNullType();
    }

    public boolean isSubTypeCompatible(ITypeBinding otherType) {
        if (otherType == null || this.elements == null || this.elements.length == 0) {
            return false;
        }
        boolean isSubTypeCompatible = false;
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IType type;
                block8: {
                    IModelElement element = iModelElementArray[n2];
                    type = (IType)element;
                    if (type.getSuperClasses() != null && type.getSuperClasses().length != 0) break block8;
                    return false;
                }
                try {
                    IModelElement[] otherElements;
                    ITypeHierarchy supertypeHierarchy = this.hierarchy.get(type);
                    if (supertypeHierarchy == null) {
                        supertypeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        this.hierarchy.put(type, supertypeHierarchy);
                    }
                    if ((otherElements = ((TypeBinding)otherType).elements) == null) break block9;
                    IModelElement[] iModelElementArray2 = otherElements;
                    int n3 = otherElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModelElement modelElement = iModelElementArray2[n4];
                        if (modelElement instanceof IType && supertypeHierarchy.contains((IType)modelElement)) {
                            isSubTypeCompatible = true;
                            break;
                        }
                        ++n4;
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return isSubTypeCompatible;
    }

    public String getKey() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0].getHandleIdentifier();
    }

    public int getKind() {
        return 2;
    }

    public IModelElement getPHPElement() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0];
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TypeBinding)) {
            return false;
        }
        TypeBinding otherBinding = (TypeBinding)other;
        if (!this.type.equals(otherBinding.type)) {
            return false;
        }
        if (this.elements == null) {
            return otherBinding.elements == null;
        }
        if (this.elements.length != otherBinding.elements.length) {
            return false;
        }
        int i = 0;
        while (i < this.elements.length) {
            boolean hasEqual = false;
            int j = 0;
            while (j < otherBinding.elements.length) {
                if (this.elements[i].equals(otherBinding.elements[j])) {
                    hasEqual = true;
                    break;
                }
                ++j;
            }
            if (!hasEqual) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAmbiguous() {
        return !this.isUnknown() && this.elements.length != 1;
    }

    public boolean isUnknown() {
        return this.elements == null && !(this.type instanceof SimpleType);
    }
}

