/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;

public class WizardFragmentsFactoryRegistry {
    private static final String EXTENSION_POINT_NAME = "wizardAndCompositeFragments";
    private static final String FRAGMENT_TAG = "wizardAndCompositeFragment";
    private static final String ID_ATTRIBUTE = "id";
    private static final String FRAGMENTS_GROUP_ID = "fragmentsGroupID";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PLACE_AFTER_ATTRIBUTE = "placeAfter";
    private HashMap fragments;
    private static WizardFragmentsFactoryRegistry instance;
    private HashMap factories = new HashMap(4);

    public static ICompositeFragmentFactory[] getFragmentsFactories(String fragmentsGroupID) {
        WizardFragmentsFactoryRegistry registry = WizardFragmentsFactoryRegistry.getInstance();
        ICompositeFragmentFactory[] factories = (ICompositeFragmentFactory[])registry.factories.get(fragmentsGroupID);
        if (factories == null) {
            List fragments = (List)registry.fragments.get(fragmentsGroupID);
            ArrayList<ICompositeFragmentFactory> factoriesList = new ArrayList<ICompositeFragmentFactory>();
            int i = 0;
            while (i < fragments.size()) {
                FragmentsFactory factory = (FragmentsFactory)fragments.get(i);
                factoriesList.add(factory.createFragmentFactory());
                ++i;
            }
            factories = new ICompositeFragmentFactory[factoriesList.size()];
            factoriesList.toArray(factories);
            registry.factories.put(fragmentsGroupID, factories);
            registry.fragments.remove(fragmentsGroupID);
        }
        return factories;
    }

    private WizardFragmentsFactoryRegistry() {
        this.fragments = new HashMap(5);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (FRAGMENT_TAG.equals(element.getName())) {
                String id = element.getAttribute(ID_ATTRIBUTE);
                String groupID = element.getAttribute(FRAGMENTS_GROUP_ID);
                String placeAfter = element.getAttribute(PLACE_AFTER_ATTRIBUTE);
                ArrayList<FragmentsFactory> list = (ArrayList<FragmentsFactory>)this.fragments.get(groupID);
                if (list == null) {
                    list = new ArrayList<FragmentsFactory>(5);
                    this.fragments.put(groupID, list);
                }
                if (element.getNamespaceIdentifier().equals("org.eclipse.php.ui")) {
                    list.add(0, new FragmentsFactory(element, id, placeAfter));
                } else {
                    list.add(new FragmentsFactory(element, id, placeAfter));
                }
            }
            ++i;
        }
        Iterator keys = this.fragments.keySet().iterator();
        while (keys.hasNext()) {
            this.sortFragmentsByPlace((ArrayList)this.fragments.get(keys.next()));
        }
    }

    private void sortFragmentsByPlace(ArrayList fragments) {
        ArrayList rootsFragments = new ArrayList(fragments.size());
        ArrayList nonRootFragments = new ArrayList(fragments.size());
        int i = 0;
        while (i < fragments.size()) {
            FragmentsFactory factory = (FragmentsFactory)fragments.get(i);
            if (factory.getPlaceAfter() == null || factory.getPlaceAfter().equals("")) {
                this.addAsList(rootsFragments, factory);
            } else {
                this.addAsList(nonRootFragments, factory);
            }
            ++i;
        }
        i = 0;
        while (i < nonRootFragments.size()) {
            ArrayList fragmentsGroup = (ArrayList)nonRootFragments.get(i);
            boolean moved = this.placeFragment(rootsFragments, fragmentsGroup);
            if (!moved) {
                moved = this.placeFragment(nonRootFragments, fragmentsGroup);
            }
            if (!moved) {
                FragmentsFactory invalidFactory = this.getFactory(nonRootFragments, i);
                this.addAsList(rootsFragments, invalidFactory);
                PHPUiPlugin.log((IStatus)new Status(2, "org.eclipse.php.ui", 0, "Invalid 'placeAfter' id (" + invalidFactory.getPlaceAfter() + ')', null));
            }
            ++i;
        }
        fragments.clear();
        i = 0;
        while (i < rootsFragments.size()) {
            List list = (List)rootsFragments.get(i);
            int j = 0;
            while (j < list.size()) {
                fragments.add(list.get(j));
                ++j;
            }
            ++i;
        }
    }

    private boolean placeFragment(List targetFactories, ArrayList factoriesGroup) {
        if (factoriesGroup == null || factoriesGroup.size() == 0) {
            return true;
        }
        FragmentsFactory factory = (FragmentsFactory)factoriesGroup.get(0);
        String placeAfter = factory.getPlaceAfter();
        int i = 0;
        while (i < targetFactories.size()) {
            List list = (List)targetFactories.get(i);
            int j = 0;
            while (j < list.size()) {
                FragmentsFactory nextFactory = (FragmentsFactory)list.get(j);
                if (nextFactory.getID().equals(placeAfter)) {
                    if (list.size() > j + 1) {
                        list.addAll(j + 1, factoriesGroup);
                    } else {
                        list.addAll(factoriesGroup);
                    }
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private FragmentsFactory getFactory(List nonRootFragments, int i) {
        List list = (List)nonRootFragments.get(i);
        return (FragmentsFactory)list.get(0);
    }

    private void addAsList(List target, Object element) {
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(element);
        target.add(list);
    }

    private static WizardFragmentsFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new WizardFragmentsFactoryRegistry();
        }
        return instance;
    }

    private class FragmentsFactory {
        private IConfigurationElement element;
        private ICompositeFragmentFactory factory;
        private String id;
        private String placeAfter;

        public FragmentsFactory(IConfigurationElement element, String id, String placeAfter) {
            this.element = element;
            this.id = id;
            this.placeAfter = placeAfter;
        }

        public ICompositeFragmentFactory createFragmentFactory() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.server.ui.wizardAndCompositeFragments"){

                public void run() throws Exception {
                    FragmentsFactory.this.factory = (ICompositeFragmentFactory)FragmentsFactory.this.element.createExecutableExtension(WizardFragmentsFactoryRegistry.CLASS_ATTRIBUTE);
                }
            });
            return this.factory;
        }

        public String getID() {
            return this.id;
        }

        public String getPlaceAfter() {
            return this.placeAfter;
        }
    }
}

