/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.preferences.includepath.PHPBuildPathsBlock;
import org.eclipse.php.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardFirstPage;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardSecondPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class PHPProjectWizardThirdPage
extends PHPProjectWizardSecondPage {
    public PHPProjectWizardThirdPage(PHPProjectWizardFirstPage mainPage) {
        super(mainPage);
    }

    protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
        PHPBuildPathsBlock buildPathsBlock = new PHPBuildPathsBlock(new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
        return buildPathsBlock;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.updateProject((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    protected void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IBuildpathEntry[] rawBuildpath;
        IProject projectHandle = this.fFirstPage.getProjectHandle();
        IScriptProject scriptProject = DLTKCore.create((IProject)projectHandle);
        if (scriptProject != null) {
            rawBuildpath = new IBuildpathEntry[]{};
            if (scriptProject.isOpen()) {
                rawBuildpath = scriptProject.getRawBuildpath();
            }
        } else {
            throw new IllegalStateException();
        }
        this.init(scriptProject, rawBuildpath, true);
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        BuildpathsBlock fBuildPathsBlock;
        if (this.getContainer().getCurrentPage() == this && (fBuildPathsBlock = this.getBuildPathsBlock()).hasChangesInDialog()) {
            fBuildPathsBlock.configureScriptProject(monitor);
        }
    }

    protected void setHelpContext(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.php.help.configuring_build_paths");
    }
}

