/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalScriptProject;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class EditorUtility {
    public static final IEditorInput getEditorInput(IModelElement element) throws ModelException {
        while (element != null) {
            if (element instanceof ISourceModule) {
                PHPStructuredEditor editorPart;
                final ISourceModule unit = (ISourceModule)element;
                if (!(unit.getScriptProject() instanceof ExternalScriptProject) || (editorPart = (PHPStructuredEditor)EditorUtility.findOpenEditor(new IEditorLookupCondition(){

                    public boolean find(IEditorPart editorPart) {
                        return editorPart instanceof PHPStructuredEditor && ((PHPStructuredEditor)editorPart).getModelElement().equals(unit);
                    }
                })) == null) break;
                return editorPart.getEditorInput();
            }
            element = element.getParent();
        }
        return org.eclipse.dltk.internal.ui.editor.EditorUtility.getEditorInput((Object)element);
    }

    public static final PHPStructuredEditor getPHPStructuredEditor(IWorkbenchPart editor) {
        return editor != null ? (PHPStructuredEditor)editor.getAdapter(PHPStructuredEditor.class) : null;
    }

    public static final PHPStructuredEditor getPHPEditor(final ITextViewer textViewer) {
        return (PHPStructuredEditor)EditorUtility.findOpenEditor(new IEditorLookupCondition(){

            public boolean find(IEditorPart editorPart) {
                return editorPart instanceof PHPStructuredEditor && ((PHPStructuredEditor)editorPart).getTextViewer().getDocument() == textViewer.getDocument();
            }
        });
    }

    public static IEditorPart openLocalFile(String filePath, int lineNumber) throws CoreException {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(filePath);
        if (member instanceof IFile) {
            IEditorPart editor = org.eclipse.dltk.internal.ui.editor.EditorUtility.openInEditor((Object)member, (boolean)true);
            org.eclipse.dltk.internal.ui.editor.EditorUtility.revealInEditor((IEditorPart)editor, (int)lineNumber);
            return editor;
        }
        Path path = new Path(filePath);
        String parentPath = path.removeLastSegments(1).toOSString();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(parentPath));
        if (!(fileStore = fileStore.getChild(path.lastSegment())).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchPage page = DLTKUIPlugin.getActivePage();
            IEditorPart editorPart = null;
            try {
                editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                if (lineNumber >= 0) {
                    org.eclipse.dltk.internal.ui.editor.EditorUtility.revealInEditor((IEditorPart)editorPart, (int)(lineNumber - 1));
                }
                return editorPart;
            }
            catch (PartInitException e) {
                Logger.logException("Failed to open local file", e);
            }
        }
        return null;
    }

    private static IEditorPart findOpenEditor(IEditorLookupCondition cond) {
        IWorkbenchPage workbenchpage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart activeEditorPart = workbenchpage.getActiveEditor();
        if (cond.find(activeEditorPart)) {
            return activeEditorPart;
        }
        IEditorReference[] editorReferences = workbenchpage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference editorReference = editorReferences[i];
            IEditorPart editorPart = editorReference.getEditor(false);
            if (activeEditorPart != editorPart && cond.find(editorPart)) {
                return editorPart;
            }
            ++i;
        }
        return null;
    }

    private static interface IEditorLookupCondition {
        public boolean find(IEditorPart var1);
    }
}

