/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.template.contentassist;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.text.HTML2TextReader;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlCreatorExtension;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.php.internal.ui.editor.hover.PHPSourceViewerInformationControl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;

public final class TemplateInformationControlCreator
implements IInformationControlCreator,
IInformationControlCreatorExtension {
    private PHPSourceViewerInformationControl fControl;
    private int fOrientation;

    public TemplateInformationControlCreator(int orientation) {
        Assert.isLegal((orientation == 0x4000000 || orientation == 0x2000000 ? 1 : 0) != 0);
        this.fOrientation = orientation;
    }

    public IInformationControl createInformationControl(Shell parent) {
        this.fControl = new PHPSourceViewerInformationControl(parent, this.fOrientation){

            public void setInformation(String content) {
                TextPresentation presentation = new TextPresentation();
                HTML2TextReader reader = new HTML2TextReader((Reader)new StringReader(content), presentation);
                try {
                    super.setInformation(reader.getString());
                }
                catch (IOException iOException) {}
            }
        };
        this.fControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TemplateInformationControlCreator.this.fControl = null;
            }
        });
        return this.fControl;
    }

    public boolean canReuse(IInformationControl control) {
        return this.fControl == control && this.fControl != null;
    }

    public boolean canReplace(IInformationControlCreator creator) {
        return creator != null && this.getClass() == creator.getClass();
    }
}

