/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search.text;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.ui.search.text.ResultVisitor;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;

public class TextSearcher {
    public final TextSearchEngine engine;
    public final TextSearchScope scope;
    public final ResultVisitor visitor;
    public final Pattern searchPattern;
    private boolean done;

    TextSearcher(TextSearchEngine engine, TextSearchScope newSearchScope, ResultVisitor visitor, Pattern searchPattern) {
        if (engine == null || newSearchScope == null || visitor == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        this.scope = newSearchScope;
        this.visitor = visitor;
        this.searchPattern = searchPattern;
        this.done = false;
    }

    public final boolean isDone() {
        return this.done;
    }

    public static final TextSearcher createSearcher(TextSearchEngine engine, TextSearchScope newSearchScope, ResultVisitor visitor, Pattern searchPattern) {
        return new TextSearcher(engine, newSearchScope, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(TextSearchScope newSearchScope, ResultVisitor visitor, Pattern searchPattern) {
        TextSearchEngine engine = TextSearchEngine.createDefault();
        return TextSearcher.createSearcher(engine, newSearchScope, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(IResource resource, ResultVisitor visitor, Pattern searchPattern) {
        TextSearchScope searchScope = TextSearchScope.newSearchScope((IResource[])new IResource[]{resource}, null, (boolean)true);
        return TextSearcher.createSearcher(searchScope, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(IResource resource, Pattern searchPattern) {
        ResultVisitor visitor = new ResultVisitor();
        return TextSearcher.createSearcher(resource, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(IResource resource, String searchText) {
        Pattern searchPattern = Pattern.compile(searchText);
        return TextSearcher.createSearcher(resource, searchPattern);
    }

    public void search(IProgressMonitor monitor) {
        assert (!this.done);
        this.engine.search(this.scope, (TextSearchRequestor)this.visitor, this.searchPattern, monitor);
        this.done = true;
    }

    public List getResults() {
        assert (this.done);
        return this.visitor.getResult();
    }
}

