/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineStyleProviderForPhp
extends AbstractLineStyleProvider
implements LineStyleProvider {
    private IPreferenceStore fColorPreferences;
    protected static final Map<String, String> fColorTypes = new HashMap<String, String>();

    static {
        fColorTypes.put("PHP_STRING", "codeStyleNormal");
        fColorTypes.put("PHP_TOKEN", "codeStyleNormal");
        fColorTypes.put("PHP_SEMICOLON", "codeStyleNormal");
        fColorTypes.put("PHP_OPERATOR", "codeStyleNormal");
        fColorTypes.put("PHP_OPENTAG", "editorColorBoundarymaker");
        fColorTypes.put("PHP_CLOSETAG", "editorColorBoundarymaker");
        fColorTypes.put("PHP_LOGICAL_AND", "editorColorKeyword");
        fColorTypes.put("PHP_ARRAY", "editorColorKeyword");
        fColorTypes.put("PHP_AS", "editorColorKeyword");
        fColorTypes.put("PHP_BREAK", "editorColorKeyword");
        fColorTypes.put("PHP_CASE", "editorColorKeyword");
        fColorTypes.put("PHP_CATCH", "editorColorKeyword");
        fColorTypes.put("PHP_CLASS", "editorColorKeyword");
        fColorTypes.put("PHP_CONTINUE", "editorColorKeyword");
        fColorTypes.put("PHP_GOTO", "editorColorKeyword");
        fColorTypes.put("PHP_DECLARE", "editorColorKeyword");
        fColorTypes.put("PHP_DEFAULT", "editorColorKeyword");
        fColorTypes.put("PHP_DO", "editorColorKeyword");
        fColorTypes.put("PHP_ECHO", "editorColorKeyword");
        fColorTypes.put("PHP_ELSE", "editorColorKeyword");
        fColorTypes.put("PHP_ELSEIF", "editorColorKeyword");
        fColorTypes.put("PHP_EMPTY", "editorColorKeyword");
        fColorTypes.put("PHP_ENDDECLARE", "editorColorKeyword");
        fColorTypes.put("PHP_ENDFOR", "editorColorKeyword");
        fColorTypes.put("PHP_ENDFOREACH", "editorColorKeyword");
        fColorTypes.put("PHP_ENDIF", "editorColorKeyword");
        fColorTypes.put("PHP_ENDSWITCH", "editorColorKeyword");
        fColorTypes.put("PHP_EVAL", "editorColorKeyword");
        fColorTypes.put("PHP_EXIT", "editorColorKeyword");
        fColorTypes.put("PHP_EXTENDS", "editorColorKeyword");
        fColorTypes.put("PHP_FOR", "editorColorKeyword");
        fColorTypes.put("PHP_FOREACH", "editorColorKeyword");
        fColorTypes.put("PHP_FUNCTION", "editorColorKeyword");
        fColorTypes.put("PHP_IF", "editorColorKeyword");
        fColorTypes.put("PHP_HALT_COMPILER", "editorColorKeyword");
        fColorTypes.put("PHP_INCLUDE", "editorColorKeyword");
        fColorTypes.put("PHP_INCLUDE_ONCE", "editorColorKeyword");
        fColorTypes.put("PHP_GLOBAL", "editorColorKeyword");
        fColorTypes.put("PHP_LIST", "editorColorKeyword");
        fColorTypes.put("PHP_NEW", "editorColorKeyword");
        fColorTypes.put("PHP_NOT", "editorColorKeyword");
        fColorTypes.put("PHP_LOGICAL_OR", "editorColorKeyword");
        fColorTypes.put("PHP_PRINT", "editorColorKeyword");
        fColorTypes.put("PHP_PUBLIC", "editorColorKeyword");
        fColorTypes.put("PHP_PRIVATE", "editorColorKeyword");
        fColorTypes.put("PHP_PROTECTED", "editorColorKeyword");
        fColorTypes.put("PHP_REQUIRE", "editorColorKeyword");
        fColorTypes.put("PHP_REQUIRE_ONCE", "editorColorKeyword");
        fColorTypes.put("PHP_RETURN", "editorColorKeyword");
        fColorTypes.put("PHP_STATIC", "editorColorKeyword");
        fColorTypes.put("PHP_SWITCH", "editorColorKeyword");
        fColorTypes.put("PHP_TRY", "editorColorKeyword");
        fColorTypes.put("PHP_THROW", "editorColorKeyword");
        fColorTypes.put("PHP_NAMESPACE", "editorColorKeyword");
        fColorTypes.put("PHP_USE", "editorColorKeyword");
        fColorTypes.put("PHP_VAR", "editorColorKeyword");
        fColorTypes.put("PHP_WHILE", "editorColorKeyword");
        fColorTypes.put("PHP_LOGICAL_XOR", "editorColorKeyword");
        fColorTypes.put("PHP_ABSTRACT", "editorColorKeyword");
        fColorTypes.put("PHP_CLONE", "editorColorKeyword");
        fColorTypes.put("PHP_FALSE", "editorColorKeyword");
        fColorTypes.put("PHP_FINAL", "editorColorKeyword");
        fColorTypes.put("PHP_DIE", "editorColorKeyword");
        fColorTypes.put("PHP_TRUE", "editorColorKeyword");
        fColorTypes.put("PHP_INSTANCEOF", "editorColorKeyword");
        fColorTypes.put("PHP_UNSET", "editorColorKeyword");
        fColorTypes.put("PHP_SELF", "editorColorKeyword");
        fColorTypes.put("PHP_ISSET", "editorColorKeyword");
        fColorTypes.put("PHP_PARENT", "editorColorKeyword");
        fColorTypes.put("PHP_ENDWHILE", "editorColorKeyword");
        fColorTypes.put("PHP_FROM", "editorColorKeyword");
        fColorTypes.put("PHP_IMPLEMENTS", "editorColorKeyword");
        fColorTypes.put("PHP_INTERFACE", "editorColorKeyword");
        fColorTypes.put("PHP_CONST", "editorColorKeyword");
        fColorTypes.put("PHP_KEYWORD", "editorColorKeyword");
        fColorTypes.put("PHP_VARIABLE", "editorColorVariable");
        fColorTypes.put("PHP_THIS", "editorColorVariable");
        fColorTypes.put("PHP_CONSTANT_ENCAPSED_STRING", "editorColorString");
        fColorTypes.put("PHP_ENCAPSED_AND_WHITESPACE", "editorColorString");
        fColorTypes.put("PHP_COMMENT", "editorColorComment");
        fColorTypes.put("PHP_COMMENT_START", "editorColorComment");
        fColorTypes.put("PHP_COMMENT_END", "editorColorComment");
        fColorTypes.put("PHP_LINE_COMMENT", "editorColorLineComment");
        fColorTypes.put("PHP_NUMBER", "editorColorNumber");
        fColorTypes.put("PHP_HEREDOC_TAG", "editorColorHeredoc");
        fColorTypes.put("PHPDOC_METHOD", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_PROPERTY", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_VAR", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_SEE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_NAME", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_DESC", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_TODO", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_LINK", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_EXAMPLE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_LICENSE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_PACKAGE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_VERSION", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_ABSTRACT", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_INTERNAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_TUTORIAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_CATEGORY", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_FINAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_SINCE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_PARAM", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_MAGIC", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_RETURN", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_AUTHOR", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_ACCESS", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_IGNORE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_THROWS", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_STATIC", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_GLOBAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_USES", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_SUBPACKAGE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_FILESOURCE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_EXCEPTION", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_COPYRIGHT", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_STATICVAR", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_DEPRECATED", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_COMMENT", "editorColorPHPDocComment");
        fColorTypes.put("PHPDOC_COMMENT_START", "editorColorPHPDocComment");
        fColorTypes.put("PHPDOC_COMMENT_END", "editorColorPHPDocComment");
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        TextAttribute result = null;
        if (region != null) {
            String type = region.getType();
            result = type == "PHP_OPEN" ? this.getAttributeFor("PHP_OPENTAG") : (type == "PHP_CLOSE" ? this.getAttributeFor("PHP_CLOSETAG") : this.getAttributeFor(region.getType()));
        }
        if (result == null) {
            result = (TextAttribute)this.getTextAttributes().get("codeStyleNormal");
        }
        return result;
    }

    protected TextAttribute getAttributeFor(String type) {
        return (TextAttribute)this.getTextAttributes().get(fColorTypes.get(type));
    }

    protected void addTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        if (this.getColorPreferences() != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getColorPreferences().getString(colorKey)))) != null) {
            this.getTextAttributes().put(colorKey, this.createTextAttribute(stylePrefs));
        }
    }

    protected void addDefaultTextAttribute(String colorKey) {
        if (this.getColorPreferences() != null) {
            String prefString = PreferenceConstants.EDITOR_NORMAL_DEFAULT_COLOR;
            this.getColorPreferences().setValue(colorKey, prefString);
            String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
            if (stylePrefs != null) {
                this.getTextAttributes().put(colorKey, this.createTextAttribute(stylePrefs));
            }
        }
    }

    protected TextAttribute createTextAttribute(String[] stylePrefs) {
        int fontModifier = 0;
        if (Boolean.valueOf(stylePrefs[2]).booleanValue()) {
            fontModifier |= 1;
        }
        if (Boolean.valueOf(stylePrefs[3]).booleanValue()) {
            fontModifier |= 2;
        }
        if (Boolean.valueOf(stylePrefs[4]).booleanValue()) {
            fontModifier |= 0x20000000;
        }
        if (Boolean.valueOf(stylePrefs[5]).booleanValue()) {
            fontModifier |= 0x40000000;
        }
        return new TextAttribute(EditorUtility.getColor((RGB)ColorHelper.toRGB((String)stylePrefs[0])), EditorUtility.getColor((RGB)ColorHelper.toRGB((String)stylePrefs[1])), fontModifier);
    }

    public TextAttribute getTextAttributeForColor(String colorKey) {
        return (TextAttribute)this.getTextAttributes().get(colorKey);
    }

    protected StyleRange createStyleRange(ITextRegionCollection flatNode, ITextRegion region, TextAttribute attr, int startOffset, int length) {
        int start = flatNode.getStartOffset(region);
        if (start < startOffset) {
            start = startOffset;
        }
        int maxOffset = startOffset + length;
        int end = flatNode.getEndOffset(region);
        if (end > maxOffset) {
            end = maxOffset;
        }
        StyleRange result = new StyleRange(start, end - start, attr.getForeground(), attr.getBackground(), attr.getStyle());
        if ((attr.getStyle() & 0x40000000) != 0) {
            result.underline = true;
            result.fontStyle &= 0xBFFFFFFF;
        }
        if ((attr.getStyle() & 0x20000000) != 0) {
            result.strikeout = true;
            result.fontStyle &= 0xDFFFFFFF;
        }
        return result;
    }

    public boolean prepareRegions(ITypedRegion typedRegion, int lineRequestStart, int lineRequestLength, Collection holdResults) {
        int partitionStartOffset = typedRegion.getOffset();
        int partitionLength = typedRegion.getLength();
        IStructuredDocumentRegion structuredDocumentRegion = this.getDocument().getRegionAtCharacterOffset(partitionStartOffset);
        boolean prepareTextRegions = this.prepareTextRegions(structuredDocumentRegion, partitionStartOffset, partitionLength, holdResults);
        return prepareTextRegions;
    }

    public boolean prepareTextRegion(ITextRegionCollection blockedRegion, int partitionStartOffset, int partitionLength, Collection<StyleRange> holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        ITextRegion region = null;
        ITextRegionList regions = blockedRegion.getRegions();
        int nRegions = regions.size();
        StyleRange styleRange = null;
        int i = 0;
        while (i < nRegions) {
            region = regions.get(i);
            TextAttribute attr = null;
            TextAttribute previousAttr = null;
            int startOffset = blockedRegion.getStartOffset(region);
            if (startOffset > partitionEndOffset) break;
            if (blockedRegion.getEndOffset(region) > partitionStartOffset) {
                if (region instanceof ITextRegionCollection) {
                    handled = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                } else if (region.getType() == "PHP_CONTENT") {
                    handled = this.preparePhpRegions(holdResults, (IPhpScriptRegion)region, startOffset, partitionStartOffset, partitionLength);
                } else {
                    attr = this.getAttributeFor(region);
                    if (attr != null) {
                        handled = true;
                        if (styleRange != null && previousAttr != null && previousAttr.equals((Object)attr)) {
                            styleRange.length += region.getLength();
                        } else {
                            styleRange = this.createStyleRange(blockedRegion, region, attr, partitionStartOffset, partitionLength);
                            holdResults.add(styleRange);
                            previousAttr = attr;
                        }
                    } else {
                        previousAttr = null;
                    }
                }
            }
            ++i;
        }
        return handled;
    }

    public boolean prepareTextRegions(IStructuredDocumentRegion structuredDocumentRegion, int partitionStartOffset, int partitionLength, Collection<StyleRange> holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        while (structuredDocumentRegion != null && structuredDocumentRegion.getStartOffset() <= partitionEndOffset) {
            ITextRegion region = null;
            ITextRegionList regions = structuredDocumentRegion.getRegions();
            int nRegions = regions.size();
            StyleRange styleRange = null;
            int i = 0;
            while (i < nRegions) {
                region = regions.get(i);
                TextAttribute attr = null;
                TextAttribute previousAttr = null;
                int startOffset = structuredDocumentRegion.getStartOffset(region);
                if (startOffset > partitionEndOffset) break;
                if (structuredDocumentRegion.getEndOffset(region) > partitionStartOffset) {
                    if (region instanceof ITextRegionCollection) {
                        handled = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                    } else if (region.getType() == "PHP_CONTENT") {
                        handled = this.preparePhpRegions(holdResults, (IPhpScriptRegion)region, startOffset, partitionStartOffset, partitionLength);
                    } else {
                        attr = this.getAttributeFor(region);
                        if (attr != null) {
                            handled = true;
                            if (styleRange != null && previousAttr != null && previousAttr.equals((Object)attr)) {
                                styleRange.length += region.getLength();
                            } else {
                                styleRange = this.createStyleRange((ITextRegionCollection)structuredDocumentRegion, region, attr, partitionStartOffset, partitionLength);
                                holdResults.add(styleRange);
                                previousAttr = attr;
                            }
                        } else {
                            previousAttr = null;
                        }
                    }
                }
                ++i;
            }
            structuredDocumentRegion = structuredDocumentRegion.getNext();
        }
        return handled;
    }

    private boolean preparePhpRegions(Collection<StyleRange> holdResults, IPhpScriptRegion region, int regionStart, int partitionStartOffset, int partitionLength) {
        assert (region.getType() == "PHP_CONTENT");
        StyleRange styleRange = null;
        TextAttribute previousAttr = null;
        ITextRegion[] phpTokens = null;
        try {
            int length;
            int from;
            if (partitionStartOffset < regionStart) {
                from = 0;
                length = partitionLength - (regionStart - partitionStartOffset);
            } else {
                from = partitionStartOffset - regionStart;
                length = partitionLength;
            }
            phpTokens = region.getPhpTokens(from, Math.min(length, region.getLength()));
            ITextRegion prevElement = null;
            int i = 0;
            while (i < phpTokens.length) {
                block19: {
                    ITextRegion element;
                    block21: {
                        int styleLength;
                        TextAttribute attr;
                        block20: {
                            element = phpTokens[i];
                            attr = this.getAttributeFor(element);
                            if (prevElement == element) break block19;
                            if (styleRange == null || previousAttr == null || !previousAttr.equals((Object)attr) || prevElement == null || prevElement.getLength() != prevElement.getLength()) break block20;
                            styleRange.length += element.getLength();
                            if (styleRange.start + styleRange.length > partitionStartOffset + partitionLength) {
                                styleRange.length -= styleRange.start + styleRange.length - (partitionStartOffset + partitionLength);
                            }
                            break block21;
                        }
                        int styleStart = regionStart + element.getStart();
                        if (styleStart + (styleLength = element.getLength()) < partitionStartOffset) break block19;
                        if (styleStart < partitionStartOffset) {
                            styleLength -= partitionStartOffset - styleStart;
                            styleStart = partitionStartOffset;
                        }
                        if (styleStart > partitionStartOffset + partitionLength) {
                            styleLength -= styleStart - (partitionStartOffset + partitionLength);
                        }
                        if (attr.getBackground() != null && element.getTextEnd() != element.getEnd()) {
                            styleRange = new StyleRange(styleStart, styleLength - (element.getEnd() - element.getTextEnd()), attr.getForeground(), attr.getBackground(), attr.getStyle());
                            if ((attr.getStyle() & 0x40000000) != 0) {
                                styleRange.underline = true;
                                styleRange.fontStyle &= 0xBFFFFFFF;
                            }
                            if ((attr.getStyle() & 0x20000000) != 0) {
                                styleRange.strikeout = true;
                                styleRange.fontStyle &= 0xDFFFFFFF;
                            }
                            holdResults.add(styleRange);
                            styleRange = new StyleRange(regionStart + element.getTextEnd(), element.getEnd() - element.getTextEnd(), attr.getForeground(), null, attr.getStyle());
                            holdResults.add(styleRange);
                            previousAttr = null;
                        } else {
                            styleRange = new StyleRange(styleStart, styleLength, attr.getForeground(), attr.getBackground(), attr.getStyle());
                            if ((attr.getStyle() & 0x40000000) != 0) {
                                styleRange.underline = true;
                                styleRange.fontStyle &= 0xBFFFFFFF;
                            }
                            if ((attr.getStyle() & 0x20000000) != 0) {
                                styleRange.strikeout = true;
                                styleRange.fontStyle &= 0xDFFFFFFF;
                            }
                            holdResults.add(styleRange);
                            previousAttr = attr;
                        }
                    }
                    prevElement = element;
                }
                ++i;
            }
            return true;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return false;
        }
    }

    public Map<String, String> getColorTypesMap() {
        return fColorTypes;
    }

    public void loadColors() {
        this.addTextAttribute("codeStyleNormal");
        this.addTextAttribute("editorColorBoundarymaker");
        this.addTextAttribute("editorColorKeyword");
        this.addTextAttribute("editorColorVariable");
        this.addTextAttribute("editorColorString");
        this.addTextAttribute("editorColorComment");
        this.addTextAttribute("editorColorLineComment");
        this.addTextAttribute("editorColorPHPDocComment");
        this.addTextAttribute("editorColorPhpdoc");
        this.addTextAttribute("editorColorNumber");
        this.addTextAttribute("editorColorHeredoc");
        this.addTextAttribute("editorColorTask");
    }

    protected void clearColors() {
        this.getTextAttributes().clear();
    }

    public void setColorPreferences(IPreferenceStore preferenceStore) {
        this.fColorPreferences = preferenceStore;
    }

    public IPreferenceStore getColorPreferences() {
        if (this.fColorPreferences != null) {
            return this.fColorPreferences;
        }
        return PreferenceConstants.getPreferenceStore();
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if (event != null) {
            String prefKey = event.getProperty();
            if ("codeStyleNormal".equals(prefKey) || "editorColorBoundarymaker".equals(prefKey) || "editorColorKeyword".equals(prefKey) || "editorColorVariable".equals(prefKey) || "editorColorString".equals(prefKey) || "editorColorComment".equals(prefKey) || "editorColorLineComment".equals(prefKey) || "editorColorPHPDocComment".equals(prefKey) || "editorColorPhpdoc".equals(prefKey) || "editorColorNumber".equals(prefKey) || "editorColorHeredoc".equals(prefKey) || "editorColorTask".equals(prefKey)) {
                this.addTextAttribute(prefKey);
            } else if (PreferenceConstants.getEnabledPreferenceKey("codeStyleNormal").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorBoundarymaker").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorKeyword").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorVariable").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorString").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorComment").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorLineComment").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorPHPDocComment").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorPhpdoc").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorNumber").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorHeredoc").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorTask").equals(prefKey)) {
                boolean enabled = this.getColorPreferences().getBoolean(prefKey);
                prefKey = prefKey.split("\\.")[1];
                if (enabled) {
                    this.addTextAttribute(prefKey);
                } else {
                    this.addDefaultTextAttribute(prefKey);
                }
            }
        } else {
            this.loadColors();
        }
        if (this.fRecHighlighter != null) {
            this.fRecHighlighter.refreshDisplay();
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            LineStyleProviderForPhp.this.handlePropertyChange(event);
        }
    }
}

