/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.text.hover.CompletionHoverControlCreator;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.AutoActivationTrigger;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProcessor;
import org.eclipse.php.internal.ui.editor.contentassist.UseStatementInjector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PHPCompletionProposal
extends ScriptCompletionProposal {
    private IInformationControlCreator fCreator;

    public PHPCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
    }

    public PHPCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, boolean indoc) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance, indoc);
    }

    protected boolean isValidPrefix(String prefix) {
        String word = this.getDisplayString();
        if (word.startsWith("$") && !prefix.startsWith("$")) {
            word = word.substring(1);
        }
        return this.isPrefix(prefix, word);
    }

    protected boolean isSmartTrigger(char trigger) {
        return trigger == '$';
    }

    public void apply(IDocument document, char trigger, int offset) {
        IModelElement modelElement = this.getModelElement();
        boolean activateCodeAssist = false;
        String replacementString = this.getReplacementString();
        if (modelElement instanceof IScriptProject && replacementString.endsWith("/")) {
            activateCodeAssist = true;
        } else {
            IPreferencesService preferencesService = Platform.getPreferencesService();
            boolean enableAutoactivation = preferencesService.getBoolean("org.eclipse.php.core", "contentAssistAutoactivation", false, null);
            if (enableAutoactivation) {
                char lastChar = replacementString.charAt(replacementString.length() - 1);
                char[] cArray = PHPCompletionProcessor.completionAutoActivationChars;
                int n = PHPCompletionProcessor.completionAutoActivationChars.length;
                int n2 = 0;
                while (n2 < n) {
                    char autoActivationChar = cArray[n2];
                    if (autoActivationChar == lastChar) {
                        activateCodeAssist = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (activateCodeAssist) {
            AutoActivationTrigger.register(document);
        }
        UseStatementInjector injector = new UseStatementInjector(this);
        offset = injector.inject(document, this.getTextViewer(), offset);
        super.apply(document, trigger, offset);
        this.setCursorPosition(this.calcCursorPosition());
    }

    private int calcCursorPosition() {
        String replacementString = this.getReplacementString();
        int i = replacementString.lastIndexOf(40);
        if (i != -1) {
            return i + 1;
        }
        i = replacementString.lastIndexOf(39);
        if (i != -1) {
            return i;
        }
        i = replacementString.lastIndexOf(34);
        if (i != -1) {
            return i;
        }
        return replacementString.length();
    }

    public IContextInformation getContextInformation() {
        String displayString = this.getDisplayString();
        if (displayString.indexOf(40) == -1) {
            return null;
        }
        return super.getContextInformation();
    }

    protected boolean isCamelCaseMatching() {
        return true;
    }

    protected boolean insertCompletion() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertCompletion", true, null);
    }

    protected ScriptTextTools getTextTools() {
        return PHPUiPlugin.getDefault().getTextTools();
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (this.fCreator == null) {
            this.fCreator = new CompletionHoverControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, "org.eclipse.dltk.ui.documentationFont", true);
                    }
                    return new DefaultInformationControl(parent, true);
                }
            }, true);
        }
        return this.fCreator;
    }
}

