package jp.sourceforge.pdt_tools.codeFolding;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.ui.internal.projection.XMLFoldingStrategy;

@SuppressWarnings("restriction")
public class PHPFoldingStrategy extends XMLFoldingStrategy {

	private ProjectionViewer viewer;

	public PHPFoldingStrategy() {
		super();
	}

	@Override
	public void setViewer(ProjectionViewer viewer) {
		this.viewer = viewer;
		super.setViewer(viewer);
	}

	@Override
	public void uninstall() {
		this.viewer = null;
		super.uninstall();
	}

	@Override
	protected Position calcNewFoldPosition(IndexedRegion indexedRegion) {
		if (!(indexedRegion instanceof ElementImplForPhp)) {
			return super.calcNewFoldPosition(indexedRegion);
		}
		ElementImplForPhp elementImplForPhp = (ElementImplForPhp) indexedRegion;
		if (!elementImplForPhp.isPhpTag()) {
			return super.calcNewFoldPosition(indexedRegion);
		}
		if (!CodeFolding.getDefault().isEnabled()) {
			return null;
		}
		if (fProjectionAnnotationModel == null) {
			return null;
		}
		IDocument document = elementImplForPhp.getStructuredDocument();
		if (document != null) {
			IResource resource = getResource(document);
			if (resource != null) {
				ISourceModule sourceModule = PHPToolkitUtil
						.getSourceModule(resource);
				if (sourceModule != null) {
					try {
						Program program = SharedASTProvider.getAST(
								sourceModule,
								SharedASTProvider.WAIT_ACTIVE_ONLY,
								new NullProgressMonitor());
						if (program == null) {
							// e.g. external source module
							PHPVersion phpVersion = ProjectOptions
									.getPhpVersion(sourceModule);
							IProject project = sourceModule.getScriptProject()
									.getProject();
							boolean useShortTag = ProjectOptions
									.useShortTags(project);
							ASTParser parser = ASTParser.newParser(
									new StringReader(document.get()),
									phpVersion, useShortTag);
							program = parser
									.createAST(new NullProgressMonitor());
						}
						if (program != null) {
							final int[] offset = { 0 };
							PlatformUI.getWorkbench().getDisplay()
									.syncExec(new Runnable() {
										public void run() {
											ISelection selection = viewer
													.getSelection();
											if (selection instanceof ITextSelection) {
												offset[0] = ((ITextSelection) selection)
														.getOffset();
											}
										}
									});
							Map<Annotation, Position> additions = new HashMap<Annotation, Position>();
							FoldingVisitor foldingVisitor = new FoldingVisitor(
									document, offset[0], additions);
							program.accept(foldingVisitor);
							modifyAnnotations(additions, document);
						}
					} catch (Exception e) {
						CodeFolding.log(e);
					}
				}
			}
		}
		return null;
	}

	@Override
	protected boolean indexedRegionValidType(IndexedRegion indexedRegion) {
		if (indexedRegion instanceof ElementImplForPhp) {
			return true;
		}
		return super.indexedRegionValidType(indexedRegion);
	}

	private IResource getResource(IDocument document) {
		IResource resource = null;
		if (document != null) {
			IStructuredModel model = null;
			try {
				IModelManager manager = StructuredModelManager
						.getModelManager();
				model = manager.getExistingModelForRead(document);
				if (model != null) {
					String baselocation = model.getBaseLocation();
					if (baselocation != null) {
						IWorkspaceRoot root = ResourcesPlugin.getWorkspace()
								.getRoot();
						resource = root.getFile(new Path(baselocation));
					}
				}
			} finally {
				if (model != null) {
					model.releaseFromRead();
				}
			}
		}
		return resource;
	}

	@SuppressWarnings("rawtypes")
	private void modifyAnnotations(Map<Annotation, Position> additions,
			IDocument document) {
		List<ProjectionAnnotation> dels = new ArrayList<ProjectionAnnotation>();
		Iterator it = fProjectionAnnotationModel.getAnnotationIterator();
		while (it.hasNext()) {
			ProjectionAnnotation ann = (ProjectionAnnotation) it.next();
			Position pos = fProjectionAnnotationModel.getPosition(ann);
			if (additions.containsValue(pos)) {
				Iterator iter = additions.entrySet().iterator();
				while (iter.hasNext()) {
					Map.Entry mapEntry = (Map.Entry) iter.next();
					Position position = (Position) mapEntry.getValue();
					if (position.equals(pos)) {
						additions.remove(mapEntry.getKey());
						break;
					}
				}
			} else {
				try {
					ITypedRegion partition = document.getPartition(pos
							.getOffset());
					if (partition != null) {
						String type = partition.getType();
						if (type.equals(PHPPartitionTypes.PHP_DEFAULT)
								|| type.equals(PHPPartitionTypes.PHP_COMMENT)
								|| type.equals(PHPPartitionTypes.PHP_DOC)
								|| type.equals(PHPPartitionTypes.PHP_MULTI_LINE_COMMENT)
								|| type.equals(PHPPartitionTypes.PHP_QUOTED_STRING)
								|| type.equals(PHPPartitionTypes.PHP_SINGLE_LINE_COMMENT)) {
							dels.add(ann);
						}
					}
				} catch (BadLocationException e) {
				}
			}
		}
		if (!additions.isEmpty() || !dels.isEmpty()) {
			Annotation[] deletions = dels.toArray(new Annotation[dels.size()]);
			fProjectionAnnotationModel.modifyAnnotations(deletions, additions,
					new Annotation[0]);
		}
	}
}
