package jp.sourceforge.pdt_tools.callhierarchy;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.ui.editor.SharedASTProvider;

@SuppressWarnings("restriction")
public class FindCalleeVisitor extends AbstractVisitor {

	private Map<SimpleReference, IMethod[]> map;

	public FindCalleeVisitor() {
		map = new TreeMap<SimpleReference, IMethod[]>(
				new Comparator<SimpleReference>() {
					public int compare(SimpleReference o1, SimpleReference o2) {
						return o1.sourceStart() - o2.sourceStart();
					}
				});
	}

	/**
	 * 
	 * @param method
	 * @param monitor
	 * @param scope
	 * @return
	 */
	public Map<SimpleReference, IMethod[]> find(IMethod method,
			IProgressMonitor monitor, IDLTKSearchScope scope) {
		ISourceModule sourceModule = method.getSourceModule();
		try {
			Program program = SharedASTProvider.getAST(sourceModule,
					SharedASTProvider.WAIT_YES, null);
			if (program != null) {
				int offset = method.getSourceRange().getOffset();
				ASTNode node = program.getElementAt(offset);
				if (node != null) {
					node.accept(this);
				}
			}
		} catch (ModelException e) {
			CallHierarchyPlugin.log(e);
		} catch (IOException e) {
			CallHierarchyPlugin.log(e);
		}
		return map;
	}

	@Override
	public boolean visit(FunctionInvocation functionInvocation) {
		ASTNode parent = functionInvocation.getParent();
		if (!(parent instanceof MethodInvocation)
				&& !(parent instanceof StaticMethodInvocation)) {
			IFunctionBinding functionBinding = functionInvocation
					.resolveFunctionBinding();
			if (functionBinding != null) {
				SimpleReference ref = new SimpleReference(
						functionInvocation.getStart(),
						functionInvocation.getEnd(), functionBinding.getName());
				IMethod method = (IMethod) functionBinding.getPHPElement();
				IMethod[] methods = new IMethod[] { method };
				map.put(ref, methods);
			}
		}
		return super.visit(functionInvocation);
	}

	@Override
	public boolean visit(MethodInvocation methodInvocation) {
		IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
		if (methodBinding != null) {
			SimpleReference ref = new SimpleReference(methodInvocation
					.getMethod().getStart(), methodInvocation.getMethod()
					.getEnd(), methodBinding.getName());
			IMethod method = (IMethod) methodBinding.getPHPElement();
			IMethod[] methods = new IMethod[] { method };
			map.put(ref, methods);
		}
		return super.visit(methodInvocation);
	}

	@Override
	public boolean visit(StaticMethodInvocation staticMethodInvocation) {
		IMethodBinding methodBinding = staticMethodInvocation
				.resolveMethodBinding();
		if (methodBinding != null) {
			SimpleReference ref = new SimpleReference(staticMethodInvocation
					.getMethod().getStart(), staticMethodInvocation.getMethod()
					.getEnd(), methodBinding.getName());
			IMethod method = (IMethod) methodBinding.getPHPElement();
			IMethod[] methods = new IMethod[] { method };
			map.put(ref, methods);
		}
		return super.visit(staticMethodInvocation);
	}

}
