
/* --------------------------------------------- */
/*  H8-3069F Linker script                       */
/*                (c) KAZ.Imamura                */
/*                                               */
/*  CPU    : Renesus H8/3069F 25MHz              */
/*  Memory : ROM 512KB, RAM 16KB E-RAM 2MB       */
/*  Target : AKI-3069-USB on h8mon               */
/* --------------------------------------------- */

OUTPUT_FORMAT("elf32-h8300")
OUTPUT_ARCH(h8300h)
ENTRY("_start")
MEMORY
{
	vectors(rw)	: o = 0x000000, l =    0x100
	vrom(rwx)	: o = 0x400000, l =  0x1C000
	ram(rwx)	: o = 0x41C000, l =   0x4000
	eram(rwx)	: o = 0x420000, l = 0x1E0000
	temp(rwx)	: o = 0x600000, l =        0
	vvect(rw)	: o = 0xffbf20, l =    0x100
	stack(rw)	: o = 0xffd30c, l =        0
}

SECTIONS
{
.vvect : {
/* .vectors : { */
	LONG (ABSOLUTE(_start))												 /* #00 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #01 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #02 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #03 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #04 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #05 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #06 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #07 NMI                       */ 
	LONG (ABSOLUTE(_start))												 /* #08 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #09 Reserverd                 */ 

	LONG (ABSOLUTE(_start))												 /* #10 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #11 Reserverd                 */ 
	LONG (DEFINED(_int_IRQ0)?ABSOLUTE(_int_IRQ0):ABSOLUTE(_start))		 /* #12 IRQ0                      */ 
	LONG (ABSOLUTE(_start))												 /* #13 IRQ1                      */ 
	LONG (ABSOLUTE(_start))												 /* #14 IRQ2                      */ 
	LONG (ABSOLUTE(_start))												 /* #15 IRQ3                      */ 
	LONG (ABSOLUTE(_start))												 /* #16 IRQ4                      */ 
	LONG (ABSOLUTE(_start))												 /* #17 IRQ5                      */ 
	LONG (ABSOLUTE(_start))												 /* #18 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #19 Reserverd                 */ 

	LONG (ABSOLUTE(_start))												 /* #20 Watchdog timer (WOVI)     */ 
	LONG (ABSOLUTE(_start))												 /* #21 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #22 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #23 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #24 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #25 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #26 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #27 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #28 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #29 Reserverd                 */ 

	LONG (ABSOLUTE(_start))												 /* #30 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #31 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #32 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #33 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #34 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #35 Reserverd                 */ 
	LONG (DEFINED(_int_CMIA0)?ABSOLUTE(_int_CMIA0):ABSOLUTE(_start))	 /* #36 8bit timer CM-A0          */ 
	LONG (ABSOLUTE(_start))												 /* #37 Reserverd                 */ 
	LONG (DEFINED(_int_CMIA0)?ABSOLUTE(_int_CMIA1):ABSOLUTE(_start))	 /* #38 8bit timer CM-A1/B1       */ 
	LONG (ABSOLUTE(_start))												 /* #39 Reserverd                 */ 

	LONG (ABSOLUTE(_start))												 /* #40 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #41 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #42 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #43 Reserverd                 */ 
	LONG (DEFINED(_int_DEND0)?ABSOLUTE(_int_DEND0):ABSOLUTE(_start))	 /* #44 DMAC transfer(ch0) end    */ 
	LONG (ABSOLUTE(_start))												 /* #45 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #46 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #47 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #48 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #49 Reserverd                 */ 

	LONG (ABSOLUTE(_start))												 /* #50 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #51 Reserverd                 */ 
	LONG (DEFINED(_int_ERI0)?ABSOLUTE(_int_ERI0):ABSOLUTE(_start))		 /* #52 SCI-0 ERI                 */ 
	LONG (DEFINED(_int_RXI0)?ABSOLUTE(_int_RXI0):ABSOLUTE(_start))		 /* #53 SCI-0 RXI                 */ 
	LONG (DEFINED(_int_TXI0)?ABSOLUTE(_int_TXI0):ABSOLUTE(_start))		 /* #54 SCI-0 TXI                 */ 
	LONG (DEFINED(_int_TEI0)?ABSOLUTE(_int_TEI0):ABSOLUTE(_start))		 /* #55 SCI-0 TEI                 */ 
	LONG (ABSOLUTE(_start))												 /* #56 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #57 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #58 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #59 Reserverd                 */ 

	LONG (ABSOLUTE(_start))												 /* #60 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #61 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #62 Reserverd                 */ 
	LONG (ABSOLUTE(_start))												 /* #63 Reserverd                 */ 
/*	} > vectors */
	} > vvect
	
.text :	{
	*(.text)
	*(.strings)
	*(.rodata)
	} > vrom
/*
.vvect : {
	*(.vvect)
	} > vvect
*/

.bss : {
	*(.bss)
	*(.data)
	} > ram

.eram : {
	_eram_start = .;
	*(.eram)
	_eram_end = .;
	} > eram

.temp : {
	*(.eram)
	_eram_end = .;
	} > temp

.stack : {
	_stack_start = .;
	*(.stack)
	_stack_end = .;
	} > stack
}



