
/* --------------------------------------------- */
/*  H8-3069F USB Common Header file              */
/*                                               */
/*  CPU    : Renesus H8/3069F 25MHz              */
/*  Memory : ROM 512KB, RAM 16KB E-RAM 2MB       */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */


#ifndef __COMMON_H__
#define __COMMON_H__

#include "3069s.h"

#define ROM_VERSION
#ifdef ROM_VERSION
	//#define DEBUG_ON
	#define START_WITH_ENDUSERMODE
#else
	#define DEBUG_ON
	#define START_WITH_ENDUSERMODE
#endif


#ifdef DEBUG_ON
	#define SL811HS_DEBUG_ON
	#define MSCLASS_DEBUG_ON
	#define SCI_DEBUG_ON
	#define UI_DEBUG_ON
	#define SYS_DEBUG_ON
#endif
#define REQUEST_TO_CLASS	unsigned char
#define SUB_PROC_RESULT		unsigned char
enum sub_proc_result_code {
	SUB_PROC_BUSY,
	SUB_PROC_DONE,
	SUB_PROC_ERROR,
};

// ----------------------------------------------------
//   [INTER-CLASS COMMUNICATION] Requests
// ----------------------------------------------------
#define CLASS_REQ_NONE				0x00
#define CLASS_REQ_RESET				0x01
#define CLASS_REQ_RECOVERY			0x02
// ----------------------------------------------------
//   [INTER-CLASS COMMUNICATION] Resopnse of Requests
// ----------------------------------------------------
#define CLASS_REQ_ACCEPTED			0
#define CLASS_REQ_BUSY				1
#define CLASS_REQ_REFUSED			2
// ----------------------------------------------------
//   [INTER-CLASS COMMUNICATION] Status
// ----------------------------------------------------
#define CLASS_STS_NOT_READY			0x00
#define CLASS_STS_READY				0x01
#define CLASS_STS_ERROR_STOP		0x02
#define CLASS_STS_RESET_IN_PROGRESS	0x03
#define CLASS_STS_UNKNOWN			0xFF


#ifdef DEBUG_ON
#define  printf  ((int (*)(const char *,...))0x00002b84)
#define  scanf   ((int (*)(const char *,...))0x00002bd6)
#endif // DEBUG_ON

extern const char hex2char[256][3];

#endif
