<?php

// {{{ IC2_DatabaseManager

/**
 * ImageCache2 - 摜𑀍삷NX
 */
class IC2_DatabaseManager
{
    // {{{ update()

    /**
     * 摜XV
     */
    static public function update($updated)
    {
        if (empty($updated)) {
            return;
        }
        if (!is_array($updated)) {
            P2Util::pushInfoHtml('<p>WARNING! IC2_DatabaseManager::update(): sȈ</p>');
            return;
        }

        // gUNV̊Jn
        $ta = new IC2_DataObject_Images;
        $db = $ta->getDatabaseConnection();
        if ($db->phptype == 'pgsql') {
            $ta->query('BEGIN');
        } elseif ($db->phptype == 'sqlite') {
            $db->query('BEGIN;');
        }

        // 摜f[^XV
        foreach ($updated as $id => $data) {
            $icdb = new IC2_DataObject_Images;
            $icdb->whereAdd("id = $id");
            if ($icdb->find(true)) {
                // XV
                if ($icdb->memo != $data['memo']) {
                    $memo = new IC2_DataObject_Images;
                    $memo->memo = (strlen($data['memo']) > 0) ? $data['memo'] : '';
                    $memo->whereAdd("id = $id");
                    $memo->update();
                }
                // NXV
                if ($icdb->rank != $data['rank']) {
                    $rank = new IC2_DataObject_Images;
                    $rank->rank = $data['rank'];
                    $rank->whereAddQuoted('size', '=', $icdb->size);
                    $rank->whereAddQuoted('md5',  '=', $icdb->md5);
                    $rank->whereAddQuoted('mime', '=', $icdb->mime);
                    $rank->update();
                }
            }
        }

        // gUNṼR~bg
        if ($db->phptype == 'pgsql') {
            $ta->query('COMMIT');
        } elseif ($db->phptype == 'sqlite') {
            $db->query('COMMIT;');
        }
    }

    // }}}
    // {{{ remove()

    /**
     * 摜폜
     */
    static public function remove($target, $to_blacklist = false)
    {
        $removed_files = array();
        if (empty($target)) {
            return $removed_files;
        }
        if (!is_array($target)) {
            if (is_integer($target) || ctype_digit($target)) {
                $id = (int) $target;
                if ($id > 0) {
                    $target = array($id);
                } else {
                    return $removed_files;
                }
            } else {
                P2Util::pushInfoHtml('<p>WARNING! IC2_DatabaseManager::remove(): sȈ</p>');
                return $removed_files;
            }
        }

        // gUNV̊Jn
        $ta = new IC2_DataObject_Images;
        $db = $ta->getDatabaseConnection();
        if ($db->phptype == 'pgsql') {
            $ta->query('BEGIN');
        } elseif ($db->phptype == 'sqlite') {
            $db->query('BEGIN;');
        }

        // 摜폜
        foreach ($target as $id) {
            $icdb = new IC2_DataObject_Images;
            $icdb->whereAdd("id = {$id}");

            if ($icdb->find(true)) {
                // LbVĂt@C폜
                $sizes = array(
                    IC2_Thumbnailer::SIZE_PC,
                    IC2_Thumbnailer::SIZE_MOBILE,
                    IC2_Thumbnailer::SIZE_INTERMD,
                );
                $dprs = array(
                    IC2_Thumbnailer::DPR_DEFAULT,
                    IC2_Thumbnailer::DPR_1_5,
                    IC2_Thumbnailer::DPR_2_0,
                );
                foreach ($sizes as $size) {
                    foreach ($dprs as $dpr) {
                        $t = new IC2_Thumbnailer($size | $dpr);
                        $path = $t->thumbPath($icdb->size, $icdb->md5, $icdb->mime);
                        if (file_exists($path)) {
                            unlink($path);
                            $removed_files[] = $path;
                        }
                    }
                }
                $t = new IC2_Thumbnailer();
                $path = $t->srcPath($icdb->size, $icdb->md5, $icdb->mime);
                if (file_exists($path)) {
                    unlink($path);
                    $removed_files[] = $path;
                }

                // ubNXg̏
                if ($to_blacklist) {
                    $_blacklist = new IC2_DataObject_BlackList;
                    $_blacklist->size = $icdb->size;
                    $_blacklist->md5  = $icdb->md5;
                    if ($icdb->mime == 'clamscan/infected' || $icdb->rank == -4) {
                        $_blacklist->type = 2;
                    } elseif ($icdb->rank < 0) {
                        $_blacklist->type = 1;
                    } else {
                        $_blacklist->type = 0;
                    }
                }

                // 摜
                $remover = new IC2_DataObject_Images;
                $remover->whereAddQuoted('size', '=', $icdb->size);
                $remover->whereAddQuoted('md5',  '=', $icdb->md5);
                //$remover->whereAddQuoted('mime', '=', $icdb->mime); // SizeMD5ŏ\
                $remover->find();
                while ($remover->fetch()) {
                    // ubNXgɂ
                    if ($to_blacklist) {
                        $blacklist = clone $_blacklist;
                        $blacklist->uri = $remover->uri;
                        $blacklist->insert();
                    }
                    // e[u疕
                    $remover->delete();
                }
            }
        }

        // gUNṼR~bg
        if ($db->phptype == 'pgsql') {
            $ta->query('COMMIT');
        } elseif ($db->phptype == 'sqlite') {
            $db->query('COMMIT;');
        }

        return $removed_files;
    }

    // }}}
    // {{{ setRank()

    /**
     * Nݒ
     */
    static public function setRank($target, $rank)
    {
        if (empty($target)) {
            return;
        }
        if (!is_array($target)) {
            if (is_integer($updated) || ctype_digit($updated)) {
                $id = (int)$updated;
                if ($id > 0) {
                    $updated = array($id);
                } else {
                    return;
                }
            } else {
                P2Util::pushInfoHtml('<p>WARNING! IC2_DatabaseManager::setRank(): sȈ</p>');
                return $removed_files;
            }
        }

        $icdb = new IC2_DataObject_Images;
        $icdb->rank = $rank;
        foreach ($target as $id) {
            $icdb->whereAdd("id = $id", 'OR');
        }
        $icdb->update();
    }

    // }}}
    // {{{ addMemo()

    /**
     * ǉ
     */
    static public function addMemo($target, $memo)
    {
        if (empty($target)) {
            return;
        }
        if (!is_array($target)) {
            if (is_integer($updated) || ctype_digit($updated)) {
                $id = (int)$updated;
                if ($id > 0) {
                    $updated = array($id);
                } else {
                    return;
                }
            } else {
                P2Util::pushInfoHtml('<p>WARNING! IC2_DatabaseManager::addMemo(): sȈ</p>');
                return $removed_files;
            }
        }

        // gUNV̊Jn
        $ta = new IC2_DataObject_Images;
        $db = $ta->getDatabaseConnection();
        if ($db->phptype == 'pgsql') {
            $ta->query('BEGIN');
        } elseif ($db->phptype == 'sqlite') {
            $db->query('BEGIN;');
        }

        // Ɏw蕶񂪊܂܂ĂȂ΍XV
        foreach ($target as $id) {
            $find = new IC2_DataObject_Images;
            $find->whereAdd("id = $id");
            if ($find->find(true) && strpos($find->memo, $memo) === false) {
                $update = new IC2_DataObject_Images;
                $update->whereAdd("id = $id");
                if (strlen($find->memo) > 0) {
                    $update->memo = $find->memo . ' ' . $memo;
                } else {
                    $update->memo = $memo;
                }
                $update->update();
                unset($update);
            }
            unset($find);
        }

        // gUNṼR~bg
        if ($db->phptype == 'pgsql') {
            $ta->query('COMMIT');
        } elseif ($db->phptype == 'sqlite') {
            $db->query('COMMIT;');
        }
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
