<?php
// {{{ SettingTxt

/**
 * p2 - 2ch  SETTING.TXT NX
 * http://news19.2ch.net/newsplus/SETTING.TXT
 *
 * @since 2006/02/27
 */
class SettingTxt
{
    // {{{ properties

    public $setting_array; // SETTING.TXTp[XAzz

    private $_host;
    private $_bbs;
    private $_url;           // SETTING.TXT URL
    private $_setting_txt;   // SETTING.TXT [Jۑt@CpX
    private $_setting_srd;   // p2_kb_setting.srd $this->setting_array  serialize() f[^t@CpX
    private $_cache_interval;

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     */
    public function __construct($host, $bbs)
    {
        $this->_cache_interval = 60 * 60 * 12; // LbV12ԗL

        $this->_host = $host;
        $this->_bbs =  $bbs;

        $dat_host_bbs_dir_s = P2Util::datDirOfHostBbs($host, $bbs);
        $this->_setting_txt = $dat_host_bbs_dir_s . 'SETTING.TXT';
        $this->_setting_srd = $dat_host_bbs_dir_s . 'p2_kb_setting.srd';

        $this->_url = 'http://' . $host . '/' . $bbs . '/SETTING.TXT';
        //$this->_url = P2Util::adjustHostJbbs($this->_url); // ΂livedoorړ]ɑΉBǍlivedoorƂB

        $this->setting_array = array();

        // SETTING.TXT _E[hZbg
        $this->dlAndSetData();
    }

    // }}}
    // {{{ dlAndSetData()

    /**
     * SETTING.TXT _E[hZbg
     *
     * @return boolean Zbgł trueAłȂ false
     */
    public function dlAndSetData()
    {
        $this->downloadSettingTxt();

        return $this->setSettingArray();
    }

    // }}}
    // {{{ downloadSettingTxt()

    /**
     * SETTING.TXT _E[hāAp[XāALbV
     *
     * @return boolean s
     */
    public function downloadSettingTxt()
    {
        global $_conf;

        // ܂BBSE  SETTING.TXT ݂Ȃ̂Ƃ
        if (P2Util::isHostMachiBbs($this->_host) || P2Util::isHostJbbsShitaraba($this->_host)) {
            return false;
        }

        $perm = (isset($_conf['dl_perm'])) ? $_conf['dl_perm'] : 0606;

        FileCtl::mkdirFor($this->_setting_txt); // fBNg΍

        if (file_exists($this->_setting_srd) && file_exists($this->_setting_txt)) {
            // XVȂꍇ́ȀŔĂ܂
            if (!empty($_GET['norefresh']) || isset($_REQUEST['word'])) {
                return true;
            // LbVVꍇ
            } elseif ($this->isCacheFresh()) {
                return true;
            }
            $modified = http_date(filemtime($this->_setting_txt));
        } else {
            $modified = false;
        }

        // DL
        if (!class_exists('HTTP_Request', false)) {
            require 'HTTP/Request.php';
        }

        $params = array();
        $params['timeout'] = $_conf['http_conn_timeout'];
        $params['readTimeout'] = array($_conf['http_read_timeout'], 0);
        if ($_conf['proxy_use']) {
            $params['proxy_host'] = $_conf['proxy_host'];
            $params['proxy_port'] = $_conf['proxy_port'];
        }
        $req = new HTTP_Request($this->_url, $params);
        $modified && $req->addHeader('If-Modified-Since', $modified);
        $req->addHeader('User-Agent', "Monazilla/1.00 ({$_conf['p2ua']})");

        $response = $req->sendRequest();

        if (PEAR::isError($response)) {
            $error_msg = $response->getMessage();
        } else {
            $code = $req->getResponseCode();

            if ($code == 302) {
                // zXg̈ړ]ǐ
                $new_host = BbsMap::getCurrentHost($this->_host, $this->_bbs);
                if ($new_host != $this->_host) {
                    $aNewSettingTxt = new SettingTxt($new_host, $this->_bbs);
                    $body = $aNewSettingTxt->downloadSettingTxt();
                    return true;
                }
            }

            if (!($code == 200 || $code == 206 || $code == 304)) {
                //var_dump($req->getResponseHeader());
                $error_msg = $code;
            }
        }

        // DLG[
        if (isset($error_msg) && strlen($error_msg) > 0) {
            $url_t = P2Util::throughIme($this->_url);
            $info_msg_ht = "<p class=\"info-msg\">Error: {$error_msg}<br>";
            $info_msg_ht .= "rep2 info: <a href=\"{$url_t}\"{$_conf['ext_win_target_at']}>{$this->_url}</a> ɐڑł܂łB</p>";
            P2Util::pushInfoHtml($info_msg_ht);
            touch($this->_setting_txt); // DLsꍇ touch
            return false;

        }

        $body = $req->getResponseBody();

        // DL  XVĂۑ
        if ($body && $code != "304") {

            //  or be.2ch.net ȂEUCSJISɕϊ
            if (P2Util::isHostJbbsShitaraba($this->_host) || P2Util::isHostBe2chNet($this->_host)) {
                $body = mb_convert_encoding($body, 'CP932', 'CP51932');
            }

            if (FileCtl::file_write_contents($this->_setting_txt, $body) === false) {
                p2die('cannot write file');
            }
            chmod($this->_setting_txt, $perm);

            // p[XăLbVۑ
            if (!$this->cacheParsedSettingTxt()) {
                return false;
            }

        } else {
            // touch邱ƂōXVC^[ôŁA΂炭ă`FbNȂȂ
            touch($this->_setting_txt);
            // ɃLbVtouchȂƁA_setting_txt_setting_srdōXVԂA
            // 񂱂܂ŏiT[oւ̃wb_NGXgԁjꍇB
            touch($this->_setting_srd);
        }

        return true;
    }

    // }}}
    // {{{ isCacheFresh()

    /**
     * LbVVNȂ true Ԃ
     *
     * @return boolean VNȂ trueBłȂ falseB
     */
    public function isCacheFresh()
    {
        // LbVꍇ
        if (file_exists($this->_setting_srd)) {
            // LbV̍XVw莞ԈȓȂ
            // clearstatcache();
            if (filemtime($this->_setting_srd) > time() - $this->_cache_interval) {
                return true;
            }
        }

        return false;
    }

    // }}}
    // {{{ cacheParsedSettingTxt()

    /**
     * SETTING.TXT p[XăLbVۑ
     *
     * ΁A$this->setting_array Zbg
     *
     * @return boolean s
     */
    public function cacheParsedSettingTxt()
    {
        global $_conf;

        $this->setting_array = array();

        if (!$lines = FileCtl::file_read_lines($this->_setting_txt)) {
            return false;
        }

        foreach ($lines as $line) {
            if (strpos($line, '=') !== false) {
                list($key, $value) = explode('=', $line, 2);
                $key = trim($key);
                $value = trim($value);
                $this->setting_array[$key] = $value;
            }
        }
        $this->setting_array['p2version'] = $_conf['p2version'];

        // p[XLbVt@Cۑ
        if (FileCtl::file_write_contents($this->_setting_srd, serialize($this->setting_array)) === false) {
            return false;
        }

        return true;
    }

    // }}}
    // {{{ setSettingArray()

    /**
     * SETTING.TXT ̃p[Xf[^ǂݍ
     *
     * ΁A$this->setting_array Zbg
     *
     * @return boolean s
     */
    public function setSettingArray()
    {
        global $_conf;

        if (!file_exists($this->_setting_srd)) {
            return false;
        }

        $this->setting_array = unserialize(file_get_contents($this->_setting_srd));

        /*
        if ($this->setting_array['p2version'] != $_conf['p2version']) {
            unlink($this->_setting_srd);
            unlink($this->_setting_txt);
        }
        */

        return (bool)$this->setting_array;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
