<?php
require_once 'HTTP/Client.php';

// {{{ P2Client

/**
 * p2.2ch.net NCAg
 */
class P2Client
{
    // {{{ constants

    /**
     * CookieۑSQLite3f[^x[X̃t@C
     */
    const COOKIE_STORE_NAME = 'p2_2ch_net_cookies.sqlite3';

    /**
     * eGg|Cg̖O
     */
    const SCRIPT_NAME_READ = 'read.php';
    const SCRIPT_NAME_POST = 'post.php';
    const SCRIPT_NAME_INFO = 'info.php';
    const SCRIPT_NAME_DAT  = 'dat.php';

    /**
     * User-Agent
     */
    const HTTP_USER_AGENT = 'PHP P2Client class';

    /**
     * HTTPNGXg̃p[^
     */
    const REQUEST_PARAMETER_LOGIN_ID    = 'form_login_id';
    const REQUEST_PARAMETER_LOGIN_PASS  = 'form_login_pass';
    const REQUEST_PARAMETER_LOGIN_REGIST_COOKIE = 'regist_cookie';
    const REQUEST_PARAMETER_LOGIN_IGNORE_COOKIE_ADDR = 'ignore_cip';
    const REQUEST_PARAMETER_HOST    = 'host';
    const REQUEST_PARAMETER_BBS     = 'bbs';
    const REQUEST_PARAMETER_KEY     = 'key';
    const REQUEST_PARAMETER_LS      = 'ls';
    const REQUEST_PARAMETER_NAME    = 'FROM';
    const REQUEST_PARAMETER_MAIL    = 'mail';
    const REQUEST_PARAMETER_MESSAGE = 'MESSAGE';
    const REQUEST_PARAMETER_POPUP   = 'popup';
    const REQUEST_PARAMETER_BERES   = 'submit_beres';
    const REQUEST_PARAMETER_CHARACTER_SET_DETECTION_HINT = 'detect_hint';

    /**
     * HTTPNGXǧŒp[^
     */
    const REQUEST_DATA_CHARACTER_SET_DETECTION_HINT = '';
    const REQUEST_DATA_LS_LAST1_NO_FIRST = 'l1n';

    /**
     * ǂݍݐ۔̂߂̕
     */
    const NEEDLE_READ_NO_THREAD = '<b>p2 info - T[oŐṼXbh擾ł܂łB</b>';
    const NEEDLE_DAT_NO_DAT = '<h4>p2 error: wDAT͂܂ł</h4>';

    /**
     * ݐ۔̂߂̐K\
     */
    const REGEX_POST_SUCCESS = '{<title>.*(?:(?:|)݂܂|ݏI - SubAll BBS).*</title>}is';
    const REGEX_POST_COOKIE  = '{<!-- 2ch_X:cookie -->|<title> ݊mF </title>|>݊mFB<}';

    // }}}
    // {{{ properties

    /**
     * HTMLǂݍ߂ȂƂ̑փGR[fBO
     *
     * @var array
     */
    static private $_fallbackEncodings = array('Windows-31J', 'Shift_JIS-2004');

    /**
     * p2̃[gURI
     *
     * @var string
     */
    private $_rootUri;

    /**
     * p2.2ch.net/^| OCID ([AhX)
     *
     * @var string
     */
    private $_loginId;

    /**
     * p2.2ch.net/^| OCpX[h
     *
     * @var string
     */
    private $_loginPass;

    /**
     * p2.2ch.net CookieF؎IPAhX̓ꐫ`FbNȂ
     *
     * @var bool
     */
    private $_ignoreCookieAddr;

    /**
     * CookieۑKey-Value StoreIuWFNg
     *
     * @var P2KeyValueStore_Serializing
     */
    private $_cookieStore;

    /**
     * CookieǗIuWFNg
     *
     * @var HTTP_Client_CookieManager
     */
    private $_cookieManager;

    /**
     * HTTPNCAgIuWFNg
     *
     * @var HTTP_Client
     */
    private $_httpClient;

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     *
     * @param string $rootUri
     * @param string $loginId
     * @param string $loginPass
     * @param string $cookieSaveDir
     * @param bool $ignoreCookieAddr
     * @throws P2Exception
     */
    public function __construct($rootUri,
                                $loginId,
                                $loginPass,
                                $cookieSaveDir,
                                $ignoreCookieAddr = false)
    {
        if (!preg_match('!^https?://.+/$!', $rootUri)) {
            throw new Exception('Invalid root URI was given.');
        }
        $this->_rootUri = $rootUri;

        try {
            $cookieSavePath = $cookieSaveDir . DIRECTORY_SEPARATOR . self::COOKIE_STORE_NAME;
            $cookieStore = P2KeyValueStore::getStore($cookieSavePath,
                                                     P2KeyValueStore::CODEC_SERIALIZING);
        } catch (Exception $e) {
            throw new P2Exception(get_class($e) . ': ' . $e->getMessage());
        }

        if ($cookieManager = $cookieStore->get($loginId)) {
            if (!($cookieManager instanceof HTTP_Client_CookieManager)) {
                $cookieStore->delete($loginId);
                throw new Exception('Cannot restore the cookie manager.');
            }
        } else {
            $cookieManager = new HTTP_Client_CookieManager;
        }

        $this->_loginId = $loginId;
        $this->_loginPass = $loginPass;
        $this->_cookieStore = $cookieStore;
        $this->_cookieManager = $cookieManager;
        $this->_ignoreCookieAddr = $ignoreCookieAddr;

        $defaultHeaders = array(
            'User-Agent' => self::HTTP_USER_AGENT,
        );
        $this->_httpClient = new HTTP_Client(null, $defaultHeaders, $cookieManager);
    }

    // }}}
    // {{{ destructor

    /**
     * f[^x[XCookieۑ
     *
     * @param void
     */
    public function __destruct()
    {
        $this->_cookieStore->set($this->_loginId, $this->_cookieManager);
    }

    // }}}
    // {{{ login()

    /**
     * p2ɃOC
     *
     * @param string $uri
     * @param array $data
     * @param P2DOM $dom
     * @param DOMElement $form
     * @param mixed &$response
     * @return bool
     * @throws P2Exception
     */
    public function login($uri = null, array $data = array(),
                          P2DOM $dom = null, DOMElement $form = null,
                          &$response = null)
    {
        if ($uri === null) {
            $uri = $this->_rootUri;
        }

        if ($dom === null) {
            $response = $this->httpGet($uri);
            $dom = new P2DOM($response['body'], self::$_fallbackEncodings);
            $form = null;
        }

        if ($form === null) {
            $form = $this->getLoginForm($dom);
            if ($form === null) {
                throw new P2Exception('Login form not found.');
            }
        }

        $postData = array();
        foreach ($data as $name => $value) {
            $postData[$name] = rawurlencode($value);
        }
        $postData = $this->getFormValues($dom, $form, $postData);
        $postData[self::REQUEST_PARAMETER_LOGIN_ID] = rawurlencode($this->_loginId);
        $postData[self::REQUEST_PARAMETER_LOGIN_PASS] = rawurlencode($this->_loginPass);
        $postData[self::REQUEST_PARAMETER_LOGIN_REGIST_COOKIE] = '1';
        if ($this->_ignoreCookieAddr) {
            $postData[self::REQUEST_PARAMETER_LOGIN_IGNORE_COOKIE_ADDR] = '1';
        } elseif (array_key_exists(self::REQUEST_PARAMETER_LOGIN_IGNORE_COOKIE_ADDR, $postData)) {
            unset($postData[self::REQUEST_PARAMETER_LOGIN_IGNORE_COOKIE_ADDR]);
        }

        $response = $this->httpPost($uri, $postData, true);

        return $this->getLoginForm(new P2DOM($response['body'], self::$_fallbackEncodings)) === null;
    }

    // }}}
    // {{{ readThread()

    /**
     * Xbhǂ
     *
     * @param string $host
     * @param string $bbs
     * @param string $key
     * @param string $ls
     * @param mixed &$response
     * @return string HTTPX|X{fB
     * @throws P2Exception
     */
    public function readThread($host, $bbs, $key, $ls = '1', &$response = null)
    {
        $getData = $this->setupGetData($host, $bbs, $key, $ls);
        $uri = $this->_rootUri . self::SCRIPT_NAME_READ;
        $response = $this->httpGet($uri, $getData, true);
        $dom = new P2DOM($response['body'], self::$_fallbackEncodings);

        if ($form = $this->getLoginForm($dom)) {
            if (!$this->login($uri, $getData, $dom, $form, $response)) {
                throw new P2Exception('Login failed.');
            }
        }

        if (strpos($response['body'], self::NEEDLE_READ_NO_THREAD) !== false) {
            return null;
        }

        return $response['body'];
    }

    // }}}
    // {{{ downloadDat()

    /**
     * dat荞
     *
     * dat擾ꍇ͎Ń^|dat擾B
     * sĂȂB
     *
     * @param string $host
     * @param string $bbs
     * @param string $key
     * @param mixed &$response
     * @return string dat
     * @throws P2Exception
     */
    public function downloadDat($host, $bbs, $key, &$response = null)
    {
        // Xbh̗Lm߂邽߁A܂ read.php @B
        // datɃzXgړ]ꍇAړ]̃zXgŃANZXĂ
        // Xbh擾łȂƂ̃bZ[W\B
        $html = $this->readThread($host, $bbs, $key,
                                  self::REQUEST_DATA_LS_LAST1_NO_FIRST,
                                  $response);
        if ($html === null) {
            return null;
        }

        // u^|p2Ɏ荞ށvN̗L𒲂ׂB
        // ꍇdat擾̂ƂB
        // dat擾Ȃꍇ⃂^|ʒ̎cȂꍇ̏͒[܂B
        $dom = new P2DOM($html, self::$_fallbackEncodings);
        $expression = './/a[contains(@href, "' . self::SCRIPT_NAME_READ . '?")'
                    . ' and contains(@href, "&moritapodat=")]';
        $result = $dom->query($expression);
        if (($result instanceof DOMNodeList) && $result->length > 0) {
            $anchor = $result->item(0);
            $uri = $this->_rootUri
                 . strstr($anchor->getAttribute('href'), self::SCRIPT_NAME_READ);
            $response = $this->httpGet($uri);
        }

        // dat擾B
        $getData = $this->setupGetData($host, $bbs, $key);
        $uri = $this->_rootUri . self::SCRIPT_NAME_DAT;
        $response = $this->httpGet($uri, $getData, true);

        if (strpos($response['body'], self::NEEDLE_DAT_NO_DAT) !== false) {
            return null;
        }

        return $response['body'];
    }

    // }}}
    // {{{ post()

    /**
     * Xbhɏ
     *
     * @param string $host
     * @param string $bbs
     * @param string $key
     * @param string $name
     * @param string $mail
     * @param string $message
     * @param bool $beRes
     * @param mixed &$response
     * @return bool
     * @throws P2Exception
     */
    public function post($host, $bbs, $key, $name, $mail, $message,
                         $beRes = false, &$response = null)
    {
        // csrfId擾Ap2̊ǂŐV̏Ԃɂ邽߁A܂ read.php @B
        // ʐMʂߖł悤 ls=l1n ƂĂB
        // popup=1 ͏݌̃y[WɃ_CNgȂ߁B
        $html = $this->readThread($host, $bbs, $key,
                                  self::REQUEST_DATA_LS_LAST1_NO_FIRST,
                                  $response);
        if ($html === null) {
            return false;
        }

        $dom = new P2DOM($html, self::$_fallbackEncodings);
        $form = $this->getPostForm($dom);
        if ($form === null) {
            throw new P2Exception('Post form not found.');
        }

        // POSTf[^pӁB
        $postData = $this->setupPostData($dom, $form, $name, $mail, $message);
        $postData[self::REQUEST_PARAMETER_POPUP] = '1';
        if ($beRes) {
            $postData[self::REQUEST_PARAMETER_BERES] = '1';
        } elseif (array_key_exists(self::REQUEST_PARAMETER_BERES, $postData)) {
            unset($postData[self::REQUEST_PARAMETER_BERES]);
        }

        // POSTsB
        $uri = $this->_rootUri . self::SCRIPT_NAME_POST;
        $response = $this->httpPost($uri, $postData, true);

        // CookiemF̏ꍇ͍POSTB
        if (preg_match(self::REGEX_POST_COOKIE, $response['body'])) {
            // x-sjislibxml2ŕsȕZbgɂȂA
            // G[͏oȂҒʂɓǂݍ߂Ȃ̂Shift_JIS}Ă
            $html = preg_replace('/<head[^<>]*>/i',
                                 '$0<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">',
                                 $response['body']);
            $dom = new P2DOM($html, self::$_fallbackEncodings);
            $expression = './/form[contains(@action, "' . self::SCRIPT_NAME_POST . '")]';
            $result = $dom->query($expression);
            if (($result instanceof DOMNodeList) && $result->length > 0) {
                $postData = $this->setupPostData($dom, $result->item(0), $name, $mail, $message);
                $response = $this->httpPost($uri, $postData, true);
            } else {
                return false;
            }
        }

        return (bool)preg_match(self::REGEX_POST_SUCCESS, $response['body']);
    }

    // }}}
    // {{{ httpGet()

    /**
     * HTTP_Client::get() ̃bp[\bh
     *
     * @param string $uri
     * @param mixed $data
     * @param bool $preEncoded
     * @param array $headers
     * @return array HTTPX|X
     * @throws P2Exception
     */
    protected function httpGet($uri, $data = null, $preEncoded = false,
                               $headers = array())
    {
        $code = $this->_httpClient->get($uri, $data, $preEncoded, $headers);
        P2Exception::pearErrorToP2Exception($code);
        if ($code != 200) {
            throw new P2Exception('HTTP '. $code);
        }
        return $this->_httpClient->currentResponse();
    }

    // }}}
    // {{{ httpPost()

    /**
     * HTTP_Client::post() ̃bp[\bh
     *
     * @param string $uri
     * @param mixed $data
     * @param bool $preEncoded
     * @param array $files
     * @param array $headers
     * @return array HTTPX|X
     * @throws P2Exception
     */
    protected function httpPost($uri, $data, $preEncoded = false,
                                $files = array(), $headers = array())
    {
        $code = $this->_httpClient->post($uri, $data, $preEncoded, $files, $headers);
        P2Exception::pearErrorToP2Exception($code);
        if ($code != 200) {
            throw new P2Exception('HTTP '. $code);
        }
        return $this->_httpClient->currentResponse();
    }

    // }}}
    // {{{ getLoginForm()

    /**
     * OCtH[𒊏o
     *
     * @paramP2DOM $dom
     * @return DOMElement|null
     */
    protected function getLoginForm(P2DOM $dom)
    {
        $result = $dom->query('.//form[@action and @id="login"]');
        if (($result instanceof DOMNodeList) && $result->length > 0) {
            return $result->item(0);
        }
        return null;
    }

    // }}}
    // {{{ getPostForm()

    /**
     * read.php/post_form.php ̏o͂珑݃tH[𒊏o
     *
     * @paramP2DOM $dom
     * @return DOMElement|null
     */
    protected function getPostForm(P2DOM $dom)
    {
        $result = $dom->query('.//form[@action and @id="resform"]');
        if (($result instanceof DOMNodeList) && $result->length > 0) {
            return $result->item(0);
        }
        return null;
    }

    // }}}
    // {{{ getFormValues()

    /**
     * tH[inputvf𒊏oAAzz𐶐
     *
     * selectvftextareavf͖B
     * ܂A<input type="checkbox" name="foo[]" value="bar"> ̂悤
     * nameŔzwĂ̂͐ȂB
     * (̃NX̂vfKv̂ꍇlĂȂ)
     *
     * @param P2DOM $dom
     * @param DOMElement $form
     * @param array $data
     * @param bool $raw
     * @return array
     */
    protected function getFormValues(P2DOM $dom, DOMElement $form,
                                     array $data = array(), $raw = false)
    {
        $fields = $dom->query('.//input[@name and @value]', $form);
        foreach ($fields as $field) {
            $name = $field->getAttribute('name');
            $value = $field->getAttribute('value');
            if (!$raw) {
                $value = rawurlencode(mb_convert_encoding($value, 'SJIS-win', 'UTF-8'));
            }
            $data[$name] = $value;
        }

        return $data;
    }

    // }}}
    // {{{ setupGetData()

    /**
     * Xbhǂނ߂̋ʃp[^̔z𐶐
     *
     * @param string $host
     * @param string $bbs
     * @param string $key
     * @return array
     */
    protected function setupGetData($host, $bbs, $key, $ls = null)
    {
        $data = array(
            self::REQUEST_PARAMETER_HOST => rawurlencode($host),
            self::REQUEST_PARAMETER_BBS => rawurlencode($bbs),
            self::REQUEST_PARAMETER_KEY => rawurlencode($key),
        );
        if ($ls !== null) {
            $data[self::REQUEST_PARAMETER_LS] = rawurlencode($ls);
        }

        return $data;
    }

    // }}}
    // {{{ setupPostData()

    /**
     * Xbhɏނ߂̋ʃp[^̔z𐶐
     *
     * @param P2DOM $dom
     * @param DOMElement $form
     * @param string $key
     * @param string $name
     * @param string $mail
     * @param string $message
     * @return array
     */
    protected function setupPostData(P2DOM $dom, DOMElement $form,
                                     $name, $mail, $message)
    {
        $data = $this->getFormValues($dom, $form);
        $data[self::REQUEST_PARAMETER_CHARACTER_SET_DETECTION_HINT] =
            rawurlencode(self::REQUEST_DATA_CHARACTER_SET_DETECTION_HINT);
        $data[self::REQUEST_PARAMETER_NAME] = rawurlencode($name);
        $data[self::REQUEST_PARAMETER_MAIL] = rawurlencode($mail);
        $data[self::REQUEST_PARAMETER_MESSAGE] = rawurlencode($message);

        return $data;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
