<?php

// {{{ Login

/**
 * rep2 - OCF؂NX
 *
 * @create  2005/6/14
 * @author aki
 */
class Login
{
    // {{{ properties

    public $user;   // [UiIȂ́j
    public $user_u; // [Ui[UƒڐG镔j
    public $pass_x; // ÍꂽpX[h

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     */
    public function __construct()
    {
        $login_user = $this->setdownLoginUser();

        // [Uw肳ĂȂ
        if ($login_user == NULL) {

            // OCs
            require_once P2_LIB_DIR . '/login_first.inc.php';
            printLoginFirst($this);
            exit;
        }

        $this->setUser($login_user);
        $this->pass_x = NULL;
    }

    // }}}
    // {{{ setUser()

    /**
     * [UZbg
     */
    public function setUser($user)
    {
        $this->user_u = $user;
        $this->user = $user;
    }

    // }}}
    // {{{ setdownLoginUser()

    /**
     * OC[U̎w𓾂
     */
    public function setdownLoginUser()
    {
        $login_user = NULL;

        // [U̗D揇ʂɉ

        // OCtH[̎w
        if (!empty($GLOBALS['brazil'])) {
            $add_mail = '.,@-';
        } else {
            $add_mail = '';
        }
        if (isset($_REQUEST['form_login_id']) && preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_REQUEST['form_login_id'])) {
            $login_user = $this->setdownLoginUserWithRequest();

        // GETł̎w
        } elseif (isset($_REQUEST['user']) && preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_REQUEST['user'])) {
            $login_user = $_REQUEST['user'];

        // CookieŎw
        } elseif (isset($_COOKIE['cid']) && ($user = $this->getUserFromCid($_COOKIE['cid'])) !== false) {
            if (preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $user)) {
                $login_user = $user;
            }

        // SessionŎw
        } elseif (isset($_SESSION['login_user']) && preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_SESSION['login_user'])) {
            $login_user = $_SESSION['login_user'];

        /*
        // BasicF؂Ŏw
        } elseif (!empty($_REQUEST['basic'])) {

            if (isset($_SERVER['PHP_AUTH_USER']) && (preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_SERVER['PHP_AUTH_USER']))) {
                $login_user = $_SERVER['PHP_AUTH_USER'];

            } else {
                header('WWW-Authenticate: Basic realm="zone"');
                header('HTTP/1.0 401 Unauthorized');
                echo 'Login Failed. [UF؂Ɏs܂B';
                exit;
            }
        */

        }

        return $login_user;
    }

    // }}}
    // {{{ setdownLoginUserWithRequest()

    /**
     * REQUEST烍OC[U̎w𓾂
     */
    public function setdownLoginUserWithRequest()
    {
        return $_REQUEST['form_login_id'];
    }

    // }}}
    // {{{ authorize()

    /**
     * F؂s
     */
    public function authorize()
    {
        global $_conf, $_p2session;

        // {{{ F؃`FbN

        $auth_result = $this->_authCheck();
        if (!$auth_result) {
            // OCs
            if (!function_exists('printLoginFirst')) {
                include P2_LIB_DIR . '/login_first.inc.php';
            }
            printLoginFirst($this);
            exit;
        }

        // }}}

        // OCOKȂ

        // {{{ OAEg̎w肪

        if (!empty($_REQUEST['logout'])) {

            // ZbVNAiANeBuAANeBu킸j
            Session::unSession();

            // ⏕F؂NA
            $this->clearCookieAuth();

            $url = rtrim(dirname(P2Util::getMyUrl()), '/') . '/'; // . $user_u_q;

            header('Location: '.$url);
            exit;
        }

        // }}}
        // {{{ ZbVpĂȂAZbVϐ̍XV

        if (isset($_p2session)) {

            // [UƃpXXXV
            $_SESSION['login_user']   = $this->user_u;
            $_SESSION['login_pass_x'] = $this->pass_x;
            if (!array_key_exists('login_microtime', $_SESSION)) {
                $_SESSION['login_microtime'] = microtime();
            }

            // devicePixelRatiow肪Εێ
            if (!empty($_REQUEST['device_pixel_ratio'])) {
                $device_pixel_ratio = floatval($_REQUEST['device_pixel_ratio']);
                if ($device_pixel_ratio === 1.5 || $device_pixel_ratio === 2.0) {
                    $_SESSION['device_pixel_ratio'] = $device_pixel_ratio;
                }
            }
        }

        // }}}
        // {{{ v΁A⏕F؂o^

        $this->registerCookie();

        // }}}

        // ZbVF؈ȊOɎgȂꍇ͕
        if (P2_SESSION_CLOSE_AFTER_AUTHENTICATION) {
            session_write_close();
        }

        // _authCheck() ԂƂ́AURLƌȂă_CNg
        if (is_string($auth_result)) {
            header('Location: ' . $auth_result);
            exit;
        }

        return true;
    }

    // }}}
    // {{{ checkAuthUserFile()

    /**
     * F؃[Uݒ̃t@C𒲂ׂāAȃf[^Ȃ̂ĂĂ܂
     */
    public function checkAuthUserFile()
    {
        global $_conf;

        if (@include($_conf['auth_user_file'])) {
            // [U񂪂ȂAt@ĈĂĔ
            if (empty($rec_login_user_u) || empty($rec_login_pass_x)) {
                unlink($_conf['auth_user_file']);
            }
        }

        return true;
    }

    // }}}
    // {{{ _authCheck()

    /**
     * F؂̃`FbNs
     *
     * @return bool
     */
    private function _authCheck()
    {
        global $_conf;
        global $_login_failed_flag;
        global $_p2session;

        $this->checkAuthUserFile();

        // F؃[Uݒit@Cjǂݍ݂ł
        if (file_exists($_conf['auth_user_file'])) {
            include $_conf['auth_user_file'];

            // [UAF؎sŔ
            if ($this->user_u != $rec_login_user_u) {
                P2Util::pushInfoHtml('<p>p2 error: OCG[</p>');

                // OCsOL^
                if (!empty($_conf['login_log_rec'])) {
                    $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
                    P2Util::recAccessLog($_conf['login_failed_log_file'], $recnum);
                }

                return false;
            }

            // pX[hݒ肪΁AZbg
            if (isset($rec_login_pass_x) && strlen($rec_login_pass_x) > 0) {
                $this->pass_x = $rec_login_pass_x;
            }
        }

        // Fؐݒ or pX[hL^Ȃꍇ͂܂
        if (!$this->pass_x) {

            // VKo^łȂ΃G[\
            if (empty($_POST['submit_new'])) {
                P2Util::pushInfoHtml('<p>p2 error: OCG[</p>');
            }

            return false;
        }

        // {{{ NbL[F؃pXX[

        if (isset($_COOKIE['cid'])) {

            if ($this->checkUserPwWithCid($_COOKIE['cid'])) {
                return true;

            // CookieF؂ʂȂ
            } else {
                // ÂNbL[NAĂ
                $this->clearCookieAuth();
            }
        }

        // }}}
        // {{{ łɃZbVo^ĂAZbVŔF

        if (isset($_SESSION['login_user']) && isset($_SESSION['login_pass_x'])) {

            // ZbVpĂȂAZbV̑Ó`FbN
            if (isset($_p2session)) {
                if ($msg = $_p2session->checkSessionError()) {
                    P2Util::pushInfoHtml('<p>p2 error: ' . htmlspecialchars($msg) . '</p>');
                    //Session::unSession();
                    // OCs
                    return false;
                }
            }

            if ($this->user_u == $_SESSION['login_user']) {
                if ($_SESSION['login_pass_x'] != $this->pass_x) {
                    Session::unSession();
                    return false;

                } else {
                    return true;
                }
            }
        }

        // }}}

        $mobile = Net_UserAgent_Mobile::singleton();

        // {{{ tH[烍OC

        if (!empty($_POST['submit_member'])) {

            // tH[OCȂ
            if ($_POST['form_login_id'] == $this->user_u and sha1($_POST['form_login_pass']) == $this->pass_x) {

                // ÂNbL[NAĂ
                $this->clearCookieAuth();

                // OCOL^
                $this->logLoginSuccess();

                // _CNg
                return $_SERVER['REQUEST_URI'];
                //return true;

            // tH[OCsȂ
            } else {
                P2Util::pushInfoHtml('<p>p2 info: OCł܂łB<br>[UpX[hႢ܂B</p>');
                $_login_failed_flag = true;

                // OCsOL^
                $this->logLoginFailed();

                return false;
            }
        }

        // }}}

        return false;
    }

    // }}}
    // {{{ logLoginSuccess()

    /**
     * OCOL^
     */
    public function logLoginSuccess()
    {
        global $_conf;

        if (!empty($_conf['login_log_rec'])) {
            $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
            P2Util::recAccessLog($_conf['login_log_file'], $recnum);
        }

        return true;
    }

    // }}}
    // {{{ logLoginFailed()

    /**
     * OCsOL^
     */
    public function logLoginFailed()
    {
        global $_conf;

        if (!empty($_conf['login_log_rec'])) {
            $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
            P2Util::recAccessLog($_conf['login_failed_log_file'], $recnum, 'txt');
        }

        return true;
    }

    // }}}
    // {{{ _registerAuth()

    /**
     * [IDF؃t@Co^
     */
    private function _registerAuth($key, $sub_id, $auth_file)
    {
        global $_conf;

        $cont = <<<EOP
<?php
\${$key}='{$sub_id}';
?>
EOP;
        FileCtl::make_datafile($auth_file, $_conf['pass_perm']);
        $fp = fopen($auth_file, 'wb');
        if (!$fp) {
            P2Util::pushInfoHtml('<p>Error: f[^ۑł܂łBFؓo^sB</p>');
            return false;
        }
        flock($fp, LOCK_EX);
        fwrite($fp, $cont);
        flock($fp, LOCK_UN);
        fclose($fp);
        return true;
    }

    // }}}
    // {{{ _registerAuthOff()

    /**
     * [ID̔F؃t@Co^O
     */
    private function _registerAuthOff($auth_file)
    {
        if (file_exists($auth_file)) {
            unlink($auth_file);
        }
    }

    // }}}
    // {{{ makeUser()

    /**
     * VK[U쐬
     */
    public function makeUser($user_u, $pass)
    {
        global $_conf;

        $crypted_login_pass = sha1($pass);
        $auth_user_cont = <<<EOP
<?php
\$rec_login_user_u = '{$user_u}';
\$rec_login_pass_x = '{$crypted_login_pass}';
?>
EOP;
        FileCtl::make_datafile($_conf['auth_user_file'], $_conf['pass_perm']); // t@CȂΐ
        if (FileCtl::file_write_contents($_conf['auth_user_file'], $auth_user_cont) === false) {
            p2die("{$_conf['auth_user_file']} ۑł܂łBF{$p_str['user']}o^sB");
        }

        return true;
    }

    // }}}
    // {{{ registerCookie()

    /**
     * cookieF؂o^/
     *
     * @param void
     * @return boolean
     */
    public function registerCookie()
    {
        $r = true;

        if (!empty($_REQUEST['ctl_keep_login'])) {
            if (!empty($_REQUEST['keep_login'])) {
                $r = $this->setCookieCid($this->user_u, $this->pass_x);
            } else {
                // NbL[NA
                $r = $this->clearCookieAuth();
            }
        }

        return $r;
    }

    // }}}
    // {{{ clearCookieAuth()

    /**
     * CookieF؂NA
     */
    public function clearCookieAuth()
    {
        setcookie('cid', '', time() - 3600);
        /*
        setcookie('p2_user', '', time() - 3600);    //  p~vf 2005/6/13
        setcookie('p2_pass', '', time() - 3600);    //  p~vf 2005/6/13
        setcookie('p2_pass_x', '', time() - 3600);  //  p~vf 2005/6/13
        */
        $_COOKIE = array();

        return true;
    }

    // }}}
    // {{{ setCookieCid()

    /**
     * CIDcookieɃZbg
     *
     * @param string $user_u
     * @param string $pass_x
     * @return boolean
     */
    protected function setCookieCid($user_u, $pass_x)
    {
        global $_conf;

        $time = time() + 60*60*24 * $_conf['cid_expire_day'];

        if ($cid = $this->makeCid($user_u, $pass_x)) {
            return P2Util::setCookie('cid', $cid, $time);
        }
        return false;
    }

    // }}}
    // {{{ makeCid()

    /**
     * IDPASSƎԂ߂ĈÍCookieiCIDj𐶐擾
     *
     * @return mixed
     */
    public function makeCid($user_u, $pass_x)
    {
        if (is_null($user_u) || is_null($pass_x)) {
            return false;
        }

        $user_time  = $user_u . ':' . time() . ':';
        $md5_utpx = md5($user_time . $pass_x);
        $cid_src  = $user_time . $md5_utpx;
        if (isset($_SESSION['device_pixel_ratio'])) {
            $cid_src .= ':' . $_SESSION['device_pixel_ratio'];
        }
        return MD5Crypt::encrypt($cid_src, self::getMd5CryptPassForCid());
    }

    // }}}
    // {{{ getCidInfo()

    /**
     * CookieiCIDj烆[U𓾂
     *
     * @return array|false ΔzAsȂ false Ԃ
     */
    public function getCidInfo($cid)
    {
        global $_conf;

        $dec = MD5Crypt::decrypt($cid, self::getMd5CryptPassForCid());

        $cid_info = explode(':', $dec);
        switch (count($cid_info)) {
            case 3:
                break;
            case 4:
                $device_pixel_ratio = floatval(array_pop($cid_info));
                if (isset($GLOBALS['_p2session'])
                    && ($device_pixel_ratio === 1.5 || $device_pixel_ratio === 2.0)
                ) {
                    $_SESSION['device_pixel_ratio'] = $device_pixel_ratio;
                }
                break;
            default:
                return false;
        }

        list($user, $time, $md5_utpx) = $cid_info;
        if (!strlen($user) || !$time || !$md5_utpx) {
            return false;
        }

        // L 
        if (time() > $time + (60*60*24 * $_conf['cid_expire_day'])) {
            return false; // ؂
        }

        return $cid_info;
    }

    // }}}
    // {{{ getUserFromCid()

    /**
     * CookieiCIDjuser𓾂
     *
     * @return mixed
     */
    public function getUserFromCid($cid)
    {
        if (!$ar = $this->getCidInfo($cid)) {
            return false;
        }

        return $user = $ar[0];
    }

    // }}}
    // {{{ checkUserPwWithCid()

    /**
     * CookieiCIDjuser, passƍ
     *
     * @return boolean
     */
    public function checkUserPwWithCid($cid)
    {
        global $_conf;

        if (is_null($this->user_u) || is_null($this->pass_x) || is_null($cid)) {
            return false;
        }

        if (!$ar = $this->getCidInfo($cid)) {
            return false;
        }

        $time = $ar[1];
        $pw_enc = $ar[2];

        // PWƍ
        if ($pw_enc == md5($this->user_u . ':' . $time . ':' . $this->pass_x)) {
            return true;
        } else {
            return false;
        }
    }

    // }}}
    // {{{ getMd5CryptPassForCid()

    /**
     * MD5Crypt::encrypt, MD5Crypt::decrypt ̂߂ password(salt) 𓾂
     * iNbL[cid̐ɗpĂj
     *
     * @param   void
     * @access  private
     * @return  string
     */
    static private function getMd5CryptPassForCid()
    {
        static $pass = null;

        if ($pass !== null) {
            return $pass;
        }

        $seed = $_SERVER['SERVER_SOFTWARE'];
        $pass = md5($seed, true);

        return $pass;
    }

    // }}}
    // {{{ _checkIp()

    /**
     * IPAhXш̌؂
     *
     * @param string $type
     * @return bool
     */
    private function _checkIp($type)
    {
        $method = 'isAddress' . ucfirst(strtolower($type));
        if (method_exists('HostCheck', $method)) {
            return HostCheck::$method();
        }

        // ɗȂ悤ɈLq邱
        p2die('Login::_checkIp() Failure', "Invalid argument ({$type}).");
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
