<?php
require_once P2_LIB_DIR . '/DataPhp.php';

/**
 * p2p̃[eBeBNX
 * static\bhŗp
 * 
 * @created  2004/07/15
 */
class P2Util
{
    /**
     * X̃qbgCNg
     *
     * @access  public
     * @return  boolean
     */
    function incrementFilterHits()
    {
        $GLOBALS['_filter_hits']++;
    }
    
    /**
     * XȂtrueԂ
     *
     * @access  public
     * @return  boolean
     */
    function ifFiltering()
    {
        return geti($GLOBALS['word']);
        //return !is_null($GLOBALS['_filter_hits']);
    }
    
    /**
     * @access  public
     * @return  boolean
     */
    function enableBe2ch()
    {
        global $_conf;
        
        if (
            strlen($_conf['be_2ch_password']) && $_conf['be_2ch_mail']
            || strlen($_conf['be_2ch_DMDM']) && $_conf['be_2ch_MDMD']
            //|| isset($_COOKIE['DMDM']) && isset($_COOKIE['MDMD'])
        ) {
            return true;
        }
        return false;
    }
    
    /**
     * [U[ݒ肵AJEgŁAbe.2ch.netɃOCDMDM, MDMD擾
     * iF؃R[hurlencodeꂽ܂܂̏ԁj
     *
     * @access  public
     * @return  array|false|null  F؃R[hz|F؂łȂ|ݒ肾
     */
    function getBe2chCodeWithUserConf()
    {
        global $_conf;

        if ($_conf['be_2ch_mail'] && strlen($_conf['be_2ch_password'])) {
            $r = P2Util::getBe2chCodeByMailPass($_conf['be_2ch_mail'], $_conf['be_2ch_password']);
            if (is_array($r)) {
                return $r;
            }
            return false;
        }
        return null;
    }
    
    /**
     * be.2ch.netɃOCDMDM, MDMD擾
     * iF؃R[hurlencodeꂽ܂܂̏ԁj
     *
     * @access  private
     * @return  array|string |G[bZ[W
     */
    function getBe2chCodeByMailPass($mail, $pass)
    {
        global $_conf;
        
        require_once 'HTTP/Request.php';
    
        $params = array('timeout' => $_conf['fsockopen_timeout']);
        
        if (!empty($GLOBALS['_conf']['proxy_use'])) {
            $params['proxy_host'] = $GLOBALS['_conf']['proxy_host'];
            $params['proxy_port'] = $GLOBALS['_conf']['proxy_port'];
        }
        
        $req = new HTTP_Request('http://be.2ch.net/test/login.php', $params);
        
        $req->setMethod(HTTP_REQUEST_METHOD_POST);
        $req->addPostData('m', $mail);
        $be2chEncoding = 'eucJP-win';
        $req->addPostData('p', mb_convert_encoding($pass, $be2chEncoding, mb_internal_encoding()));
        $req->addPostData('submit', mb_convert_encoding('o^', $be2chEncoding, mb_internal_encoding()));
        
        //var_dump($req);
        // If-Modified-Since => gmdate('D, d M Y H:i:s', time()) . ' GMT';
        
        /*
        if ($headers) {
            foreach ($headers as $k => $v) {
                $req->addHeader($k, $v);
            }
        }
        */
        
        // 2011/01/11 ۂSet-CookieŔʂ΂
        // ʖڂȂƂ́usȃNGXgvƂupX[h[AhXȂ悤łBvԂ
        // 
        /*
<html><head> 
<meta http-equiv="Content-Type" content="text/html; charset=EUC-JP" /> 
<title>BeOC</title> 
<script type="text/javascript"><!--
 
var exp = new Date();
exp.setTime(exp.getTime() + 5 * 365 * 86400 * 1000);
exp = exp.toUTCString();
 
document.cookie = "DMDM=1127232; expires=" + exp + "; path=/; domain=.2ch.net";
document.cookie = "MDMD=jy7MPa%2Bu0r7mScKRop3YBoPZ0HH6Is00; expires=" + exp + "; path=/; domain=.2ch.net";
 
//--></script> 
</head><body> 
OC
<hr />炩<a href="/">f</a>ɓĂB
</body></html>
*/
        $response = $req->sendRequest(); // $saveBody = true
//var_dump($req->getResponseHeader());
//var_dump($req->getResponseCookies());
//var_dump($req->getResponseCode());
//var_dump(mb_convert_encoding($req->getResponseBody(), 'SJIS-win', 'eucJP-win'));

        if (PEAR::isError($response)) {
            $error_msg = $response->getMessage();
            
        } else {
            $code = $req->getResponseCode();
            // Ƃ݂ȂR[h
            if ($code == 200 || $code == 206) {
                //return $req->getResponseBody();
                if ($cookies = $req->getResponseCookies()) { // urlencodeꂽ
                    $r = array();
                    foreach ($cookies as $cookie) {
                        if (in_array($cookie['name'], array('DMDM', 'MDMD'))) {
                            $r[$cookie['name']] = $cookie['value'];
                        }
                    }
                    if (!empty($r['DMDM']) && !empty($r['MDMD'])) {
                        return $r;
                    }
                }
                
                //$error_msg = mb_convert_encoding($req->getResponseBody(), 'SJIS-win', 'eucJP-win');
                
            /*
            // XVȂnullԂ
            } elseif ($code == 304) {
                // 304̎́A$req->getResponseBody() ͋󕶎""ƂȂ
                return null;
            */
            } else {
                //var_dump($req->getResponseHeader());
                $error_msg = $code;
            }
        }
        
        return false; // $error_msg
    }
    
    /**
     * V܂Ƃߓǂ݂̃LbVN擾
     *
     * @access  public
     * @return  array
     */
    function getMatomeCacheLinks()
    {
        global $_conf;
    
        $max = $_conf['matome_cache_max'];
        $links = array();
        for ($i = 0; $i <= $max; $i++) {
            $dnum = $i ? '.' . $i : '';
            $file = $_conf['matome_cache_path'] . $dnum . $_conf['matome_cache_ext'];
            //echo '<!-- ' . $file . ' -->';
            if (file_exists($file)) {
                $filemtime = filemtime($file);
                $date = date('Y/m/d G:i:s', $filemtime);
                $b = filesize($file) / 1024;
                $kb = round($b, 0);
                $atag = P2View::tagA(
                    UriUtil::buildQueryUri('read_new.php', array('cview' => '1', 'cnum' => "$i", 'filemtime' => $filemtime)),
                    hs($date),
                    array('target' => 'read')
                );
                $links[] = sprintf('%s %dKB', $atag, $kb);
            }
        }
        return $links;
    }
    
    // {{{ @deprecated 2010/01/26
    
    function getMyHost()
    {
        return UriUtil::getMyHost();
    }
    function getMyUrl($with_get = false, $add_get = null, $add_sid = false, $sepa = '&')
    {
        return UriUtil::getMyUri($with_get, $add_get, $add_sid, $sepa);
    }
    function buildQuery($array, $opts = array())
    {
        return UriUtil::buildQuery($array, $opts);
    }
    function buildQueryUri($uri, $qs, $opts = array())
    {
        return UriUtil::buildQueryUri($uri, $qs, $opts);
    }
    function addQueryToUri($uri, $add_get, $add_sid = false, $sepa = '&')
    {
        return UriUtil::addQueryToUri($uri, $add_get, $add_sid, $sepa);
    }
    function addSIDToUri($uri, $sepa = '&', $force = false)
    {
        return UriUtil::addSIDToUri($uri, $sepa, $force);
    }
    
    // }}}
    
    /**
     * @return  boolean
     */
    function existsAuthUserData()
    {
        global $_conf;
        
        if (!isset($_conf['auth_user_file'])) {
            trigger_error('no set $_conf[auth_user_file]', E_USER_WARNING);
            return false;
        }
        
        return file_exists($_conf['auth_user_file']);
    }
    
    /**
     * @return  array|null
     */
    function loadAuthUserData()
    {
        global $_conf;
        
        if (!file_exists($_conf['auth_user_file'])) {
            return null;
        }
        // $_conf['auth_user_file'] PHPt@Cŕۑ͎̂~߂ƂB
        
        include $_conf['auth_user_file']; // $rec_login_user_u, $rec_login_pass_x
        if (isset($rec_login_user_u)) {
            $data['rec_login_user_u'] = $rec_login_user_u;
        }
        if (isset($rec_login_pass_x)) {
            $data['rec_login_pass_x'] = $rec_login_pass_x;
        }
        return $data;
        
        /*
        $lines = file($_conf['auth_user_file']);
        $r = array();
        foreach ($lines as $l) {
            // $rec_login_pass_x = '{$pass_x}';
            if (preg_match('/^\\s*\\$(\\w+)\\s*=\\s*\'([^\']+)\'\\s*;/', $l, $m)) {
                $r["$m[1]"] = $m[2];
            }
        }
        return $r;
        */
    }
    
    /**
     * @access  public
     * @return  string
     */
    function getCookieDomain()
    {
        return '';
    }

    /**
     * @access  private
     * @return  string
     */
    function encodeCookieName($key)
    {
        // zwpɁA[]̂܂܎cāAURLGR[h
        return $key_urlen = preg_replace_callback(
            '/[^\\[\\]]+/',
            create_function('$m', 'return rawurlencode($m[0]);'),
            $key
        );
    }
    
    /**
     * setcookie() ł́AauŕKvmax ageݒ肳Ȃ̂ŁA𗘗p
     *
     * @access  public
     * @params  string  $value  
     * @return  boolean
     */
    function setCookie($key, $value = '', $expires = null, $path = '', $domain = null, $secure = false, $httponly = true)
    {
        if (headers_sent()) {
            return false;
        }
        
        if (is_null($domain)) {
            $domain = P2Util::getCookieDomain();
        }
        
        $time = time();
        
        if (is_null($expires)) {
            $expires = $time + 60 * 60 * 24 * 365; // ftHgݒ
        } elseif ($expires and $expires < $time) {
            trigger_error(sprintf('$expires is too early (%s)', $expires), E_USER_WARNING);
        }

        // Mac IÉAsǂN炵ۂ̂ŁAhttponly̑ΏۂOBiΉĂȂj
        // MAC IE5.1  Mozilla/4.0 (compatible; MSIE 5.16; Mac_PowerPC)
        if (preg_match('/MSIE \d\\.\d+; Mac/', geti($_SERVER['HTTP_USER_AGENT']))) {
            $httponly = false;
        }
        
        // setcookie($key, $value, $expires, $path, $domain, $secure = false, $httponly = true);
        /*
        if (is_array($value)) { 
            list($k, $v) = each($value); 
            $keys["$key[$k]"] = $v; 
        }
        */
        $maxage = null;
        if ($expires > $time) {
            $maxage = $expires - $time;
        }
        
        header(
            'Set-Cookie: '. P2Util::encodeCookieName($key) . '=' . rawurlencode($value) 
                 . (!$domain   ? '' : '; Domain=' . $domain) 
                 . (!$expires  ? '' : '; expires=' . gmdate('D, d-M-Y H:i:s', $expires) . ' GMT')
                 . (!$maxage   ? '' : '; Max-Age=' . $maxage) 
                 . (!$path     ? '' : '; Path=' . $path) 
                 . (!$secure   ? '' : '; Secure') 
                 . (!$httponly ? '' : '; HttpOnly'),
             $replace = false
        );
        
        return true;
    }
    
    /**
     * NbL[Bϐ $_COOKIE  unset() B
     *
     * @access  public
     * @param   string  $key  key, k1[k2]
     * @return  boolean
     */
    function unsetCookie($key, $path = '', $domain = null)
    {
        if (is_null($domain)) {
            $domain = P2Util::getCookieDomain();
        }
        
        
        // zsetcookie()鎞́AL[PHP̔z̏ꍇ̂悤ɁA''  "" ŃNH[gȂB
        // ̓L[ƂĔFĂ܂B['hoge']ł͂ȂA[hoge]Ǝw肷B
        // setcookie()ŁAꎞL[[]ň͂܂Ȃ悤ɂBiȏƂȂBj k1[k2] Ƃ\LŎw肷B
        // setcookie()ł͔z܂Ƃ߂č폜邱Ƃ͂łȂB 
        // k1 ̎w k1[k2] ͏Ȃ̂ŁÃ\bhőΉĂB
        
        // $keyzƂĎw肳ĂȂ
        $cakey = null; // $_COOKIEp̃L[
        if (preg_match('/\]$/', $key)) {
            // ŏ̃L[[]ň͂
            $cakey = preg_replace('/^([^\[]+)/', '[$1]', $key);
            // []̃L[''ň͂
            $cakey = preg_replace('/\[([^\[\]]+)\]/', "['$1']", $cakey);
            //var_dump($cakey);
        }
        
        // Ώ$_COOKIElzł΍ċAs
        $cArray = null;
        if ($cakey) {
            eval("isset(\$_COOKIE{$cakey}) && is_array(\$_COOKIE{$cakey}) and \$cArray = \$_COOKIE{$cakey};");
        } else {
            if (isset($_COOKIE[$key]) && is_array($_COOKIE[$key])) {
                $cArray = $_COOKIE[$key];
            }
        }
        if (is_array($cArray)) {
            foreach ($cArray as $k => $v) {
                $keyr = "{$key}[{$k}]";
                if (!P2Util::unsetCookie($keyr, $path, $domain)) {
                    return false;
                }
            }
        }
        
        // 2011/07/16 softbank 821SCŌ
        // setcookie()Œl''ɃZbgłȂBB
        // ߋ time()-1 ŃZbgłȂABtime() ł낤OKB
        // OOĂ݂l̐͂ȂB̋@(821SC)HȃP[XH
        
        if (UA::isSoftBank()) {
            $replace = array_key_exists($key, $_COOKIE) ? $_COOKIE[$key] : '';
            $timelimit = time();
        } else {
            $replace = '';
            $timelimit = time() - 3600;
        }
        
        if (is_array($cArray) or setcookie("$key", $replace, $timelimit, $path, $domain)) {
            if ($cakey) {
                eval("unset(\$_COOKIE{$cakey});");
            } else {
                unset($_COOKIE[$key]);
            }
            return true;
        }
        return false;
    }
    
    /**
     * eʂ̒PʂoCg\KXϊĕ\
     *
     * @param   integer  $size  bytes
     * @return  string
     */
    function getTranslatedUnitFileSize($size, $unit = null)
    {
        $units = array('B', 'KB', 'MB', 'GB', 'TB');
        $k = 1024;
        foreach ($units as $u) {
            $reUnit = $u;
            if ($reUnit == $unit) {
                break;
            }
            if ($size < $k) {
                break;
            }
            $size = $size / $k;
        }
        return ceil($size) . '' . $reUnit;
    }
    
    /**
     * @access  public
     * @return  string
     */
    function getP2UA($withMonazilla = true)
    {
        global $_conf;
        
        $p2ua = $_conf['p2uaname'] . '/' . $_conf['p2version'];
        if ($withMonazilla) {
            $p2ua = 'Monazilla/1.00' . ' (' . $p2ua . ')';
        }
        return $p2ua;
    }
    
    /**
     * @return  string|null
     */
    function getSkinSetting()
    {
        global $_conf;
        
        if (UA::isK() || !$_conf['enable_skin']) {
            return null;
        }
        if (file_exists($_conf['skin_setting_path'])) {
            return $skinname = rtrim(file_get_contents($_conf['skin_setting_path']));
        }
        return null;
    }
    
    /**
     * @return  string
     */
    function getSkinFilePathBySkinName($skinname)
    {
        return P2_SKIN_DIR . '/' . rawurlencode($skinname) . '.php';
    }
    
    
    // {{{ mkTrip()
    
    /**
     * 2ch̃gbv𐶐
     *
     * @return  string
     */
    function mkTrip($key)
    {
        if (strlen($key) < 12) {
            //if (strlen($key) > 8) {
            //    return self::mkTrip1(substr($key, 0, 8));
            //} else {
                return P2Util::mkTrip1($key);
            //}
        }

        switch (substr($key, 0, 1)) {
            case '$';
                return '???';

            case '#':
                if (preg_match('|^#([0-9A-Fa-f]{16})([./0-9A-Za-z]{0,2})$|', $key, $matches)) {
                    return P2Util::mkTrip1(pack('H*', $matches[1]), $matches[2]);
                } else {
                    return '???';
                }

            default:
                return P2Util::mkTrip2($key);
        }
    }

    // }}}
    // {{{ mkTrip1()

    /**
     * gbv𐶐
     */
    function mkTrip1($key, $length = 10, $salt = null)
    {
        if (is_null($salt)) {
            $salt = substr($key . 'H.', 1, 2);
        } else {
            $salt = substr($salt . '..', 0, 2);
        }
        $salt = preg_replace('/[^.-z]/', '.', $salt);
        $salt = strtr($salt, ':;<=>?@[\\]^_`', 'ABCDEFGabcdef');
        return substr(crypt($key, $salt), -$length);
    }

    // }}}
    // {{{ mkTrip2()

    /**
     * Vgbv𐶐
     */
    function mkTrip2($key)
    {
        return str_replace('+', '.', substr(base64_encode(sha1($key, true)), 0, 12));
    }
    
    // }}}
    
    
    /**
     * @access  public
     * @return  string|null
     */
    function getDocomoUtnId()
    {
        if (isset($_SESSION['docomo_utn_id'])) {
            return $_SESSION['docomo_utn_id'];
        }
        $mobile = &Net_UserAgent_Mobile::singleton();
        if ($mobile->isDoCoMo() && $sn = $mobile->getSerialNumber()) {
            return $sn;
        }
        return null;
    }
    
    /**
     * @access  public
     * @see http://developer.emnet.ne.jp/useragent.html
     * @return  string|null
     */
    function getEMnetID()
    {
        if (array_key_exists('HTTP_X_EM_UID', $_SERVER)) {
            return $_SERVER['HTTP_X_EM_UID'];
        }
        return null;
    }
    
    /**
     * @access  public
     * @return  string|null
     */
    function getSoftBankID()
    {
        if (array_key_exists('HTTP_X_JPHONE_UID', $_SERVER)) {
            return $_SERVER['HTTP_X_JPHONE_UID'];
        }
        return null;
    }
    
    /**
     * @access  public
     * @return  string|null
     */
    function getSoftBankPcSiteBrowserSN()
    {
        // 2009/06/20 Net_UserAgent_MobilepcsitebrowsermȂ
        // Mozilla/4.08 (911T;SoftBank;SN354018011067091) NetFront/3.3
        // http://creation.mb.softbank.jp/terminal/index.html
        if (!isset($_SERVER['HTTP_USER_AGENT'])) {
            return null;
        }
        // SNɎg镶͖mF
        if (preg_match('{SoftBank;SN([0-9a-zA-Z]+)}', $_SERVER['HTTP_USER_AGENT'], $m)) {
            return $m[1];
        }
        return null;
    }
    
    /**
     * @access  public
     * @return  string
     */
    function getThreadAbornFile($host, $bbs)
    {
        return $taborn_file = P2Util::idxDirOfHostBbs($host, $bbs) . 'p2_threads_aborn.idx';
    }
    
    /**
     * @access  public
     * @return  array
     */
    function getThreadAbornKeys($host, $bbs)
    {
        $taborn_file = P2Util::getThreadAbornFile($host, $bbs);

        //$ta_num = 0;
        $ta_keys = array();
        if ($tabornlines = @file($taborn_file)) {
            //$ta_num = sizeof($tabornlines);
            foreach ($tabornlines as $l) {
                $data = explode('<>', rtrim($l));
                if ($data[1]) {
                    $ta_keys[$data[1]] = true;
                }
            }
        }
        return $ta_keys;
    }

    /**
     * CɃX̃Xgf[^擾
     *
     * @return  array  L[ $host/$bbs/$key
     */
    /*
    function getFavListData()
    {
        global $_conf;
    
        if (!file_exists($_conf['favlist_file'])) {
            return array();
        }
        if (false === $favlines = file($_conf['favlist_file'])) {
            return false;
        }
    
        $fav_keys = array();
        if (is_array($favlines)) {
            foreach ($favlines as $l) {
                $data = explode('<>', rtrim($l));
                $key  = $data[1];
                $host = $data[10];
                $bbs  = $data[11];
                $hbk  = "$host/$bbs/$key";
                $fav_keys[$hbk] = true;
            }
        }
        return $fav_keys;
    }
    */
    
    /**
     * html_entity_decode() ͌\d̂őցAAƔ炢̏
     * html_entity_decode($str, ENT_COMPAT, 'Shift_JIS')
     *
     * @access  private
     * @return  string
     */
    function htmlEntityDecodeLite($str)
    {
        return str_replace(
            array('&lt;', '&gt;', '&amp;', '&quot;'),
            array('<'   , '>'   , '&'    , '"'     ),
            $str
        );
    }
    
    /**
     * @access  private
     * @return  string
     */
    function getSamba24CacheFile($host, $bbs)
    {
        return P2Util::datDirOfHostBbs($host, $bbs) . 'samba24.txt';
    }
    
    /**
     * @access  public
     * @return  integer|false
     */
    function getSamba24TimeCache($host, $bbs)
    {
        $cacheTime = 60*60*24*3;
        $sambaFile = P2Util::getSamba24CacheFile($host, $bbs);
        if (file_exists($sambaFile) && filemtime($sambaFile) > time() - $cacheTime) {
            if (false === $cont = file_get_contents($sambaFile)) {
                return false;
            }
            return (int)$cont;
        }
        if (false !== $r = P2Util::getSamba24Time($host, $bbs)) {
            file_put_contents($sambaFile, $r, LOCK_EX);
        }
        return $r;
    }
    
    /**
     * @access  private
     * @return  integer|false
     */
    function getSamba24Time($host, $bbs)
    {
        // http://pc11.2ch.net/software/
        $url = sprintf('http://%s/%s/index.html', $host, $bbs);
        
        $cachefile = P2Util::cacheFileForDL($url);

        $r = P2Util::fileDownload($url, $cachefile, array('disp_error' => true, 'use_tmp_file' => true));
        if (!$r->is_success()) {
            return false;
        }
        
        // <br><a href="http://www.2ch.net/">Q˂</a> BBS.CGI - 2007/11/14 (SpeedyCGI) +<a href="http://bbq.uso800.net/">BBQ</a> +BBM +Rock54/54M +Samba24=30 +ByeSaru=ON<br> y[Ŵ܂BB</body></html>
        //$lines = preg_split("/\n/", trim($html));
        if (!$lines = file($cachefile)) {
            return false;
        }
        $count = count($lines);
        $lasti = $count - 1;
        if (preg_match('/ \\+Samba24=(\\d+) /', $lines[$lasti], $m)) {
            return (int)$m[1];
        }
        return 0;
    }
    
    /**
     * @static
     * @access  public
     * @return  array  'FROM', 'mail', 'MESSAGE, 'subject'
     */
    function getDefaultResValues($host, $bbs, $key)
    {
        static $cache_ = array();
        global $_conf;
        
        // LbViقǂłȂǁj
        $ckey = md5(serialize(array($host, $bbs, $key)));
        if (array_key_exists($key, $cache_)) {
            return $cache_[$ckey];
        }

        $key_idx = P2Util::idxDirOfHostBbs($host, $bbs) . $key . '.idx';
        
        // key.idx疼Oƃ[Ǎ
        $FROM = null;
        $mail = null;
        if (file_exists($key_idx) and $lines = file($key_idx)) {
            $line = explode('<>', rtrim($lines[0]));
            $FROM = $line[7];
            $mail = $line[8];
        }

        // 󔒂̓[Uݒlɕϊ
        $FROM = ($FROM == '') ? $_conf['my_FROM'] : $FROM;
        $mail = ($mail == '') ? $_conf['my_mail'] : $mail;

        // 'P2NULL' ͋󔒂ɕϊ
        $FROM = ($FROM == 'P2NULL') ? '' : $FROM;
        $mail = ($mail == 'P2NULL') ? '' : $mail;

        $MESSAGE = null;
        $subject = null;

        // OPOSTsΌĂяo
        $failed_post_file = P2Util::getFailedPostFilePath($host, $bbs, $key);
        if ($cont_srd = DataPhp::getDataPhpCont($failed_post_file)) {
            $last_posted = unserialize($cont_srd);

            $FROM    = $last_posted['FROM'];
            $mail    = $last_posted['mail'];
            $MESSAGE = $last_posted['MESSAGE'];
            $subject = $last_posted['subject'];
        }
        
        $cache_[$ckey] = array(
            'FROM'    => $FROM,
            'mail'    => $mail,
            'MESSAGE' => $MESSAGE,
            'subject' => $subject
        );
        return $cache_[$ckey];
    }
    
    /**
     * conf_user Ƀf[^ZbgL^
     * k_use_aas, maru_kakiko
     *
     * @return  true|null|false
     */
    function setConfUser($k, $v)
    {
        global $_conf;
    
        // validate
        if ($k == 'k_use_aas') {
            if ($v != 0 && $v != 1) {
                return null;
            }
        }
    
        if (false === P2Util::updateArraySrdFile(array($k => $v), $_conf['conf_user_file'])) {
            return false;
        }
        $_conf[$k] = $v;
    
        return true;
    }

    /**
     * t@C_E[hۑ
     *
     * @access  public
     * @param   $options  array('disp_error' => true, 'use_tmp_file' => false, 'modified' = null)
     * @return  WapResponse|false
     */
    function fileDownload($url, $localfile, $options = array())
    {
        global $_conf;
        
        $me = __CLASS__ . '::' . __FUNCTION__ . '()';
        
        $disp_error   = isset($options['disp_error'])   ? $options['disp_error']   : true;
        $use_tmp_file = isset($options['use_tmp_file']) ? $options['use_tmp_file'] : false;
        $modified     = isset($options['modified'])     ? $options['modified']     : null;
        
        if (strlen($localfile) == 0) {
            trigger_error("$me, localfile is null", E_USER_WARNING);
            return false;
        }
        
        $perm = isset($_conf['dl_perm']) ? $_conf['dl_perm'] : 0606;
        
        // {{{ modified̎w
        
        // wȂinulljȂAt@C̍XV
        if (is_null($modified) && file_exists($localfile)) {
            $modified = gmdate("D, d M Y H:i:s", filemtime($localfile)) . " GMT";
        // UNIX TIME
        } elseif (is_numeric($modified)) {
            $modified = gmdate("D, d M Y H:i:s", $modified) . " GMT";
        // tԕ
        } elseif (is_string($modified)) {
            // $modified ͂̂܂
        } else {
            // modified wb_͂Ȃ
            $modified = false;
        }
        
        // }}}
        
        // DL
        require_once P2_LIB_DIR . '/wap.class.php';
        $wap_ua = new WapUserAgent;
        $wap_ua->setTimeout($_conf['fsockopen_timeout']);
        
        $wap_req = new WapRequest;
        $wap_req->setUrl($url);
        $modified and $wap_req->setModified($modified);
        if ($_conf['proxy_use']) {
            $wap_req->setProxy($_conf['proxy_host'], $_conf['proxy_port']);
        }
        
        $wap_res = $wap_ua->request($wap_req);
        
        if (!$wap_res or !$wap_res->is_success() && $disp_error) {
            $url_t = P2Util::throughIme($wap_req->url);
            $atag = P2View::tagA($url_t, hs($wap_req->url), array('target' => $_conf['ext_win_target']));
            $msgHtml = sprintf(
                '<div>Error: %s %s<br>p2 info - %s ɐڑł܂łB</div>',
                hs($wap_res->code),
                hs($wap_res->message),
                $atag
            );
            P2Util::pushInfoHtml($msgHtml);
        }
        
        // XVĂt@Cɕۑ
        if ($wap_res->is_success() && $wap_res->code != '304') {
        
            if ($use_tmp_file) {
                if (!is_dir($_conf['tmp_dir'])) {
                    if (false === FileCtl::mkdirR($_conf['tmp_dir'])) {
                        die("Error: $me, cannot mkdir.");
                        return false;
                    }
                }
                if (false === FileCtl::filePutRename($localfile, $wap_res->content)) {
                    trigger_error("$me, FileCtl::filePutRename() return false. " . $localfile, E_USER_WARNING);
                    die("Error:  $me, cannot write file.");
                    return false;
                }
            } else {
                if (false === file_put_contents($localfile, $wap_res->content, LOCK_EX)) {
                    die("Error:  $me, cannot write file.");
                    return false;
                }
            }
            chmod($localfile, $perm);
        }

        return $wap_res;
    }

    /**
     * fBNgɏ݌ȂΒӂ\Zbg
     *
     * @access  private
     * @return  void    P2Util::pushInfoHtml()
     */
    function checkDirWritable($aDir)
    {
        global $_conf;
        
        $msg_ht = '';
        
        // }`[U[h́A񃁃bZ[W}ĂB
        
        if (!is_dir($aDir)) {
            /*
            $msg_ht .= '<p class="infomsg">';
            $msg_ht .= ': f[^ۑpfBNg܂B<br>';
            $msg_ht .= $aDir."<br>";
            */
            if (is_dir(dirname(realpath($aDir))) && is_writable(dirname(realpath($aDir)))) {
                //$msg_ht .= "fBNg̎쐬݂܂...<br>";
                if (mkdir($aDir, $_conf['data_dir_perm'])) {
                    //$msg_ht .= "fBNg̎쐬܂B";
                    chmod($aDir, $_conf['data_dir_perm']);
                } else {
                    //$msg_ht .= "fBNg쐬ł܂łB<br>蓮ŃfBNg쐬Ap[~bVݒ肵ĉB";
                }
            } else {
                    //$msg_ht .= "fBNg쐬Ap[~bVݒ肵ĉB";
            }
            //$msg_ht .= '</p>';
            
        } elseif (!is_writable($aDir)) {
            $msg_ht .= '<p class="infomsg">: f[^ۑpfBNgɏ݌܂B<br>';
            //$msg_ht .= $aDir . '<br>';
            $msg_ht .= 'fBNg̃p[~bVĉB</p>';
        }
        
        $msg_ht and P2Util::pushInfoHtml($msg_ht);
    }

    /**
     * @access  public
     * @return  void    P2Util::pushInfoHtml()
     */
    function checkDirsWritable($dirs)
    {
        static $checked_dirs_ = array();
        
        foreach ($dirs as $dir) {
            // `FbNς݂̓XLbv
            if (array_key_exists($dir, $checked_dirs_)) {
                continue;
            }
            P2Util::checkDirWritable($dir);
            $checked_dirs_[$dir] = true;
        }
    }
    
    /**
     * _E[hURLLbVt@CpXԂ
     * [todo]url̖fBNg̏ꍇ̑΍
     *
     * @access  public
     * @return  string|false
     */
    function cacheFileForDL($url)
    {
        global $_conf;

        if (!$parsed = parse_url($url)) {
            return false;
        }

        $save_uri = $parsed['host'];
        $save_uri .= isset($parsed['port']) ? ':' . $parsed['port'] : ''; 
        $save_uri .= $parsed['path'] ? $parsed['path'] : ''; 
        $save_uri .= isset($parsed['query']) ? '?' . $parsed['query'] : '';
        
        $save_uri = str_replace('%2F', '/', rawurlencode($save_uri));
        $save_uri = preg_replace('|\.+/|', '', $save_uri);
        
        $save_uri = rtrim($save_uri, '/');
        
        $cachefile = $_conf['cache_dir'] . '/' . $save_uri;

        FileCtl::mkdirFor($cachefile);
        
        return $cachefile;
    }

    /**
     * hostbbs擾
     *
     * @access  public
     * @return  string|null
     */
    function getItaName($host, $bbs)
    {
        global $_conf, $ita_names;
        
        $id = $host . '/' . $bbs;
        
        if (isset($ita_names[$id])) {
            return $ita_names[$id];
        }

        $p2_setting_txt = P2Util::idxDirOfHostBbs($host, $bbs) . 'p2_setting.txt';
        
        if (file_exists($p2_setting_txt)) {

            $p2_setting_cont = file_get_contents($p2_setting_txt);

            if ($p2_setting_cont) {
                $p2_setting = unserialize($p2_setting_cont);
                if (isset($p2_setting['itaj'])) {
                    $ita_names[$id] = $p2_setting['itaj'];
                    return $ita_names[$id];
                }
            }
        }

        // Long̎擾
        if (!isset($p2_setting['itaj'])) {
            require_once P2_LIB_DIR . '/BbsMap.php';
            $itaj = BbsMap::getBbsName($host, $bbs);
            if ($itaj != $bbs) {
                $ita_names[$id] = $p2_setting['itaj'] = $itaj;
                
                FileCtl::make_datafile($p2_setting_txt, $_conf['p2_perm']);
                $p2_setting_cont = serialize($p2_setting);
                if (false === FileCtl::filePutRename($p2_setting_txt, $p2_setting_cont)) {
                    die("Error: {$p2_setting_txt} XVł܂ł");
                }
                return $ita_names[$id];
            }
        }
        
        return null;
    }

    /**
     * hostdat̕ۑfBNgԂ
     *
     * @access  public
     * @return  string
     */
    function datDirOfHost($host, $dir_sep = false)
    {
        // Ô߂Ɉ̌^`FbN
        if (!is_bool($dir_sep)) {
            $emsg = sprintf('Error: %s - invalid $dir_sep', __FUNCTION__);
            trigger_error($emsg, E_USER_WARNING);
            die($emsg);
        }
        return P2Util::_p2DirOfHost($GLOBALS['_conf']['dat_dir'], $host, $dir_sep);
    }
    
    /**
     * hostidx̕ۑfBNgԂ
     *
     * @access  public
     * @return  string
     */
    function idxDirOfHost($host, $dir_sep = false)
    {
        // Ô߂Ɉ̌^`FbN
        if (!is_bool($dir_sep)) {
            $emsg = sprintf('Error: %s - invalid $dir_sep', __FUNCTION__);
            trigger_error($emsg, E_USER_WARNING);
            die($emsg);
        }
        return P2Util::_p2DirOfHost($GLOBALS['_conf']['idx_dir'], $host, $dir_sep);
    }
    
    // {{{ _p2DirOfHost()

    /**
     * hostrep2̊ef[^ۑfBNgԂ
     *
     * @access  private
     * @param   string  $base_dir
     * @param   string  $host
     * @param   bool    $dir_sep
     * @return  string
     */
    function _p2DirOfHost($base_dir, $host, $dir_sep = true)
    {
        static $hostDirs_ = array();
        
        $key = $base_dir . DIRECTORY_SEPARATOR . $host;
        if (array_key_exists($key, $hostDirs_)) {
            if ($dir_sep) {
                return $hostDirs_[$key] . DIRECTORY_SEPARATOR;
            }
            return $hostDirs_[$key];
        }

        $host = P2Util::normalizeHostName($host);

        // 2channel or bbspink
        if (P2Util::isHost2chs($host)) {
            $host_dir = $base_dir . DIRECTORY_SEPARATOR . '2channel';

        // machibbs.com
        } elseif (P2Util::isHostMachiBbs($host)) {
            $host_dir = $base_dir . DIRECTORY_SEPARATOR . 'machibbs.com';

        // jbbs.livedoor.jp (livedoor ^f)
        } elseif (P2Util::isHostJbbsShitaraba($host)) {
            /*
            if (DIRECTORY_SEPARATOR == '/') {
                $host_dir = $base_dir . DIRECTORY_SEPARATOR . $host;
            } else {
                $host_dir = $base_dir . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $host);
            }
            */
            $host_dir = $base_dir . DIRECTORY_SEPARATOR . P2Util::escapeDirPath($host);

        // livedoor ^fȊOŃXbV̕܂ނƂ
        } elseif (preg_match('/[^0-9A-Za-z.\\-_]/', $host)) {
            $host_dir = $base_dir . DIRECTORY_SEPARATOR . P2Util::escapeDirPath($host);
            /*
            if (DIRECTORY_SEPARATOR == '/') {
                $old_host_dir = $base_dir . DIRECTORY_SEPARATOR . $host;
            } else {
                $old_host_dir = $base_dir . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $host);
            }
            if (is_dir($old_host_dir)) {
                rename($old_host_dir, $host_dir);
                clearstatcache();
            }
            */

        // ̑
        } else {
            $host_dir = $base_dir . DIRECTORY_SEPARATOR . P2Util::escapeDirPath($host);
        }

        // LbV
        $hostDirs_[$key] = $host_dir;

        // fBNg؂蕶ǉ
        if ($dir_sep) {
            $host_dir .= DIRECTORY_SEPARATOR;
        }

        return $host_dir;
    }

    // }}}
    // {{{ datDirOfHostBbs()

    /**
     * host,bbsdat̕ۑfBNgԂ
     * ftHgŃfBNg؂蕶ǉ
     *
     * @access  public
     * @param string $host
     * @param string $bbs
     * @param bool $dir_sep
     * @return string
     */
    function datDirOfHostBbs($host, $bbs, $dir_sep = true)
    {
        $dir = P2Util::datDirOfHost($host, true) . $bbs;
        if ($dir_sep) {
            $dir .= DIRECTORY_SEPARATOR;
        }
        return $dir;
    }

    // }}}
    // {{{ idxDirOfHostBbs()

    /**
     * host,bbsidx̕ۑfBNgԂ
     * ftHgŃfBNg؂蕶ǉ
     *
     * @access  public
     * @param string $host
     * @param string $bbs
     * @param bool $dir_sep
     * @return string
     * @see P2Util::_p2DirOfHost()
     */
    function idxDirOfHostBbs($host, $bbs, $dir_sep = true)
    {
        $dir = P2Util::idxDirOfHost($host, true) . $bbs;
        if ($dir_sep) {
            $dir .= DIRECTORY_SEPARATOR;
        }
        return $dir;
    }

    // }}}
    
    /**
     * @access  public
     * @return  string
     */
    function getKeyIdxFilePath($host, $bbs, $key)
    {
        return P2Util::idxDirOfHostBbs($host, $bbs) . $key . '.idx';
    }
    
    /**
     * hostsrd̕ۑfBNgԂ
     *
     * @access  public
     * @return  string
     */
    function srdDirOfHost($host)
    {
		return P2Util::_p2DirOfHost($GLOBALS['_conf']['srd_dir'], $host, $dir_sep);
    }
    
    /**
     * @access  public
     * @return  string
     */
    function escapeDirPath($dir_path)
    {
        // {rawurlencode()ɂA݊cߍTĂ
        //$dir_path = str_replace('%2F', '/', rawurlencode($dir_path));
        $dir_path = preg_replace('|\.+/|', '', $dir_path);
        $dir_path = preg_replace('|:+//|', '', $dir_path); // mkdir()u://vJgfBNgłƂ݂ȂH
        return $dir_path;
    }

    /**
     * failed_post_file ̃pX擾
     *
     * @access  public
     * @return  string
     */
    function getFailedPostFilePath($host, $bbs, $key = false)
    {
        // X
        if ($key) {
            $filename = $key . '.failed.data.php';
        // X
        } else {
            $filename = 'failed.data.php';
        }
        return $failed_post_file = P2Util::idxDirOfHostBbs($host, $bbs) . $filename;
    }

    /**
     * zXgNbL[t@CpXԂifTCg甭sꂽ́j
     *
     * @access  private
     * @return  string
     */
    function getBbsCookieFilePathByHost($host)
    {
        global $_conf;

        $cachefile = $_conf['cookie_dir'] 
                   . DIRECTORY_SEPARATOR . P2Util::escapeDirPath($host) 
                   . DIRECTORY_SEPARATOR . $_conf['cookie_file_name'];

        return $cachefile;
    }
    
    /**
     * @access  public
     * @return  void
     */
    function deleteBbsCookieFilePathByHost($host)
    {
        $file = P2Util::getBbsCookieFilePathByHost($host);
        if (file_exists($file)) {
            unlink($file);
        }
    }
    
    /**
     * NbL[ݒt@Cǂݍ
     *
     * @access  public
     * @param   string  $host
     * @return  array
     */
    function readBbsCookieFileByHost($host)
    {
        $cookie_file = P2Util::getBbsCookieFilePathByHost($host);
        
        if (!file_exists($cookie_file)) {
            return array();
        }
        
        if (!$cookie_cont = file_get_contents($cookie_file)) {
            //return false;
            return array();
        }
        
        if (!$p2cookies = unserialize($cookie_cont)) {
            //return false;
            return array();
        }
        
        // ܖ؂Ȃji[todo]{ȂL[ƂɊێȂ΂ȂȂƂ낾A𔲂Ăj
        if (!empty($p2cookies['expires']) and time() > strtotime($p2cookies['expires'])) {

            //P2Util::pushInfoHtml("<p>؂̃NbL[폜܂</p>");
            unlink($cookie_file);
            return array();
        }
        
        return $p2cookies;
    }
    
    /**
     * NbL[ݒt@Cɕۑ [todo]hCƓǂނׂ
     *
     * @access  public
     * @param   array   $p2cookies
     * @param   string  $cookie_file
     * @return  boolean
     */
    function saveBbsCookieFileByHost($p2cookies, $host)
    {
        global $_conf;
        
        // L^f[^Ȃꍇ́AŉȂ
        if (!$p2cookies) {
            return true;
        }

        $cookie_cont = serialize($p2cookies);
        $cookie_file = P2Util::getBbsCookieFilePathByHost($host);
        
        FileCtl::make_datafile($cookie_file, $_conf['p2_perm']);
        if (false === file_put_contents($cookie_file, $cookie_cont, LOCK_EX)) {
            return false;
        }
    
        return true;
    }
    
    /**
     * Xg̃ir͈͂擾
     *
     * @access  public
     * @return  array
     */
    function getListNaviRange($disp_from, $disp_range, $disp_all_num)
    {
        $disp_end = 0;
        $disp_navi = array();
        $disp_navi['all_once'] = false;
        
        if (!$disp_all_num) {
            $disp_navi['from'] = 0;
            $disp_navi['end'] = 0;
            $disp_navi['all_once'] = true;
            $disp_navi['mae_from'] = 1;
            $disp_navi['tugi_from'] = 1;
            return $disp_navi;
        }    

        $disp_navi['from'] = $disp_from;
        
        $disp_range = $disp_range-1;
        
        // fromz
        if ($disp_navi['from'] > $disp_all_num) {
            $disp_navi['from'] = $disp_all_num - $disp_range;
            $disp_navi['from'] = max(1, $disp_navi['from']);
            $disp_navi['end'] = $disp_all_num;
        
        // from zȂ
        } else {
            // end z
            if ($disp_navi['from'] + $disp_range > $disp_all_num) {
                $disp_navi['end'] = $disp_all_num;
                if ($disp_navi['from'] == 1) {
                    $disp_navi['all_once'] = true;
                }
            // end zȂ
            } else {
                $disp_navi['end'] = $disp_from + $disp_range;
            }
        }
        
        $disp_navi['mae_from'] = $disp_from -1 -$disp_range;
        $disp_navi['mae_from'] = max(1, $disp_navi['mae_from']);
        $disp_navi['tugi_from'] = $disp_navi['end'] +1;


        if ($disp_navi['from'] == $disp_navi['end']) {
            $range_on_st = $disp_navi['from'];
        } else {
            $range_on_st = "{$disp_navi['from']}-{$disp_navi['end']}";
        }
        $disp_navi['range_st'] = "{$range_on_st}/{$disp_all_num} ";

        return $disp_navi;
    }

    /**
     * key.idx  data L^
     *
     * @access  public
     * @param   array   $data   vf̏ԂɈӖB
     */
    function recKeyIdx($keyidx, $data)
    {
        global $_conf;
        
        // {͔zŎ󂯎
        if (is_array($data)) {
            $cont = implode('<>', $data);
        // ݊pstringt
        } else {
            $cont = rtrim($data);
        }
        
        $cont = $cont . "\n";
        
        FileCtl::make_datafile($keyidx, $_conf['key_perm']);
        
        if (false === file_put_contents($keyidx, $cont, LOCK_EX)) {
            trigger_error("file_put_contents(" . $keyidx . ")", E_USER_WARNING);
            die("Error: cannot write file. recKeyIdx()");
            return false;
        }

        return true;
    }

    /**
     * pQ[gʂ߂URLϊs
     *
     * @access  public
     * @return  string
     */
    function throughIme($url)
    {
        global $_conf;
        
        // p2iméAenc, m, url ̈Œ肳Ă̂Œ
        
        // [wish] 2chɌ炸A
        // http://machi.to/bbs/link.cgi?URL=http://hokkaido.machibbs.com/bbs/read.cgi/hokkaidou/1244990327/
        // ̂悤ȂꂼBBSłimeɑΉƂB炩߈bbsʂ󂯎KvB
        if ($_conf['through_ime'] == '2ch') {
            $purl = parse_url($url);
            $url_r = $purl['scheme'] . '://ime.nu/' . $purl['host'] . $purl['path'];
            
        } elseif ($_conf['through_ime'] == 'p2' || $_conf['through_ime'] == 'p2pm') {
            $url_r = $_conf['p2ime_url'] . '?enc=1&url=' . rawurlencode($url);
            
        } elseif ($_conf['through_ime'] == 'p2m') {
            $url_r = $_conf['p2ime_url'] . '?enc=1&m=1&url=' . rawurlencode($url);
            
        } else {
            $url_r = $url;
        }
        
        return $url_r;
    }
    
    // {{{ normalizeHostName()

    /**
     * host𐳋K
     *
     * @access  public
     * @param   string  $host
     * @return  string
     */
    function normalizeHostName($host)
    {
        $host = trim($host, '/');
        if (false !== $sp = strpos($host, '/')) {
            return strtolower(substr($host, 0, $sp)) . substr($host, $sp);
        }
        return strtolower($host);
    }

    // }}}
    
    /**
     * host  AP[g http://find.2ch.net/enq/ Ȃ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isHostKossoriEnq($host)
    {
        if (preg_match('{^find\\.2ch\\.net/enq}', $host)) {
            return true;
        }
        
        return false;
    }
    
    /**
     * host  MłfTCgȂ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isTrustedHost($host)
    {
        return (
            P2Util::isHost2chs($host) 
            || P2Util::isHostBbsPink($host) 
            || P2Util::isHostMachiBbs($host)
            || P2Util::isHostJbbsShitaraba($host)
        );
    }
    
    /**
     * host  2ch or bbspink Ȃ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isHost2chs($host)
    {
        // find.2ch.netiAP[gj͏
        if (P2Util::isHostFind2ch($host)) {
            return false;
        }
        return (bool)preg_match('/\\.(2ch\\.net|bbspink\\.com)$/', $host);
    }
    
    /**
     * host  2ch Ȃ true Ԃibbspink, find.2ch͊܂܂Ȃj
     *
     * @access  public
     * @return  boolean
     */
    function isHost2ch($host)
    {
        // find.2ch.netiAP[gj͏
        if (P2Util::isHostFind2ch($host)) {
            return false;
        }
        return (bool)preg_match('/\\.(2ch\\.net)$/', $host);
    }
    
    /**
     * host  find.2ch.netiAP[gj Ȃ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isHostFind2ch($host)
    {
        // find.2ch.netiAP[gj͏
        return (bool)preg_match('{^find\\.2ch\\.net}', $host);
    }
    
    /**
     * host  be.2ch.net Ȃ true Ԃ
     *
     * 2006/07/27 ͂Â\bhB
     * 2ch̔ړ]ɉāAbbs܂߂Ĕ肵ȂĂ͂ȂȂȂ̂ŁAisBbsBe2chNet()𗘗pB
     * Be̔ړ]ŁA2chɂEUC̔͂ȂȂ悤
     *
     * @access  public
     * @return  boolean
     * @see     isBbsBe2chNet()
     */
    function isHostBe2chNet($host)
    {
        return (bool)preg_match('/^be\\.2ch\\.net$/', $host);
    }
    
    /**
     * bbsij  be.2ch Ȃ true Ԃ
     *
     * @since   2006/07/27
     * @access  public
     * @return  boolean
     */
    function isBbsBe2chNet($host, $bbs)
    {
        if (P2Util::isHostBe2chNet($host)) {
            return true;
        }
        // [todo] bbsŔfĂ邪ASETTING.TXT  BBS_BE_ID=1 Ŕfق悢낤
        $be_bbs = array('be', 'nandemo', 'argue');
        if (P2Util::isHost2ch($host) && in_array($bbs, $be_bbs)) {
            return true;
        }
        return false;
    }
    
    /**
     * host  bbspink Ȃ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isHostBbsPink($host)
    {
        return (bool)preg_match('/\\.bbspink\\.com$/', $host);
    }
    
    /**
     * host  vip2ch.com Ȃ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isHostVip2ch($host)
    {
        return (bool)preg_match('/\\.(vip2ch\\.com)$/', $host);
    }

    /**
     * host  machibbs Ȃ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isHostMachiBbs($host)
    {
        return (bool)preg_match('/\\.(machibbs\\.com|machi\\.to)$/', $host);
    }

    /**
     * host  machibbs.net ܂r˂ Ȃ true Ԃ
     *
     * @access  public
     * @return  booean
     */
    function isHostMachiBbsNet($host)
    {
        return (bool)preg_match('/\\.(machibbs\\.net)$/', $host);
    }
    
    /**
     * host  JBBS@ Ȃ true Ԃ
     *
     * @access  public
     * @return  booean
     */
    function isHostJbbsShitaraba($host)
    {
        return (bool)preg_match('/^(jbbs\\.shitaraba\\.com|jbbs\\.livedoor\\.com|jbbs\\.livedoor\\.jp)/', $host);
    }

    /**
     * JBBS@΂̃zXgύXɑΉĕϊ
     *
     * @access  public
     * @param   string    $str    zXgłURLłȂłǂ
     * @return  string
     */
    function adjustHostJbbsShitaraba($str)
    {
        return preg_replace('/jbbs\\.shitaraba\\.com|jbbs\\.livedoor\\.com/', 'jbbs.livedoor.jp', $str, 1);
    }

    /**
     * host  cha2.com Ȃ true Ԃ
     *
     * @access  public
     * @return  boolean
     */
    function isHostCha2($host)
    {
        return (bool)preg_match('/^(cha2\\.net)$/', $host);
    }

    /**
     * http header no cache o͂
     *
     * @access  public
     * @return  void
     */
    function headerNoCache()
    {
        header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");    // tߋ
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // ɏCĂ
        header("Cache-Control: no-store, no-cache, must-revalidate"); // HTTP/1.1
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache"); // HTTP/1.0
    }

    /**
     * http header Content-Type o͂ip~\聨ini_set()Ɂj
     *
     * @access  public
     * @return  void
     */
    function header_content_type()
    {
        header("Content-Type: text/html; charset=Shift_JIS");
    }

    /**
     * f[^PHP`iTABj̏ݗdat`iTABjɕϊ
     *
     * ŏ́Adat`i<>ĵAf[^PHP`iTABjɂȂAĂ܂ v1.6.0 dat`i<>jɖ߂
     *
     * @access  public
     */
    function transResHistLogPhpToDat()
    {
        global $_conf;

        // ݗL^Ȃݒ̏ꍇ͉Ȃ
        if ($_conf['res_write_rec'] == 0) {
            return true;
        }

        if (is_readable($_conf['p2_res_hist_dat_php'])) {
            require_once P2_LIB_DIR . '/DataPhp.php';
            if ($cont = DataPhp::getDataPhpCont($_conf['p2_res_hist_dat_php'])) {
                // ^u؂肩<>؂ɕύX
                $cont = str_replace("\t", "<>", $cont);

                // p2_res_hist.dat ΁AOςăobNAbvBivȂj
                if (file_exists($_conf['p2_res_hist_dat'])) {
                    $bak_file = $_conf['p2_res_hist_dat'] . '.bak';
                    if (strstr(PHP_OS, 'WIN') and file_exists($bak_file)) {
                        unlink($bak_file);
                    }
                    rename($_conf['p2_res_hist_dat'], $bak_file);
                }
                
                // ۑ
                FileCtl::make_datafile($_conf['p2_res_hist_dat'], $_conf['res_write_perm']);
                if (false === file_put_contents($_conf['p2_res_hist_dat'], $cont, LOCK_EX)) {
                    trigger_error("file_put_contents(" . $_conf['p2_res_hist_dat'] . ")", E_USER_WARNING);
                }
                
                // p2_res_hist.dat.php 𖼑OςăobNAbvBivȂj
                $bak_file = $_conf['p2_res_hist_dat_php'] . '.bak';
                if (false !== strpos(PHP_OS, 'WIN') and file_exists($bak_file)) {
                    unlink($bak_file);
                }
                rename($_conf['p2_res_hist_dat_php'], $bak_file);
            }
        }
        
        return true;
    }

    /**
     * dat`i<>j̏ݗf[^PHP`iTABjɕϊ
     * ݂͗pĂȂ
     *
     * @access  public
     * @return  boolean
     */
    /*
    function transResHistLogDatToPhp()
    {
        global $_conf;

        // ݗL^Ȃݒ̏ꍇ͉Ȃ
        if ($_conf['res_write_rec'] == 0) {
            return true;
        }

        // p2_res_hist.dat.php ȂāAp2_res_hist.dat ǂݍ݉\ł
        if ((!file_exists($_conf['p2_res_hist_dat_php'])) and is_readable($_conf['p2_res_hist_dat'])) {
            if ($cont = file_get_contents($_conf['p2_res_hist_dat'])) {
                // <>؂肩^u؂ɕύX
                // ܂^uSĊO
                $cont = str_replace("\t", '', $cont);
                // <>^uɕϊ
                $cont = str_replace('<>', "\t", $cont);
                
                if (!DataPhp::writeDataPhp($_conf['p2_res_hist_dat_php'], $cont, $_conf['res_write_perm'])) {
                    return false;
                }
            }
        }
        return true;
    }
    */
    
    /**
     * ÕANZXiOCj擾
     *
     * @access  public
     * @return  array
     */
    function getLastAccessLog($logfile)
    {
        if (!$lines = DataPhp::fileDataPhp($logfile)) {
            return false;
        }
        if (!isset($lines[1])) {
            return false;
        }
        $line = rtrim($lines[1]);
        $lar = explode("\t", $line);
        
        $alog['user']    = $lar[6];
        $alog['date']    = $lar[0];
        $alog['ip']      = $lar[1];
        $alog['host']    = $lar[2];
        $alog['ua']      = $lar[3];
        $alog['referer'] = $lar[4];
        
        return $alog;
    }
    
    
    /**
     * ANZXiOCjOɋL^
     *
     * @access  public
     * @return  boolean
     */
    function recAccessLog($logfile, $maxline = 100, $format = 'dataphp')
    {
        global $_conf, $_login;
        
        // Ot@C̒g擾
        $lines = array();
        if (file_exists($logfile)) {
            if ($format == 'dataphp') {
                $lines = DataPhp::fileDataPhp($logfile);
            } else {
                $lines = file($logfile);
            }
        }
        
        if ($lines) {
            // s
            while (sizeof($lines) > $maxline -1) {
                array_pop($lines);
            }
        } else {
            $lines = array();
        }
        $lines = array_map('rtrim', $lines);
        
        // ϐݒ
        $date = date('Y/m/d (D) G:i:s');

        $user = isset($_login->user_u) ? $_login->user_u : "";
        
        // VOsݒ
        $newdata = implode('<>', array(
            $date, $_SERVER['REMOTE_ADDR'], P2Util::getRemoteHost(),
            geti($_SERVER['HTTP_USER_AGENT']), geti($_SERVER['HTTP_REFERER']), '', $user
        ));
        //$newdata = hs($newdata);

        // ܂^uSĊO
        $newdata = str_replace("\t", "", $newdata);
        // <>^uɕϊ
        $newdata = str_replace("<>", "\t", $newdata);

        // Vf[^ԏɒǉ
        @array_unshift($lines, $newdata);
        
        $cont = implode("\n", $lines) . "\n";

        FileCtl::make_datafile($logfile, $_conf['p2_perm']);
        
        // ݏ
        if ($format == 'dataphp') {
            if (!DataPhp::writeDataPhp($logfile, $cont, $_conf['p2_perm'])) {
                return false;
            }
        } else {
            if (false === file_put_contents($logfile, $cont, LOCK_EX)) {
                trigger_error("file_put_contents(" . $logfile . ")", E_USER_WARNING);
                return false;
            }
        }
        
        return true;
    }

    /**
     * 2chOCIDPASSƎOCݒۑ
     *
     * @access  public
     * @return  boolean
     */
    function saveIdPw2ch($login2chID, $login2chPW, $autoLogin2ch = 0)
    {
        global $_conf;
        
        require_once P2_LIB_DIR . '/md5_crypt.funcs.php';
        
        // Ô߁Ałsȕ͒eĂ
        require_once P2_LIB_DIR . '/P2Validate.php';
        
        // 2ch ID (Ah)
        if ($login2chID and $errmsg = P2Validate::mail($login2chID)) {
            //P2Util::pushInfoHtml('<p>p2 error: gpłȂID񂪊܂܂Ă܂</p>');
            trigger_error($errmsg, E_USER_WARNING);
            return false;;
        }

        // mȋ͕s
        if ($login2chPW and $errmsg = P2Validate::login2chPW($login2chPW)) {
            //P2Util::pushInfoHtml('<p>p2 error: gpłȂpX[h񂪊܂܂Ă܂</p>');
            trigger_error($errmsg, E_USER_WARNING);
            return false;;
        }
        
        $autoLogin2ch = intval($autoLogin2ch);
        
        $crypted_login2chPW = md5_encrypt($login2chPW, P2Util::getMd5CryptPass());
        $idpw2ch_cont = <<<EOP
<?php
\$rec_login2chID = '{$login2chID}';
\$rec_login2chPW = '{$crypted_login2chPW}';
\$rec_autoLogin2ch = '{$autoLogin2ch}';
?>
EOP;
        FileCtl::make_datafile($_conf['idpw2ch_php'], $_conf['pass_perm']);
        if (false === file_put_contents($_conf['idpw2ch_php'], $idpw2ch_cont, LOCK_EX)) {
            p2die('f[^XVł܂ł');
            return false;
        }
        
        return true;
    }

    /**
     * 2chOC̕ۑςIDPASSƎOCݒǂݍ
     *
     * @access  public
     * @return  array|false
     */
    function readIdPw2ch()
    {
        global $_conf;
        
        require_once P2_LIB_DIR . '/md5_crypt.funcs.php';
        
        if (!file_exists($_conf['idpw2ch_php'])) {
            return false;
        }
        
        $rec_login2chID   = null;
        $login2chPW       = null;
        $rec_autoLogin2ch = null;
        
        include $_conf['idpw2ch_php'];

        // pX𕡍
        if (!is_null($rec_login2chPW)) {
            $login2chPW = md5_decrypt($rec_login2chPW, P2Util::getMd5CryptPass());
        }
        
        return array($rec_login2chID, $login2chPW, $rec_autoLogin2ch);
    }
    
    /**
     * md5_encrypt, md5_decrypt ̂߂ password(salt) 𓾂
     * i2chOCPASSۑɗpĂj
     *
     * @static
     * @access  private
     * @return  string
     */
    function getMd5CryptPass()
    {
        global $_login;
        
        return md5($_login->user . $_SERVER['SERVER_SOFTWARE']);
    }
    
    /**
     * @static
     * @access  public
     * @return  string
     */
    function getCsrfId()
    {
        global $_login;
        
        // docomoutfUAςႤ̂ŁAUA͊OĂ܂
        // return md5($_login->user . $_login->pass_x . geti($_SERVER['HTTP_USER_AGENT']));
        return md5($_login->user . $_login->pass_x);
    }
    
    /**
     * @static
     * @access  public
     * @return  boolean
     */
    function checkCsrfId($csrfid)
    {
        if (!$csrfid) {
            return false;
        }
        if ($csrfid == P2Util::getCsrfId()) {
            return true;
        }
        return false;
    }
    
    /**
     * 403 FobbidenHTMLo͂
     * 2007/01/20 ӁFEZwebł́A403y[WŖ{\ȂƂmFB
     *
     * @access  public
     * @return  void
     */
    function print403Html($msg_html = '', $die = true)
    {
        header('HTTP/1.0 403 Forbidden');
        ?>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">
    <title>403 Forbidden</title>
</head>
<body>
    <h1>403 Forbidden</h1>
    <p><?php echo $msg_html; ?></p>
</body>
</html>
<?php
        // IEftHg403bZ[W\Ȃ悤ɗeʂ҂߃_~[Xy[Xo͂
        $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT']: null;
        if (false !== strpos($ua, 'MSIE')) {
            for ($i = 0; $i < 512; $i++) {
                echo ' ';
            }
        }
        
        $die and die;
    }
    
    // {{{ session_gc()

    /**
     * ZbVt@C̃K[xbWRNV
     *
     * session.save_path̃pX̐[2傫ꍇAK[xbWRNV͍sȂ
     * ŃK[xbWRNVȂƂȂB
     *
     * @access  public
     * @return  void
     *
     * @link http://jp.php.net/manual/ja/ref.session.php#ini.session.save-path
     */
    function session_gc()
    {
        global $_conf;

        if (session_module_name() != 'files') {
            return;
        }

        $d = (int)ini_get('session.gc_divisor');
        $p = (int)ini_get('session.gc_probability');
        mt_srand();
        if (mt_rand(1, $d) <= $p) {
            $m = (int)ini_get('session.gc_maxlifetime');
            FileCtl::garbageCollection($_conf['session_dir'], $m);
        }
    }

    // }}}

    /**
     * Weby[W擾
     *
     * Ƃ݂ȂR[h
     * 200 OK
     * 206 Partial Content
     *
     * XVȂnullԂ
     * 304 Not Modified
     *
     * @static
     * @access  public
     * @param   string  $url     URL
     * @param   integer $code    X|XR[h
     * @param   integer $timeout ڑ^CAEgԕb
     * @param   array   $headers ǉwb_itB[hL[ => tB[hlj
     * @return  string|null|false     y[We|304|s
     */
    function getWebPage($url, &$code, &$error_msg, $timeout = 15, $headers = array())
    {
        //  &$code = null ͋o[WPHPł͕s
        
        require_once 'HTTP/Request.php';
    
        $params = array('timeout' => $timeout);
        
        if (!empty($GLOBALS['_conf']['proxy_use'])) {
            $params['proxy_host'] = $GLOBALS['_conf']['proxy_host'];
            $params['proxy_port'] = $GLOBALS['_conf']['proxy_port'];
        }
        
        $req = new HTTP_Request($url, $params);
        
        // If-Modified-Since => gmdate('D, d M Y H:i:s', time()) . ' GMT';
        
        if ($headers) {
            foreach ($headers as $k => $v) {
                $req->addHeader($k, $v);
            }
        }

        $response = $req->sendRequest();

        if (PEAR::isError($response)) {
            $error_msg = $response->getMessage();
        } else {
            $code = $req->getResponseCode();
            // Ƃ݂ȂR[h
            if ($code == 200 || $code == 206) {
                return $req->getResponseBody();
            // XVȂnullԂ
            } elseif ($code == 304) {
                // 304̎́A$req->getResponseBody() ͋󕶎""ƂȂ
                return null;
            } else {
                //var_dump($req->getResponseHeader());
                $error_msg = $code;
            }
        }
        
        return false;
    }

    /**
     * gт̌ŗL[IDABBMɋKĂ邩ǂ₢킹
     *
     * http://qb5.2ch.net/test/read.cgi/operate/1093340433/99
     * http://qb5.2ch.net/test/read.cgi/operate/1093340433/241
     * my $AHOST = "$NOWTIME.$$.c.$FORM{'bbs'}.$FORM{'key'}.A.B.C.D.E.$idnotane.bbm.2ch.net"; 
     *
     * @static
     * @access  public
     * @return  boolean
     */
    function isKIDBurnedByBBM($sn, $bbs = null, $key = null)
    {
        if (!$sn) {
            trigger_error(sprintf('%s(): no $sn', __FUNCTION__), E_USER_WARNING);
            return false;
        }
        
        $kid = P2Util::getKidForBBM($sn);
    
        //$bbm_host = 'niku.2ch.net';
        
        !$bbs and $bbs = 'd';
        !$key and $key = 'e';
        
        $query_host = time() . ".b.c.{$bbs}.{$key}.A.B.C.D.E." . $kid . '.bbm.2ch.net';
    
        // ₢킹s
        $result_addr = gethostbyname($query_host);
        /* var_dump($query_addr, $result_addr); */
        if ($result_addr == '127.0.0.2') {
            return TRUE; // BBMɏĂĂ
        }
        return FALSE; // BBMɏĂĂȂ
    }
    
    /**
     * gт̌ŗL[IDBBMpɐK
     *
     * http://qb5.2ch.net/test/read.cgi/operate/1093340433/99
     * http://qb5.2ch.net/test/read.cgi/operate/1093340433/241
     *
     * @static
     * @access  private
     * @param   string  $kid  gьŗL[ID
     * @return  string
     */
    function getKidForBBM($kid)
    {
        // http://qb5.2ch.net/test/read.cgi/operate/1208685863/808
        // EBBMo^u7BBMo^͂ꂽ(ႦAbcD123)A 
        // AbcD123-0110000  BBM ɓo^悤ɂ
        $kid = P2Util::getKidForImodeID($kid);
        
        // A_[XRÁAnCtɕϊ
        // http://qb5.2ch.net/test/read.cgi/operate/1093340433/84
        $kid = str_replace('_', '-', $kid);
        
        $kid = preg_replace('/\.ezweb\.ne\.jp$/' , '', $kid);

        return $kid;
    }
    
    /**
     * @static
     * @access  private
     * @param   string  $kid  gьŗL[ID
     * @return  string
     */
    function getKidForImodeID($kid)
    {
        if (preg_match('/^[0-9A-Za-z]{7}$/', $kid)) {
            $kid = $kid . '-' . strtr(
                $kid,
                '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',
                '00000000000000000000000000000000000011111111111111111111111111'
            );
        }
        return $kid;
    }
    
    /**
     * VvHTML\
     * iPɃeLXg𑗂auȂǂ́A\ĂȂ̂Łj
     *
     * @static
     * @access  public
     * @return  void
     */
    function printSimpleHtml($body_html)
    {
        echo "<html><body>{$body_html}</body></html>";
    }
    
    /**
     * t@Cw肵āAVACYꂽzf[^}[WXVĩf[^ɏ㏑}[Wj
     *
     * @static
     * @access  public
     * @param   array    $data
     * @param   string   $file
     * @return  boolean
     */
    function updateArraySrdFile($data, $file)
    {
        // ̃f[^}[W擾
        if (file_exists($file)) {
            if ($cont = file_get_contents($file)) {
                $array = unserialize($cont);
                if (is_array($array)) {
                    $data = array_merge($array, $data);
                }
            }
        }
        
        // }[WXVȂ̂ŏ㏑f[^ۂ͉̎Ȃ
        if (empty($data) || !is_array($data)) {
            return false;
        }

        if (false === file_put_contents($file, serialize($data), LOCK_EX)) {
            trigger_error("file_put_contents(" . hs($file) . ")", E_USER_WARNING);
            return false;
        }
        return true;
    }
    
    /**
     * 2006/11/24 $_info_msg_ht 𒼐ڎQƂ̂͂߂Ẵ\bhʂ
     *
     * @static
     * @access  public
     * @return  void
     */
    function pushInfoHtml($html)
    {
        global $_info_msg_ht;
        
        if (!isset($_info_msg_ht)) {
            $_info_msg_ht = $html;
        } else {
            $_info_msg_ht .= $html;
        }
    }
    
    /**
     * @static
     * @access  public
     * @return  void
     */
    function printInfoHtml()
    {
        global $_info_msg_ht, $_conf;
        
        if (!isset($_info_msg_ht) || !strlen($_info_msg_ht)) {
            return;
        }
        
        if (UA::isK() && $_conf['k_save_packet']) {
            echo mb_convert_kana($_info_msg_ht, 'rnsk');
        } else {
            echo $_info_msg_ht;
        }
        
        $_info_msg_ht = '';
    }
    
    /**
     * @static
     * @access  public
     * @return  string|null
     */
    function getInfoHtml()
    {
        global $_info_msg_ht;
        
        if (!isset($_info_msg_ht)) {
            return null;
        }
        
        $info_msg_ht = $_info_msg_ht;
        $_info_msg_ht = '';
        
        return $info_msg_ht;
    }

    /**
     * O̕ϐiGET, POST, [COOKIE]j擾
     *
     * @static
     * @access  public
     * @param   string|array  $key      擾Ώۂ̃L[
     * @param   mixed         $alt      l !isset() ̏ꍇ̑֒l
     * @param   array|string  $methods  擾Ώۃ\bhizȂODj
     * @return  string|array  L[zŎw肳Ă΁AzŕԂ
     */
    function getReq($key, $alt = null, $methods = array('GET', 'POST'))
    {
        if (is_array($key)) {
            $req = array_flip($key);
            foreach ($req as $k => $v) {
                $req[$k] = $alt;
            }
        } else {
            $req = $alt;
        }
        
        if (!is_array($methods)) {
            $methods = array($methods);
        } else {
            $methods = array_reverse($methods);
        }
        
        foreach ($methods as $method) {
            $globalsName = '_' . $method;
            if (is_array($key)) {
                foreach ($key as $v) {
                    isset($GLOBALS[$globalsName][$v]) and $req[$v] = $GLOBALS[$globalsName][$v];
                }
            } else {
                isset($GLOBALS[$globalsName][$key]) and $req = $GLOBALS[$globalsName][$key];
            }
        }
        
        return $req;
    }

    /**
     * iANZX[Új[gzXg擾
     *
     * @param   string  $empty  gethostbyaddr() IPԂ̎̑֕B
     * @return  string
     */
    function getRemoteHost($empty = '')
    {
        // gethostbyaddr() ́AsXNvgłLbVȂ悤Ȃ̂ŃLbV
        static $gethostbyaddr_ = null;
        
        if (isset($_SERVER['REMOTE_HOST'])) {
            return $_SERVER['REMOTE_HOST'];
        }
        
        if (php_sapi_name() == 'cli') {
            return 'cli';
        }
        
        if (is_null($gethostbyaddr_)) {
            require_once P2_LIB_DIR . '/HostCheck.php';
            $gethostbyaddr_ = HostCheck::cachedGetHostByAddr($_SERVER['REMOTE_ADDR']);
        }
        
        return ($gethostbyaddr_ == $_SERVER['REMOTE_ADDR']) ? $empty : $gethostbyaddr_;
    }
}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
