#include <vcclr.h>
#include "orbitersdk.h"
#include "Launcher.h"

using namespace Orbiter::Interfaces;
using namespace Orbiter::Launcher;
using namespace System;
using namespace System::IO;
using namespace System::Reflection;

#pragma unmanaged

HINSTANCE dllHandle;

void WINAPI clrInitialize(DWORD sd)
{
	InitModule(dllHandle);
}

BOOL WINAPI DllMain(
  HINSTANCE hinstDLL,
  DWORD fdwReason,
  LPVOID lpvReserved
)
{
	DWORD threadID;
	switch(fdwReason)
	{
	case DLL_PROCESS_ATTACH:
		dllHandle=hinstDLL;		
		CreateThread(0, 0, (LPTHREAD_START_ROUTINE) clrInitialize, 0, 0, &threadID);
		break;
	}
	return TRUE;
}

#pragma managed

gcroot<Launcher^> launcher=gcnew Launcher();

DLLCLBK void InitModule (HINSTANCE hDLL)
{
	//Just a dummy to start CLR	
}

DLLCLBK void ExitModule (HINSTANCE hDLL)
{
	//Actually never called due to current single-AppDomain solution
	launcher->VesselModule->ExitModule((IntPtr)hDLL);
	launcher=nullptr;
}

DLLCLBK VESSEL *ovcInit (OBJHANDLE hVessel,int flightmodel)
{
	return (VESSEL *)(VESSEL2 *)(void *)(launcher->VesselModule->InitVessel((IntPtr)hVessel, flightmodel));
}

DLLCLBK void ovcExit (VESSEL *vessel)
{
	launcher->VesselModule->ExitVessel((IntPtr)vessel);
}

namespace Orbiter
{
	namespace Launcher
	{
		Launcher::Launcher()
		{
			Assembly^ launcher=Assembly::GetExecutingAssembly();
			String^ name=Path::GetFileName(launcher->Location);
			String^ dir=Path::GetDirectoryName(launcher->Location);
			AppDomain^ x=AppDomain::CreateDomain(launcher->Location);
			Assembly^ assm=Assembly::LoadFrom(Path::Combine(Path::Combine(dir, "DotNET"), name));
			Type^ vtype=Orbiter::Interfaces::VesselModule::typeid;
			if (assm!=nullptr)
			{
				for each (Type^ t in assm->GetTypes())
				{
					if (vtype->IsAssignableFrom(t))
					{
						vesselModule=(Orbiter::Interfaces::VesselModule^)assm->CreateInstance(t->FullName);
						break;
					}
				}
			}
			vesselModule->InitModule((IntPtr)(void *)dllHandle);
		}

		Orbiter::Interfaces::VesselModule^ Launcher::VesselModule::get(void){return vesselModule;}
	}
}