#pragma once
#include <vcclr.h>
#include "orbitersdk.h"

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;

namespace Orbiter
{
	namespace Wrapper
	{
		public class Vessel2 :public VESSEL2
		{
		public:
			Vessel2(OBJHANDLE hVessel, int flightmodel, Interfaces::Vessel2^ vessel2);
			~Vessel2();
			//VESSEL2 implementations
			virtual void clbkSetClassCaps (FILEHANDLE cfg);
			virtual void clbkSaveState (FILEHANDLE scn);
			virtual void clbkLoadStateEx (FILEHANDLE scn, void *status);
			virtual void clbkSetStateEx (const void *status);
			virtual void clbkPostCreation ();
			virtual void clbkFocusChanged (bool getfocus, OBJHANDLE hNewVessel, OBJHANDLE hOldVessel);
			virtual void clbkPreStep (double simt, double simdt, double mjd);
			virtual void clbkPostStep (double simt, double simdt, double mjd);
			virtual bool clbkPlaybackEvent (double simt, double event_t, const char *event_type, const char *event);
			virtual void clbkVisualCreated (VISHANDLE vis, int refcount);
			virtual void clbkVisualDestroyed (VISHANDLE vis, int refcount);
			virtual void clbkDrawHUD (int mode, const HUDPAINTSPEC *hps, HDC hDC);
			virtual void clbkRCSMode (int mode);
			virtual void clbkADCtrlMode (DWORD mode);
			virtual void clbkHUDMode (int mode);
			virtual void clbkMFDMode (int mfd, int mode);
			virtual void clbkNavMode (int mode, bool active);
			virtual void clbkDockEvent (int dock, OBJHANDLE mate);
			virtual void clbkAnimate (double simt);
			virtual int  clbkConsumeDirectKey (char *keystate);
			virtual int  clbkConsumeBufferedKey (DWORD key, bool down, char *keystate);
			virtual bool clbkLoadGenericCockpit ();
			virtual bool clbkLoadPanel (int id);
			virtual bool clbkPanelMouseEvent (int id, int event, int mx, int my);
			virtual bool clbkPanelRedrawEvent (int id, int event, SURFHANDLE surf);
			virtual bool clbkLoadVC (int id);
			virtual bool clbkVCMouseEvent (int id, int event, VECTOR3 &p);
			virtual bool clbkVCRedrawEvent (int id, int event, SURFHANDLE surf);
			//Implementing the base calls
			void SetClassCaps (IntPtr configuration);
			void SaveState (IntPtr scenario);
			void LoadStateEx (IntPtr scenario, IntPtr status);
			void SetStateEx (Interfaces::VesselStatus2);
			void PostCreation ();
			void FocusChanged (bool getFocus, IntPtr newVessel, IntPtr oldVessel);
			void PreStep (double simt, double simdt, double mjd);
			void PostStep (double simt, double simdt, double mjd);
			bool PlaybackEvent (double simt, double event_t, String^ event_type, String^ event_name);
			void VisualCreated (IntPtr vis, int refCount);
			void VisualDestroyed (IntPtr vis, int refCount);
			void DrawHUD (int mode, Interfaces::HudPaintSpecification hps, IntPtr hDC);
			void RCSMode (int mode);
			void ADCtrlMode (int mode);
			void HUDMode (int mode);
			void MFDMode (int mfd, int mode);
			void NavMode (int mode, bool active);
			void DockEvent (int dock, IntPtr mate);
			void Animate (double simt);
			int  ConsumeDirectKey (IntPtr keyState);
			int  ConsumeBufferedKey (int key, bool down, IntPtr keyState);
			bool LoadGenericCockpit ();
			bool LoadPanel (int id);
			bool PanelMouseEvent (int id, int mouseEvent, int mx, int my);
			bool PanelRedrawEvent (int id, int mouseEvent, IntPtr surface);
			bool LoadVC (int id);
			bool VCMouseEvent (int id, int mouseEvent, Interfaces::Vector3^ p);
			bool VCRedrawEvent (int id, int mouseEvent, IntPtr surface);
		private:
			gcroot<Interfaces::Vessel2^> vessel2;
			bool bSetClassCaps;
			bool bSaveState;
			bool bLoadStateEx;
			bool bSetStateEx;
			bool bPostCreation;
			bool bFocusChanged;
			bool bPreStep;
			bool bPostStep;
			bool bPlaybackEvent;
			bool bVisualCreated;
			bool bVisualDestroyed;
			bool bDrawHUD;
			bool bRCSMode;
			bool bADCtrlMode;
			bool bHUDMode;
			bool bMFDMode;
			bool bNavMode;
			bool bDockEvent;
			bool bAnimate;
			bool bConsumeDirectKey;
			bool bConsumeBufferedKey;
			bool bLoadGenericCockpit;
			bool bLoadPanel;
			bool bPanelMouseEvent;
			bool bPanelRedrawEvent;
			bool bLoadVC;
			bool bVCMouseEvent;
			bool bVCRedrawEvent;
		};
	}
}