#pragma once
#include <vcclr.h>
#include "orbitersdk.h"

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;

namespace Orbiter
{
	namespace Wrapper
	{
		public ref class Vessel : Interfaces::Vessel
		{
		public:
			Vessel(VESSEL *vessel);
			~Vessel();
			static IntPtr Init(IntPtr vessel, int flightmodel, Interfaces::Vessel2^ vessel2);
			static void Exit(IntPtr vessel);
			virtual property IntPtr Handle{IntPtr get(void);};
			virtual property String^ Name {String^ get(void);}
			virtual property String^ ClassName {String^ get(void);}
			virtual property int FlightModel {int get(void);}
			virtual property int DamageModel {int get(void);}
			virtual property bool FocusEnabled {bool get(void); void set(bool value);}
			virtual property double Size {double get(void); void set(double value);}
			virtual property double ClipRadius {double get(void); void set(double value);}
			virtual property double Mass {double get(void);}
			virtual property double EmptyMass {double get(void); void set(double value);}
			virtual property double ISP {double get(void);}
			virtual void SetVisibilityLimit(double vislimit);
			virtual void SetVisibilityLimit(double vislimit, double spotlimit);
			virtual property Interfaces::CW CW {Interfaces::CW get(void); void set(Interfaces::CW value);}
			virtual property double WingAspect {double get(void); void set(double value);}
			virtual property double WingEffectiveness {double get(void); void set(double value);}
			virtual property Interfaces::Vector3^ CrossSections {Interfaces::Vector3^ get(void); void set(Interfaces::Vector3^ value);}
			virtual property Interfaces::Vector3^ RotationalDrag {Interfaces::Vector3^ get(void); void set(Interfaces::Vector3^ value);}
			virtual property double PitchMomentScale {double get(void); void set(double value);}
			virtual property double BankMomentScale {double get(void); void set(double value);}
			virtual property double TrimScale {double get(void); void set(double value);}
			virtual property Interfaces::Vector3^ PMI {Interfaces::Vector3^ get(void); void set(Interfaces::Vector3^ value);}
			virtual property Interfaces::Vector3^ CameraOffset {Interfaces::Vector3^ get(void); void set(Interfaces::Vector3^ value);}
			virtual property Interfaces::LiftCoefficientDelegate^ LiftCoefficient {void set(Interfaces::LiftCoefficientDelegate^ value);}
			virtual void SetDockParameters (Interfaces::DockParameters parameters);
			virtual void SetDockParameters (IntPtr dock, Interfaces::DockParameters parameters);
			virtual Interfaces::DockParameters GetDockParameters (IntPtr dock);
			virtual property Interfaces::TouchDownPoints TouchDownPoints {Interfaces::TouchDownPoints get(void); void set(Interfaces::TouchDownPoints value);}
			virtual UINT AddMesh(String^ name, Interfaces::Vector3^ offset);
			virtual UINT AddMesh(IntPtr mesh, Interfaces::Vector3^ offset);
			virtual UINT AddMesh(String^ name);
			virtual UINT AddMesh(IntPtr mesh);
			virtual IntPtr CreatePropellantResource (double maxmass);
			virtual IntPtr CreatePropellantResource (double maxmass, double mass);
			virtual IntPtr CreatePropellantResource (double maxmass, double mass, double efficiency);
			virtual IntPtr CreateThruster(Interfaces::Vector3^ position, Interfaces::Vector3^ direction, double maximumVacuumThrust, IntPtr propellant, double ispVacuum, double ispReference, double pressureReference);
			virtual IntPtr CreateThruster(Interfaces::Vector3^ position, Interfaces::Vector3^ direction, double maximumVacuumThrust, IntPtr propellant, double ispVacuum, double ispReference);
			virtual IntPtr CreateThruster(Interfaces::Vector3^ position, Interfaces::Vector3^ direction, double maximumVacuumThrust, IntPtr propellant, double ispVacuum);
			virtual IntPtr CreateThruster(Interfaces::Vector3^ position, Interfaces::Vector3^ direction, double maximumVacuumThrust, IntPtr propellant);
			virtual IntPtr CreateThruster(Interfaces::Vector3^ position, Interfaces::Vector3^ direction, double maximumVacuumThrust);
			virtual IntPtr CreateThrusterGroup (array<IntPtr>^ thruster, Interfaces::ThrusterGroup group);
			virtual UINT AddExhaust (IntPtr thruster, double lengthScale, double widthScale, IntPtr texture);
			virtual UINT AddExhaust (IntPtr thruster, double lengthScale, double widthScale);
			virtual UINT AddExhaust (IntPtr thruster, double lengthScale, double widthScale, double lengthOffset, IntPtr texture);
			virtual UINT AddExhaust (IntPtr thruster, double lengthScale, double widthScale, double lengthOffset);
			virtual UINT AddExhaust (IntPtr thruster, double lengthScale, double widthScale, Interfaces::Vector3^ position, Interfaces::Vector3^ direction, IntPtr texture);
			virtual UINT AddExhaust (IntPtr thruster, double lengthScale, double widthScale, Interfaces::Vector3^ position, Interfaces::Vector3^ direction);
			virtual IntPtr AddExhaustStream (IntPtr thruster, Interfaces::ParticleStreamSpecification particleStream);
			virtual IntPtr AddExhaustStream (IntPtr thruster);
			virtual IntPtr AddExhaustStream (IntPtr thruster, Interfaces::Vector3^ position, Interfaces::ParticleStreamSpecification particleStream);
			virtual IntPtr AddExhaustStream (IntPtr thruster, Interfaces::Vector3^ position);
			virtual property IntPtr AtmosphereReference {IntPtr get(void);}
			virtual property double AtmosphereTemperature {double get(void);}
			virtual property double AtmosphereDensity {double get(void);}
			virtual property double AtmospherePressure {double get(void);}
			virtual property double DynamicPressure {double get(void);}
			virtual property double MachNumber {double get(void);}
			virtual double GetThrusterLevel (IntPtr thruster);
			virtual void   SetThrusterLevel (IntPtr thruster, double level);
			virtual property Interfaces::Vector3^ ForceVector {Interfaces::Vector3^ get(void);}
            virtual property Interfaces::Vector3^ WeightVector {Interfaces::Vector3^ get(void);}
			virtual property Interfaces::Vector3^ ThrustVector {Interfaces::Vector3^ get(void);}
            virtual property Interfaces::Vector3^ LiftVector {Interfaces::Vector3^ get(void);}
			virtual property Interfaces::Vector3^ DragVector {Interfaces::Vector3^ get(void);}
			virtual property double Drag {double get(void);}
			virtual property double Lift {double get(void);}            
			virtual void DelPropellantResource (IntPtr propellant);
			virtual void ClearPropellantResources (void);
			virtual IntPtr GetPropellantHandleByIndex (unsigned int index);
			virtual void SetDefaultPropellantResource (IntPtr propellant);
			virtual void SetPropellantMaxMass (IntPtr propellant, double maxMass);
			virtual double GetPropellantMaxMass (IntPtr propellant);
			virtual void SetPropellantEfficiency (IntPtr propellant, double efficiency);
			virtual double GetPropellantEfficiency (IntPtr propellant);
			virtual void SetPropellantMass (IntPtr propellant, double mass);			
			virtual double GetPropellantMass (IntPtr propellant);
			virtual double GetPropellantFlowrate (IntPtr propellant);
			virtual property unsigned int PropellantCount {unsigned int get(void);};
			virtual property double TotalPropellantMass {double get(void);};
			virtual property double TotalPropellantFlowrate {double get(void);};
			virtual property double FuelMass {double get(void); void set(double value);};
			virtual property double FuelRate {double get(void);};
			virtual property double MaxFuelMass {double get(void); void set(double value);};
			virtual unsigned int CreateAnimation (double initial_state);
			virtual IntPtr AddAnimationComponent (unsigned int animation, double state0, double state1, Interfaces::MeshGroupTransformation^ transformation, IntPtr parent);
			virtual IntPtr AddAnimationComponent (unsigned int animation, double state0, double state1, Interfaces::MeshGroupTransformation^ transformation);
			virtual property Interfaces::Vector3^ AlbedoRGB {void set(Interfaces::Vector3^ value);};
			virtual property double GravityGradientDamping {double get(void); void set(double value);};
			virtual void SetSurfaceFrictionCoefficients(double longitudinal, double latitudinal);
			virtual property double MaxWheelbrakeForce {void set(double value);};
			virtual void SetWheelbrakeLevel (double level, int which, bool permanent);
			virtual void SetWheelbrakeLevel (double level, int which);
			virtual void SetWheelbrakeLevel (double level);
			virtual double GetWheelbrakeLevel (int which);
			virtual void InitNavRadios (unsigned int navRadios);
			virtual property bool IsTransponderEnabled {void set(bool value);};			
			virtual void CreateAirfoil (Interfaces::AirFoilOrientation align, Interfaces::Vector3^ reference, Interfaces::AirFoilCoefficientDelegate^ coefficient, double chordLength, double wingArea, double aspectRatio);
			virtual IntPtr CreateAirfoil2 (Interfaces::AirFoilOrientation align, Interfaces::Vector3^ reference, Interfaces::AirFoilCoefficientDelegate^ coefficient, double chordLength, double wingArea, double aspectRatio);
			virtual IntPtr CreateAirfoil3 (Interfaces::AirFoilOrientation align, Interfaces::Vector3^ reference, Interfaces::AirFoilCoefficientExDelegate^ coefficient, Object^ context, double chordLength, double wingArea, double aspectRatio);
			virtual Object^ GetAirFoilCoefficientFunctionContext (IntPtr key);
			virtual void CreateControlSurface (Interfaces::ControlSurface type, double area, double liftCoefficientShift, Interfaces::Vector3^ reference);
			virtual void CreateControlSurface (Interfaces::ControlSurface type, double area, double liftCoefficientShift, Interfaces::Vector3^ reference, int axis);
			virtual void CreateControlSurface (Interfaces::ControlSurface type, double area, double liftCoefficientShift, Interfaces::Vector3^ reference, int axis, unsigned int animation);
			virtual IntPtr CreateControlSurface2 (Interfaces::ControlSurface type, double area, double liftCoefficientShift, Interfaces::Vector3^ reference);
			virtual IntPtr CreateControlSurface2 (Interfaces::ControlSurface type, double area, double liftCoefficientShift, Interfaces::Vector3^ reference, int axis);
			virtual IntPtr CreateControlSurface2 (Interfaces::ControlSurface type, double area, double liftCoefficientShift, Interfaces::Vector3^ reference, int axis, unsigned int animation);			
			virtual void CreateVariableDragElement (Interfaces::DoublePointer^ drag, double factor, Interfaces::Vector3^ reference);
			virtual void SetMeshVisibilityMode (unsigned int mesh, short int mode);
			virtual void AddBeacon (Interfaces::BeaconLightSpecification beacon);
			virtual property Interfaces::AttitudeMode AttitudeMode {Interfaces::AttitudeMode get(void); void set(Interfaces::AttitudeMode value);};
																										
	//double GetMaxThrust (ENGINETYPE eng) const;			
	//double GetEngineLevel (ENGINETYPE eng) const;
	//double *GetMainThrustModPtr (void) const;	
	//int    ToggleAttitudeMode (void) const;
	//DWORD  GetADCtrlMode (void) const;
	//void   SetADCtrlMode (DWORD mode) const;
	//void   GetAttitudeRotLevel (VECTOR3 &th) const;
	//void   GetAttitudeLinLevel (VECTOR3 &th) const;
	//double GetManualControlLevel (THGROUP_TYPE thgt, DWORD mode = MANCTRL_ATTMODE, DWORD device = MANCTRL_ANYDEVICE) const;
	//double GetCOG_elev (void) const;	
	//void   GetCameraDefaultDirection (VECTOR3&) const;
	//void   GetStatus (VESSELSTATUS &status) const;
	//void   GetStatusEx (void *status) const;
	//DWORD  GetFlightStatus (void) const;
	//const  OBJHANDLE GetGravityRef () const;
	//const  OBJHANDLE GetSurfaceRef () const;
	//double GetAltitude (void) const;
	//double GetAirspeed (void) const;
	//bool   GetHorizonAirspeedVector (VECTOR3 &v) const;
	//bool   GetShipAirspeedVector (VECTOR3 &v) const;
	//double GetAOA (void) const;
	//double GetSlipAngle (void) const;
	//double GetPitch (void) const;
	//double GetBank (void) const;
	//void   GetGlobalPos (VECTOR3 &pos) const;
	//void   GetGlobalVel (VECTOR3 &vel) const;
	//void   GetRelativePos (OBJHANDLE hRef, VECTOR3 &pos) const;
	//void   GetRelativeVel (OBJHANDLE hRef, VECTOR3 &vel) const;
	//void   GetLinearMoment (VECTOR3 &F) const;
	//void   GetAngularVel (VECTOR3 &avel) const;
	//void   SetAngularVel (const VECTOR3 &avel) const;
	//void   GetAngularAcc (VECTOR3 &aacc) const;
	//void   GetAngularMoment (VECTOR3 &amom) const;
	//void   GetGlobalOrientation (VECTOR3 &arot) const;
	//void   SetGlobalOrientation (const VECTOR3 &arot) const;
	//OBJHANDLE GetEquPos (double &longitude, double &latitude, double &radius) const;
	//OBJHANDLE GetElements (ELEMENTS &el, double &mjd_ref) const;
	//bool   GetElements (OBJHANDLE hRef, ELEMENTS &el, ORBITPARAM *prm = 0, double mjd_ref = 0, int frame = FRAME_ECL) const;
	//bool   SetElements (OBJHANDLE hRef, const ELEMENTS &el, ORBITPARAM *prm = 0, double mjd_ref = 0, int frame = FRAME_ECL) const;
	//OBJHANDLE GetArgPer (double &arg) const;
	//OBJHANDLE GetSMi (double &smi) const;
	//OBJHANDLE GetApDist (double &apdist) const;
	//OBJHANDLE GetPeDist (double &pedist) const;	
	//void   SetISP (double) const;
	//void   SetMaxThrust (ENGINETYPE eng, double th) const;
	//void   SetEngineLevel (ENGINETYPE eng, double level) const;
	//void   IncEngineLevel (ENGINETYPE eng, double dlevel) const;
	//void   SetAttitudeRotLevel (const VECTOR3 &th) const;
	//void   SetAttitudeRotLevel (int axis, double th) const;
	//void   SetAttitudeLinLevel (const VECTOR3 &th) const;
	//void   SetAttitudeLinLevel (int axis, double th) const;
	//bool   ActivateNavmode (int mode);
	//bool   DeactivateNavmode (int mode);
	//bool   ToggleNavmode (int mode);
	//bool   GetNavmodeState (int mode);
	//void   SetCOG_elev (double h) const;		
	//void   SetCameraDefaultDirection (const VECTOR3 &cd) const;
	//void   SetCameraDefaultDirection (const VECTOR3 &cd, double tilt) const;
	//void   SetCameraRotationRange (double left, double right, double up, double down) const;
	//void   SetCameraShiftRange (const VECTOR3 &fpos, const VECTOR3 &lpos, const VECTOR3 &rpos) const;
	//void   SetCameraMovement (const VECTOR3 &fpos, double fphi, double ftht, const VECTOR3 &lpos, double lphi, double ltht, const VECTOR3 &rpos, double rphi, double rtht) const;		
	//void   DefSetState (const VESSELSTATUS *status) const;
	//void   DefSetStateEx (const void *status) const;
	//void   SaveDefaultState (FILEHANDLE scn) const;
	//void   ParseScenarioLine (char *line, VESSELSTATUS *status) const;
	//void   ParseScenarioLineEx (char *line, void *status) const;
	//void   ClearMeshes () const;
	//void   ClearMeshes (bool retain_anim) const;	
	//UINT   InsertMesh (const char *meshname, UINT idx, const VECTOR3 *ofs=0) const;
	//UINT   InsertMesh (MESHHANDLE hMesh, UINT idx, const VECTOR3 *ofs=0) const;
	//bool   DelMesh (UINT idx, bool retain_anim=false) const;
	//bool   ShiftMesh (UINT idx, const VECTOR3 &ofs) const;
	//void   ShiftMeshes (const VECTOR3 &ofs) const;
	//MESHHANDLE GetMesh (VISHANDLE vis, UINT idx) const;
	//void   SetMeshVisibleInternal (UINT meshidx, bool visible) const;
	//bool   MeshgroupTransform (VISHANDLE vis, const MESHGROUP_TRANSFORM &mt) const;
	//void   SetExhaustScales (EXHAUSTTYPE exh, WORD id, double lscale, double wscale) const;
	//void   SetReentryTexture (SURFHANDLE tex, double plimit=6e7, double lscale=1.0, double wscale=1.0) const;
	//void   ShiftCentreOfMass (const VECTOR3 &shift);
	//void   ShiftCG (const VECTOR3 &shift);
	//void   AddForce (const VECTOR3 &F, const VECTOR3 &r) const;

	//// Animations
	//void   RegisterAnimation (void) const;
	//void   UnregisterAnimation (void) const;
	//UINT   RegisterAnimSequence (double defmeshstate) const; // obsolete
	//bool   AddAnimComp (UINT seq, ANIMCOMP *comp); // obsolete
	//bool   SetAnimState (UINT seq, double state); // obsolete
	//bool   DelAnimation (UINT anim) const;
	//bool   DelAnimationComponent (UINT anim, ANIMATIONCOMPONENT_HANDLE hAC);
	//bool   SetAnimation (UINT anim, double state) const;

	//// Recording/playback functions
	//bool   Recording (void) const;
	//bool   Playback (void) const;
	//void   RecordEvent (const char *event_type, const char *event) const;

	//// Transformations
	//void   GetRotationMatrix (MATRIX3 &R) const;
	//void   SetRotationMatrix (const MATRIX3 &R) const;
	//void   GlobalRot (const VECTOR3 &rloc, VECTOR3 &rglob) const;
	//void   HorizonRot (const VECTOR3 &rloc, VECTOR3 &rhorizon) const;
	//void   HorizonInvRot (const VECTOR3 &rhorizon, VECTOR3 &rloc) const;
	//void   Local2Global (const VECTOR3 &local, VECTOR3 &global) const;
	//void   Global2Local (const VECTOR3 &global, VECTOR3 &local) const;
	//void   Local2Rel (const VECTOR3 &local, VECTOR3 &rel) const;

	//// Thruster management
	//bool   DelThruster (THRUSTER_HANDLE &th) const;
	//void   ClearThrusterDefinitions () const;
	//THRUSTER_HANDLE GetThrusterHandleByIndex (DWORD idx) const;
	//DWORD  GetThrusterCount (void) const;
	//void   SetThrusterRef (THRUSTER_HANDLE th, const VECTOR3 &pos) const;
	//void   SetThrusterDir (THRUSTER_HANDLE th, const VECTOR3 &dir) const;
	//void   SetThrusterMax0 (THRUSTER_HANDLE th, double maxth0) const;
	//double GetThrusterMax0 (THRUSTER_HANDLE th) const;
	//double GetThrusterMax (THRUSTER_HANDLE th) const;
	//double GetThrusterMax (THRUSTER_HANDLE th, double p_ref) const;
	//void   SetThrusterIsp (THRUSTER_HANDLE th, double isp) const;
	//void   SetThrusterIsp (THRUSTER_HANDLE th, double isp0, double isp_ref, double p_ref=101.4e3) const;
	//double GetThrusterIsp (THRUSTER_HANDLE th) const;
	//double GetThrusterIsp (THRUSTER_HANDLE th, double p_ref) const;
	//double GetThrusterIsp0 (THRUSTER_HANDLE th) const;
	//void   SetThrusterResource (THRUSTER_HANDLE th, PROPELLANT_HANDLE ph) const;
	//PROPELLANT_HANDLE GetThrusterResource (THRUSTER_HANDLE th) const;	
	//void   IncThrusterLevel (THRUSTER_HANDLE th, double dlevel) const;
	//void   SetThrusterLevel_SingleStep (THRUSTER_HANDLE th, double level) const;
	//void   IncThrusterLevel_SingleStep (THRUSTER_HANDLE th, double dlevel) const;
	//void   GetThrusterRef (THRUSTER_HANDLE th, VECTOR3 &pos) const;
	//void   GetThrusterDir (THRUSTER_HANDLE th, VECTOR3 &dir) const;	
	//void   GetThrusterMoment (THRUSTER_HANDLE th, VECTOR3 &F, VECTOR3 &T) const;

	//// Thruster group management	
	//bool   DelThrusterGroup (THGROUP_HANDLE &thg, THGROUP_TYPE thgt, bool delth = false) const;
	//bool   DelThrusterGroup (THGROUP_TYPE thgt, bool delth = false) const;
	//THGROUP_HANDLE GetThrusterGroupHandle (THGROUP_TYPE thgt) const;
	//THGROUP_HANDLE GetUserThrusterGroupHandleByIndex (DWORD idx) const;
	//DWORD  GetGroupThrusterCount (THGROUP_HANDLE thg) const;
	//DWORD  GetGroupThrusterCount (THGROUP_TYPE thgt) const;
	//THRUSTER_HANDLE GetGroupThruster (THGROUP_HANDLE thg, DWORD idx) const;
	//THRUSTER_HANDLE GetGroupThruster (THGROUP_TYPE thgt, DWORD idx) const;
	//DWORD  GetUserThrusterGroupCount (void) const;
	//bool   ThrusterGroupDefined (THGROUP_TYPE thgt) const;
	//void   SetThrusterGroupLevel (THGROUP_HANDLE thg, double level) const;
	//void   SetThrusterGroupLevel (THGROUP_TYPE thgt, double level) const;
	//void   IncThrusterGroupLevel (THGROUP_HANDLE thg, double dlevel) const;
	//void   IncThrusterGroupLevel (THGROUP_TYPE thgt, double dlevel) const;
	//void   IncThrusterGroupLevel_SingleStep (THGROUP_HANDLE thg, double dlevel) const;
	//void   IncThrusterGroupLevel_SingleStep (THGROUP_TYPE thgt, double dlevel) const;
	//double GetThrusterGroupLevel (THGROUP_HANDLE thg) const;
	//double GetThrusterGroupLevel (THGROUP_TYPE thgt) const;

	//// Exhaust render functions	
	//bool   DelExhaust (UINT idx) const;
	//UINT   AddExhaustRef (EXHAUSTTYPE exh, VECTOR3 &pos, double lscale = -1.0, double wscale = -1.0, VECTOR3 *dir = 0) const; // obsolete
	//void   DelExhaustRef (EXHAUSTTYPE exh, WORD id) const;  // obsolete
	//void   ClearExhaustRefs (void) const; // obsolete
	//UINT   AddAttExhaustRef (const VECTOR3 &pos, const VECTOR3 &dir, double wscale = 1.0, double lscale = 1.0) const; // obsolete
	//void   AddAttExhaustMode (UINT idx, ATTITUDEMODE mode, int axis, int dir) const; // obsolete
	//void   ClearAttExhaustRefs (void) const; // obsolete

	//// Particle systems
	//PSTREAM_HANDLE AddReentryStream (PARTICLESTREAMSPEC *pss) const;
	//PSTREAM_HANDLE AddParticleStream (PARTICLESTREAMSPEC *pss, const VECTOR3 &pos, const VECTOR3 &dir, double *lvl) const;	
	//bool   DelExhaustStream (PSTREAM_HANDLE ch) const;

	//// Airfoil and control surface functions
	//void   CreateAirfoil (AIRFOIL_ORIENTATION align, const VECTOR3 &ref, AirfoilCoeffFunc cf, double c, double S, double A) const;
	//AIRFOILHANDLE CreateAirfoil2 (AIRFOIL_ORIENTATION align, const VECTOR3 &ref, AirfoilCoeffFunc cf, double c, double S, double A) const;
	//AIRFOILHANDLE CreateAirfoil3 (AIRFOIL_ORIENTATION align, const VECTOR3 &ref, AirfoilCoeffFuncEx cf, void *context, double c, double S, double A) const;
	//void   EditAirfoil (AIRFOILHANDLE hAirfoil, DWORD flag, const VECTOR3 &ref, AirfoilCoeffFunc cf, double c, double S, double A) const;
	//bool   DelAirfoil (AIRFOILHANDLE hAirfoil) const;
	//void   ClearAirfoilDefinitions (void) const;
	//bool   DelControlSurface (CTRLSURFHANDLE hCtrlSurf) const;
	//void   ClearControlSurfaceDefinitions (void) const;
	//void   SetControlSurfaceLevel (AIRCTRL_TYPE type, double level) const;
	//double GetControlSurfaceLevel (AIRCTRL_TYPE type) const;
	//void   ClearVariableDragElements () const;

	//// Nosewheel-steering
	//void   SetNosewheelSteering (bool activate) const;
	//bool   GetNosewheelSteering (void) const;

	//// Docking port management
	//DOCKHANDLE CreateDock (const VECTOR3 &pos, const VECTOR3 &dir, const VECTOR3 &rot) const;
	//bool   DelDock (DOCKHANDLE hDock) const;
	//void   ClearDockDefinitions (void) const;
	
	//UINT   DockCount (void) const;
	//DOCKHANDLE GetDockHandle (UINT n) const;
	//OBJHANDLE GetDockStatus (DOCKHANDLE hDock) const;
	//int    Dock (OBJHANDLE target, UINT n, UINT tgtn, UINT mode) const;
	//bool   Undock (UINT n, const OBJHANDLE exclude = 0) const;

	//// Passive attachment management
	//ATTACHMENTHANDLE CreateAttachment (bool toparent, const VECTOR3 &pos, const VECTOR3 &dir, const VECTOR3 &rot, const char *id, bool loose = false) const;
	//void   SetAttachmentParams (ATTACHMENTHANDLE attachment, const VECTOR3 &pos, const VECTOR3 &dir, const VECTOR3 &rot) const;
	//void   GetAttachmentParams (ATTACHMENTHANDLE attachment, VECTOR3 &pos, VECTOR3 &dir, VECTOR3 &rot) const;
	//const char *GetAttachmentId (ATTACHMENTHANDLE attachment) const;
	//OBJHANDLE GetAttachmentStatus (ATTACHMENTHANDLE attachment) const;
	//DWORD  AttachmentCount (bool toparent) const;
	//DWORD  GetAttachmentIndex (ATTACHMENTHANDLE attachment) const;
	//ATTACHMENTHANDLE GetAttachmentHandle (bool toparent, DWORD i) const;
	//bool   AttachChild (OBJHANDLE child, ATTACHMENTHANDLE attachment, ATTACHMENTHANDLE child_attachment) const;
	//bool   DetachChild (ATTACHMENTHANDLE attachment, double vel = 0.0) const;

	//// beacon light management
	//bool   DelBeacon (BEACONLIGHTSPEC *bs);
	//void   ClearBeacons ();

	//// Super-structure interface
	//bool   GetSuperstructureCG (VECTOR3 &cg) const;

	//// Navigation radio interface
	//bool   SetNavRecv (DWORD n, DWORD ch) const;
	//DWORD  GetNavRecv (DWORD n) const;
	//float  GetNavRecvFreq (DWORD n) const;
	//bool   SetTransponderChannel (DWORD ch) const;
	//bool   SetIDSChannel (DOCKHANDLE hDock, DWORD ch) const;
	//void   EnableIDS (DOCKHANDLE hDock, bool enable) const;
	//NAVHANDLE GetTransponder (void) const;
	//NAVHANDLE GetIDS (DOCKHANDLE hDock) const;
	//NAVHANDLE GetNavSource (DWORD n) const;

	//// Status flags
	//bool   GroundContact (void) const;
	//bool   OrbitStabilised (void) const;
	//bool   NonsphericalGravityEnabled (void) const;
	//UINT   DockingStatus (UINT port) const;

	//// Scenario editor interface
	//bool   GetEditorModule (char *fname) const;
		private:
			VESSEL *vessel;
			Interfaces::LiftCoefficientDelegate^ liftCoefficientDelegate;
			System::Collections::Hashtable^ coefficientDelegatesByAirFoil;
			System::Collections::Hashtable^ coefficientDelegatesByKey;
		};
	}
}