#pragma once
#include <vcclr.h>
#include "orbitersdk.h"

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;
using namespace Orbiter::Interfaces;

namespace Orbiter
{
	namespace Wrapper
	{
		public ref class OAPI
		{
		public:
			static Interfaces::AtmosphereConstants GetPlanetAtmConstants(IntPtr body);
			static double GetInducedDrag (double cl, double aspectRatio, double efficiency);
			static double GetWaveDrag (double mach, double mach1, double mach2, double mach3, double maximumWaveDragCooefficient);
			static bool ReadItem (IntPtr file, String^ name, bool %flag);
			static void ParticleSetLevelReference (IntPtr particleStream, Interfaces::DoublePointer^ reference);
			static IntPtr LoadMeshGlobal (String^ name);
			static IntPtr CreateTextureSurface (int width, int height);
			static IntPtr GetTextureHandle (IntPtr mesh, unsigned int textureIndex);
			static void Blt (IntPtr target, IntPtr source, int targetX, int targetY, int sourceX, int sourceY, int width, int height, unsigned int colorKey);
			static void Blt (IntPtr target, IntPtr source, int targetX, int targetY, int sourceX, int sourceY, int width, int height);
			static property double SimTime {double get(void);};
			static property double SimStep {double get(void);};
			static property double SysTime {double get(void);};
			static property double SysStep {double get(void);};
			static property double SimMJD {double get(void);};
			static property double SysMJD {double get(void);};
			static property double FrameRate {double get(void);};
			static property double TimeAcceleration {double get(void); void set(double);};
			static property bool Pause {bool get(void); void set(bool);};
			static property Interfaces::CockpitMode CockpitMode {Interfaces::CockpitMode get(void);};
		};
	}
}