#pragma once
#include <vcclr.h>
#include "orbitersdk.h"

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;

// Transformation types for animations
namespace Orbiter
{
	namespace Wrapper
	{
		// Transformation base class
		public ref class MeshGroupTransformation:Orbiter::Interfaces::MeshGroupTransformation
		{
		public:
			MeshGroupTransformation ();
			MeshGroupTransformation (int mesh, array<int>^ group);			
			virtual property int Mesh {int get(void); void set(int value);}
			virtual property array<int>^ Group {array<int>^ get(void); void set(array<int>^ value);}
			virtual property IntPtr Native{IntPtr get(void);}
		protected:
			void SetNative(MGROUP_TRANSFORM *value);
		private:
			MGROUP_TRANSFORM *native;
		};

		// Rotation
		public ref class MeshGroupRotation: MeshGroupTransformation, Orbiter::Interfaces::MeshGroupRotation
		{
		public:
			MeshGroupRotation (int mesh, array<int>^ group, Orbiter::Interfaces::Vector3^ reference, Orbiter::Interfaces::Vector3^ axis, float angle);
			virtual property Orbiter::Interfaces::Vector3^ Reference {Orbiter::Interfaces::Vector3^ get(void); void set(Orbiter::Interfaces::Vector3^ value);}
			virtual property Orbiter::Interfaces::Vector3^ Axis {Orbiter::Interfaces::Vector3^ get(void); void set(Orbiter::Interfaces::Vector3^ value);}
			virtual property float Angle {float get(void); void set(float value);}
		};

		// Translation
		public ref class MeshGroupTranslation: MeshGroupTransformation, Orbiter::Interfaces::MeshGroupTranslation
		{
		public:
			MeshGroupTranslation (int mesh, array<int>^ group, Orbiter::Interfaces::Vector3^ shift);
			virtual property Orbiter::Interfaces::Vector3^ Shift{Orbiter::Interfaces::Vector3^ get(void); void set(Orbiter::Interfaces::Vector3^ value);}
		};

		// Scaling
		public ref class MeshGroupScale: MeshGroupTransformation, Orbiter::Interfaces::MeshGroupScale
		{
		public:
			MeshGroupScale (int mesh, array<int>^ group, Orbiter::Interfaces::Vector3^ reference, Orbiter::Interfaces::Vector3^ scale);
			virtual property Orbiter::Interfaces::Vector3^ Reference{Orbiter::Interfaces::Vector3^ get(void); void set(Orbiter::Interfaces::Vector3^ value);}
			virtual property Orbiter::Interfaces::Vector3^ Scale{Orbiter::Interfaces::Vector3^ get(void); void set(Orbiter::Interfaces::Vector3^ value);}
		};
	};
};

