#pragma once
#include <vcclr.h>
#include "orbitersdk.h"

using namespace Orbiter::Interfaces;

//Common module callbacks
DLLCLBK void InitModule (HINSTANCE hDLL);
DLLCLBK void ExitModule (HINSTANCE hDLL);

//Vessel module callbacks
DLLCLBK VESSEL *ovcInit (OBJHANDLE hVessel,int flightmodel);
DLLCLBK void ovcExit (VESSEL *vessel);

//Plugin module callbacks
DLLCLBK void opcOpenRenderViewport (HWND renderWnd,DWORD width,DWORD height,bool fullscreen);
DLLCLBK void opcCloseRenderViewport ();
DLLCLBK void opcPreStep (double SimT,double SimDT,double mjd);
DLLCLBK void opcPostStep (double SimT,double SimDT,double mjd);
DLLCLBK void opcFocusChanged (OBJHANDLE new_focus,OBJHANDLE old_focus);
DLLCLBK void opcTimeAccChanged (double nWarp,double oWarp);
DLLCLBK void opcPause (bool pause);

//Planet module callbacks
DLLCLBK CELBODY *InitInstance (OBJHANDLE hBody);
DLLCLBK void ExitInstance (CELBODY *body);

namespace Orbiter
{
	namespace Launcher
	{
		public ref class Launcher
		{
		public:
			Launcher();
			virtual property Orbiter::Interfaces::VesselModule^ VesselModule{Orbiter::Interfaces::VesselModule^ get(void);}
			virtual property Orbiter::Interfaces::PluginModule^ PluginModule{Orbiter::Interfaces::PluginModule^ get(void);}
			virtual property Orbiter::Interfaces::PlanetModule^ PlanetModule{Orbiter::Interfaces::PlanetModule^ get(void);}
			virtual property Orbiter::Interfaces::Module^ Module{Orbiter::Interfaces::Module^ get(void);}
		private:
			Orbiter::Interfaces::VesselModule^ vesselModule;
			Orbiter::Interfaces::PluginModule^ pluginModule;
			Orbiter::Interfaces::PlanetModule^ planetModule;
			Orbiter::Interfaces::Module^ module;
		};
	}
}