using System;
using System.Collections.Generic;
using System.Text;

namespace Orbiter.Interfaces.Templates
{
    public class BasePluginModule:PluginModule
    {
        #region PluginModule Members

        public virtual void OpenRenderViewport(IntPtr renderWindow, uint width, uint height, bool fullScreen){}
        public virtual void CloseRenderViewport(){}
        public virtual void PreStep(double simt, double simdt, double mjd){}
        public virtual void PostStep(double simt, double simdt, double mjd){}
        public virtual void FocusChanged(IntPtr newFocus, IntPtr oldFocus){}
        public virtual void TimeAccelerationChanged(double newWarp, double oldWarp){}
        public virtual void Pause(bool pause){}

        #endregion

        #region Module Members

        public virtual void InitModule(IntPtr nativeDLL){}
        public virtual void ExitModule(IntPtr nativeDLL){}

        #endregion
    }
}
