using System;

namespace Orbiter.Interfaces
{
    public interface PluginModule : Module
    {
        void OpenRenderViewport(IntPtr renderWindow, uint width, uint height, bool fullScreen);
        void CloseRenderViewport();
        void PreStep(double simt, double simdt, double mjd);
        void PostStep(double simt, double simdt, double mjd);
        void FocusChanged(IntPtr newFocus, IntPtr oldFocus);
        void TimeAccelerationChanged(double newWarp, double oldWarp);
        void Pause(bool pause);
    }
}