using System;

namespace Orbiter.Interfaces
{
    public class Constants
    {
        public const double PI05 = 1.57079632679490;
        public const double Radiant = Math.PI / 180.0;
        public const double DEG = 180.0 / Math.PI;
        public const double C0 = 299792458.0;   // speed of light in vacuum [m/s]
        public const double TAUA = 499.004783806; // light time for 1 AU [s]
        public const double AU = C0 * TAUA;       // astronomical unit (mean geocentric distance of the sun) [m]
        public const double GGRAV = 6.67259e-11;   // gravitational constant [m^3 kg^-1 s^-2]
        public const double G = 9.81;          // gravitational acceleration [m/s^2] at Earth mean radius
        public const double ATMP = 101.4e3;       // atmospheric pressure [Pa] at Earth sea level
        public const double ATMD = 1.293;         // atmospheric density [kg/m^3] at Earth sea level
        public const int AIRCTRL_AXIS_AUTO = 0;
        public const int AIRCTRL_AXIS_YPOS = 1;
        public const int AIRCTRL_AXIS_YNEG = 2;
        public const int AIRCTRL_AXIS_XPOS = 3;
        public const int AIRCTRL_AXIS_XNEG = 4;
        public const uint BEACONSHAPE_COMPACT = 0;
        public const uint BEACONSHAPE_DIFFUSE = 1;
        public const uint BEACONSHAPE_STAR = 2;
        public const int MESHVIS_NEVER = 0x00;
        public const int MESHVIS_EXTERNAL = 0x01;
        public const int MESHVIS_COCKPIT = 0x02;
        public const int MESHVIS_ALWAYS = (MESHVIS_EXTERNAL|MESHVIS_COCKPIT);
        public const int MESHVIS_VC = 0x04;
        public const int MESHVIS_EXTPASS = 0x10;
    }
}
