/*

Copyright (c) 2003-2004, AXE, Inc.  All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef _OPVP_NULL_H_
#define _OPVP_NULL_H_

/* private function prototyoes */
static
int	GetUnique(
	void
	);
static
int	SetApiList(
	void
	);
static
int	Output(
	char		*format,
	char		**variable
	);

/* API functions */
static
int	ClosePrinter(
	int		printerContext
	);
static
int	StartJob(
	int		printerContext,
	char		*jobInfo
	);
static
int	EndJob(
	int		printerContext
	);
static
int	StartDoc(
	int		printerContext,
	char		*docInfo
	);
static
int	EndDoc(
	int		printerContext
	);
static
int	StartPage(
	int		printerContext,
	char		*pageInfo
	);
static
int	EndPage(
	int		printerContext
	);
#if (_PDAPI_VERSION_MAJOR_ > 0 || _PDAPI_VERSION_MINOR_ >= 2)
static
int     QueryDeviceCapability(
	int		printerContext,
	int		queryflag,
	int		buflen,
	char		*infoBuf
	);
static
int     QueryDeviceInfo(
	int		printerContext,
	int		queryflag,
	int		buflen,
	char		*infoBuf
	);
#endif
static
int	ResetCTM(
	int		printerContext
	);
static
int	SetCTM(
	int		printerContext,
	OPVP_CTM	*pCTM
	);
static
int	GetCTM(
	int		printerContext,
	OPVP_CTM	*pCTM
	);
static
int	InitGS(
	int		printerContext
	);
static
int	SaveGS(
	int		printerContext
	);
static
int	RestoreGS(
	int		printerContext
	);
static
int	QueryColorSpace(
	int		printerContext,
	OPVP_ColorSpace	*pcspace,
	int		*pnum
	);
static
int	SetColorSpace(
	int		printerContext,
	OPVP_ColorSpace	cspace
	);
static
int	GetColorSpace(
	int		printerContext,
	OPVP_ColorSpace	*pcspace
	);
static
int	QueryROP(
	int		printerContext,
	int		*pnum,
	int		*prop
	);
static
int	SetROP(
	int		printerContext,
	int		rop
	);
static
int	GetROP(
	int		printerContext,
	int		*prop
	);
static
int	SetFillMode(
	int		printerContext,
	OPVP_FillMode	fillmode
	);
static
int	GetFillMode(
	int		printerContext,
	OPVP_FillMode	*pfillmode
	);
static
int	SetAlphaConstant(
	int		printerContext,
	float		alpha
	);
static
int	GetAlphaConstant(
	int		printerContext,
	float		*palpha
	);
static
int	SetLineWidth(
	int		printerContext,
	OPVP_Fix	width
	);
static
int	GetLineWidth(
	int		printerContext,
	OPVP_Fix	*pwidth
	);
static
int	SetLineDash(
	int		printerContext,
	OPVP_Fix	pdash[],
	int		num
	);
static
int	GetLineDash(
	int		printerContext,
	OPVP_Fix	pdash[],
	int		*pnum
	);
static
int	SetLineDashOffset(
	int		printerContext,
	OPVP_Fix	offset
	);
static
int	GetLineDashOffset(
	int		printerContext,
	OPVP_Fix	*poffset
	);
static
int	SetLineStyle(
	int		printerContext,
	OPVP_LineStyle	linestyle
	);
static
int	GetLineStyle(
	int		printerContext,
	OPVP_LineStyle	*plinestyle
	);
static
int	SetLineCap(
	int		printerContext,
	OPVP_LineCap	linecap
	);
static
int	GetLineCap(
	int		printerContext,
	OPVP_LineCap	*plinecap
	);
static
int	SetLineJoin(
	int		printerContext,
	OPVP_LineJoin	linejoin
	);
static
int	GetLineJoin(
	int		printerContext,
	OPVP_LineJoin	*plinejoin
	);
static
int	SetMiterLimit(
	int		printerContext,
	OPVP_Fix	miterlimit
	);
static
int	GetMiterLimit(
	int		printerContext,
	OPVP_Fix	*pmiterlimit
	);
static
int	SetPaintMode(
	int		printerContext,
	OPVP_PaintMode	paintmode
	);
static
int	GetPaintMode(
	int		printerContext,
	OPVP_PaintMode	*ppaintmode
	);
static
int	SetStrokeColor(
	int		printerContext,
	OPVP_Brush	*brush
	);
static
int	SetFillColor(
	int		printerContext,
	OPVP_Brush	*brush
	);
static
int	SetBgColor(
	int		printerContext,
	OPVP_Brush	*brush
	);
static
int	NewPath(
	int		printerContext
	);
static
int	EndPath(
	int		printerContext
	);
static
int	StrokePath(
	int		printerContext
	);
static
int	FillPath(
	int		printerContext
	);
static
int	StrokeFillPath(
	int		printerContext
	);
static
int	SetClipPath(
	int		printerContext,
	OPVP_ClipRule	clipRule
	);
#if (_PDAPI_VERSION_MAJOR_ > 0 || _PDAPI_VERSION_MINOR_ >= 2)
static
int     ResetClipPath(
	int             printerContext
	);
#endif
static
int	SetCurrentPoint(
	int		printerContext,
	OPVP_Fix	x,
	OPVP_Fix	y
	);
static
int	LinePath(
	int		printerContext,
	int		flag,
	int		npoints,
	OPVP_Point	*points
	);
static
int	PolygonPath(
	int		printerContext,
	int		npolygons,
	int		*nvertexes,
	OPVP_Point	*points
	);
static
int	RectanglePath(
	int		printerContext,
	int		nrectangles,
	OPVP_Rectangle	*reclangles
	);
static
int	RoundRectanglePath(
	int		printerContext,
	int		nrectangles,
	OPVP_RoundRectangle	*reclangles
	);
static
int	BezierPath(
	int		printerContext,
#if (_PDAPI_VERSION_MAJOR_ == 0 && _PDAPI_VERSION_MINOR_ < 2)
	int             *npoints,
#else
	int             npoints,
#endif
	OPVP_Point	*points
	);
static
int	ArcPath(
	int		printerContext,
	int		kind,
	int		dir,
	OPVP_Fix	bbx0,
	OPVP_Fix	bby0,
	OPVP_Fix	bbx1,
	OPVP_Fix	bby1,
	OPVP_Fix	x0,
	OPVP_Fix	y0,
	OPVP_Fix	x1,
	OPVP_Fix	y1
	);
static
int	DrawBitmapText(
	int		printerContext,
	int		width,
	int		height,
	int		pitch,
	void		*fontdata
	);
static
int	DrawImage(
	int		printerContext,
	int		sourceWidth,
	int		sourceHeight,
	int		colorDepth,
	OPVP_ImageFormat	imageFormat,
	OPVP_Rectangle	destinationSize,
	int		count,
	void		*imagedata
	);
static
int	StartDrawImage(
	int		printerContext,
	int		sourceWidth,
	int		sourceHeight,
	int		colorDepth,
	OPVP_ImageFormat	imageFormat,
	OPVP_Rectangle	destinationSize
	);
static
int	TransferDrawImage(
	int		printerContext,
	int		count,
	void		*imagedata
	);
static
int	EndDrawImage(
	int		printerContext
	);
static
int	StartScanline(
	int		printerContext,
	int		yposition
	);
static
int	Scanline(
	int		printerContext,
	int		nscanpairs,
	int		*scanpairs
	);
static
int	EndScanline(
	int		printerContext
	);
static
int	StartRaster(
	int		printerContext,
	int		rasterWidth
	);
static
int	TransferRasterData(
	int		printerContext,
	int		count,
	unsigned char	*data
	);
static
int	SkipRaster(
	int		printerContext,
	int		count
	);
static
int	EndRaster(
	int		printerContext
	);
static
int	StartStream(
	int		printerContext
	);
static
int	TransferStreamData(
	int		printerContext,
	int		count,
	void		*data
	);
static
int	EndStream(
	int		printerContext
	);

#endif	/* _OPVP_NULL_H_ */
