﻿// OpenTween - Client of Twitter
// Copyright (c) 2015 kim_upsilon (@kim_upsilon) <https://upsilo.net/~upsilon/>
// All rights reserved.
//
// This file is part of OpenTween.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program. If not, see <http://www.gnu.org/licenses/>, or write to
// the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
// Boston, MA 02110-1301, USA.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Xunit;

namespace OpenTween
{
    public class MouseWheelMessageFilterTest
    {
        [Fact(Skip = "Monoの不具合修正反映待ち")]
        public void ParseMessage_MinusTest()
        {
            const int WM_MOUSEWHEEL = 0x020A;

            var message = new Message
            {
                Msg = WM_MOUSEWHEEL,
                LParam = (IntPtr)0xffffffffff29ff22,
                WParam = (IntPtr)0xffffffffff880000,
            };
            var ret = MouseWheelMessageFilter.ParseMessage(message);

            Assert.Equal(-222, ret.ScreenLocation.X); // (short)0xff29
            Assert.Equal(-215, ret.ScreenLocation.Y); // (short)0xff22
            Assert.Equal(-120, ret.WheelDelta); // (short)0xff88
        }
    }
}
