//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	Duration
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.text.DecimalFormat;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;

/**
 *	DurationNX<BR>
 * 	ԏ𐶐擾NX<BR>
 */
public class Duration {

	/** ~b */
	private long msec;

	/**
	 * RXgN^
	 *
	 * 	@param
	 *		duration	Ԃ\
	 *					FPxxYxxMxxDTxxHxxMxx.xS
	 *							P`:N
	 *								xxY:NAxxM:AxxD:
	 *							T`F
	 *								xxH:ԁAxxM:Axx.xS:b
	 *							xx:Cӂ̐
	 */
	public Duration(String duration) throws SystemException {

		try {

			this.msec = parse(duration);

		}
		catch (Exception e) {
			throw new SystemException("Duration[Duration(String duration)]: '" + duration + "' Duration܂B");
		}
	}

	/**
	 *	RXgN^<BR>
	 *
	 *   @param	msec	(~bP)
	 *
	 */
	public Duration(long msec) {
		this.msec = msec;
	}

	/**
	 *	RXgN^<BR>
	 *
	 * @param	duration	
	 *
	 */
	public Duration(Duration duration) {
		this.msec = duration.msec;
	}

	/**
	 * msec̎Ԃǉ
	 *
	 *	@param
	 *		msec	ǉ鎞(~b)
	 */
	public Duration add(long msec) {
		return new Duration(this.msec + msec);
	}

	/**
	 * duration̊Ԃǉ
	 *
	 *	@param
	 *		duration	ǉ
	 */
	public Duration add(Duration duration) {
		return new Duration(this.msec + duration.msec);
	}

	/**
	 *	String^msecϊĉZ
	 *
	 * 	@param msec Zmsec
	 */
	public Duration add(String msec) {
		return new Duration(this.msec + Long.parseLong(msec));
	}

	/**
	* Ԃ擾
	*
	* 	@return long ~b擾
	*/
	public long getMsec() {
		return msec;
	}

	/**
	 * ݂̊ԂƔCӂ̊ԂƂׂ̒
	 *	@param
	 *		val		r
	 *	@return
	 *		 1		݂̊Ԃ̕Cӂ̊Ԃ蒷
	 *		 0		݂̊ԂƔCӂ̊Ԃ
	 *		-1		݂̊Ԃ̕Cӂ̊ԂZ
	 */
	public int compareTo(Duration val) {

		long compareDuration = val.getMsec();

		if (this.msec > compareDuration) {
			return 1;
		}
		else if (this.msec == compareDuration) {
			return 0;
		}
		else {
			return -1;
		}
	}

	/** "999"փtH[}bgׂDecimalFormat */
	private static DecimalFormat _999Formatter = new DecimalFormat("000");

	/**
	 *  ԂbPʂɕϊ
	 *
	 *	@return	ԂbPʂɕϊ
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();

		sb.append("PT");
		sb.append(Long.toString(msec / 1000));
		sb.append(".");
		sb.append(_999Formatter.format(msec % 1000));
		sb.append("S");

		return sb.toString();
	}

	/**
	 * tH[}bg̕ϊ<BR>
	 * duration 񂩂tH[}bg𒲂ׂ<BR>
	 * tH[}bg`ȉ̕@ŏꍇ<BR>
	 * E̐擪 'P'               EEE PxxYxxMxxDTxxHxxMxx.xS<BR>
	 * EȊȌꍇ                         EEE HHHH:MM:SS.SS<BR>
	 * @param duration duration<BR>
	 * @return duratioñ~b\<BR>
	 */
	private long parse(String duration) throws Exception {

		//vZ
		String p_dur = "";
		String t_dur = "";
		String str_year = "";
		String str_month = "";
		String str_day = "";
		String str_hour = "";
		String str_min = "";
		String str_sec = "";
		String buf = "";
		int t_dur_st = duration.indexOf("T");
		long year = 0L;
		long month = 0L;
		long day = 0L;
		long hour = 0L;
		long min = 0L;
		double sec = 0.0;
		long msec;

		// durationNƎԂɕ
		if (t_dur_st != -1) {
			p_dur = duration.substring(0, t_dur_st);
			t_dur = duration.substring(t_dur_st);
		}
		else {
			p_dur = duration.substring(0);
		}

		// N擾
		if (!p_dur.equals("")) {
			buf = p_dur.substring(1);
			if (buf.indexOf("Y") != -1) {
				str_year = buf.substring(0, buf.indexOf("Y"));
				year = Long.parseLong(str_year);
				year = year * 365L * 24L;
				year = year * 60L * 60L;
				year = year * 1000L;
				buf = buf.substring(buf.indexOf("Y") + 1);
			}
			if (buf.indexOf("M") != -1) {
				str_month = buf.substring(0, buf.indexOf("M"));
				month = Long.parseLong(str_month);
				month = month * 31L * 24L;
				month = month * 60L * 60L;
				month = month * 1000L;
				buf = buf.substring(buf.indexOf("M") + 1);
			}
			if (buf.indexOf("D") != -1) {
				str_day = buf.substring(0, buf.indexOf("D"));
				day = Long.parseLong(str_day);
				day = day * 24L;
				day = day * 60L * 60L;
				day = day * 1000L;
			}
		}
		// ԁAAb擾
		if (!t_dur.equals("")) {
			buf = t_dur.substring(1);
			if (buf.indexOf("H") != -1) {
				str_hour = buf.substring(0, buf.indexOf("H"));
				hour = Long.parseLong(str_hour);
				hour = hour * 60L * 60L;
				hour = hour * 1000L;
				buf = buf.substring(buf.indexOf("H") + 1);
			}
			if (buf.indexOf("M") != -1) {
				str_min = buf.substring(0, buf.indexOf("M")); // 擾
				min = Long.parseLong(str_min);
				min = min * 60L * 1000L;
				buf = buf.substring(buf.indexOf("M") + 1);
			}
			if (buf.indexOf("S") != -1) {
				str_sec = buf.substring(0, buf.indexOf("S"));
				sec = Double.parseDouble(str_sec);
				sec = sec * 1000L;
			}
		}

		msec = (long) (year + month + day + hour + min + sec);

		return msec;
	}
}
