/*
 * gтrbnqlGg
 * 
 * 쐬: 2006/10/23
 *
 * ύX
 *   [U[G[WFg@\ǉ ntc-hagiwara '07/06/08
 *
 */
package jp.co.ntt.lms.imode.xms.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.imode.common.MobConst;
import jp.co.ntt.lms.imode.common.MobileUtl;
import jp.co.ntt.lms.imode.extension.PageSequence;
import jp.co.ntt.lms.imode.lo.scorm.engine.MobSCORMBean;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsRequest;
import jp.co.ntt.lms.xms.framework.XmsSystemException;
import jp.co.ntt.lms.xms.framework.XmsWarningException;

//[U[G[WFg@\
import jp.co.ntt.lms.imode.common.UserAgentCheck;

/**
 * gтrbnqlGg
 * 
 * @author ntc-sakai
 *
 */
public class MobSCORMEntry extends HttpServlet {
	/**
	 * GET`NGXg\bhB<br>
	 * 
	 * @param request HTTPNGXgB
	 * @param response HTTPX|XB
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		this.doRequest(request, response);
	}

	/**
	 * POST`NGXg\bhB
	 * 
	 * @param request HTTPNGXgB
	 * @param response HTTPX|XB
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		this.doRequest(request, response);
	}

	/**
	 * NGXg\bhB<br>
	 * GET/POSTʂŌĂяoB<br>
	 * <ol>
	 * <li>y[WSEQ`FbNsȂ܂B</li>
	 * <li>y[WSEQ`FbNʂ̏ꍇA<br>
	 * <ul>
	 * <li>㏈XNvgsȂ܂B</li>
	 * <li>OXNvgsȂ܂B</li>
	 * </ul>
	 * <li>y[WSEQ`FbNʂG[̏ꍇA<br>
	 * <ul>
	 * <li>G[ʂ\܂B</li>
	 * </ul>
	 * </li>
	 * </ol>
	 * 
	 * @param request  HTTPNGXg
	 * @param response HTTPX|X
	 */
	protected void doRequest(HttpServletRequest request,
			HttpServletResponse response) {
		XmsRequest xmsRequest = null;

		response.setContentType("text/html; charset=shift_jis");
		//20070707 ADD Start ntc higuchi LbV𖳌ɂ鏈ǉ
		response.setHeader("Expires", "Sat, 01 Jan 2005 01:00:00 GMT");
		response.setHeader("Pragma", "no-cache");
		response.setHeader("Cache-Control", "no-cache");
		//20070707 ADD End

		try {
			request.setCharacterEncoding("shift_jis");
		} catch (UnsupportedEncodingException e1) {
		}
		try {
			
			// NGXgEX|XIuWFNg̐
			xmsRequest = new XmsRequest(request, response);

			// ̓p[^̕łrdp擾
			String inPageSeq = xmsRequest.getParameter("page_seq");
			
			// łrdpL`FbN
			if (MobileUtl.isEmpty(inPageSeq)) {
				throw new XmsSystemException(
						"parameter not found Error(page_seq)");
			}

			// ZbVJgSEQ擾
			HttpSession session = xmsRequest.getRequest().getSession();
			PageSequence pageSeq = (PageSequence) session.getAttribute(MobConst.S_PAGE_SEQ);

			if (pageSeq == null) {
				// ZbV^CAEgG[
				throw new XmsWarningException("SessionTimeout");
			}

			// łrdp`FbN
			if (!pageSeq.isCheck(inPageSeq)) {
				// SEQG[́AG[ʕ\֑J
				throw new XmsWarningException("PageSequenceError");
			}

			// łrdpǗԍ{P
			pageSeq.next();

			// ZbVgтrbnqlaNX擾
			MobSCORMBean scormBean = (MobSCORMBean) session.getAttribute(MobConst.S_SCORM_BEAN);
			
			if (scormBean == null) {
				// ZbV^CAEgG[
				throw new XmsWarningException("SessionTimeout");
			}

			// HttpServletRequestݒ
			scormBean.setReq(request);

			// OXNvgtqkNA
			scormBean.setDispUrl("");

			// ㏈XNvgtqk擾
			String postUrl = scormBean.getPostUrlPath();

			// ㏈XNvgtqkݒH
			if (postUrl == null || postUrl.equals("")) {
				// ̓p[^̌㏈XNvg擾
				postUrl = xmsRequest.getParameter("post_url");
				// ㏈XNvgtqkt@Cݒ
				scormBean.setPostUrl(postUrl);
				// ㏈XNvgtqkiPatht)擾
				postUrl =  scormBean.getPostUrlPath();

				// ̓p[^㏈XNvgݒH
				if (postUrl == null || postUrl.equals("")) {
					// ftHg㏈XNvgtqkݒ
					postUrl = MobConst.C_DEFAULT_POSTURL;
					// ㏈XNvgtqkt@Cݒ
					scormBean.setPostUrl(postUrl);
				}
			}
			// ㏈XNvgt@CL
			if (!scormBean.isPostUrl()) {
				// ㏈XNvgt@C݂Ȃ
				DebugLog.write(getClass(), "[MobSCORMEntry] PostUrl not found(" + postUrl + ")", DebugLog.HIGHT);
				throw new XmsSystemException("PostUrl not found error");
			}
			// ㏈XNvgCN[hs
			PostUrlInclude(xmsRequest, postUrl);

			// ㏈XNvgtqkNA
			scormBean.setPostUrl("");

			// wKԏIH
			if (scormBean.isEndlearn()) {
				// ㏈XNvgŊwKI͒f̃irQ[Vv
				// sȂꂽꍇA߂tqkփ_CNgB
				endlearn(xmsRequest);
			} else {
				// ㏈XNvgŃirQ[VvꍇAirQ[VԂCjVCY
				scormBean.NaviInitialize();
				// wKIȊȌꍇAOXNvgtqkփtH[hB
				// OXNvgtqk擾
				String dispUrl = scormBean.getDispUrlPath();
				if (dispUrl == null || dispUrl.equals("")) {
					// ㏈XNvgŃG[
					DebugLog.write(getClass(), "Postprocess Error PostUrl = [" + postUrl + "]", DebugLog.HIGHT);
				} else {
					// ㏈XNvgI
					if (!scormBean.isDispUrl()) {
						// OXNvgt@C݂Ȃ
						DebugLog.write(getClass(), "[MobSCORMEntry] DispUrl not found(" + dispUrl + ")", DebugLog.HIGHT);
						throw new XmsSystemException("PostUrl not found error");
					}
					String forwardUrl = dispUrl;
					// tH[htqkgq
					if (dispUrl.toLowerCase().endsWith(".htm") ||
						dispUrl.toLowerCase().endsWith(".html")) {
						// t@C̏ꍇAgslkʕ\փtH[hB
						// ForWardUrlɂgslkʕ\Urlݒ
						dispUrl = MobConst.C_COM_HTML_PATH;
						// OXNvgt@Cݒ
						xmsRequest.getRequest().setAttribute("MOBILE.DISP.URL", forwardUrl);
					}

					// tH[h
					forward(xmsRequest, dispUrl);
				}

			}
		} catch (XmsSystemException e) {
			// VXeG[ʂ
			terminateWithSystemException(xmsRequest, e);
		} catch (XmsWarningException e) {
			// [jOG[ʂ
			terminateWithWarningException(xmsRequest, e);
		} catch (Exception e) {
			// ̑G[ʂ
			terminateWithThrowable(xmsRequest, e);
		}

		
	}

	/**
	 * ㏈XNvgCN[h
	 * 
	 * @param xmsRequest
	 * @param postUrl
	 * @throws XmsSystemException
	 */
	private void PostUrlInclude(XmsRequest xmsRequest, String postUrl)
		throws XmsSystemException {
		RequestDispatcher dispatcher = null;
		HttpServletRequest request = null;
		HttpServletResponse response = null;

		try {
			request = xmsRequest.getRequest();
			response = xmsRequest.getResponse();
			dispatcher = request.getRequestDispatcher(postUrl);
			dispatcher.include(request, response);
		} catch (Exception e) {
			// ㏈XNvgincludeG[
			DebugLog.write(getClass(),"[PostUrlInclude] RequestDispatcher(include) error postUrl = [" + postUrl + "]", DebugLog.HIGHT);
			throw new XmsSystemException(e);
		}

	}

	/**
	 * wKIB<br>
	 * <br>
	 * [U[G[WFg菈<br>
	 * wKȊJڐ肵܂B<br>
	 * <ol>
	 * <li>[U[G[WFggт̏ꍇA<br>
	 * <ul>
	 * <li>߂URLփ_CNg܂B</li>
	 * </ul>
	 * <li>[U[G[WFggшȊȌꍇA<br>
	 * <ul>
	 * <li>EChE܂B</li>
	 * </ul>
	 * </li>
	 * </ol>
	 * 
	 * @param xmsRequest NGXg
	 * @throws XmsSystemException
	 * @throws XmsWarningException
	 */
	private void endlearn(XmsRequest xmsRequest)
		throws XmsSystemException, XmsWarningException {
		// ZbV߂URL擾
		HttpSession session = xmsRequest.getRequest().getSession();
		String returnURL = (String) session.getAttribute(MobConst.S_RETURN_URL);

		HttpServletRequest request = xmsRequest.getRequest();
		UserAgentCheck userCarrier = new UserAgentCheck(request);
				
		// [U[G[WFg 
		if (userCarrier.getMobileCarrier() == UserAgentCheck.PC) {
			// PC windowclose
			returnURL = MobConst.C_WINDOWCLOSE_URI;
		} else {
			// NULL
			if (returnURL == null || returnURL.equals("")) {
				// TimeOut G[
				DebugLog.write(getClass(),"[endlearn] session is null "
						+ "MOBILE.RETURN_URL" , DebugLog.HIGHT);
				throw new XmsWarningException("SessionTimeout");
			}
		}

		// ZbV폜
		session.removeAttribute(MobConst.S_PAGE_SEQ);
		session.removeAttribute(MobConst.S_RETURN_URL);
		session.removeAttribute(MobConst.S_SCORM_BEAN);

		// X|X擾
		HttpServletResponse response = xmsRequest.getResponse();
		try {
			// ߂tqkփ_CNg
			response.sendRedirect(returnURL);
			
		} catch (IOException e) {
			// knfo
			DebugLog.write(getClass(), "[endlearn]sendRedirect Error returnURL = "
					+ returnURL, DebugLog.HIGHT);
			throw new XmsSystemException("sendRedirect error");
		}

	}

	/**
	 * xG[ʂ\܂B
	 * 
	 * @param xmsRequest NGXg
	 * @param exception xO
	 */
	private void terminateWithWarningException(XmsRequest xmsRequest,
			XmsWarningException exception) {
		try {
			String uri = null;

			if (exception.getKey() != null &&
				exception.getKey().equals("SessionTimeout")) {
				// TimeoutG[
				uri = MobConst.C_TIMEOUT_URI;
			} else if (exception.getKey() != null &&
						exception.getKey().equals("PageSequenceError")) {
				// SEQG[
				uri = MobConst.C_SEQERR_URI;
			} else {
				// ̑xG[
				uri = MobConst.C_WARN_ERR_URI;
			}

			forward(xmsRequest, uri);
		} catch (XmsException e) {
			terminateWithThrowable(xmsRequest, exception);
		}

	}

	/**
	 * VXeG[ʂ\܂B
	 * 
	 * @param xmsRequest NGXg
	 * @param exception VXeO
	 */
	private void terminateWithSystemException(XmsRequest xmsRequest,
			XmsSystemException exception) {
		try {
			DebugLog.write(getClass(), exception, DebugLog.HIGHT);
			forward(xmsRequest, MobConst.C_SYS_ERR_URI);
		} catch (XmsException e) {
			terminateWithThrowable(xmsRequest, exception);
		}

	}

	/**
	 * ̑G[ʂ\܂B
	 * 
	 * @param xmsRequest NGXg
	 * @param th Throwable ̑O
	 */
	private void terminateWithThrowable(XmsRequest xmsRequest, Throwable th) {
		try {
			forward(xmsRequest, MobConst.C_THROW_ERR_URI);
		} catch (XmsException e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
		}

	}

	/**
	 * ړURLփtH[h܂B
	 * 
	 * @param xmsRequest NGXg
	 * @param uri ړURL
	 * @throws XmsException
	 */
	private void forward(XmsRequest xmsRequest, String uri)
		throws XmsException {
		// HTTP NGXg
		HttpServletRequest request = null;
		// HTTPX|X
		HttpServletResponse response = null;
		RequestDispatcher dispatcher = null;

		try {
			request = xmsRequest.getRequest();
			response = xmsRequest.getResponse();
			dispatcher = request.getRequestDispatcher(uri);
			dispatcher.forward(request, response);
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

}
