/*
 * 쐬: 2006/10/23
 *
 * gїprbnqlaNX
 * 
 */
package jp.co.ntt.lms.imode.lo.scorm.engine;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.imode.common.MobConst;
import jp.co.ntt.lms.imode.extension.CmiParameters;
import jp.co.ntt.lms.imode.extension.HacpDataParameters;
import jp.co.ntt.lms.imode.extension.RunTimeFormat;
import jp.co.ntt.lms.lo.scorm.engine.SCORMAPIAdapter;
import jp.co.ntt.lms.lo.scorm.util.SG;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xms.framework.XmsException;

/**
 * rbnql`oh񋟂NXłB
 *
 * @author ntc-sakai
 * 
 */
public class MobSCORMBean implements Serializable {

	/** HttpServletRequest */
	private HttpServletRequest req;

	/** OXNvgtqk */
	private String dispUrl;

	/** ㏈XNvgtqk */
	private String postUrl;

	/** wKI */
	private boolean endlearn;

	/** API Xe[^X */
	private String api_status;
	
	/** `ohG[R[h */
	private String api_errcode;

	/** ŌSetValue("adl.nav.request", R}h)R}h  */
	private String lastNavRequest;

	/** SCORM2004RTEpAICC_SID */
	private String aiccSid;

	/** irQ[gstO true:s false:s */
	private boolean navExeFlg;

	/** `ohXe[^X */
	private static final String STS_NOT_INI = "NotInitialize";
	private static final String STS_RUN     = "Running";
	private static final String STS_TERM    = "Terminated";

	private static final String GET_LMS_COMMENT = "command=GetLmsComments&version=S1.3&aicc_data=";

	/** CMIp[^ */
	private CmiParameters cmiParameters = null;

	/** JSPforwardppX */
	private String forwardPath;

	/** HTMLޓ͗ppX */
	private String filePath;

	/**
	 * RXgNg
	 * 
	 * @param manifestID }jtFXghc
	 */
	public MobSCORMBean(String manifestID) {
		endlearn = false;
		navExeFlg = false;
		api_status = STS_NOT_INI;
		api_errcode = "0";
		lastNavRequest = "_none_";
		// wKJnptqkݒ
		this.postUrl = MobConst.C_START_POSTURL;
		makeContentsPath(manifestID);
		
	}

	/**
	 * forwardp̃pXƃt@CpX쐬܂B
	 * @param manifestID }jtFXghc
	 */
	private void makeContentsPath(String manifestID)  {

		StringBuffer sbForward = new StringBuffer();

		// ForwardppXݒ
		try {
			sbForward.append(SG.get("ForwardPath"));
		} catch (Exception e) {
			// <ForwardPath>ݒ肳ĂȂꍇAftHglgp
			DebugLog.write(getClass(),
					"SCORMSG <ForwardPath> Not Found Error", DebugLog.HIGHT);
			sbForward.append("contents");
		}
		sbForward.append("/");
		sbForward.append(manifestID);
		sbForward.append("/");
		forwardPath =  sbForward.toString();

		// t@CpXݒ
		StringBuffer htmlPath = new StringBuffer();
		try {
			htmlPath.append(SG.get("ContentsBaseURL"));
		} catch (Exception e) {
			DebugLog.write(getClass(),
					"SCORMSG <ContentsBaseURL> Not Found Error", DebugLog.HIGHT);
			htmlPath.append(File.separator);
			htmlPath.append("usr");
			htmlPath.append(File.separator);
			htmlPath.append("local");
			htmlPath.append(File.separator);
			htmlPath.append("sce");
			htmlPath.append(File.separator);
			htmlPath.append("contents");
		}

		htmlPath.append(File.separator);
		htmlPath.append(manifestID);
		htmlPath.append(File.separator);
		filePath = htmlPath.toString();
	}

	/**
	 * HttpServletRequest߂܂B
	 * @return req HttpNGXg
	 */
	public HttpServletRequest getReq() {
		return req;
	}

	/**
	 * HttpServletRequestݒ肵܂B
	 * @param req HttpNGXg
	 */
	public void setReq(HttpServletRequest req) {
		this.req = req;
	}

	/**
	 * Otqkt@CL`FbNʂ߂܂B
	 * 
	 * @return t@CLꍇtrue t@Cꍇfalse
	 */
	public boolean isDispUrl() {
		// OXNvgtqkݒ肳Ėꍇ
		if (dispUrl == null || dispUrl.equals("")) {
			// t@C߂
			return false;
		}

		// OXNvgt@CL`FbN
		File dispFile = new File(filePath + dispUrl);
		return dispFile.exists();
	}

	/**
	 * ㏈tqkt@CL`FbNʂ߂܂B
	 * 
	 * @return t@CLꍇtrue t@Cꍇfalse
	 */
	public boolean isPostUrl() {
		// ㏈XNvgtqkݒ肳Ėꍇ
		if (postUrl == null || postUrl.equals("")) {
			// t@C߂
			return false;
		}
		// wKJn㏈XNvg̓ftHg㏈XNvg
		if (postUrl.equals(MobConst.C_DEFAULT_POSTURL) ||
			postUrl.equals(MobConst.C_START_POSTURL)) {
			return true;
		}

		StringBuffer postPath = new StringBuffer();
		// ރt@CpXݒ
		postPath.append(filePath);
		// ㏈XNvgtqkt@Cݒ
		postPath.append(postUrl);
		// ㏈XNvgt@CL`FbN
		File dispFile = new File(postPath.toString());
		return dispFile.exists();
	}

	/**
	 * pX{OXNvgtqk߂܂B<br>
	 * htmlt@C̏ꍇAt@CpXt܂B<br>
	 * LȊȌꍇAforwardpXt܂B
	 * 
	 * @return dispUrl pX{OuXNvgtqk
	 */
	public String getDispUrlPath() {
		// pXtOXNvgtqk
		StringBuffer sb = new StringBuffer();

		// OXNvgtqk
		if (dispUrl != null && !dispUrl.equals("")) {
			// OXNvgtqk̊gq
			if (dispUrl.toLowerCase().endsWith(".htm") ||
				dispUrl.toLowerCase().endsWith(".html")) {
				// t@C̏ꍇAt@CpXt
				sb.append(filePath);
			} else {
				// t@CȊȌꍇAtH[hppXt
				sb.append(forwardPath);
			}
			sb.append(dispUrl);
		}

		return sb.toString();
	}

	/**
	 * OXNvgtqk߂܂B
	 * 
	 * @return dispUrl OuXNvgtqk
	 */
	public String getDispUrl() {
		return dispUrl;
	}

	/**
	 * OXNvgtqkݒ肵܂B
	 * @param dispUrl@OXNvgtqk
	 */
	public void setDispUrl(String dispUrl) {
		// OXNvgtqkݒ
		this.dispUrl = dispUrl;
	}

	/**
	 * forwardpX{㏈XNvgtqk߂܂B
	 * 
	 * @return postUrl forwardpX{㏈XNvgtqk
	 */
	public String getPostUrlPath() {
		// pXt㏈XNvgtqk
		StringBuffer sb = new StringBuffer();
		
		// JnpAftHg㏈XNvgȊȌꍇforwardPatht
		if (postUrl != null && !postUrl.equals("")) {
			if (!postUrl.equals(MobConst.C_DEFAULT_POSTURL) &&
			    !postUrl.equals(MobConst.C_START_POSTURL)) {
				// forwardPathݒ
				sb.append(forwardPath);
			}
			// ㏈XNvgt@Cݒ
			sb.append(postUrl);
		}

		return sb.toString();
	}

	/**
	 * ㏈XNvgtqk߂܂B
	 * @return postUrl ㏈XNvgtqk
	 */
	public String getPostUrl() {
		return postUrl;
	}

	/**
	 * ㏈XNvgtqkݒ肵܂B
	 * 
	 * @param postUrl ㏈XNvgtqk 
	 */
	public void setPostUrl(String postUrl) {
		this.postUrl = postUrl;
	}

	/**
	 * wKIԂ߂܂B
	 * @return endlean wKȈꍇtrue wK̏ꍇfalse
	 */
	public boolean isEndlearn() {
		return endlearn;
	}

	/**
	 * wKIԂݒ肵܂B
	 * @param endlearn true:wKI false:wK
	 */
	public void setEndlearn(boolean endlearn) {
		this.endlearn = endlearn;
	}

	/**
	 * GWɃirQ[VvsȂ܂B
	 * 
	 * @param command irQ[VR}h
	 * @param activityID ANereBhc
	 */
	public void navigate(String command, String activityID) {
		try {
			// irQ[Vv
			NavigateEngine naveng = new NavigateEngine();
			naveng.execute(req, command, activityID);
			endlearn = naveng.isEndLean();
			// irQ[VR}h
			if (!endlearn) {
				// fAIȊȌꍇAOXNvgtqkݒ肷B
				dispUrl = naveng.getScoUrl();
				setDispUrl(dispUrl);
				aiccSid = naveng.getAiccSid();
				// irQ[VtOsɂB
				navExeFlg= true;;
			}
		} catch (XmsException e) {
			// knfo
			DebugLog.write(getClass(),
					"[navigate]NavigateEngine Error command = " + command +
					" activityid = " + activityID,	DebugLog.HIGHT);
			// ʓIȗOG[
			api_errcode = "101";
		}

	}

	/**
	 * `oh̃CjVCYsȂ܂B
	 * G[R[hGetLastError\bhŎ擾邱Ƃo܂B
	 * 
	 * @return ̏ꍇtrue G[̏ꍇfalse
	 */
	public boolean Initialize() {
		// `ohԃ`FbN
		if (api_status != null && api_status.equals(STS_RUN)) {
			// ς݃G[
			api_errcode = "103";
			return false;
		} else if (api_status != null && api_status.equals(STS_TERM)) {
			// Iς݃G[
			api_errcode = "104";
			return false;
		}

		// sessionapi adapter擾
		HttpSession session = req.getSession();
		SCORMAPIAdapter adapter = (SCORMAPIAdapter)session.getAttribute("SCORM.API_ADAPTER");

		if (adapter == null) {
			// session Time out G[
			// knfo
			DebugLog.write(getClass(),
					"[Initialize]SessionTimeout(apiAdapter is null)",
					DebugLog.HIGHT);
			// ʓIȗOG[
			api_errcode = "101";
			return false;
		}

		try {
			// SCORM2004RTE擾(GetParam)
			String param ="command=GetParam&version=S1.3&session_id=" + aiccSid + "&aicc_data=";
			String result = adapter.hacp(param);

			// GetPrameaicc dataRTEf[^fɕϊHashTableɃZbg
			HacpDataParameters hacpGetData = new HacpDataParameters();
			hacpGetData.setHacpDataText(result);
			String strGetData = hacpGetData.get("aicc_data");
			cmiParameters = new CmiParameters();
			cmiParameters.setCmiDataParam(strGetData);

			// SCORM2004RTE擾(GetLMSComments)
			String lmscpmment = adapter.hacp(GET_LMS_COMMENT);

			// GetLMSCommentsaicc dataRTEf[^fɕϊHashTableɃZbg
			HacpDataParameters hacpLMSComments = new HacpDataParameters();
			hacpLMSComments.setHacpDataText(lmscpmment);
			String strLMSComments = hacpLMSComments.get("aicc_data");
			cmiParameters.setCmiDataLmsComments(strLMSComments);

			// APIG[R[hɐݒ
			api_errcode = "0";
			// APIXe[^XjOԂɂ
			api_status = STS_RUN;
			// XgirQ[V
			lastNavRequest = "_none_";
		} catch (Exception e) {
			// knfo
			DebugLog.write(getClass(),
					"[Initialize]Exception Error(101)",
					DebugLog.HIGHT);
			// ʓIȗOG[
			api_errcode = "101";
			return false;
		}
		return true;
	}

	/**
	 * RTEf[^AirQ[V̐ݒsȂ܂B
	 * G[R[hGetLastError\bhŎ擾邱Ƃo܂B
	 * 
	 * @param strKey L[
	 * @param strValue l
	 * @return ̏ꍇtrue G[̏ꍇfalse
	 */
	public boolean SetValue(String strKey, String strValue) {
		boolean bRtn;
		// `FbN
		// `ohԃ`FbN
		if (api_status != null && api_status.equals(STS_NOT_INI)) {
			// OG[
			api_errcode = "132";
			return false;
		} else if (api_status != null && api_status.equals(STS_TERM)) {
			// Iς݃G[
			api_errcode = "133";
			return false;
		}

		if (strKey == null) {
			api_errcode = "401";
			bRtn = false;
		}else if (strKey.equals("adl.nav.request")) {
			bRtn = NavSetValue(strValue);
		} else if (strKey.startsWith("cmi.")) {
			// f[^fikeyj`FbN
			RunTimeFormat rte = new RunTimeFormat();
			api_errcode = rte.cmiCheck(strKey, "w");
			if (api_errcode.equals("0")) {
				// 펞ARTEf[^ݒ
				cmiParameters.put(strKey, strValue);
				bRtn = true;
			} else {
				// f[^f`FbNG[
				bRtn = false;
			}
		} else {
			// f[^fG[
			api_errcode = "401";
			bRtn = false;
		}
		return bRtn;
	}

	/**
	 * irQ[Vݒ肵܂B
	 * 
	 * @param strValue l
	 * @return ̏ꍇ G[̏ꍇfalse
	 */
	private boolean NavSetValue(String strValue) {
		boolean bRtn;
		// f[^f`FbN
		if (strValue.equals("continue")   ||
			strValue.equals("previous")   ||
			strValue.equals("exit")       ||
			strValue.equals("exitAll")    ||
			strValue.equals("suspendAll") ||
			strValue.equals("_none_")) {
			// 펞
			lastNavRequest = strValue;
			api_errcode = "0";
			bRtn = true;
		} else if (	strValue.startsWith("{target=") &&
				strValue.endsWith("}choice")) {
			if (strValue.length() > ("{target=".length() + "}choice".length())) {
				// 펞
				lastNavRequest = strValue;
				api_errcode = "0";
				bRtn = true;
			} else {
				// f[^fG[
				api_errcode = "401";
				bRtn = false;
			}
		} else {
			// f[^fG[
			api_errcode = "401";
			bRtn = false;
		}

		return bRtn;
	}

	/**
	 * RTEf[^AirQ[V񓙂擾܂B
	 * G[R[hGetLastError\bhŎ擾邱Ƃo܂B
	 * 
	 * @param strKey f[^f
	 * @return RTEf[^́AirQ[V
	 */
	public String GetValue(String strKey) {
		String strValue = null;
		// `FbN
		// `ohԃ`FbN
		if (api_status != null && api_status.equals(STS_NOT_INI)) {
			// OG[
			api_errcode = "122";
		} else if (api_status != null && api_status.equals(STS_TERM)) {
			// Iς݃G[
			api_errcode = "123";
		} else 	if (strKey.startsWith("adl.nav.")) {
			strValue = NavGetValue(strKey);
			if (strValue != null) {
				api_errcode = "0";
			} else {
				api_errcode = "401";
			}
		} else {
			// f[^fikeyj`FbN
			RunTimeFormat rte = new RunTimeFormat();
			api_errcode = rte.cmiCheck(strKey, "r");
			if (api_errcode.equals("0")) {
				// 펞RTEf[^ݒ
				strValue = (String) cmiParameters.get(strKey);
				strValue = (strValue == null) ? "": strValue;
			}
		}

		return strValue;
	}

	/**
	 * irQ[V擾<br>
	 * <table border="1">
	 * <tr><th>R}h</th><th></th></tr>
	 * <tr><td>adl.nav.request</td><td>ŌɃZbgirQ[V߂܂B</td></tr>
	 * <tr>
	 * <td>adl.nav.request.request_valid(R}h)</td>
	 * <td>R}h̗LE߂܂BR}hFcontinue,previous</td>
	 * </tr>
	 * <tr>
	 * <td>adl.nav.request.request_valid.choice{target=uri}</td>
	 * <td>R}h̗LE߂܂Buri݂Ȃꍇ́Anull߂܂B</td>
	 * </tr>
	 * </table>
	 * @param strKey adl.nav.xxxx R}h
	 * @return null:f[^fG[ nullȊO:f[^l
	 */
	private String NavGetValue(String strKey) {
		String rtn = null;
		// f[^f`FbN
		// adl.nav.request
		String [] dataModel = strKey.split("\\.");
	
		switch (dataModel.length) {
		case 3:
			// adl.nav.request
			if (dataModel[2].equals("request")) {
				// adl.nav.request̏ꍇAŌɎsR}h߂
				rtn = lastNavRequest;
			}
			break;

		case 4:
			// adl.nav.request_valid.continue||previous
			if (dataModel[2].equals("request_valid") &&
				(dataModel[3].equals("continue") ||
				 dataModel[3].equals("previous"))) {
				// request_valid.continue
				// request_valid.previous̏ꍇ
				// R}hs̉ۂ߂
				NavigateEngine naveng = new NavigateEngine();
				rtn = naveng.getRequestValid(req, dataModel[3], null);
			}
			break;
		
		case 5:
			// adl.nav.request_valid.choice.{target=uri}
			if (dataModel[2].equals("request_valid") &&
				// 2010.10.06 taku-harada mod >>
				//dataModel[3].equals("choice") &&
				(dataModel[3].equals("choice") || dataModel[3].equals("jump"))&&
				// 2010.10.06 taku-harada mod <<
				dataModel[4].startsWith("{target=") &&
				dataModel[4].endsWith("}")) {
				// URIw肳Ă邩H@"{target=}"̏ꍇG[
				if (("{target=".length() + "}".length()) < dataModel[4].length() ) {
					// "{target=uri}"uri擾
					String url = dataModel[4].substring("{target=".length(), (dataModel[4].length() - "}".length()));
					// w肳ꂽuriChoice\`FbN
					NavigateEngine naveng = new NavigateEngine();
					rtn = naveng.getRequestValid(req, dataModel[3], url);
				}
			}
			break;

 		default:
			// f[^fG[
			break;
		}
		return rtn;
	}

	/**
	 * RTEf[^GW֑M܂B
	 * 
	 * @return errcode ̏ꍇtrue G[̏ꍇfalse
	 */
	public boolean Commit() {
		// knfo
		DebugLog.write(getClass(), "[Commit]`ohԃ`FbN",	DebugLog.ROW);
		// `ohԃ`FbN
		if (api_status != null && api_status.equals(STS_NOT_INI)) {
			// OG[
			api_errcode = "142";
			return false;
		} else if (api_status != null && api_status.equals(STS_TERM)) {
			// Iς݃G[
			api_errcode = "143";
			return false;
		}
		// knfo
		DebugLog.write(getClass(), "[Commit]PutParam",	DebugLog.ROW);
		// GWփf[^M
		api_errcode = putData();

		if (api_errcode == null) {
			// ʓIȗOG[
			api_errcode = "391";
			// knfo
			DebugLog.write(getClass(), "[Commit]putData() error",	DebugLog.HIGHT);
		}
		
		return api_errcode.equals("0");
	}

	/**
	 * RTEf[^GWɑMirQ[Vݒ肳Ă
	 * GWփirQ[Vv܂B
	 * 
	 * @return@̏ꍇtrue G[̏ꍇfalse
	 */
	public boolean Terminate() {
		// `ohԃ`FbN
		if (api_status != null && api_status.equals(STS_NOT_INI)) {
			// OG[
			api_errcode = "112";
			return false;
		} else if (api_status != null && api_status.equals(STS_TERM)) {
			// Iς݃G[
			api_errcode = "113";
			return false;
		}

		api_errcode = putData();

		if (api_errcode == null) {
			// ʓIȗOG[
			api_errcode = "391";
			return false;
		} else if (!api_errcode.equals("0")) {
			return false;
		}
		// adl.nav.requestݒ肳ĂꍇAirQ[VvB
		// irQ[VR}hp[NNA
		// 
		api_errcode = putCommand("EXITAU", "");

		if (api_errcode == null) {
			// ʓIȗOG[
			api_errcode = "391";
			return false;
		} else if (!api_errcode.equals("0")) {
			return false;
		}
		// `ohԃXe[^XIɂB
		api_status = STS_TERM;
		// 
		if (lastNavRequest != null && !lastNavRequest.equals("_none_")) {
			String command;
			String activityID = null;
			if (lastNavRequest.startsWith("{target=") &&
				lastNavRequest.endsWith("}choice")) {
				command = "choice";
				activityID = lastNavRequest.substring("{target=".length(), (lastNavRequest.length() - "}choice".length()));
			} else {
				command = lastNavRequest;
			}
			navigate(command, activityID);
			if (!api_errcode.equals("0")) {
				return false;
			}
		}
		return true;
	}

	/**
	 * RTEf[^AICCf[^ɕϊGW֑M܂B
	 * 
	 * @return errcode M
	 */
	private String putData() {
		String errCode;

		// GWAICCf[^M PutParam
		errCode = putCommand("PutParam", cmiParameters.getAiccDataParam());
		// Mʔ
		if (errCode == null || !errCode.equals("0")) {
			// ʓIȗOG[
			// knfo
			DebugLog.write(getClass(),
					"[putData]putCommand(PutParam, aicc) error " + errCode,
					DebugLog.HIGHT);
			return errCode;
		}

		// Interactionsf[^擾
		String interactionsData = cmiParameters.getAiccDataInteractions();

		if (interactionsData != null) {
			// interactionsf[^݂ꍇ
			// knfo
			DebugLog.write(getClass(), "[Commit]PutParam(interaction)",	DebugLog.ROW);
			// GWAICCf[^M PutInteractions
			errCode = putCommand("PutInteractions", interactionsData);

			// Mʔ
			if (errCode == null || !errCode.equals("0")) {
				// ʓIȗOG[
				// knfo
				DebugLog.write(getClass(),
						"[putData]putCommand(PutInteractions, aicc) error " + errCode,
						DebugLog.HIGHT);
				return errCode;
			}
		}

		// PutCommentsf[^擾
		String commentsData = cmiParameters.getAiccDataComments();

		if (commentsData != null) {
			// knfo
			DebugLog.write(getClass(), "[Commit]PutParam(PutComments)",	DebugLog.ROW);
			// GWAICCf[^M PutComments
			errCode = putCommand("PutComments", commentsData);

			// Mʔ
			if (errCode == null || !errCode.equals("0")) {
				// ʓIȗOG[
				// knfo
				DebugLog.write(getClass(),
						"[putData]putCommand(PutComments, aicc) error " + errCode,
						DebugLog.HIGHT);
				return errCode;
			}
		}

		return errCode;
	}

	/**
	 * Ŏw肳ꂽR}hɃGWAICCf[^𑗐M܂B
	 * @param command R}h
	 * @param aiccData AICCf[^
	 * @return errcode M
	 */
	private String putCommand(String command, String aiccData) {
		// sessionapi adapter擾
		HttpSession session = req.getSession();
		SCORMAPIAdapter adapter = (SCORMAPIAdapter)session.getAttribute("SCORM.API_ADAPTER");

		if (adapter == null) {
			// session Time out G[
			// knfo
			DebugLog.write(getClass(),
					"[putdata]SessionTimeout(apiAdapter is null)",
					DebugLog.HIGHT);
			return null;
		}

		StringBuffer sbCommand = new StringBuffer();
		sbCommand.append("command=");
		sbCommand.append(command);
		sbCommand.append("&version=S1.3&session_id=");
		sbCommand.append(aiccSid);
		sbCommand.append("&aicc_data=");
		try {
			sbCommand.append(URLEncoder.encode(aiccData, "UTF-8"));
		} catch (UnsupportedEncodingException e1) {
			sbCommand.append(aiccData);
		}

		// SCORM2004RTEM(PutParam)
		String result = null;
		try {
			DebugLog.write(getClass(), "[putdata]-> " + sbCommand.toString(), DebugLog.ROW);
			result = adapter.hacp(sbCommand.toString());
			DebugLog.write(getClass(), "[putdata]<- " + result, DebugLog.ROW);
		} catch (Exception e) {
			DebugLog.write(getClass(), "[putdara]hacp error " + sbCommand.toString(), DebugLog.HIGHT);
			return null;
		}
		// Mʔ
		return aiccErrGet(result);
	}

	/**
	 * Mʏ񂩂G[R[h擾܂B
	 * 
	 * @param aiccData Mʃf[^
	 * @return errcode G[R[h
	 */
	private String aiccErrGet(String aiccData) {
		StringTokenizer st = new StringTokenizer(aiccData, "\n");
		boolean bErrFlg = false;
		boolean bDetailFlg = false;
		String errCode = null;
		String detailCode = null;
		while(st.hasMoreTokens()) {
			int startpos;
			String value = st.nextToken().trim();
			if (!bErrFlg) {
				// errorR[h擾
				startpos = value.indexOf("error=");
				if (startpos >= 0) {
					value = value.substring(startpos);
					errCode = value.replaceAll("error=", "");
					bErrFlg = true;
				}
			}
			if (!bDetailFlg) {
				// detail_error擾
				startpos = value.indexOf("detail_error=");
				if (startpos >= 0) {
					value = value.substring(startpos);
					detailCode = value.replaceAll("detail_error=", "");
					bDetailFlg = true;;
				}
			}
			// G[R[hڍ׃R[h擾o?
			if (bErrFlg && bDetailFlg) {
				break;
			}
		}

		if (errCode != null && errCode.equals("0")) {
			if (detailCode != null) {
				errCode = detailCode;
			}
		}
		return errCode;
	}

	/**
	 * APIXe[^XԂ߂܂B
	 * <table border="1">
	 * <tr><td>Notinitialize</td><td>CjVCYO</td></tr>
	 * <tr><td>running</td><td>s</td></tr>
	 * <tr><td>Terminated</td><td>I</td></tr>
	 * </table>
	 * 
	 * @return APIXe[^XR[h
	 */
	public String getApi_status() {
		return api_status;
	}

	/**
	 * APIG[R[h߂܂B
	 * 
	 * @return APIG[R[h
	 */
	public String GetLastError() {
		return api_errcode;
	}

	/**
	 * irQ[VԂ܂B
	 *
	 */
	public void NaviInitialize() {
		// irQ[Vsς݂̏ꍇACjVCYOԂɐݒ
		if (navExeFlg) {
			// `ohԃXe[^XCjVCYOɐݒ
			api_status = STS_NOT_INI;
			// `ohG[R[h𐳏ɐݒ
			api_errcode = "0";
			// XgirQ[VNA
			lastNavRequest = "_none_";
			// irQ[VstONA
			navExeFlg = false;
		}
	}
}
