#!/bin/bash
if [ $# -eq 2 ]
then
	XMS2USER=$1
	XMS2DBNAME=$2
	SQLFILEDIR="."
	PSQLPATH="/usr/local/pgsql/bin"
	echo "--------------------------------- "
	echo "--- start db setup "
	echo "--- database user : ${XMS2USER} "
	echo "--- database name : ${XMS2DBNAME} "
	echo "--------------------------------- "
	echo -n "--- start ok ? ( y / n ) :"
	read INPUTKEY
	if [ ${INPUTKEY} != "y" ]
	then
		exit
	fi
else
	echo "--------------------------------- "
	echo "--- parameter error "
	echo "--- parameter 1 : database user "
	echo "--- parameter 2 : database name "
	echo "--------------------------------- "
	exit
fi

#--- database check ---
${PSQLPATH}/psql -l | grep " ${XMS2DBNAME} "
if [ $? -ne 0 ]
then
	echo "--- create database ---"
	${PSQLPATH}/createdb --encoding UTF-8 ${XMS2DBNAME}
fi

#---- Script ----
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_CreateTB.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_CreateIDX.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_CreateView.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_GroupAndPeople.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_Groups.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_LO.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_LORelation.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_LOType.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_People.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_RoleAssignments.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_Roles.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_RolesFunction.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_XMOEntry.sql
${PSQLPATH}/psql ${XMS2DBNAME} ${XMS2USER} -f ${SQLFILEDIR}/Pg_InsertTB_XmoRelation.sql

