/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * ꊇo^̐ݒɂē͂ANVENXB
 * @author T.Nishiki
 */
public class LumpInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(LumpInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * XLbvȂ̂false߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return false߂܂B
	 */
	public boolean isSkipped(InstallerValues values) {
		return false;
	}

	/**
	 * ꊇo^̐ݒɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return LumpInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see LumpInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");

		// ̓f[^
		LumpInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			LumpInputValue defaultValue = getDefaultValue(values);
			// ^Cg\
			InstallerUiUtil.outputMessageAsTitle(
				values, "LumpInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					// ͊mFς񂾏ꍇAw肳ꂽfBNg
					// 쐬ΏۂƂēo^B
					File lumpDir = new File(inputValue.getLumpPath());
					values.addMadeDirectory(lumpDir);
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * ꊇo^ݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽeLumpInputValueƂĖ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private LumpInputValue readInputValue(
			InstallerValues values, LumpInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues)");

		LumpInputValue inputValue = null;
		try {
			inputValue = new LumpInputValue();
			// =============================================================
			// ꊇo^fBNg
			String lumpFilePath = null;
			while (true) {
				lumpFilePath = InstallerUiUtil.askUserInput(values,
						"LumpInputAction.prompt.lumpFilePath",
						defaultValue.getLumpPath());
				// 
				if (InstallerCheckUtil.isEmptyViolation(lumpFilePath, values,
						"LumpInputAction.error.lumpFilePath.empty")) {
					continue;
				}
				// t@C
				if (InstallerCheckUtil.isFilePath(lumpFilePath, values,
						"LumpInputAction.error.lumpFilePath.file")) {
					continue;
				}
				break;
			}
			inputValue.setLumpPath(lumpFilePath);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, LumpInputValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, LumpInputValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"LumpInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// ꊇo^tH_pX
			InstallerUiUtil.outputConfirm(values,
				"LumpInputAction.confirm.lumpFilePath",
				inputValue.getLumpPath());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "LumpInputAction.confirm" );
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, LumpInputValue)", confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglManagerInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private LumpInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		LumpInputValue defaultValue = null;
		try {
			defaultValue = new LumpInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
				defaultValue.getTargetFileKey());
			Properties existProperties
				= FileUtil.loadAsProperties(existFile);
			// =================================================================
			// \[Xi{j̓e
			Properties resourceProperties
				= InstallerPropertiesUtil.load(
						values, defaultValue.getTargetFileKey());
			////////////////////////////////////////////////////////////////////
			// ftHgl̐ݒ
			// =================================================================
			// ꊇo^fBNg
			String lumpPath = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								LumpInputValue.KEY_LUMP_UPLOAD_PATH);
			defaultValue.setLumpPath(lumpPath);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
