/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * t@CɊ֘A郆[eBeBENXB
 * @author T.Nishiki
 */
public class InstallerFileUtil {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB<br>
	 * Oo̓IuWFNg擾܂B
	 */
	static {
		_logger = LoggerUtil.getLogger(InstallerFileUtil.class);
	}

	/**
	 * t@CRs[܂B<br>
	 * @param fromFile Rs[̃t@CB
	 * @param toFile Rs[t@CB
	 * @throws InstallerException Rs[ɎsꍇB
	 */
	public static void copyFile(File fromFile, File toFile)
			throws InstallerException {
		// \bhJn^O
		String logMessge = null;
		if (LoggerUtil.isLoggableMethod(_logger)) {
			logMessge = "copyFile(" + fromFile + "," + toFile + ")";
			LoggerUtil.methodHead(_logger, logMessge);
		}

		try {
			FileUtil.copyFile(fromFile, toFile);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhI^O
		if (LoggerUtil.isLoggableMethod(_logger)) {
			LoggerUtil.methodTail(_logger, logMessge);
		}
	}

	/**
	 * w肵fBNgɂ܂B
	 * @param directory ɂfBNg\FileB
	 * @throws InstallerException 폜ɎsꍇB
	 */
	public static void cleanDirectory(File directory)
			throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger, "cleanDirectory(" + directory + ")");

		File[] children = directory.listFiles();
		for (int i = 0; i < children.length; i++) {
			delete(children[i]);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger, "cleanDirectory(" + directory + ")");
	}

	/**
	 * w肳ꂽt@C܂̓fBNg폜܂B<br>
	 * fBNg̏ꍇAɎqt@C^fBNg폜܂B
	 * @param file 폜Ώۂ̃fBNgB
	 * @throws InstallerException 폜ɎsꍇB
	 */
	public static void delete(File file) throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger, "delete(" + file + ")");

		try {
			FileUtil.delete(file);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger, "delete(" + file + ")");
	}

	/**
	 * ̓Xg[܂B<br>
	 * w肳ꂽ̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param stream N[Y݂̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws InstallerException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(InputStream stream, boolean throwFlag)
		throws InstallerException {

		try {
			FileUtil.close(stream, throwFlag);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
	}

	/**
	 * o̓Xg[܂B<br>
	 * w肳ꂽo̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param stream N[Y݂o̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws InstallerException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(OutputStream stream, boolean throwFlag)
		throws InstallerException {

		try {
			FileUtil.close(stream, throwFlag);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
	}

	/**
	 * o̓Xg[܂B<br>
	 * w肳ꂽ̓Xg[Əo̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param inStream N[Y݂̓Xg[B
	 * @param outStream N[Y݂o̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws InstallerException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(
		InputStream inStream, OutputStream outStream, boolean throwFlag)
		throws InstallerException {

		InstallerException thrown = null;
		// ̓Xg[̃N[Y
		try {
			close(inStream, throwFlag);
		}
		catch (InstallerException e) {
			thrown = e;
		}
		// o̓Xg[̃N[Y
		try {
			close(outStream, throwFlag);
		}
		catch (InstallerException e) {
			if (thrown == null) {
				thrown = e;
			}
		}
		// ǂ炩OꍇAX[܂B
		if ( thrown != null ) {
			throw thrown;
		}
	}

	/**
	 * ̓Xg[܂B<br>
	 * w肳ꂽ̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param reader N[Y݂镶̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws InstallerException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(Reader reader, boolean throwFlag)
		throws InstallerException {

		try {
			FileUtil.close(reader, throwFlag);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
	}

	/**
	 * o̓Xg[܂B<br>
	 * w肳ꂽo̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param writer N[Y݂镶o̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws InstallerException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(Writer writer, boolean throwFlag)
		throws InstallerException {

		try {
			FileUtil.close(writer, throwFlag);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
	}

	/**
	 * o̓Xg[܂B<br>
	 * w肳ꂽ̓Xg[ƕo̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param reader N[Y݂镶̓Xg[B
	 * @param writer N[Y݂镶o̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws InstallerException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(
		Reader reader, Writer writer, boolean throwFlag)
		throws InstallerException {

		InstallerException thrown = null;
		// ̓Xg[̃N[Y
		try {
			close(reader, throwFlag);
		}
		catch (InstallerException e) {
			thrown = e;
		}
		// o̓Xg[̃N[Y
		try {
			close(writer, throwFlag);
		}
		catch (InstallerException e) {
			if (thrown == null) {
				thrown = e;
			}
		}
		// ǂ炩OꍇAX[܂B
		if ( thrown != null ) {
			throw thrown;
		}
	}

	/**
	 * w肵\[Xt@C̓et@CɃRs[܂B<br>
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param file Rs[ƂȂ郊\[Xt@CB
	 * @param targetFileKey 擾郊\[Xt@C
	 * @throws InstallerException t@CRs[ɃG[ꍇB
	 */
	public static void loadFile(InstallerValues values,
			File file, String targetFileKey)
		throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger,
			"loadFile(" + file + "," + targetFileKey + ")");

		// \[X̓̓Xg[
		InputStream inStream = null;
		// Rs[ƂȂo̓Xg[
		OutputStream outStream = null;
		// tOiꍇtrueɕύXj
		boolean successFlag = false;
		try {
			// ̓Xg[̐
			inStream = values.getResourceKeyStream(targetFileKey);
			// Rs[̏o̓Xg[̐
			outStream = new BufferedOutputStream(new FileOutputStream(file));
			// Rs[Jn
			while (true) {
				byte[] buffer = new byte[1024 * 10];
				int length = inStream.read(buffer);
				if (length <= 0) {
					break;
				}
				outStream.write(buffer, 0, length);
			}
			// tryubN̍Ō܂œBA
			successFlag = true;
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		finally {
			close(inStream, outStream, successFlag);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger,
			"loadFile(" + file + "," + targetFileKey + ")");
	}
}
