/*
 * CopyRight(C) 2003, NTT All rights reserved
 *
 *	XMS2f[^x[Xe[u̍쐬
 *		ύX
 *			2004.01.08  VK쐬  񞊒q
 *
 *	XMS2f[^x[Xe[uVK쐬܂B
*/

import java.sql.*;
import java.io.*;

public class DBSet {

	// [Uێ
	private String USER_NAME;
	// pX[hێ
	private String USER_PASSWORD;
	// DBێ
	private String DB_NAME;
	// DB|[gێ
	private String DB_PORT;
	// T[oێ
	private String DB_SERVER;
	// XMS2CXg[fBNgێ
	private String XMS2_DIR;
	// SMTFCXg[tOێ
	private String SMTF_FLAG;

	// PerceptionCXg[tOێ
	private String PCT_FLAG;
	// OfflineCXg[tOێ
	private String OFL_FLAG;

	// [UIvV
	private static String USER_NAME_OPTION = "-U";
	// pX[hIvV
	private static String USER_PASSWORD_OPTION = "-P";
	// DBIvV
	private static String DB_NAME_OPTION = "-D";
	// DB|[gIvV
	private static String DB_PORT_OPTION = "-p";
	// T[oIvV
	private static String DB_SERVER_OPTION = "-S";
	// XMS2CXg[fBNgIvV
	private static String XMS2_DIR_OPTION = "-i";
	// SMTFCXg[tOIvV
	private static String SMTF_FLAG_OPTION = "-sm";

	// PerceptionCXg[tOIvV
	private static String PCT_FLAG_OPTION = "-pc";

	// OfflineCXg[tOIvV
	private static String OFL_FLAG_OPTION = "-ol";

	// hCo
	private static final String DRIVER_NAME = "com.microsoft.jdbc.sqlserver.SQLServerDriver";

	// SQL؂蕶
	private static final String SQL_TOKEN = "GO";

	// DBRlNV
	private Connection connection;

	// SQL`t@C
	private String[] DBSET_FILE = {
									"CreateDB.sql",
									"CreateUser.sql",
									"CreateTB.sql",
									"CreateIDX.sql",
									"InsertTB_GroupAndPeople.sql",
									"InsertTB_Groups.sql",
									"InsertTB_LO.sql",
									"InsertTB_LORelation.sql",
									"InsertTB_LOType.sql",
									"InsertTB_People.sql",
									"InsertTB_RoleAssignments.sql",
									"InsertTB_Roles.sql",
									"InsertTB_RolesFunction.sql",
									"InsertTB_XMOEntry.sql",
									"InsertTB_XmoRelation.sql",
									"lomu.sql"
								};

// SQLr[`t@C
	private String[] VIEWSET_FILE = {
									"Create_v_LOList.sql",
									"Create_v_UserList.sql"
	};
	
	// SmartForce SQL`t@C
	private String SMTF_FILE = "InsertTB_LOType_SMTF.sql";

	// Perception SQL`t@C
	private String PCT_FILE = "InsertTB_LOType_PCT.sql";

	// Offline SQL`t@C
	private String OFL_FILE = "InsertTB_LOType_OFL.sql";

	/**
	 * C֐
	 * R}hCȉ̈擾܂B
	 * -U [U
	 * -P pX[h
	 * -D DB
	 * -p DB|[g
	 * -S DBT[o
	 * -i XMS2CXg[fBNg
	 */
	public static void main(String[] args) {
		String userName = null;
		String password = null;
		String dbName = null;
		String dbPort = null;
		String dbServer = null;
		String xms2Dir = null;
		String smtfFlag = null;
		String pctFlag = null;
		String oflFlag = null;

		// `FbN
		for( int i = 0; i < args.length; i++ ) {
			if( args[i].charAt(0) == '-' ) {
				String option = args[i];
				String value = "";
				try {
					if( args[i+1].charAt(0) != '-' ) {
						value = args[i+1];
					}
				}
				catch( ArrayIndexOutOfBoundsException ae ) {
				}
				if( option.equals( USER_NAME_OPTION ) ) {
					userName = value;
				}
				else if( option.equals( USER_PASSWORD_OPTION ) ) {
					password = value;
				}
				else if( option.equals( DB_NAME_OPTION ) ) {
					dbName = value;
				}
				else if( option.equals( DB_PORT_OPTION ) ) {
					dbPort = value;
				}
				else if( option.equals( DB_SERVER_OPTION ) ) {
					dbServer = value;
				}
				else if( option.equals( XMS2_DIR_OPTION ) ) {
					xms2Dir = value;
				}
				else if( option.equals( SMTF_FLAG_OPTION ) ) {
					smtfFlag = value;
				}
				else if( option.equals( PCT_FLAG_OPTION ) ) {
					pctFlag = value;
				}
				else if( option.equals( OFL_FLAG_OPTION ) ) {
					oflFlag = value;
				}
			}
		}

		// 1łnullG[
		if( userName == null || password == null || dbName == null ||
			dbPort == null || dbServer == null || xms2Dir == null || smtfFlag == null || pctFlag== null || oflFlag== null)
		{
			// ُI
			System.exit(1);
		}

		// CX^X
		try {
			DBSet dbSet = new DBSet(userName, password, dbName,
									dbPort, dbServer, xms2Dir, smtfFlag, pctFlag, oflFlag);
			dbSet.setDB();
		}
		catch(ClassNotFoundException ce) {
			ce.printStackTrace();
			// JDBChCo[݂Ȃ
			System.exit(1);
		}
		catch(FileNotFoundException fe) {
			fe.printStackTrace();
			// t@C݂Ȃꍇ
			System.exit(1);
		}
		catch(IOException ie) {
			ie.printStackTrace();
			// t@CǂݍݗO
			System.exit(1);
		}
		catch(SQLException se) {
			se.printStackTrace();
			// SQLO
			System.exit(1);
		}

		// I
		System.exit(0);
	}
	/**
	 * RXgN^
	 * @param userName [U
	 * @param password pX[h
	 * @param dbName DB
	 * @param dbServer DBT[o
	 * @param xms2_dir XMS2CXg[fBNg
	 * @param smtfFlag SmartForceCXg[tO
	 * @param pctFlag PerceptionCXg[tO
	 */
	private DBSet(	String userName,
					String password,
					String dbName,
					String dbPort,
					String dbServer,
					String xms2_dir,
					String smtfFlag,
					String pctFlag,
					String oflFlag )
		throws SQLException, ClassNotFoundException
	{
		USER_NAME = userName;
		USER_PASSWORD = password;
		DB_NAME = dbName;
		DB_PORT = dbPort;
		DB_SERVER = dbServer;
		XMS2_DIR = xms2_dir + "/table/";
		SMTF_FLAG = smtfFlag;
		PCT_FLAG = pctFlag;
		OFL_FLAG = oflFlag;
		
		connection = getConnection();
		connection.setAutoCommit( false );
	}

	/**
	 * DBݒs܂B
	 * @exception SQLException SQLO
	 * @exception IOException t@CǂݍݗO
	 * @exception FileNotFoundException t@C݂Ȃꍇ
	 */
	private void setDB()
		throws SQLException, IOException, FileNotFoundException
	{
		// Statement擾
		Statement statement = connection.createStatement();

		String strFilePath = "";
		String strSQL = "";

		// SQLt@C`t@CJԂ
		try {
			for( int i = 0; i < DBSET_FILE.length; i++ ) {
				strFilePath = XMS2_DIR + DBSET_FILE[i];
				strSQL = loadFile( strFilePath );
				statement.execute( strSQL );
			}

			// X}[gtH[X
			if( !SMTF_FLAG.equals( "OFF" ) ) {
				strFilePath = XMS2_DIR + SMTF_FILE;
				strSQL = loadFile( strFilePath );
				statement.execute( strSQL );
			}

			// Perception
			if( !PCT_FLAG.equals( "OFF" ) ) {
				strFilePath = XMS2_DIR + PCT_FILE;
				strSQL = loadFile( strFilePath );
				statement.execute( strSQL );
			}
			// Offline
			if( !OFL_FLAG.equals( "OFF" ) ) {
				strFilePath = XMS2_DIR + OFL_FILE;
				strSQL = loadFile( strFilePath );
				statement.execute( strSQL );
			}

			connection.commit();

			//View̒ǉ̂߂ɁAe[uR~bgs
			for( int i = 0; i < VIEWSET_FILE.length; i++ ) {
				strFilePath = XMS2_DIR + VIEWSET_FILE[i];
				strSQL = loadFile( strFilePath );
				statement.execute( strSQL );
			}
			connection.commit();

		}
		catch( FileNotFoundException fe ) {
			// [obN
			try { connection.rollback();
			} catch( Exception e) {}
			throw fe;
		}
		catch( IOException ie ) {
			// [obN
			try { connection.rollback();
			} catch( Exception e) {}
			throw ie;
		}
		catch( SQLException se ) {
			// [obN
			try { connection.rollback();
			} catch( Exception e) {}
			throw se;
		}
		finally {
			try {	statement.close();
					connection.close();
			} catch( Exception e) {}
		}

	}

	/**
	 * t@C[h<BR>
	 * t@C"GO"͓ǂݔ΂܂
	 * @param t@CpX
	 * @return String t@Ce
	 * @exception IOException t@CǂݍݗO
	 * @exception FileNotFoundException t@C݂Ȃꍇ
	 */
	private String loadFile( String strFilePath )
		throws IOException, FileNotFoundException
	{
		BufferedReader reader = new BufferedReader(new FileReader( strFilePath ));

		StringBuffer sbFile = new StringBuffer();
		String strLine = null;
		while( (strLine = reader.readLine()) != null ) {
			if(!strLine.trim().equals( SQL_TOKEN )) {
				sbFile.append( strLine + "\n");
			}
		}

		return new String(sbFile);
	}

	private Connection getConnection()
		throws SQLException, ClassNotFoundException
	{
		// hCo̐ݒ
		Class.forName(DRIVER_NAME);

		// ڑ񐶐
		String strCon = "jdbc:microsoft:sqlserver://" + DB_SERVER + ":" + DB_PORT;

		// RlNV擾܂
		Connection con = DriverManager.getConnection(strCon,USER_NAME,USER_PASSWORD);

		return con;
	}
}