/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormDocument
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.xms.logsumup.scorm;

import java.util.List;
import java.util.ArrayList;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/**
 * ScormNodeNX̊NXłB
 * 
 */
public class ScormDocument {
	/**
	 * ލ\DOM DocumentB
	 */
	private Document manifestDocument;

	/**
	 * ftHg&lt;organization&gt;m[hB
	 */
	private Node organizationNode;

	/**
	 * &lt;resources&gt;m[hB
	 */
	private Node resourcesNode;

	/**
	 * RXgN^<BR>
	 * @XMLt@C͂ł̏s܂B
	 */
	public ScormDocument(){
	}

	/**
	 * p[X
	 * @hLg̃p[XsDocumentIuWFNg擾
	 * @param strXML : p[XΏۂ̃hLg
	 */
	public void parseXML(String strXML){
		try{
			// hLgr_[t@Ng𐶐
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			// hLgr_[𐶐
			factory.setIgnoringComments(true);
			DocumentBuilder builder = factory.newDocumentBuilder();
			// XMLf[^̓ǂݍ
			StringReader reader = new StringReader(strXML);
			InputSource source = new InputSource(reader);
			// p[XsDocumentIuWFNg擾
			manifestDocument = builder.parse(source);

			// ftHgorganizationm[h
			organizationNode = XPathAPI.selectSingleNode(
				manifestDocument,
				"/manifest/organizations/organization"
				+ "[@identifier=/manifest/organizations/@default]");
			// resourcesm[h
			resourcesNode = XPathAPI.selectSingleNode(
				manifestDocument,"/manifest/resources");

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * NCAg֕ԋpׂ݂̌̃m[hXg쐬܂B
	 * @param targetID Xgitemm[h̐eitemidentifier
	 * @return w肵IDɈvitemeƂitem̏ɊւXMLB
	 */
	public String getChildListXml(String targetID){

		StringBuffer childListBuffer = new StringBuffer();

		try {
			NodeList itemList = null;

			// [gŖŕsAm[hXgݒ肷
			if(getRootItemID().equals(targetID)){
				itemList = XPathAPI.selectNodeList(
						organizationNode,"./item");
			} else {
				// wID<item><item>擾B
				itemList = XPathAPI.selectNodeList(
						organizationNode,"descendant::item[@identifier='" + targetID + "']/item");
			}
			// Xg쐬Jn
			childListBuffer.append("<childlenlist>\n");
			for( int i = 0; i < itemList.getLength(); i++ ) {
				Element item = (Element)itemList.item(i);
				// ID擾
				String	itemID = "";
				itemID = item.getAttribute(ScormNodeConst.ID_AT_IDENTIFIER);
				// ^Cg擾
				Node titleTextNode = XPathAPI.selectSingleNode(
					item, "./title/text()");
				String	title = null;
				if (titleTextNode != null) {
					title = titleTextNode.getNodeValue();
				} else {
					title = "";
				}
				// m[h̎ʂ擾
				int nodeType = getItemType(item);
				String iconID = null;
				switch( nodeType ) {
					// AZbg̏ꍇ
					case ScormNodeConst.ASSET_NODE:
						iconID = "au";
						break;
					// SCȌꍇ
					case ScormNodeConst.SCO_NODE:
						iconID = "au";
						break;
					// ubN̏ꍇ
					case ScormNodeConst.BLOCK_NODE:
						iconID = "block";
						break;
					default:
						break;
				}
				// Ō̃m[hɂType="L"ĕԋp
				if (i + 1 == itemList.getLength()) {
					childListBuffer.append( "<child title=\"" + title + "\" iconid=\"" + iconID + "\" id=\"" + itemID + "\"  type=\"L\"/>\n" );
				}else{
					childListBuffer.append( "<child title=\"" + title + "\" iconid=\"" + iconID + "\" id=\"" + itemID + "\"  type=\"\"/>\n" );
				}
			}
			childListBuffer.append("</childlenlist>\n");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return childListBuffer.toString();	
	}
	
	/**
	 * 
	 * w肵IDɊYitemƂȉitem̔z߂܂B
	 * @param targetID 擾ΏۂitemidentifierB
	 * @return targetIDɊYitem܂߂āA̎qitemm[hXgB
	 *          Ym[hȂꍇAvfÕXg߂܂B
	 * 			[gw肵ꍇ̓[gg܂݂܂
	 * 
	 */

	public List getDescendantItems(String targetID) {
		NodeList itemList 		= null;
		List 	 items 			= new ArrayList();
		try{
			// [gŖŕsAm[hXgݒ肷
			Node targetItem = null;
			String SearchPath = null;
			if(getRootItemID().equals(targetID)){
				targetItem = organizationNode;
				// [g̃T[`pXݒ
				SearchPath = ".//item";
			} else {
				// wID<item><item>擾B
				targetItem = XPathAPI.selectSingleNode(
						organizationNode,"descendant::item[@identifier='" + targetID + "']");
				// [gȊÕT[`pXݒ
				SearchPath = ".|.//item";
			}
			// w肳ꂽIDɈvitem擾A
			// item܂߂Ďqitemm[h擾B
			if (targetItem != null) {
				// ΏۂitemAΏۂitemzitem擾
				itemList = XPathAPI.selectNodeList(targetItem, SearchPath);
				for ( int i = 0; i < itemList.getLength(); i++) {
					items.add(itemList.item(i));
				}
			} else {
				items = null;
			}
		}catch (Exception e) {
			items = null;
		}
		return items;
	}
	
	/**
	 * w肵itemm[h̎ʂ擾܂B<br>
	 * itemm[hidentifierrefw\[X擾A
	 * ̎ʂ߂܂B
	 * \[X̒ɑ݂Ȃ̂͑SăubNƂ܂B<br>
	 *
	 * @param item ʂ𔻒肷itemm[hB
	 * @return item̎ʁBQƂ̂ꂩ̒l߂܂B
	 * @see ScormNodeConst#ASSET_NODE 
	 * @see ScormNodeConst#SCO_NODE 
	 * @see ScormNodeConst#BLOCK_NODE 
	 */
	public int getItemType(Node item){
		int nodeType = 0;
		try {
			// \[Xւ̎QIDm[h擾
			Node resourceIdNode = XPathAPI.selectSingleNode(
					item, "./@identifierref");
			if (resourceIdNode != null ) {
				String resourceID = resourceIdNode.getNodeValue();
				// w肳ꂽ\[XIDɈvresourcem[h
				// scormType擾B
				Node scormType = XPathAPI.selectSingleNode(
						resourcesNode,
						"./resource[@identifier='" +resourceID + "']"
							+ "/@scormType");
// MOD Start 2005.07.13 NTTR-an 1.2\Ή
				if (scormType == null ) {
//					nodeType = ScormNodeConst.BLOCK_NODE;
				    scormType = XPathAPI.selectSingleNode(
							resourcesNode,
							"./resource[@identifier='" +resourceID + "']"
								+ "/@scormtype");
				}
//	MOD End
				// 擾łȂꍇ́AubN
				if (scormType == null ) {
				    nodeType = ScormNodeConst.BLOCK_NODE;
				}
				
				// 擾łꍇ͑̒l画fB
				else {
					String scormTypeValue = scormType.getNodeValue();
					if(scormTypeValue.equals("asset")){
						nodeType = ScormNodeConst.ASSET_NODE;
					}
					else if (scormTypeValue.equals("sco")){
						nodeType = ScormNodeConst.SCO_NODE;
					}
					else{
						nodeType = ScormNodeConst.BLOCK_NODE;
					}
				}
			}
			// \[X擾łȂꍇAubNB
			else {
				nodeType = ScormNodeConst.BLOCK_NODE;
			}
		}
		catch (Exception e) {
			nodeType = ScormNodeConst.BLOCK_NODE;
		}
		
		return nodeType;
	}

	/**
	 * [ĝ`thc擾܂B<br>
	 * organizationNodem[hidentifier̒l擾߂܂B
	 * ̏sOɃp[X͕K{łB
	 * @return RootAuID̒l߂܂B<BR>
	 *          p[XĂȂꍇm[h擾łĂȂ<BR>
	 *          ꍇNULL߂܂B
	 */
	public String getRootItemID(){
		String RootID = null;
		try{
			Node RootIDNode = XPathAPI.selectSingleNode(
					organizationNode, "./@identifier");
			if (RootIDNode != null ) {
				RootID = RootIDNode.getNodeValue();
			}	
		}catch (Exception e){
			e.printStackTrace();
		}
		return RootID;
	}

	/**
	 * [g̃^Cg擾܂B<br>
	 * organizationNodem[hztitle̒l擾߂܂B
	 * ̏sOɃp[X͕K{łB
	 * @return Roottitle̒l߂܂B<BR>
	 *          p[XĂȂꍇm[h擾łĂȂ<BR>
	 *          ꍇNULL߂܂B
	 */
	public String getRootTitle(){
		String RootTitle = null;
		try{
			Node RootIDNode = XPathAPI.selectSingleNode(
					organizationNode, "./title/text()");
			if (RootIDNode != null ) {
				RootTitle = RootIDNode.getNodeValue();
			}	
		}catch (Exception e){
			e.printStackTrace();
		}
		return RootTitle;
	}

}
