/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	GroupAndPeople ǗXMO f[^ANZXNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.xmo.GroupAndPeople;

import java.util.*;
import java.sql.*;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.*;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.Groups.GroupsClient;
import jp.co.ntt.lms.xmo.People.PeopleClient;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignmentsClient;

/**
 * GroupAndPeople ǗXMO f[^ANZXNXłB<BR>
 * ̃NXGroupAndPeoplee[uւ̓o^ACA폜As܂B<BR>
 * DataAccessNXgpAo^ACA폜APʂ
 * gUNVǗs܂B
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class GroupAndPeopleDataAccess
	implements GroupAndPeopleMessage, GroupAndPeopleTable
{
	/**
	 * RXgN^łB<BR>
	 */
	public GroupAndPeopleDataAccess() {
	}

	/**
	 * GroupAndPeoplee[u֓o^s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * Ȃe[u̎L[ȊOȗꍇ͏ȗtB[hɂ
	 * Nullli[܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             MEMBER_SHIP_ID          lXID
	 *             PARENT_ID               eID
	 *             CHILD_ID                qID
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	synchronized public String insert( Hashtable htData )
		throws XMOException
	{

		// O[vƐlf[^null̂Ƃ
		if( htData == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htData );

			// o^s\bhs܂
			insertAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞CtH[VbZ[WIDԋp
		return "";
	}

	/**
	 * o^s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam o^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void insertAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		Hashtable htbData = setData( htbParam );
		// eID̎擾
		String strParentID = (String)htbParam.get("parentID");
		// qID̎擾
		String strChildID = (String)htbParam.get("childID");
		// o[VbvID̐ݒ
		htbData.put( MEMBER_SHIP_ID, strParentID + strChildID );

		// \[gԍ̍ől擾܂
		int intMaxSortNo = getMaxSortNo( strParentID, objDataAccess );
		// \[gԍ+1āAo^pHashtablesort_noL[ɂĊi[܂B
		String strSortNo = Integer.toString( ++intMaxSortNo );
		htbData.put( SORT_NO, strSortNo );

		String strSQL = objDataAccess.getInsertSQL(htbData);

		// o^s
		objDataAccess.execute( strSQL );

		// o^ꂽO[vѐlɐeO[vɊ蓖ĂĂ
		// LOƓ̂蓖Ă܂B
		assignLoSameToParent( htbParam, objDataAccess );

	}

	/**
	 * o^O[v܂͐lɐeO[vɓo^ĂLoAssignmentsƓ̂
	 * 蓖Ă܂B
	 * @param htbParam p[^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void assignLoSameToParent( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		// eID̎擾
		String strParentID = (String)htbParam.get("parentID");
		// qID̎擾
		String strChildID = (String)htbParam.get("childID");

		try {
			// eo[VbvID̎擾s߂GroupAndPeoplẽNCAg
			// iCX^X܂
			GroupAndPeopleClient objrgoupAndPeople = new GroupAndPeopleClient();

			// ݓo^eID̎qIDɐݒ肵āAeID̃o[VbvID
			// 擾܂B
			objrgoupAndPeople.setChildID( strParentID );

			// ݎgp̃RlNVCfbNXw肵AgUNV
			// L܂B
			objrgoupAndPeople.setConnectionIndex( objDataAccess.getConnectionIndex() );
			// \bhs
			if( !objrgoupAndPeople.select() ) {
				// G[X[
				throw new XMOException( objrgoupAndPeople.getMessageData() );
			}

			// o[VbvID̎擾
			String strMemberShipID ="";
			if(objrgoupAndPeople.next()){
				// o[VbvID擾܂
				strMemberShipID =  objrgoupAndPeople.getMemberShipID();
			}

			// 擾o[VbvIDɊ蓖ĂĂLOATC
			// 邽߂AssignmentsNCAgCX^X܂B
			AssignmentsClient objAssignments = new AssignmentsClient();

			// o[VbvIDɕt^܂B
			objAssignments.setWhereMemberShipID( strMemberShipID );
			// ݎgp̃RlNVCfbNXw肵AgUNV
			// L܂B
			objAssignments.setConnectionIndex( objDataAccess.getConnectionIndex() );

			// \bhs
			if( !objAssignments.select() ) {
				// G[X[
				throw new XMOException( objAssignments.getMessageData() );
			}

			// ʐ[vȂAo[VbvID݂̂ύXāA
			// Assignments̓o^\bhs܂B
			//o^郆[ŨATCo^
			while(objAssignments.next()){
				// o^pAssignmentsClientCX^X܂
				AssignmentsClient objInAss = new AssignmentsClient();
				// ݎgpĂRlNV悤gUNV̋Ls܂
				objInAss.setConnectionIndex( objDataAccess.getConnectionIndex() );
				// p[^ݒ
				objInAss.setMemberShipID( strParentID + strChildID );				// lXID
				objInAss.setMaterialID( objAssignments.getMaterialID() );			// R|[lgID
				objInAss.setStudyStartDate( objAssignments.getStudyStartDate() );	// Jn
				objInAss.setEndDate( objAssignments.getEndDate() );					// I
				objInAss.setAssigner( objAssignments.getAssigner() );							// ATC
				objInAss.setLearnAuthority( objAssignments.getLearnAuthority() );				// wK
				objInAss.setManagementAuthority( objAssignments.getManagementAuthority() );		// Ǘ
				objInAss.setMethodFlag( objAssignments.getMethodFlag());		// \bhtO
				// o^\bhs
				if( !objInAss.insert() ) {
					// o^G[X[
					throw new XMOException( objInAss.getMessageData() );
				}
			}
		}
		catch( Exception e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// f[^x[XG[X[
			throw new XMOException( getMessageData( DB_ERR ) );
		}
	}


	/**
	 * GroupAndPeoplee[u֍XVs܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * ȗtB[h͍XV܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             MEMBER_SHIP_ID          lXID
	 *             PARENT_ID               eID
	 *             CHILD_ID                qID
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData XV
	 * @param mobjTree c[\
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	synchronized public String update( Hashtable htData, GroupAndPeopleTree mobjTree)
		throws XMOException
	{
		// GroupAndPeoplef[^null̂Ƃ
		if( htData == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htData );

			// XVs\bhs܂
			updateAction( htData, objDataAccess, mobjTree );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * XVs\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam XV
	 * @param mobjTree c[\
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void updateAction( Hashtable htbParam, DataAccess objDataAccess, GroupAndPeopleTree mobjTree )
		throws XMOException, SQLException
	{

		// XV郌R[h擾܂
		Vector vecSelect = selectAction( htbParam, objDataAccess );
		//////////////////////////////////////////////////////
		// ݃`FbNs܂
		//////////////////////////////////////////////////////
		// eID̎擾
		String strParentID = (String)htbParam.get(PARENT_ID);
		// qID̎擾
		String strChildID = (String)htbParam.get(CHILD_ID);
		// XVチo[VbvID
		String strUpdateMemberShipID = strParentID + strChildID;
		// XVOo[VbvID
		String strBeforeMemberShipID = "";
		// XVOړo[VbvID
		String strBeforeTransferMemberShipID = "";

		// eIDAqIDǂ炩XVΏۂ̏ꍇ̂ݑ݃`FbNs
		if( strParentID != null && strChildID != null ) {
			int intCount = vecSelect.size();
			for( int i = 0; i < intCount; i++ ) {
				GroupAndPeopleData objData = (GroupAndPeopleData)vecSelect.get(i);
				if(i == 0){
					strBeforeTransferMemberShipID = objData.getMemberShipID();
				}
				strBeforeMemberShipID = objData.getMemberShipID();
				if( !strUpdateMemberShipID.equals( strBeforeMemberShipID ) ) {
					if( objDataAccess.isExit( htbParam, MEMBER_SHIP_ID ) ) {
						// XV郌R[hłɑ݂G[𓊂܂
						throw new XMOException( getMessageData( EXIT_MEMBERSHIP_WAR ) );
					}
				}
			}
		}

		// XVp̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		String strSQL = objDataAccess.getUpdateSQL(htbData);

		// ̎擾
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			strSQL += strCondition;
		}

		// XVs
		objDataAccess.execute( strSQL );

		String strDont = (String)htbParam.get( UPDATE_ASSIGNMENTS );
		if( strDont == null ) {
			// XVꂽO[vѐlɐeO[vɊ蓖ĂĂ
			// LOƓ̂蓖Ă܂B
			//LO蓖ăe[u̍XVKvȏꍇ̂ݍXV܂B
			try {
				// LOe[uXV܂
				AssignmentsClient objAss = new AssignmentsClient();
				objAss.setMemberShipID( strUpdateMemberShipID );
				objAss.setWhereMemberShipID( strBeforeMemberShipID );
				// ݎgpĂRlNV悤gUNV̋Ls܂
				objAss.setConnectionIndex( objDataAccess.getConnectionIndex() );
				// LOe[uXV
				if( !objAss.update() ) {
					// DBG[𓊂
					throw new XMOException( objAss.getMessageData() );
				}
			}
			catch( Exception e ) {
				DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
				// VXeG[𓊂
				throw new XMOException( getMessageData( SYSTEM_ERR ) );
			}
			// XVꂽO[vѐlɐeO[vɊ蓖ĂĂ
			// LOƓ̂蓖Ă܂B
			assignLoSameToParentUpdate( htbParam, objDataAccess );
		}

		// wIDz擾
		try {
			RoleAssignmentsClient objRolesAss = new RoleAssignmentsClient();
			String[] strChildList = mobjTree.getUnderIDList(strBeforeTransferMemberShipID);
			for( int i = 0; i < strChildList.length; i++ ) {
				if(strChildList[i].substring(0,2).equals("GR")){
					//ړO[vzɃO[v݂ꍇARoleassignmentse[u烌R[h폜܂B
					objRolesAss.setDeleteGroupID(strChildList[i]);
					if( !objRolesAss.delete() ) {
						throw new XMOException( objRolesAss.getMessageData() );
					}
				}
			}
		}
		catch( Exception e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// VXeG[𓊂
			throw new XMOException( getMessageData( SYSTEM_ERR ) );
		}
	}

	/**
	 * o^O[v܂͐lɐeO[vɓo^ĂLoAssignmentsƓ̂
	 * 蓖Ă܂Bido[Wj
	 * @param htbParam p[^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void assignLoSameToParentUpdate( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		// eID̎擾
		String strParentID = (String)htbParam.get("parentID");
		// qID̎擾
		String strChildID = (String)htbParam.get("childID");

		try {
			// eo[VbvID̎擾s߂GroupAndPeoplẽNCAg
			// iCX^X܂
			GroupAndPeopleClient objrgoupAndPeople = new GroupAndPeopleClient();

			// ݓo^eID̎qIDɐݒ肵āAeID̃o[VbvID
			// 擾܂B
			objrgoupAndPeople.setWhereChildID( strParentID );

			// ݎgp̃RlNVCfbNXw肵AgUNV
			// L܂B
			objrgoupAndPeople.setConnectionIndex( objDataAccess.getConnectionIndex() );
			// \bhs
			if( !objrgoupAndPeople.selectDatabase() ) {
				// G[X[
				throw new XMOException( objrgoupAndPeople.getMessageData() );
			}

			// o[VbvID̎擾
			String strMemberShipID ="";
			if(objrgoupAndPeople.next()){
				// o[VbvID擾܂
				strMemberShipID =  objrgoupAndPeople.getMemberShipID();
			}

			// 擾o[VbvIDɊ蓖ĂĂLOATC
			// 邽߂AssignmentsNCAgCX^X܂B
			AssignmentsClient objAssignments = new AssignmentsClient();

			// o[VbvIDɕt^܂B
			objAssignments.setWhereMemberShipID( strMemberShipID );
			// ݎgp̃RlNVCfbNXw肵AgUNV
			// L܂B
			objAssignments.setConnectionIndex( objDataAccess.getConnectionIndex() );

			// \bhs
			if( !objAssignments.select() ) {
				// G[X[
				throw new XMOException( objAssignments.getMessageData() );
			}

			// ʐ[vȂAo[VbvID݂̂ύXāA
			// Assignments̓o^\bhs܂B
			//o^郆[ŨATCo^
			while(objAssignments.next()){
				// pAssignmentsClientCX^X܂
				AssignmentsClient objInAss = new AssignmentsClient();
				// ݎgpĂRlNV悤gUNV̋Ls܂
				objInAss.setConnectionIndex( objDataAccess.getConnectionIndex() );
				// łɓo^Ăꍇ͖
				objInAss.setWhereMemberShipID( strParentID + strChildID );
				objInAss.setWhereMaterialID( objAssignments.getMaterialID() );
				if( !objInAss.select() ) {
					// ܂Ȃꍇ
					// o^G[X[
					throw new XMOException( objInAss.getMessageData() );
				}
				if( objInAss.next() ) {
					continue;
				}

				// o^pAssignmentsClientCX^X܂
				objInAss = new AssignmentsClient();
				// ݎgpĂRlNV悤gUNV̋Ls܂
				objInAss.setConnectionIndex( objDataAccess.getConnectionIndex() );
				// p[^ݒ
				objInAss.setMemberShipID( strParentID + strChildID );				// lXID
				objInAss.setMaterialID( objAssignments.getMaterialID() );			// R|[lgID
				objInAss.setStudyStartDate( objAssignments.getStudyStartDate() );	// Jn
				objInAss.setEndDate( objAssignments.getEndDate() );					// I
				objInAss.setAssigner( objAssignments.getAssigner() );							// ATC
				objInAss.setLearnAuthority( objAssignments.getLearnAuthority() );				// wK
				objInAss.setManagementAuthority( objAssignments.getManagementAuthority() );		// Ǘ
				// o^\bhs
				if( !objInAss.insert() ) {
					// o^G[X[
					throw new XMOException( objInAss.getMessageData() );
				}
			}
		}
		catch( Exception e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// f[^x[XG[X[
			throw new XMOException( getMessageData( DB_ERR ) );
		}
	}

	/**
	 * GroupAndPeoplee[u֍폜s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           폜
	 *          ---------------------------------------------
	 *          ܂
	 *          ---------------------------------------------
	 *             DELETE_SELECTID         selectID(O[vID܂̓[UID)
	 *             DELETE_PARENTID         eID
	 *          ---------------------------------------------
	 * </PRE>
	 * CONDITION_KEYɍ폜i[Ăꍇ͂̏ɉ
	 * 폜s܂B<BR>
	 * ̑̏ꍇ́Aȉ̂悤ȍ폜s܂B
	 * <PRE>
	 *     O[v̍폜̏ꍇc e[u폜s܂B܂̔z
	 *                            O[v폜܂B
	 *                            O[vz̃[Uׂ͂ĖɈړ܂B
	 *                            ̃[Uǉŕ݂ďꍇ́Aǉ[U
	 *                            ׂ͂č폜܂B
	 *     [U̍폜̏ꍇc 폜郆[UłɖɏĂꍇ́Ae[u폜
	 *                          ܂B
	 *                          ɏĂȂꍇ́AɈړ܂B
	 *                          [UǉĂꍇ͏ǉ[Uׂ͂č폜܂B
	 * </PRE>
	 * @param htData 폜
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public String delete( Hashtable htData )
		throws XMOException
	{

		// O[vƐlf[^null̂Ƃ
		if( htData == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htData );

			// 폜s\bhs܂
			deleteAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
		return "";
	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// SelectID̎擾
		String strSelectID = (String)htbParam.get( DELETE_SELECTID );
		// ParentID̎擾
		String strParentID = (String)htbParam.get( DELETE_PARENTID );
		if( strSelectID == null || strParentID == null ) {
			// w̍폜s
			deleteCondition( htbParam, objDataAccess );
		} else {

			// GroupAndPeoplee[uAmemberShipID擾
			// memberShipIDݒ肵AAssignments XMO ̍폜s
			deleteAssignments( strSelectID, strParentID, objDataAccess );

			// GroupAndPeoplee[uA擾R[h
			// childIDO[vIDƃ[UID̏ꍇŏU蕪܂
			deleteEqParentID( strSelectID, objDataAccess );

		if ( strParentID.equals( XMOPropertyDef.WASTES_GROUPID )
			|| strSelectID.startsWith( XMOPropertyDef.LEADMARK_GROUPID ) ) {
				// eIDA܂SelectIDO[vID̏ꍇA
				// GroupAndPeoplee[u̍폜s܂B
				deleteEqChildID( strSelectID, strParentID, objDataAccess );
			} else {
				// GroupAndPeoplee[uAXV܂͍폜s܂
				deleteEqSelectID( strSelectID, strParentID, objDataAccess );
			}
		}

	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteCondition( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		// GroupAndPeoplee[uf[^폜pSQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}

		// Peoplee[uf[^폜s
		objDataAccess.execute( sbSQL.toString() );
	}

	/**
	 * GroupAndPeoplee[uA擾R[hmemberShipID
	 * ݒ肵āAAssignments XMO ̍폜s܂
	 *
	 * @param strSelectID
	 * @param strParentID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteAssignments( String strSelectID, String strParentID,
		DataAccess objDataAccess ) throws XMOException, SQLException
	{
		// memberShipID擾B
		StringBuffer sbSQL = new StringBuffer( "SELECT " );
		sbSQL.append( MEMBER_SHIP_ID );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( CHILD_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strSelectID) );
		sbSQL.append( "' AND " );
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' ");
		ResultSet rs = objDataAccess.executeQuery( sbSQL.toString() );
		if( rs.next() ){
			try {
				// AssignmentsNCAgCX^X܂B
				AssignmentsClient objAssignments = new AssignmentsClient();
				// memberShipIDݒ肵AAssignments XMO ̍폜s
				objAssignments.setWhereMemberShipID(rs.getString(MEMBER_SHIP_ID));
				objAssignments.setConnectionIndex(
					objDataAccess.getConnectionIndex() );
				if( !objAssignments.delete() ) {
					throw new XMOException( objAssignments.getMessageData() );
				}
			} catch (Exception e) {
				DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
				// f[^x[XG[ݒ
				throw new XMOException( getMessageData( DB_ERR ) );
			}
		}
	}

	/**
	 * GroupAndPeoplee[uA擾R[h
	 * childIDO[vIDƃ[UID̏ꍇŏU蕪܂
	 *
	 * @param strSelectID selectID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteEqParentID( String strSelectID, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		// parentIDselectIDR[h擾
		StringBuffer sbSQL = new StringBuffer( "SELECT " );
		sbSQL.append( CHILD_ID );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strSelectID) );
		sbSQL.append( "' ");
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
		ArrayList arrChild = new ArrayList();
		while(rs.next()) {
			arrChild.add( ChangeEncode.setChar( rs.getString( CHILD_ID ) ) );
		}

		try {
			// GroupsNCAgCX^X܂B
			GroupsClient objGroups = new GroupsClient();
			// PeopleNCAgCX^X܂B
			PeopleClient objPeople = new PeopleClient();
			int iChild = arrChild.size();
			for( int i=0; i<iChild; i++ ){
				String strChildId = (String)arrChild.get(i);
				// childIDO[vID̏ꍇ
				if( strChildId.startsWith( XMOPropertyDef.LEADMARK_GROUPID ) ) {
					// childIDݒ肵AGroups XMO ̍폜s
					objGroups.setDeleteSelectID( strChildId );
					objGroups.setDeleteParentID( strSelectID );
					objGroups.setConnectionIndex(
						objDataAccess.getConnectionIndex() );
					if( !objGroups.delete() ) {
						throw new XMOException( objGroups.getMessageData() );
					}
					// CX^Xg܂킷B
					objGroups.clear();
				} else {
				// childID[UID̏ꍇ
					// childID,parentIDݒ肵APeople XMO ̍폜s
					objPeople.setDeleteUserID( strChildId );
					objPeople.setDeleteParentID( strSelectID );
					objPeople.setConnectionIndex(
						objDataAccess.getConnectionIndex() );
					if( !objPeople.delete() ) {
						throw new XMOException( objPeople.getMessageData() );
					}
					// CX^Xg܂킷B
					objPeople.clear();
				}
			}
		} catch (Exception e) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
	}

	/**
	 * GroupAndPeoplee[u̍폜s܂B
	 *
	 * @param strSelectID
	 * @param strParentID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteEqChildID( String strSelectID, String strParentID,
		DataAccess objDataAccess ) throws XMOException, SQLException
	{
		// GroupAndPeoplee[u
		// childIDselectIDR[h폜
		StringBuffer sbSQL = new StringBuffer( "DELETE FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( CHILD_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strSelectID) );
		sbSQL.append( "' AND " );
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' ");
		// SQLs
		objDataAccess.execute( sbSQL.toString() );
	}

	/**
	 * GroupAndPeoplee[uAXV܂͍폜s܂
	 *
	 * @param strSelectID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteEqSelectID( String strSelectID, String strParentID,
		DataAccess objDataAccess ) throws XMOException, SQLException
	{
		// childIDselectIDR[h擾
		StringBuffer sbSQL = new StringBuffer( "SELECT " );
		sbSQL.append( "COUNT(*)" );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( CHILD_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strSelectID) );
		sbSQL.append( "' ");
		ResultSet rs = objDataAccess.executeQuery( sbSQL.toString() );
		if (rs.next()) {
			int iCount = rs.getInt(1);
			if ( !strParentID.equals( XMOPropertyDef.WASTES_GROUPID )
				&& iCount == 1 ) {
				// eIDłȂYR[hP̏ꍇA
				// eID𖳏ɍXV
				try {
					// GroupAndPeopleNCAgCX^X܂B
					GroupAndPeopleClient objGroupAndPeople =
						new GroupAndPeopleClient();
					// w肳ꂽ[U(selectID)𖢏Ɉړ܂
					// ړ郆[ŨoVbvIDgݗĂ(eID + "^" + qID)
					String strSendID = strParentID + "^" + strSelectID;
					// ړ惁oVbvID̑gݗ( [gID ^ ID )
					String strReceiveID = XMOPropertyDef.ROOT_GROUPID + "^" + XMOPropertyDef.WASTES_GROUPID;
					// ATC̍XVȂݒB
					objGroupAndPeople.setDontUpdateAssignments();
					// gUNVL̂߁ARlNVCfbNXݒ肷B
					objGroupAndPeople.setConnectionIndex(
						objDataAccess.getConnectionIndex() );
					// ړR[(敪𒆂ւɎw肷B)
					if( !objGroupAndPeople.transfer(strSendID, strReceiveID, GroupAndPeopleClient.IN_TYPE) ) {
						throw new XMOException(objGroupAndPeople.getMessageData());
					}
				} catch (Exception e) {
					DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
					// f[^x[XG[ݒ
					throw new XMOException( getMessageData( DB_ERR ) );
				}
			} else {
				// SelectID̈v郌R[h폜܂
				deleteEqChildID( strSelectID, strParentID, objDataAccess );
			}
		}

	}

	/**
	 * GroupAndPeoplee[u֌s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public Vector select( Hashtable htData )
		throws XMOException
	{
		// O[vƐlf[^null̂Ƃ
		if( htData == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// ߂l
		Vector vecReturn = new Vector();


		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			objDataAccess.trans( htData );

			// s\bh
			vecReturn = selectAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return vecReturn;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector selectAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			sbSQL.append( strCondition );

			// ORDER BY傪ȂꍇALOIDORDER BYǉ
			if(strCondition.indexOf("ORDER BY") == -1)
			{
				sbSQL.append(" ORDER BY " + PARENT_ID);
				sbSQL.append(" , " + SORT_NO );
			}
		}
		else
		{
			sbSQL.append(" ORDER BY " + SORT_NO );
		}

		// NG[s܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		while(rs.next()) {
			String strMemberShhipID = ChangeEncode.setChar( rs.getString( MEMBER_SHIP_ID ) );
			String strParentID = ChangeEncode.setChar( rs.getString( PARENT_ID ) );
			String strChildID = ChangeEncode.setChar( rs.getString( CHILD_ID ) );
			GroupAndPeopleData objData = new GroupAndPeopleData();
			objData.setMemberShipID( strMemberShhipID );
			objData.setParentID( strParentID );
			objData.setChildID( strChildID );
			vecReturn.add( objData );
		}

		return vecReturn;

	}

	/**
	 * eIDw肵āAsort_no̍ől擾A
	 * int^ŕԂ܂B
	 * @param strParentID eID
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public int getMaxSortNo(String strParentID, DataAccess objDataAccess)
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT MAX(sort_no) as sort_no FROM " + TABLE_NAME + " WHERE " + PARENT_ID + "='" + StringEscapeUtils.escapeSql(strParentID) + "'" );

		// SQL̎ss܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		int intSortNo = 0;
		if( rs.next() ) {
			intSortNo = rs.getInt( "sort_no" );
		}

		return intSortNo;
	}

	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable setData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, MEMBER_SHIP_ID );
		putData( htbData, htbParam, PARENT_ID );
		putData( htbData, htbParam, CHILD_ID );
		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData,  Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

	/**
	 * eqIDw肵āAsort_no擾A
	 * int^ŕԂ܂B
	 * @param strMemberShipID eqID
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public int getMemberShipIDSortNo(String strMemberShipID, DataAccess objDataAccess)
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT sort_no FROM " + TABLE_NAME + " WHERE " + MEMBER_SHIP_ID + "='" + StringEscapeUtils.escapeSql(strMemberShipID) + "'" );
		// SQL̎ss܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
		int intSortNo = 0;
		if( rs.next() ) {
			intSortNo = rs.getInt( "sort_no" );
		}
		return intSortNo;
	}

	/**
	 * ւ̎Fړsort_noȏsort_no\bḧړIDXgz񐔃vXB
	 * ւ̎Fړsort_no傫sort_no\bḧړIDXgz񐔃vXB
	 * @param intReciveSortNo ړsort_no
	 * @param intSendListLength ړIDz
	 * @param strParentID ړ̐eID
	 * @param intType 敪(ցF1AցF2AցF3)
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public void updateSortNo(int intSortNo,
										int intSendListLength,
										String strParentID,
										int intType, DataAccess objDataAccess)
		throws SQLException
	{

				// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "UPDATE " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " SET " );
		sbSQL.append( SORT_NO );
		sbSQL.append( " = " );
		sbSQL.append( SORT_NO );
		sbSQL.append( " + '" );
		sbSQL.append( intSendListLength );
		sbSQL.append( "' ");
		sbSQL.append( " WHERE " );
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' ");
		sbSQL.append( " AND " );
		sbSQL.append( SORT_NO );
		//ւ̎
		if (intType == 1){
			sbSQL.append( " >= '" );
		}
		//ւ̎
		if (intType == 3){
			sbSQL.append( " > '" );
		}
		sbSQL.append( intSortNo );
		sbSQL.append( "' ");

		// SQL̎ss܂
		objDataAccess.execute( new String(sbSQL) );

	}

	/**
	 * MemberShipIDL[GroupAndPeoplee[uMemberShipIDAparentIDAsort_noXVB
	 * @param objSendData ړFLoRelationIDAparentIDAchildID
	 * @param strParentID eID(֖͉ւ̎Fړ̐eIDBւ̎Fړ̎qIDB)
	 * @param intSortNo ֖͉ւ̎Fړsort_no
	 *                          ւ̎Fړ̎q̔zsort_no̍ől
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public void updateGroupAndPeople(GroupAndPeopleData objSendData,
							String strParentID,
							int intSortNo,
							DataAccess objDataAccess)
		throws SQLException
	{
				// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "UPDATE " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " SET " );
		sbSQL.append( MEMBER_SHIP_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID + objSendData.getChildID()) );
		sbSQL.append( "' ,");
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' ,");
		sbSQL.append( SORT_NO );
		sbSQL.append( " = '" );
		sbSQL.append( intSortNo );
		sbSQL.append( "' ");
		sbSQL.append( " WHERE " );
		sbSQL.append( MEMBER_SHIP_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(objSendData.getMemberShipID()) );
		sbSQL.append( "' ");

		// SQL̎ss܂
		objDataAccess.execute( new String(sbSQL) );

	}

	/**
	 * ړɈړMemberShipIDAparentIDAchildIDAsort_noǉB
	 * @param objSendData ړFLoRelationIDAparentIDAchildID
	 * @param intSortNo ֖͉ւ̎Fړsort_no
	 *                          ւ̎Fړ̎q̔zsort_no̍ől
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public void insertGroupAndPeople(GroupAndPeopleData objSendData,
							String strParentID,
							int intSortNo,
							DataAccess objDataAccess)
		throws SQLException
	{
				// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "INSERT " );
		sbSQL.append( "INTO " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( "( " );
		sbSQL.append( MEMBER_SHIP_ID );
		sbSQL.append( "," );
		sbSQL.append( SORT_NO );
		sbSQL.append( "," );
		sbSQL.append( PARENT_ID );
		sbSQL.append( "," );
		sbSQL.append( CHILD_ID );
		sbSQL.append( " )" );
		sbSQL.append( "VALUES" );
		sbSQL.append( "( '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID + objSendData.getChildID()) );
		sbSQL.append( "' , '");
		sbSQL.append( intSortNo );
		sbSQL.append( "' , '");
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' , '");
		sbSQL.append( StringEscapeUtils.escapeSql(objSendData.getChildID()) );
		sbSQL.append( "' ");
		sbSQL.append( " )" );
		// SQL̎ss܂
		objDataAccess.execute( new String(sbSQL) );
	}

	/**
	 * qIDw肵āAMemberShipID擾܂B
	 * @param strChildID qID
	 * @param objDataAccess f[^ANZX
	 * @return String MemberShipID
	 * @exception SQLException DBG[ꍇ
	 */
	public String getMemberShipIDFromChildID(String strChildID,
							DataAccess objDataAccess)
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "SELECT " );
		sbSQL.append( MEMBER_SHIP_ID );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE ");
		sbSQL.append( CHILD_ID );
		sbSQL.append( "='" );
		sbSQL.append( StringEscapeUtils.escapeSql(strChildID) );
		sbSQL.append( "'" );

		// SQL̎ss܂
		ResultSet rs = objDataAccess.executeQuery( new String(sbSQL) );
		String strMemberShipID = null;
		if( rs.next() ) {
			strMemberShipID = ChangeEncode.setChar(rs.getString( MEMBER_SHIP_ID ));
		}

		return strMemberShipID;
	}

	/**
	 * MemberShipIDw肵āAR[ȟ擾܂B
	 * Ńe[urs܂B
	 * @param strMemberShipID oVbvID
	 * @param objDataAccess objDataAccess
	 * @return int R[h݊mF(R[h݂ꍇ"P"AȂꍇ"0")
	 * @exception SQLException DBO
	 */
	public int getCountMemberShipID( String strMemberShipID, DataAccess objDataAccess )
		throws SQLException
	{
		int intCount = 0;
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			// SQL̑gݗ
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append( "SELECT * " );
			sbSQL.append( " FROM " );
			sbSQL.append( TABLE_NAME );

			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append( " WITH(TABLOCKX) WHERE ");
			//Oraclȅꍇ OR PostgreSQL̏ꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( " WHERE ");
			}

			sbSQL.append( MEMBER_SHIP_ID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strMemberShipID) );
			sbSQL.append( "'" );

			//Oraclȅꍇ OR PostgreSQL̏ꍇ
			if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( " FOR UPDATE" );
			}
						
			DebugLog.write( this.getClass(),new String(sbSQL), DebugLog.ROW );

			ResultSet rs = objDataAccess.executeQuery( new String(sbSQL) );

			while(rs.next()) {
				//R[h݂ꍇ
				intCount = 1;
			}

		}
		catch(Exception ex)
		{

		}
		return intCount;
	}

	/**
	 * ChildIDw肵āAR[ȟ擾܂B
	 * Ńe[urs܂B
	 * @param strChildID qID
	 * @param objDataAccess objDataAccess
	 * @return int R[h
	 * @exception SQLException DBO
	 */
	public int getCountChildID( String strChildID, DataAccess objDataAccess )
		throws SQLException
	{
		int intCount = 0;
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();

			// SQL̑gݗ
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append( "SELECT COUNT(*) " );
			sbSQL.append( " FROM " );
			sbSQL.append( TABLE_NAME );

			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append( " WITH(TABLOCKX) WHERE ");
			//Oraclȅꍇ OR PostgreSQL̏ꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( " WHERE ");
			}
			sbSQL.append( CHILD_ID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strChildID) );
			sbSQL.append( "'" );

			DebugLog.write( this.getClass(),new String(sbSQL), DebugLog.ROW );

			ResultSet rs = objDataAccess.executeQuery( new String(sbSQL) );
			if( rs.next() ) {
				intCount = rs.getInt(1);
			}
		}
		catch(Exception ex)
		{

		}
		return intCount;
	}


}
