/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
//
//
//	ADNX@AD擾NX
//			ύX
//				2004.01.08	VK쐬	            񞊒q
//
package jp.co.ntt.lms.xmo.Ad;

import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;


import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.XMOPropertyDef;
import jp.co.ntt.lms.xmo.People.*;
import jp.co.ntt.lms.xmo.Groups.*;
import jp.co.ntt.lms.xmo.LumpInsert.*;

/**
 * AD AD擾NXB<BR>
 * @author T.Nijou
 * @version 2.0.1.0 2004/01/08
 */
public class ADCorpSearch {

	// ݒf[^ێ܂B
	ADCorpSetupData mobjSetup;

	/**
	 * RXgN^łB
	 * ݒf[^ݒ肵܂B
	 * @param objSetup
	 */
	public ADCorpSearch( ADCorpSetupData objSetup ) {

		mobjSetup = objSetup;
	}

	/**
	 * ADf[^擾āAADc[𐶐ĕԂ܂B
	 * @return ADCorpNode ADc[̃[gm[h
	 * @exception ADCorpException
	 */
	public ADCorpNode getADInfo()
		throws ADCorpException
	{
		if( mobjSetup == null ) {
			// G[
			throw new ADCorpException( ADCorpMessage.INNER_ERR );
		}

		NamingEnumeration objNaming = search();

		// }bsO
		ADCorpNode objNode = mapping(objNaming, mobjSetup.getRootDN());

		return objNode;
	}

	/**
	 * F؏s܂B
	 * @return String F؂ɐ[ŨOCIDԂ܂B
	 *                F؂ɎsꍇnullԂ܂B
	 */
	public String certify()
		throws ADCorpException
	{
		if( mobjSetup == null ) {
			// G[
			throw new ADCorpException( ADCorpMessage.INNER_ERR );
		}

		String strLoginID = null;
		try {
			NamingEnumeration objNaming = search();


			// }bsO
			ADCorpNode objNode = mapping(objNaming, null);

			// }bsOʂNULL  Group̏ꍇ͔F؎s
			if( objNode == null || objNode instanceof ADCorpGroup ) {
				return null;
			}

			ADCorpPeople objPeople = (ADCorpPeople)objNode;

			// XMS2VXẽ[U݃`FbNAȂeGg
			// DNO[vɃ[U쐬B
			// eGgDNO[v݂Ȃꍇ̓hC[g
			// 쐬B
			// hC[g݂Ȃꍇ͔F؎sƂB
			strLoginID = searchAndInsert( objPeople );

		}
		catch( ADCorpException ade ) {

			// VXeG[ADBG[AG[͗OX[B
			String strMessageID = ade.getMsgNum();
			if( strMessageID.equals( ADCorpMessage.SYSTEM_ERR ) ||
				strMessageID.equals( ADCorpMessage.DB_ERR ) ||
				strMessageID.equals( ADCorpMessage.INNER_ERR ) )
			{
				throw ade;
			}
		}

		return strLoginID;
	}

	/**
	 * LDAPgpADGgꗗ擾܂B
	 * @return NamingEnumeration ʃGgꗗ
	 * @exception ADCorpConnectException ADڑG[
	 * @exception ADCorpSearchException ADG[
	 */
	public NamingEnumeration search()
		throws ADCorpConnectException, ADCorpSearchException
	{
		try{

			// @LOG >info >5 AD:ADւ̌Jn܂B:hCݒԍ:n
			DebugLog.write( this.getClass(),
					"AD:ADւ̌Jn܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
					DebugLog.MID);

			DirContext ctxLDAP;

			Hashtable env = new Hashtable();
			env.put(Context.SECURITY_AUTHENTICATION, "simple");
			env.put(Context.SECURITY_PRINCIPAL, mobjSetup.getADUser());
			env.put(Context.SECURITY_CREDENTIALS, mobjSetup.getADPass());
			env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
			env.put(Context.PROVIDER_URL,"ldap://" + mobjSetup.getADHost() + ":" + mobjSetup.getADPort());

			// oCi̎w
			if( mobjSetup.getBinaryAttribute() != null && !mobjSetup.getBinaryAttribute().equals("") ) {
				env.put("java.naming.ldap.attributes.binary",mobjSetup.getBinaryAttribute());
			}

			ctxLDAP = new InitialDirContext(env);
			SearchControls constraints = new SearchControls();
			constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);

			NamingEnumeration results = ctxLDAP.search(mobjSetup.getRootDN(),mobjSetup.getADFilter(), constraints);

			// @LOG >info >5 AD:ADւ̌I܂B:hCݒԍ:n
			DebugLog.write( this.getClass(),
					"AD:ADւ̌I܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
					DebugLog.MID);

			return results;
		}
		catch( CommunicationException ce ) {
			// @LOG >err >1 AD:ADւ̐ڑɎs܂B:hCݒԍ:"n
			DebugLog.write( this.getClass(),
					"AD:ADւ̐ڑɎs܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
					DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ce, DebugLog.HIGHT );

			// ADzXgAAD|[gs
			ADCorpConnectException ace = new ADCorpConnectException();
			throw ace;
		}
		catch( AuthenticationException ae ) {
			// @LOG >err >1 AD:ADւ̐ڑɎs܂B:hCݒԍ:"n
			DebugLog.write( this.getClass(),
					"AD:ADւ̐ڑɎs܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
					DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ae, DebugLog.HIGHT );

			// AD[UAADpX[hs
			ADCorpConnectException ace = new ADCorpConnectException();
			throw ace;
		}
		catch( NameNotFoundException nfe ) {
			// @LOG >err >1 AD:ADւ̌Ɏs܂B:hCݒԍ:"n
			DebugLog.write( this.getClass(),
					"AD:ADւ̌Ɏs܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
					DebugLog.HIGHT);
			DebugLog.write( this.getClass(), nfe, DebugLog.HIGHT );

			// [gs
			ADCorpSearchException ase = new ADCorpSearchException();
			throw ase;
		}
		catch( InvalidSearchFilterException ife ) {
			// @LOG >err >1 AD:ADւ̌Ɏs܂B:hCݒԍ:"n
			DebugLog.write( this.getClass(),
					"AD:ADւ̌Ɏs܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
					DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ife, DebugLog.HIGHT );

			// tB^s
			ADCorpSearchException ase = new ADCorpSearchException();
			throw ase;
		}
		catch(NamingException ne) {
			// @LOG >err >1 AD:ADւ̐ڑɎs܂B:hCݒԍ:"n
			DebugLog.write( this.getClass(),
					"AD:ADւ̐ڑɎs܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
					DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ne, DebugLog.HIGHT );

			// ̑̃G[͐ڑG[ƂB
			ADCorpConnectException ace = new ADCorpConnectException();
			throw ace;
		}
	}

	/**
	 * }bsOs܂B
	 * @return ADCorpNode@c[̃[gm[h
	 * @exception ADCorpException
	 */
	private ADCorpNode mapping(NamingEnumeration objNaming, String strRootDN)
		throws ADCorpException
	{
		if( objNaming == null ) {
			// G[
			throw new ADCorpException( ADCorpMessage.INNER_ERR );
		}

		// @LOG >info >5 AD:}bsOJn܂B:hCݒԍ:n
		DebugLog.write( this.getClass(),
				"AD:}bsOJn܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
				DebugLog.MID);


		// DNɕێVector
		Vector vecDN = new Vector();
		// DNL[ƂāA}bsOIuWFNgێB
		Hashtable htbMap = new Hashtable();
		try{

			// JE^
			int intCounter = 0;

			while( objNaming.hasMore() ) {
				// JE^vX
				intCounter++;
				SearchResult si = (SearchResult)objNaming.next();
				Attributes attrs = si.getAttributes();
				if (attrs == null) {
				}
				else {
					Attribute attr = attrs.get(mobjSetup.getUserObjKey());
					if( attr == null ) {
						// O[v
						ADCorpGroup objGroup = new ADCorpGroup( si, mobjSetup, intCounter );
						htbMap.put( objGroup.getDN(), objGroup );
						vecDN.add( objGroup.getDN() );
					}
					else {
						// [U
						ADCorpPeople objPeople = new ADCorpPeople( si, mobjSetup, intCounter );
						htbMap.put( objPeople.getDN(), objPeople );
						vecDN.add( objPeople.getDN() );
					}
				}
			}
		}
		catch( PartialResultException pe ) {
		}
		catch(NamingException ne) {
			// @LOG >err >1 AD:}bsOɎs܂B:hCݒԍ:n
			DebugLog.write( this.getClass(),
				"AD:}bsOɎs܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
				DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ne, DebugLog.HIGHT );

			// G[
			ADCorpSearchException ase = new ADCorpSearchException();
			throw ase;
		}

		// [gm[h
		ADCorpNode objRoot = null;

		// c[}bsO
		for( int i = 0; i < vecDN.size(); i++ ) {
			String strDN = (String)vecDN.get(i);
			String strParentDN = getParentDN(strDN);

			ADCorpNode objSelf = (ADCorpNode)htbMap.get(strDN);
			ADCorpNode objParent = (ADCorpNode)htbMap.get(strParentDN);

			// [g肷ꍇDNiʖj̑啶ʂȂ
			// ő啶ʂȂ
			if( objSelf.getDN().equalsIgnoreCase(strRootDN) ) {
				objRoot = objSelf;
			}
			else if( objParent == null && strRootDN == null ) {
				// eNULLŃ[gw肪Ȃꍇ͂̃m[h[gƂB
				objRoot = objSelf;
			}
			else if( objParent != null ) {
				objParent.addChild( objSelf );
			}
			else {
				// @LOG >debug >10
				DebugLog.write(this.getClass(), "ݒGg: " + strDN, DebugLog.ROW );
			}

			// O[v̏ꍇ̓o[ݒ
			if( objSelf instanceof ADCorpGroup ) {
				((ADCorpGroup)objSelf).setMember( htbMap );
			}
		}

		// @LOG >ifno >5 AD:}bsOI܂B:hCݒԍ:n
		DebugLog.write( this.getClass(),
				"AD:}bsOI܂B:hCݒԍ:" + mobjSetup.getDomainNo(),
				DebugLog.MID);

		return objRoot;
	}


	/**
	 * XMS2VXẽ[U݃`FbNAȂeGg
	 * DNO[vɃ[U쐬B
	 * eGgDNO[v݂Ȃꍇ̓hC[g
	 * 쐬B
	 * hC[g݂Ȃꍇ͔F؎sƂB
	 * @param objPeople }bsO
	 * @return String OCID@F؎snull
	 * @exception ADCorpException
	 */
	private String searchAndInsert( ADCorpPeople objADPeople )
		throws ADCorpException
	{
		String strLoginID = null;

		try {
			PeopleClient objPeople = selectPeople( objADPeople.getOid() );

			if( objPeople.next() ) {
				// ʎ擾
				strLoginID = objPeople.getLoginID();
			}
			else {
				// ʂ擾oȂꍇ͐VKɃ[U쐬B
				strLoginID = insertPeople( objADPeople );
			}
		}
		catch( ADCorpException ae ) {
			throw ae;
		}
		catch(Exception ex ) {
			// VXeG[
			throw new ADCorpException( ADCorpMessage.SYSTEM_ERR );
		}

		return strLoginID;
	}

	/**
	 * XMS2Ƀ[UVK쐬܂B
	 * AD[U̐eGgDNO[vɍ쐬܂B
	 * LO[vȂꍇ̓hC[gO[vɍ쐬܂B
	 * hC[gO[v݂Ȃꍇ͍쐬܂B
	 * @param objADPeople [UGg
	 * @return String 쐬[ŨOCID 쐬ȂꍇnullԂB
	 * @exception ADCorpException
	 */
	private String insertPeople( ADCorpPeople objADPeople )
		throws ADCorpException
	{
		String strLoginID = null;

		try {
			// eGgDNŌ
			GroupsClient objGroup = selectGroup( getParentDN(objADPeople.getDN()) );
			if( !objGroup.next() ) {
				// ʂȂꍇroot_dnŌ
				objGroup = selectGroup( mobjSetup.getRootDN() );

				if( !objGroup.next() ) {
					// hC[g݂Ȃꍇ͍쐬Ȃ
					return null;
				}
			}

			// DBo^ݒiʓĂяo)
			LumpInsertClient objLump = new LumpInsertClient();

			objLump.setEncode("Windows-31J");	// GR[hWindows-31Jɐݒ			
			objLump.setLumpRootGroup(objGroup.getGroupID());
			objLump.setLumpXML(objADPeople.getXML());	// ʓXMLݒ

			// o^
			if( !objLump.insert() ) {
				if(objLump.isErr()) {
					// VXeG[܂̓f[^x[XG[
					String strMessageID  = objLump.getMessageID();
					if( strMessageID.equals( LumpInsertMessage.DB_ERR ) ) {
						// f[^x[XG[
						throw new ADCorpException( ADCorpMessage.DB_ERR );
					}
					else {
						// VXeG[
						throw new ADCorpException( ADCorpMessage.SYSTEM_ERR );
					}
				}
				else {
					// x
					String strMessageID  = objLump.getMessageID();
					// o^ɎsO[vE[U݂
					if( strMessageID.equals( LumpInsertMessage.INSERT_WAR ) ) {
						// F؎s
						return null;
					}
					else {
						// ͓̑G[
						throw new ADCorpException( ADCorpMessage.INNER_ERR );
					}
				}
			}

			// o^ʂ擾
			PeopleClient objPeople = selectPeople( objADPeople.getOid() );

			if( objPeople.next() ) {
				strLoginID = objPeople.getLoginID();
			}

		}
		catch( ADCorpException ae ) {
			throw ae;
		}
		catch(Exception ex ) {
			// VXeG[
			throw new ADCorpException( ADCorpMessage.SYSTEM_ERR );
		}

		return strLoginID;
	}

	/**
	 * ADDNɃO[v
	 * @return GroupsClient 
	 */
	private GroupsClient selectGroup( String strDN )
		throws ADCorpException
	{
		GroupsClient objGroup = null;
		try {
			objGroup = new GroupsClient();
			objGroup.setWhereAdDn( strDN );

			if( !objGroup.select() ) {
				// s
				String strMessageID = objGroup.getMessageID();
				if( strMessageID == null ) {
					// bZ[W擾oȂꍇ̓VXeG[
					throw new ADCorpException( ADCorpMessage.SYSTEM_ERR );
				}
				else {
					if( strMessageID.equals( GroupsMessage.DB_ERR ) ) {
						// DBG[
						throw new ADCorpException(ADCorpMessage.DB_ERR);
					}
					else {
						// VXeG[
						throw new ADCorpException(ADCorpMessage.SYSTEM_ERR);
					}
				}
			}

		}
		catch( ADCorpException ae ) {
			throw ae;
		}
		catch(Exception ex ) {
			// VXeG[
			throw new ADCorpException( ADCorpMessage.SYSTEM_ERR );
		}

		return objGroup;
	}

	/**
	 * IuWFNgIDɃ[U
	 * @return PeopleClient 
	 */
	private PeopleClient selectPeople( String strOid )
		throws ADCorpException
	{
		PeopleClient objPeople = null;

		try {
			objPeople = new PeopleClient();

			// ʂƃIuWFNgIDŌ
			objPeople.setWhereUserType( XMOPropertyDef.AD_TYPE );
			objPeople.setWhereOid( strOid );

			if( !objPeople.select() ) {
				// s
				String strMessageID = objPeople.getMessageID();
				if( strMessageID == null ) {
					// bZ[W擾oȂꍇ̓VXeG[
					throw new ADCorpException( ADCorpMessage.SYSTEM_ERR );
				}
				else {
					if( strMessageID.equals( PeopleMessage.DB_ERR ) ) {
						// DBG[
						throw new ADCorpException(ADCorpMessage.DB_ERR);
					}
					else {
						// VXeG[
						throw new ADCorpException(ADCorpMessage.SYSTEM_ERR);
					}
				}
			}
		}
		catch( ADCorpException ae ) {
			throw ae;
		}
		catch(Exception ex ) {
			// VXeG[
			throw new ADCorpException( ADCorpMessage.SYSTEM_ERR );
		}

		return objPeople;
	}

	/**
	 * DNeDNo܂B
	 * <PRE>
	 *    ex) dc=lms,dc=ntt,dc=co,dc=jp
	 *        ̐eDN
	 *        dc=ntt,dc=co,dc=jp
	 * </PRE>
	 */
	static private String getParentDN(String strDN ) {
		if( strDN == null || strDN.indexOf(',') < 0 ) {
			return strDN;
		}

		return strDN.substring( strDN.indexOf(',') + 1, strDN.length() );

	}

// ------------- fobN-------------------------------------------------------
	private void debug(NamingEnumeration results) {
			try{
				while (results != null && results.hasMore()) {
					SearchResult si = (SearchResult)results.next();
					Attributes attrs = si.getAttributes();
					if (attrs == null) {
					} else {
						for (NamingEnumeration ae = attrs.getAll();ae.hasMoreElements();)
						{
							Attribute attr = (Attribute)ae.next();
							String attrId = attr.getID();
							for (Enumeration vals = attr.getAll();vals.hasMoreElements();)
							{
								if ( !attr.getID().equals("objectSid") )
								{
								}
								else
								{
									vals.nextElement();
								}
							}
						}
					}
				}
			}
			catch( PartialResultException pe ) {
			}
			catch(NamingException e) {
				e.printStackTrace();
				System.exit(0);
			}
	}
// ------------- fobN-------------------------------------------------------

}

