/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	l[pXp Velocity ToolNX
//
//		ύX
//			2005.02.19  VK쐬   
//
//	@\
//
//	̃NX̓l[pXNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf.tools.xmo.Base;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

import jp.co.ntt.lms.lo.LoComData;
import jp.co.ntt.lms.lo.LoTopClient;
import jp.co.ntt.lms.lo.MaterialNode;
import jp.co.ntt.lms.xmf.tools.ToolBase;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.Groups.GroupsClient;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.People.PeopleClient;

/**
 * l[pXVelocity ToolNX
 * 
 * ̃NX̓l[pXNXłB
 * 
 * @author  
 * @version 1.0
 */
public class PathTool extends ToolBase
{
	/**
	 * IDpX疼̃pX쐬郁\bhłB
	 * 
	 * @param strIDPath
	 *            '/'؂IDpX
	 * @return String '/'؂̖̃pX
	 */
	public ArrayList getNamePath(String strIDPath, String strTreeType)
			throws Exception
	{
		// '/'̃g[Nɕ܂
		StringTokenizer objToken = new StringTokenizer(strIDPath, "/");

		ArrayList strPath_info = new ArrayList();

		Vector vecIDList = new Vector();
		Vector vecMatIDList = new Vector();
		boolean blIsMatID = false;
		while (objToken.hasMoreTokens())
		{
			String strID = objToken.nextToken();
			// g[N';'̏ꍇ
			if (strID.equals(":"))
			{
				blIsMatID = true;
				continue;
			}
			if (!blIsMatID)
			{
				// IDXgɒǉ
				vecIDList.add(strID);
			}
			else
			{
				// IDXgɒǉ
				vecMatIDList.add(strID);
			}
		}

		// IDXgID擾AIDL[ɂăO[v̎擾s܂
		StringBuffer strNameBuf = new StringBuffer();
		// O[ṽc[̏ꍇO[vXMO擾
		String GROUP_TYPE = getContextString("GROUP_TYPE");
		String LO_TYPE = getContextString("LO_TYPE");
		if (strTreeType.equals(GROUP_TYPE))
		{
			GroupsClient objGroups = new GroupsClient();
			PeopleClient objPeople = new PeopleClient();
			for (int i = 0; i < vecIDList.size(); i++)
			{
				String strID = (String) vecIDList.get(i);
				String USER_PRE = getContextString("USER_PRE");
				String GROUP_PRE = getContextString("GROUP_PRE");
				String GROUP_TREE_ROOT = getContextString("GROUP_TREE_ROOT");
				if (strID.startsWith(USER_PRE))
				{
					// PeopleNCAg̃p[^NA
					objPeople.clear();
					// IDZbg
					objPeople.setWhereUserID(strID);
					if (!objPeople.select()) { return null; }

					if (objPeople.next())
					{
						strNameBuf.append(objPeople.getUserName());
					}
				}
				else if (strID.startsWith(GROUP_PRE))
				{
					// O[vNCAg̃p[^NA
					objGroups.clear();
					// IDZbg
					objGroups.setWhereGroupID(strID);
					if (!objGroups.select()) { return null; }

					if (objGroups.next())
					{
						strNameBuf.append(objGroups.getGroupName());
					}
				}
				else if (strID.equals(GROUP_TREE_ROOT))
				{
					String GROUP_ROOT_NAME = getContextString("GROUP_ROOT_NAME");
					strNameBuf.append(GROUP_ROOT_NAME);
				}

				// ؂蕶('/')̕t
				if (i < vecIDList.size() - 1)
				{
					strNameBuf.append(" > ");
				}
			}
		}
		// LÕc[̏ꍇLoXMO擾
		else if (strTreeType.equals(LO_TYPE))
		{
			LoClient objLo = new LoClient();
			for (int i = 0; i < vecIDList.size(); i++)
			{
				// O[vNCAg̃p[^NA
				objLo.clear();
				String strID = (String) vecIDList.get(i);
				String LO_TREE_ROOT = getContextString("LO_TREE_ROOT");
				if (strID.equals(LO_TREE_ROOT))
				{
					String LO_ROOT_NAME = getContextString("LO_ROOT_NAME");
					strNameBuf.append(LO_ROOT_NAME);
				}
				// IDZbg
				objLo.setWhereLoID(strID);
				if (!objLo.select()) { return null; }

				if (objLo.next())
				{
					strNameBuf.append(objLo.getLoTytle());
				}

				// ؂蕶('/')̕t
				if (i < vecIDList.size() - 1)
				{
					strNameBuf.append(" > ");
				}
			}
			// IDXgɋލ\͖擾
			for (int i = 1; i < vecMatIDList.size(); i++)
			{
				// ރ^Cv擾
				String strLoType = objLo.getLoType();
				// ID擾
				String strLoID = objLo.getLoID();
				// ID擾
				String strAuID = (String) vecMatIDList.get(i);
				// RealLOID擾
				String strRealLOID = objLo.getRealLOID();
				// ގʂLoTopClientCX^X
				// LOT[o̎擾
				// LOT[o̎擾
				Environment objEnv = new Environment();
				String strLoServerName = objEnv.getLoServerName();
				// LONXCX^X܂
				LoTopClient objLoTopClient = new LoTopClient(strLoServerName,
						strLoType);
				// ID̎擾
				String strMaterialID = "";
				// LO狳ޏڍ׏擾
				if (objLoTopClient.getData(strRealLOID))
				{
					if (objLoTopClient.getDataLength() > 0)
					{
						LoComData objData = objLoTopClient.getDataInfo(0);
						// ID̎擾
						strMaterialID = objData.getMaterialID();
					}
				}
				// ލ\擾\bhR[܂
				// p[^̏
				Hashtable objParams = new Hashtable();
				objParams.put("MATID", strMaterialID);
				objParams.put("AUID", strAuID);
				if (!objLoTopClient.getMaterialStruct(objParams))
				{
					// ɃG[Lq
					throw new Exception("ގ擾G[");
				}

				MaterialNode objNode = (MaterialNode) objLoTopClient
						.getMaterialStruct();
				strNameBuf.append(" > " + objNode.getTitle());
			}

		}

		strPath_info.add(strNameBuf.toString());
		strPath_info.add(MultibyteCutter(strNameBuf.toString(), 56));
		return strPath_info;
	}

	/**
	 * ̎擾s܂B
	 * 
	 * @param strSrc
	 *            ϊΏە
	 * @param iLength
	 *            L
	 * @return String 
	 */
	private static String MultibyteCutter(String strSrc, int iLength)
			throws Exception
	{
		if (strSrc == null || strSrc.equals("")) { return strSrc; }

		int iByteLen = iLength;

		byte[] Temp = null;
		String ret = "";
		try
		{
			Temp = strSrc.getBytes("Windows-31J");
			if (Temp.length < iLength)
			{
				iByteLen = Temp.length;
			}

			ret = new String(Temp, 0, iByteLen, "Windows-31J");

			if (ret.length() == 0)
			{
				iByteLen--;
				ret = new String(Temp, 0, iByteLen, "Windows-31J");
			}
		}
		catch (Exception e)
		{
			throw e;
		}
		if (Temp.length > iLength)
		{
			return ret + "...";
		}
		else
		{
			return ret;
		}
	}

	/**
	 * w肵LOID ɑΉ LÕXg擾B
	 * $LO_TREE_ROOT (common.vmŒ`)  LOID Ɏw肵Ăꍇ́A$LO_ROOT_NAME 
	 * LOƂĕԋp܂B
	 * 
	 * @param loIdArray Rei܂ł̃pX\ LOID Ȃz
	 *                   (gbvCfbNX 0 ƂāARei܂ŏɃCfbNXU
	 *                    zƂȂĂ)
	 * @return List ̊eLOID ɑΉRei̖OȂ郊Xg
	 */
	public List getLoNameList(String[] loIdArray) throws Exception
	{
		List result = new ArrayList();
		
		LoClient client = new LoClient();
		for (int i=0; i < loIdArray.length; i++)
		{
			String loId = loIdArray[i];
			String name = "";
			String LO_TREE_ROOT = getContextString("LO_TREE_ROOT");
			if (loId.equals(LO_TREE_ROOT))
			{
				String LO_ROOT_NAME = getContextString("LO_ROOT_NAME");
				name = LO_ROOT_NAME;
			}
			else
			{
				client.clear();
				client.setWhereLoID(loId);

				if (client.select())
				{
					if (client.next())
					{
						name = client.getLoTytle();
					}
				}
			}
			result.add(name);
		}
		client = null;
		
		return result;
	}
}