/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	URL񑀍 Velcity ToolNX
//
//		ύX
//			2005.02.19  VK쐬   
//
//	@\
//
//	̃NXURL̑sVelocity ToolNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf.tools;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import jp.co.ntt.lms.xmo.Environment;

/**
 * URL񑀍 Velocity ToolNX
 * 
 * ̃NXURL̑s Velocity ToolNXłB
 * 
 * @author  
 * @version 1.0
 */
public class URLTool
{

	/**
	 * w肵fR[hB
	 * 
	 * @param strURL 
	 * @return ϊ̕
	 * @throws UnsupportedEncodingException
	 */
	public String decodeURL(String strURL) throws UnsupportedEncodingException
	{
		// j[URLfR[h܂

		strURL = URLDecoder.decode(strURL, "UTF-8");

		return strURL;
	}

	/**
	 * URLGR[hs܂B
	 * 
	 * @param strURL
	 *            ϊΏە
	 * @return String URLGR[h
	 */
	public String encodeURL(String strURL) throws UnsupportedEncodingException
	{
		// j[URLGR[h܂
		strURL = URLEncoder.encode(new String(strURL.getBytes("8859_1"),
				"Windows-31J"), "UTF-8");

		return strURL;
	}

	/**
	 * w肵 UTF-8URLGR[hB
	 * 
	 * @param strURL ϊΏە
	 * @return ϊ̕
	 * @throws UnsupportedEncodingException
	 */
	public String encodeURLUTF8(String strURL)
			throws UnsupportedEncodingException
	{
		String result = URLEncoder.encode(strURL, "UTF-8");

		return result;
	}

	/**
	 * URLGR[hs܂B
	 * 
	 * @param strURL
	 *            ϊΏە
	 * @return String URLGR[h
	 */
	public String iniMenuUrlEncode(String strURL)
			throws UnsupportedEncodingException
	{
		// j[URLGR[h܂
		strURL = URLEncoder.encode(new String(strURL.getBytes("8859_1"),
				"UTF-8"), "UTF-8");

		return strURL;
	}

	/**
	 * URLGR[hs܂B
	 * 
	 * @param strURL
	 *            ϊΏە
	 * @param charsetName
	 *            ϊΏە̕ɗp镶Zbg
	 * @param enc
	 *            ϊ̕GR[fBO
	 * @return URLGR[h
	 * @throws UnsupportedEncodingException
	 */
	public String encodeURL(String strURL, String charsetName, String enc)
			throws UnsupportedEncodingException
	{
		return URLEncoder.encode(new String(strURL.getBytes("8859_1"),
				charsetName), enc);
	}

	/**
	 * init@CServerURL擾܂B
	 */
	public String getServerURL(String iniSERVER_URL, String tree_gif_icon_path)
	{
		// XMS2T[oURL̎擾
		Environment objEnv;
		String strServerURL;
		try
		{
			objEnv = new Environment();
			strServerURL = objEnv.getProperty(iniSERVER_URL);
			strServerURL = strServerURL + tree_gif_icon_path;
			return strServerURL;
		}
		catch (Exception e)
		{
			return "";
		}
	}

	/**
	 * w̕ZbgōĐ LoLogCommon_inc.charEncodëڐA
	 * 
	 * @param str
	 * @param charsetName
	 * @return Đꂽ
	 */
	public String reconstructString(String str, String charsetName)
	{
		if (str == null) { return str; }

		String rslt = "";
		try
		{
			rslt = new String(str.getBytes("ISO-8859-1"), charsetName);
		}
		catch (UnsupportedEncodingException e)
		{
			rslt = "";
		}
		return rslt;
	}

	/**
	 * 𕶎Zbg"Windows-31J"ōĐ LoLogCommon_inc.charEncodëڐA
	 * 
	 * @param str
	 * @return Đꂽ
	 */
	public String reconstructString(String str)
	{
		return reconstructString(str, "Windows-31J");
	}
	
	/**
	 * NGp^̒ǉEύX
	 * 
	 * @param url
	 * @param key
	 * @param value
	 * @return
	 */
	public String addOrReplaceParameter(String url, String key, String value) {
		if (url.indexOf(key + "=") == -1) {
			url += "&" + key + "=" + value;
		} else {
			url = url.replaceAll(key + "=\\w*", key + "=" + value);
		}

		return url;
	}
}