/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	j[JX^}CY`}l[W[
//
//		ύX
//			2005.02.19  VK쐬  ~ _i
//
//	@\
//
//	̃NX̓j[JX^}CY`}l[W[NXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.xml.sax.SAXException;

/**
* j[JX^}CY`}l[W[NX
* 
* @author yasu
* @version 1.0
*/
public class CustomMenuManager
{
	// ʂ\萔
	public static final int RESULT_USERDEF = 0;
	public static final int RESULT_GROUPDEF = 1;
	public static final int RESULT_DEFAULTDEF = 2;
	public static final int RESULT_ERROR = 3;
	
	private static final String DEFAULT_BASE_DIR_KEY = "jp.co.ntt.lms.xmf.customizemenu.basedir";

	// JX^j[`IuWFNg
	private CustomMenuDef customMenuDef;
	
	private String baseDir = null;
	
	/**
	 * ftHg`̓ǂݍ݂sB
	 * 
	 * @param servletContext ServletContextIuWFNg
	 * @return int ʂ\萔
	 */
	public int loadDefaultDef(ServletContext servletContext)
	{
		return loadDef(servletContext, "", "");
	}

	/**
	 * `t@C̓ǂݍ݂sB
	 * 
	 * @param servletContext ServletContextIuWFNg
	 * @param userId `t@Cǂݍރ[UID
	 * @param groupId `t@CǂݍރO[vID
	 * @return int ʂ\萔
	 */
	public int loadDef(ServletContext servletContext, String userId, String groupId)
	{
		return loadDef(servletContext, DEFAULT_BASE_DIR_KEY, userId, groupId);
	}
	
	/**
	 * `t@C̓ǂݍ݂sB
	 * 
	 * @param servletContext ServletContextIuWFNg
	 * @param baseDirKey x[XfBNg̃L[
	 * @param userId `t@Cǂݍރ[UID
	 * @param groupId `t@CǂݍރO[vID
	 * @return int ʂ\萔
	 */
	protected int loadDef(ServletContext servletContext, String baseDirKey, String userId, String groupId)
	{
		int result = RESULT_ERROR;
		DocumentBuilder parser = null;
		try
		{
			parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			baseDir = servletContext.getInitParameter(baseDirKey);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return result;
		}
		if (baseDir == null)
		{
			return result;
		}
		else
		{
			if (!baseDir.endsWith("/"))
			{
				baseDir = baseDir.concat("/");
			}
		}
		try
		{
			//ftHg`̓ǂݍ
			loadDefaultDef(parser, servletContext, baseDir, userId, groupId);
			result = RESULT_DEFAULTDEF;
			if (userId == null) userId = "";
			if (groupId == null) groupId = "";
			if (userId.length() == 0 && groupId.length() == 0)
			{
				return result;
			}
			//O[v`̓ǂݍ
			loadGroupDef(parser, servletContext, baseDir, userId, groupId);
			result = RESULT_GROUPDEF;
			//[U[`̓ǂݍ
			loadUserDef(parser, servletContext, baseDir, userId, groupId);
			result = RESULT_USERDEF;
		}
		catch (IOException ex1)
		{
			switch (result)
			{
			case 3:
				//ftHg`ǂݍݎɃG[
				//ُIƂ
				break;
			case 2:
				//O[v`ǂݍݎɃG[
				try
				{
					//[U[`̓ǂݍ
					loadUserDef(parser, servletContext, baseDir, userId, groupId);
					result = RESULT_USERDEF;
				}
				catch (SAXException ex)
				{
					ex.printStackTrace();
					result = RESULT_ERROR;
				}
				catch (IOException ex)
				{
					//O[v`[U[`ȂB
				}
				break;
			case 1:
				break;
			}
		}
		catch (SAXException e)
		{
			e.printStackTrace();
			result = 3;
		}
		return result;
	}
	
	/**
	 * JX^j[`IuWFNg擾B
	 * 
	 * @return CustomMenuDef JX^j[`IuWFNg
	 */
	public CustomMenuDef getCustomMenuDef()
	{
		return customMenuDef;
	}

	/**
	 * ftHg`̓ǂݍ݂sB
	 * 
	 * @param parser DocumentBuilderIuWFNg
	 * @param servletContext ServletContextIuWFNg
	 * @param baseDir x[XfBNgL[
	 * @param userId [U[ID
	 * @param groupId O[vID
	 * @throws SAXException
	 * @throws IOException
	 */
	protected void loadDefaultDef(DocumentBuilder parser,
			ServletContext servletContext, String baseDir, String userId, String groupId) throws SAXException,
			IOException
	{
		CustomMenuDef menuDef = new CustomMenuDef(CustomMenuDef.DEFTYPE_DEFAULT, userId, groupId);
		String path = baseDir + "custom-menudef.xml";
		menuDef.loadMenuDef(parser, servletContext.getResourceAsStream(path));
		customMenuDef = menuDef;
	}

	/**
	 * O[v`̓ǂݍ݂sB
	 * 
	 * @param parser DocumentBuilderIuWFNg
	 * @param servletContext ServletContextIuWFNg
	 * @param baseDir x[XfBNgL[
	 * @param userId [U[ID
	 * @param groupId O[vID
	 * @throws SAXException
	 * @throws IOException
	 */
	protected void loadGroupDef(DocumentBuilder parser,
			ServletContext servletContext, String baseDir, String userId, String groupId) throws SAXException,
			IOException
	{
		CustomMenuDef menuDef = new CustomMenuDef(CustomMenuDef.DEFTYPE_GROUP, userId, groupId);
		String path = "";
		if (groupId != null && groupId.length() > 0)
		{
			path = baseDir + "groups/" + groupId + "/custom-menudef.xml";
		}
		else
		{
			path = baseDir + "groups/custom-menudef.xml";
		}
		menuDef.loadMenuDef(parser, servletContext.getResourceAsStream(path));
		customMenuDef = menuDef;
	}

	/**
	 * [U[`̓ǂݍ݂sB
	 * 
	 * @param parser DocumentBuilderIuWFNg
	 * @param servletContext ServletContextIuWFNg
	 * @param baseDir x[XfBNgL[
	 * @param userId [U[ID
	 * @param groupId O[vID
	 * @throws SAXException
	 * @throws IOException
	 */
	protected void loadUserDef(DocumentBuilder parser,
			ServletContext servletContext, String baseDir, String userId, String groupId) throws SAXException,
			IOException
	{
		CustomMenuDef menuDef = new CustomMenuDef(CustomMenuDef.DEFTYPE_USER, userId, groupId);
		String path = "";
		if (userId != null && userId.length() > 0)
		{
			path = baseDir + "users/" + userId + "/custom-menudef.xml";
		}
		else
		{
			path = baseDir + "users/custom-menudef.xml";
		}
		menuDef.loadMenuDef(parser, servletContext.getResourceAsStream(path));
		customMenuDef = menuDef;
	}
	
	/**
	 * JX^j[`t@Cɏo͂B
	 * 
	 * @param servletContext ServletContextIuWFNg
	 * @throws IOException IOG[O
	 */
	public void saveDefaultDef(ServletContext servletContext)
		throws IOException
	{
		String path = baseDir + "custom-menudef.xml";
		customMenuDef.saveMenuDef(servletContext.getRealPath(path));
	}
	
	/**
	 * JX^j[`t@Cɏo͂B
	 * 
	 * @param servletContext ServletContextIuWFNg
	 * @param CustomMenuDef JX^j[`IuWFNg
	 * @throws IOException IOG[O
	 */
	public void saveDefaultDef(ServletContext servletContext, CustomMenuDef menuDef)
		throws IOException
	{
		customMenuDef = menuDef;
		baseDir = servletContext.getInitParameter(DEFAULT_BASE_DIR_KEY);
		if (!baseDir.endsWith("/"))
		{
			baseDir = baseDir.concat("/");
		}
		saveDefaultDef(servletContext);
	}
		
}
