/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormSessionDataAccess
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * ScormSessione[uւ̃ANZXNXB
 * @author T.Nishiki
 */
public final class ScormSessionDataAccess extends ScormDataAccess {
	/**
	 * e[uB
	 */
	public static final String TABLE_NAME = "ScormSession";

	/**
	 * e[uE񖼁F[UIDB
	 */
	public static final String USERID = "UserID";

	/**
	 * e[uE񖼁FLOIDB
	 */
	public static final String LOID = "LOID";

	/**
	 * e[uE񖼁FwKZbV񐔁B
	 */
	public static final String STUDY_SESSION_COUNT = "StudySessionCount";

	/**
	 * e[uE񖼁FZbVIDB
	 */
	public static final String SESSIONID = "SessionID";

	/**
	 * RXgN^
	 **/
	public ScormSessionDataAccess() {
		super( TABLE_NAME );
	}

	/**
	 * w肵[UAނŏIwK̊wKZbV񐔂擾܂B<br>
	 * nꂽ[UIDALOIDɂāAőƂȂwKZbV񐔂擾
	 * R[h擾܂BR[h݂ȂꍇAO߂܂B
	 * @param userID [UIDB
	 * @param loID ނLOIDB
	 * @param dataAccess f[^ANZXNXEIuWFNgB
	 * @return ŏIwK̊wKZbV񐔁B
	 * @throws LOException f[^x[XANZXɎsꍇB
	 */
	public static int getLastStudySessionCount(
		String userID,
		String loID,
		DataAccess dataAccess)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"HEAD getLastStudySessionCount("
				+ userID + "," + loID + "," + dataAccess + ")",
			DebugLog.ROW);
		// wKZbV񐔁ĩ\bh̖߂lj
		int studySessionCount = 0;
		// ʃZbg
		ResultSet resultSet = null;
		// tOiȂtruej
		boolean successFlag = false;
		try {
			String query = null;
			query = "select max(" +  STUDY_SESSION_COUNT + ")"
				+ " as lastSession"
				+ " from " + TABLE_NAME
				+ " where userid='" + userID + "'"
				+ " and loid='" + loID + "'";

			resultSet = dataAccess.executeQuery(query);
			if (resultSet.next()) {
				studySessionCount = resultSet.getInt("lastSession");
			}
			// tryubNŌ܂œBꍇAƂB
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(
				ScormSessionDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			// OꍇA܂ŗOĂȂ΁AX[
			if (resultSet != null ) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					if ( successFlag == true ) {
						DebugLog.write(
							ScormSessionDataAccess.class, e, DebugLog.HIGHT);
						throw new LOException(e.getMessage());
					}
				}
			}
		}

		// \bhIO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"TAIL getLastStudySessionCount("
				+ userID + "," + loID + "," + dataAccess + ")"
				+ " return " + studySessionCount,
			DebugLog.ROW);
		return studySessionCount;
	}



	/**
	 * ScormSessione[uւ݂̏s܂B<br>
	 * &lt;learnsession&gt;vfƂɌĂяoAR[hǉ܂B
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	public static void insert(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData)
		throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"HEAD insert(dataAccess,endLearnData)",
			DebugLog.ROW);

		try {
			////////////////////////////////////////////////////////////////////
			// eJ̒l擾
			//==================================================================
			// Jƒl̃}bv
			ScormColumnInfo[] columnInfos =
				makeColumnInfos(endLearnData);
			////////////////////////////////////////////////////////////////////
			// SQL̐
			String query =
				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
			////////////////////////////////////////////////////////////////////
			// SQL̎s
			dataAccess.execute(query.toString());
		}
		catch (LOException e) {
			throw e;
		}
		catch (SQLException e) {
			DebugLog.write(
				ScormInteractionDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"TAIL insert(dataAccess,endLearnData)",
			DebugLog.ROW);
	}

	/**
	 * ScormSessione[ũJz𐶐܂B<br>
	 * @param endLearnData wKIB
	 * @return ScormSessione[ũJzB
	 * @throws LOException m[h̃f[^擾sꍇB
	 */
	private static ScormColumnInfo[] makeColumnInfos(
		ScormLoEndLearnData endLearnData)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"HEAD makeColumnInfos(endLearnData)",
			DebugLog.ROW);

		// ̃\bh̖߂l
		ScormColumnInfo[] columnInfos = null;
		// z񐶐pXg
		List columnInfoList = new ArrayList();
		////////////////////////////////////////////////////////////////////////
		// endLearnData擾łf[^JƂĐݒ
		//======================================================================
		// [UID
		String userID = endLearnData.getUserID();
		ScormColumnInfo userIDColumn = new ScormColumnInfo(
			USERID, userID,
			ScormColumnInfo.COLUMN_TYPE_STRING, 0, 0);
		columnInfoList.add(userIDColumn);
		// LOID
		String loID = endLearnData.getLoID();
		ScormColumnInfo loIDColumn = new ScormColumnInfo(
			LOID, loID,
			ScormColumnInfo.COLUMN_TYPE_STRING, 0, 0);
		columnInfoList.add(loIDColumn);
		// wKZbV
		int studySessionCount = endLearnData.getStudySession();
		ScormColumnInfo studySessionCountColumn = new ScormColumnInfo(
			STUDY_SESSION_COUNT, Integer.toString(studySessionCount),
			ScormColumnInfo.COLUMN_TYPE_NUMBER, 0, 0);
		columnInfoList.add(studySessionCountColumn);
		// ZbVID
		int sessionID = endLearnData.getLoginSession();
		ScormColumnInfo sessionIDColumn = new ScormColumnInfo(
			SESSIONID, Integer.toString(sessionID),
			ScormColumnInfo.COLUMN_TYPE_STRING, 0, 0);
		columnInfoList.add(sessionIDColumn);
		////////////////////////////////////////////////////////////////////////
		// Xgzɕϊ
		columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
		columnInfoList.toArray(columnInfos);

		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"TAIL makeColumnInfos(endLearnData)"
				+ " return " + columnInfos,
			DebugLog.ROW);
		return columnInfos;
	}

	/**
	 * w肳ꂽ[UAނ̑gݍ킹̃O폜܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID 폜Ώۂ̃[UIDB
	 * @param loID 폜Ώۂ̋ނLOIDB
	 * @throws LOException f[^x[XANZXɗOꍇB
	 */
	public static void delete(
		DataAccess dataAccess, String userID, String loID)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"HEAD delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
		try {
			// WHERE̐
			StringBuffer queryWhere = new StringBuffer();
			if (loID != null) {
				queryWhere.append(" and " + LOID + "='" + loID + "'" );
			}
			if (userID != null) {
				queryWhere.append(" and " + USERID + "='" + userID + "'" );
			}
			// 폜NG̐
			StringBuffer query = new StringBuffer();
			query.append("delete from " + TABLE_NAME );
			if (queryWhere.length() > 0) {
				query.append(" where " + queryWhere.substring(5) );
			}
			// 폜NG̎s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			dataAccess.execute(queryString);
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
		}
		// \bhIO
		DebugLog.write(
			ScormSessionDataAccess.class,
			"TAIL delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
	}
}
