/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormManifestUtil
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm;

import java.io.File;
import java.util.Properties;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.util.DebugLog;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * SCORMލ\f[^Ɋւ郆[eBeB\bh񋟂NXB
 * @author T.Nishiki
 */
public class ScormManifestUtil {

	/**
	 * w肵IDɑΉ鋳ލ\t@CDOMDocument擾܂B<br>
	 *
	 * @param materialListPath ލ\t@ĈpXB
	 * @param materialID 擾鋳ނ̋IDB
	 * @return materialIDɑΉ鋳ލ\`t@CDOMDocumentB
	 *          Ή鋳ލ\`t@C݂Ȃꍇ́Anull߂܂B
	 */
	public static Document getManifestXmlDocument(
		String materialListPath,
		String materialID) {
		// \bhJnO
		DebugLog.write(
			ScormManifestUtil.class,
			"HEAD getManifestXmlDocument("
				+ materialListPath + "," + materialID + ")",
			DebugLog.ROW);

		// ލ\t@C\IuWFNgB
		File manifestFile = null;
		// ̃\bh̖߂l
		Document document = null;

		// ލ\t@CEIuWFNg擾B
		manifestFile = getManifestFile(materialListPath, materialID);
		try {
			// DOM DocumentɕϊB
			document = ScormLoUtil.transformXmlFileToDocument(manifestFile);
		}
		catch (Exception e) {
			// OĂ܂B
		}

		// \bhIO
		DebugLog.write(
			ScormManifestUtil.class,
			"TAIL getManifestXmlDocument("
				+ materialListPath + "," + materialID + ")"
				+ " return " + document,
			DebugLog.ROW);
		return document;
	}

	/**
	 * w肵IDɑΉ鋳ލ\t@CXMLf[^擾܂B<br>
	 *
	 * @param materialListPath ލ\t@ĈpXB
	 * @param materialID 擾鋳ނ̋IDB
	 * @param outFormat o̓IvVEvpeBB
	 * @return materialIDɑΉ鋳ލ\`t@CXMLB
	 *          Ή鋳ލ\`t@C݂Ȃꍇ́A󕶎߂܂B
	 * @see javax.xml.transform.Transformer#setOutputProperties(Properties)
	 *       o̓IvVEvpeBB
	 */
	public static String getManifestXmlString(
		String materialListPath,
		String materialID,
		Properties outFormat) {
		// \bhJnO
		DebugLog.write(
			ScormManifestUtil.class,
			"HEAD getManifestXmlString("
				+ materialListPath + "," + materialID + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String xmlString = null;
		try {
			File manifestFile = getManifestFile(materialListPath, materialID);
			xmlString = ScormLoUtil.transformXmlFileToString(
					manifestFile, outFormat);
		}
		catch (Exception e) {
			// OĂ܂B
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
			xmlString = "";
		}

		// \bhIO
		DebugLog.write(
			ScormManifestUtil.class,
			"TAIL getManifestXmlString("
				+ materialListPath + "," + materialID + ")"
				+ " return " + xmlString,
			DebugLog.ROW);
		return xmlString;
	}

	/**
	 * ލ\`AID擾܂B
	 * @param manifestDoc ލ\`XMLDOM DocumentB
	 * @return ID擾łꍇ͂̒lA
	 *          擾łȂꍇnull߂܂B
	 */
	public static String getMaterialID(Document manifestDoc) {
		// \bhJnO
		DebugLog.write(
			ScormManifestUtil.class,
			"HEAD getMaterialID(" + manifestDoc + ")",
			DebugLog.ROW);

		String materialID = null;
		Node materialIDNode = null;
		try {
			materialIDNode =
				XPathAPI.selectSingleNode(
					manifestDoc,
					ScormLoConstant.XPATH_MATERIAL_ID);
			materialID = materialIDNode.getNodeValue();
		}
		catch (Exception e) {
			// OĂ܂B
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
		}

		// \bhIO
		DebugLog.write(
			ScormManifestUtil.class,
			"TAIL getMaterialID(" + manifestDoc + ")"
				+ " return " + materialID,
			DebugLog.ROW);
		return materialID;
	}

	/**
	 * ލ\`Aރ^Cg擾܂B
	 * @param manifestDoc ލ\`XMLDOM DocumentB
	 * @return ރ^Cg擾łꍇ͂̒lA
	 *          擾łȂꍇnull߂܂B
	 */
	public static String getMaterialTitle(Document manifestDoc) {
		// \bhJnO
		DebugLog.write(
			ScormManifestUtil.class,
			"HEAD getMaterialTitle(" + manifestDoc + ")",
			DebugLog.ROW);

		String materialTitle = null;
		Node materialTitleNode = null;
		try {
			materialTitleNode =
				XPathAPI.selectSingleNode(
					manifestDoc,
					ScormLoConstant.XPATH_MATERIAL_TITLE);
			materialTitle = materialTitleNode.getNodeValue();
		}
		catch (Exception e) {
			// OĂ܂B
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
		}

		// \bhIO
		DebugLog.write(
			ScormManifestUtil.class,
			"TAIL getMaterialTitle(" + manifestDoc + ")"
				+ " return " + materialTitle,
			DebugLog.ROW);
		return materialTitle;
	}

	/**
	 * o^SCORMނ̋ލ\`t@C擾܂B<br>
	 *
	 * @param materialID IDB
	 * @return ލ\`t@C\t@CEIuWFNgB
	 * @throws LOException ݒt@C̎擾Ɏsꍇ
	 */
	public static File getManifestTempFile(String materialID)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormManifestUtil.class,
			"HEAD getManifestTempFile(" + materialID + ")",
			DebugLog.ROW);

		ScormLoEnv env = new ScormLoEnv();
		String materialTempPath = env.getTempMaterialPath();
		File manfestTempFile = getManifestFile(materialTempPath, materialID);

		// \bhIO
		DebugLog.write(
			ScormManifestUtil.class,
			"TAIL getManifestTempFile(" + materialID + ")"
				+ " return " + manfestTempFile,
			DebugLog.ROW);
		return manfestTempFile;
	}

	/**
	 * o^ςSCORMނ̋ލ\`t@C擾܂B<br>
	 *
	 * @param materialID IDB
	 * @return ލ\`t@C\t@CEIuWFNgB
	 * @throws LOException ݒt@C̎擾Ɏsꍇ
	 */
	public static File getManifestPathFile(String materialID)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormManifestUtil.class,
			"HEAD getManifestPathFile(" + materialID + ")",
			DebugLog.ROW);

		ScormLoEnv env = new ScormLoEnv();
		String materialTempPath = env.getMaterialPath();
		File manfestPathFile = getManifestFile(materialTempPath, materialID);

		// \bhIO
		DebugLog.write(
			ScormManifestUtil.class,
			"TAIL getManifestPathFile(" + materialID + ")"
				+ " return " + manfestPathFile,
			DebugLog.ROW);
		return manfestPathFile;
	}

	/**
	 * ލ\t@CFileIuWFNg擾܂B<br>
	 * @param materialListPath ލ\t@ĈpXB
	 * @param materialID 擾鋳ނ̋IDB
	 * @return materialListPathAmaterialID画fł
	 *          ލ\t@CFileIuWFNg߂܂B
	 */
	private static File getManifestFile(
		String materialListPath,
		String materialID) {

		// ̃\bh̖߂l
		File manifestFile = null;
		// ލ\t@CpX܂B
		manifestFile =
			new File(
				new File(materialListPath, materialID),
				ScormLoConstant.MANIFEST_FILE_NAME);
		return manifestFile;
	}
}
