/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB
uIWiR[hv́uJҁv́A{dMdbЂłB
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004
{dMdb łB
SĂ̌ۂ܂B
uRgr[^vF_____________________________________


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION.
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormLo
//	ύX
//		2004.02.01	VK쐬
//		2004.09.14	M004	A.Shimoma
//

package jp.co.ntt.lms.lo.scorm;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.LoConstant;
import jp.co.ntt.lms.lo.LoLogSessionDataAccess;
import jp.co.ntt.lms.lo.LoPropertyDef;
import jp.co.ntt.lms.lo.LoServer;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.Lo.MaterialData;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.FileControl;

import org.w3c.dom.Document;

/**
 * SCORM LOT[oNXłB<BR>
 * @author T.Nishiki
 */
public class ScormLo extends LoServer implements Remote {
	/**
	 * RXgN^B
	 * @throws LOException ɎsꍇB
	 * @throws RemoteException RMI֘ȀɎsꍇB
	 */
	public ScormLo() throws LOException, RemoteException {
		super();

		// \bhJnO
		DebugLog.write(ScormLo.class, "HEAD ScormLo()", DebugLog.ROW);

		try {
			mobjMenuMakerIF = new ScormMenuMaker();
			mobjLearnManagerIF = new ScormLearnManager();
			mobjSetupIF = new ScormSetup();

			// SCORMLOTYPEuQOvLOTYPEe[uɑ݂ꍇ
			if (getLoType(LoConstant.LO_TYPE_SCORM)) {

				// SCORM LO T[o܂B
				ScormServerInfoControl control = null;
				control = ScormServerInfoControl.getInstance();
				control.initialize();
			}
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			throw new LOException(this.getClass().getName() + " :: [hs ");
		}

		// \bhIO
		DebugLog.write(ScormLo.class, "TAIL ScormLo()", DebugLog.ROW);
	}

	/**
	 * Loɓo^Ă郁\bhN܂B<br>
	 * ݗLȃ\bh́A{@link #getServerInfo()}łB
	 * @param methodName N郁\bh́B<br>
	 * @param params p[^B
	 * @return N\bh߂ꂽVectorB
	 * @see #getServerInfo()
	 * @see #isExistLoginSession(Hashtable)
	 * @see jp.co.ntt.lms.lo.LoTop#execute(String, Hashtable)
	 * @see ScormLoConstant#METHOD1
	 * @see ScormLoConstant#METHOD2
	 * @see ScormLoConstant#METHOD3
	 * @see ScormLoConstant#METHOD4
	 */
	public Vector execute(String methodName, Hashtable params) {

		Vector returnValue = null;

		if (methodName.equals(ScormLoConstant.METHOD1)) {
			returnValue = getServerInfo();
		}
		else if (methodName.equals(ScormLoConstant.METHOD2)) {
			returnValue = isExistLoginSession(params);
		}
		else if (methodName.equals(ScormLoConstant.METHOD3)) {
			returnValue = insertCommonLog(params);
		}
		else {
			returnValue = new Vector();
		}
		return returnValue;
	}

	/**
	 * SCORM LOT[õXg擾܂B<br>
	 * @return OԖڂ̗vfɏbZ[WA
	 *          PԖڂɁuScormServerInfovfƂListvi[ꂽVectorB
	 */
	public Vector getServerInfo() {
		// \bhJnO
		DebugLog.write(
			this.getClass(), "HEAD getServerInfo()",
			DebugLog.ROW);

		Vector returnValue = new Vector();
		List serverInfoList = null;
		MessageData message = null;

		// T[o񃊃Xg擾܂
		ScormServerInfoControl control =
			ScormServerInfoControl.getInstance();
		serverInfoList = control.getServerInfoList();

		returnValue.add(message);
		returnValue.add(serverInfoList);

		// \bhIO
		DebugLog.write(
			this.getClass(), "TAIL getServerInfo() return " + returnValue,
			DebugLog.ROW);
		return returnValue;
	}

	/**
	 * OCZbV񐔂݂邩`FbN܂B<br>
	 * @param params p[^B
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormConstant.KEY_USERID</td>
	 * 		<td>[UID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormConstant.KEY_LOID</td>
	 * 		<td>LOID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormConstant.KEY_LOGIN_SESSION</td>
	 * 		<td>OCZbV</td>
	 * 	</tr>
	 * </table><br>
	 * @return OԖڂ̗vfɏbZ[WA
	 *          PԖڂɁu݂ȂtrueA݂ȂȂfalse
	 *           bp[NXi{@link Boolean}jIuWFNgvi[VectorB
	 */
	public Vector isExistLoginSession(Hashtable params) {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD isExistLoginSession(" + params + ")",
			DebugLog.ROW);

		Vector returnValue = null;

		// T[o񃊃Xg擾܂
		try {
			// p[^̎擾
			String userID = (String)params.get(ScormLoConstant.KEY_USERID);
			String loID = (String)params.get(ScormLoConstant.KEY_LOID);
			String loginSession = (String)params.get(
							ScormLoConstant.KEY_LOGIN_SESSION);
			// 
			boolean result = LoLogSessionDataAccess.isExistLoginSession(
								userID, loID, loginSession);
			// ʂ߂lɊi[
			returnValue = new Vector();
			returnValue.add(null);
			returnValue.add(Boolean.valueOf(result));
		}
		catch (LOException e) {
			DebugLog.write(this.getClass(), e.getMessage(), DebugLog.HIGHT);
			MessageData message = createSystemErrMessage(e.getMessage());
			returnValue = new Vector();
			returnValue.add(message);
		}


		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL isExistLoginSession(" + params + ")"
			+ " return " + returnValue,
			DebugLog.ROW);
		return returnValue;
	}

	/**
	 * ʃOo^܂B<br>
	 * @param params p[^B
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormConstant.KEY_END_LEARN_DATA</td>
	 * 		<td>wKIScormLoEndLearnData</td>
	 * 	</tr>
	 * </table><br>
	 * @return OԖڂ̗vfɏbZ[Wi[VectorB
	 * @see ScormLoEndLearnData
	 */
	public Vector insertCommonLog(Hashtable params) {
		// \bhJnO
		DebugLog.write( this.getClass(),
			"HEAD insertCommonLog(" + params + ")",
			DebugLog.ROW);

		Vector returnValue = null;

		// T[o񃊃Xg擾܂
		DataAccess dataAccess = new DataAccess();
		try {
			dataAccess.trans();
			////////////////////////////////////////////////////////////////////
			// f[^̎擾
			ScormLoEndLearnData endLearnData =
					(ScormLoEndLearnData)params.get(
							ScormLoConstant.KEY_END_LEARN_DATA);
			////////////////////////////////////////////////////////////////////
			// Ȏ}(IR~̏ꍇA}Ȃj
			String reason = endLearnData.getReason();
			if (reason.equals(ScormLoConstant.PARAM_REASON_ABANDON) == false) {
				ScormLoLogControl logControl = new ScormLoLogControl();
				logControl.insertRestOfAiccLog(dataAccess, endLearnData);
			}
			// ʂ߂lɊi[
			returnValue = new Vector();
			returnValue.add(null);
			// R~bg
			dataAccess.commit();
		}
		catch (Exception e) {
			MessageData message = createSystemErrMessage(e.getMessage());
			DebugLog.write(this.getClass(), message, DebugLog.HIGHT);

			try {
				dataAccess.rollback();
			}
			catch (Exception e1) {
				DebugLog.write(this.getClass(), e1, DebugLog.HIGHT);
			}

			returnValue = new Vector();
			returnValue.add(message);
		}


		// \bhIO
		DebugLog.write( this.getClass(),
			"TAIL insertCommonLog(" + params + ")"
			+ " return " + returnValue,
			DebugLog.ROW);
		return returnValue;
	}

	/**
	 * ރXg擾܂B<br>
	 * @param params p[^B
	 *                ȉ̃f[^܂܂Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>&quot;METHOD&quot;</td>
	 * 		<td>INSERTAUPDATEȂǂ̃\bh</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>&quot;MATERIALID&quot;</td>
	 * 		<td>IDBMETHODINSERT̏ꍇAsvB</td>
	 * 	</tr>
	 * </table>
	 * @return OԖڂ̗vfɏbZ[WA
	 *          PԖڂɁuMaterialData̔zvi[ꂽVectorB
	 * @see jp.co.ntt.lms.lo.LoTop#getMaterialList(java.util.Hashtable)
	 */
	public Vector getMaterialList(Hashtable params) {
		// \bhJnO
		DebugLog.write(
			this.getClass(), "HEAD getMaterialList(" +  params + ")",
			DebugLog.ROW);

		Vector returnValue = new Vector();

		MessageData message = null;
		MaterialData[] materialArray = null;
		try {
			String methodType = (String)params.get("METHOD");
			String materialID = (String)params.get("MATERIALID");

			// TempfBNgpX擾
			String strTempMaterialPath = "";
			ScormLoEnv scormEnv = new ScormLoEnv();
			//o^̏ꍇATempfBNgpX擾
			if (methodType.equals("INSERT")) {
				strTempMaterialPath = scormEnv.getTempMaterialPath();
				
				
			}
			//o^ȊȌꍇAރfBNgpX擾
			else {
				strTempMaterialPath = scormEnv.getMaterialPath();
			}

			String[] strDirList =
				FileControl.getFileList(
					strTempMaterialPath,
					FileControl.DIR_LIST);

			Vector materialList = new Vector();
			for (int i = 0; i < strDirList.length; i++) {
				if ((methodType.equals("INSERT") == false)
					&& (materialID.equals(strDirList[i]) == false)) {
					continue;
				}

/////////////////////////////////////////////////////////////////////////
//ǉC START
//Author:NTTR JSATOU
//DATE:20050217
//eFimsmanifest.xmlt@C̗LmF
/////////////////////////////////////////////////////////////////////////
				boolean exists_flag = false;
				
				    //p[T[̎擾
					File dummy = new File(strTempMaterialPath);
					char separator = dummy.separatorChar;
				
					//imsmanifest.xmlt@CIuWFNg̐
					String strManifestFilePath = strTempMaterialPath + separator + strDirList[i] + separator + ScormLoConstant.MANIFEST_FILE_NAME;
					File objManifestFile = new File(strManifestFilePath);

					//fobNvg
					DebugLog.write(
							this.getClass(), "ManifestXML_Path(" + strManifestFilePath + ")",
							DebugLog.ROW);
					
					//imsmanifest.xmlt@C̑݊mF
					//߂lFboolean
					//true:݂
					//false:݂Ȃ
					exists_flag = objManifestFile.exists();

					
				//if (methodType.equals("INSERT") && (exists_flag==false)){
				if (exists_flag==false){
				    //INSERTmanifest.xmlȂȂȂ	
				}else{
/////////////////////////////////////////////////////////////////////////
//ǉ@END
/////////////////////////////////////////////////////////////////////////				    
				    // ލ\`f[^擾
				    Document manifestDoc = null;
				    manifestDoc =
				        ScormManifestUtil.getManifestXmlDocument(
				                strTempMaterialPath,
				                strDirList[i]);
				    // ލ\`擾łȂꍇ́A
				    if (manifestDoc == null) {
				        continue;
				    }
				    // ރf[^Xgɒǉ
				    // ID

//					@20040624 MOD NTTR IDXML擾CPi[tH_ɕύX
//					String manfestMaterialID =
//					ScormManifestUtil.getMaterialID(manifestDoc);
				    String manfestMaterialID = strDirList[i];
//					MOD END
				    // ރ^Cg
				    String manfestMaterialTitle =
					ScormManifestUtil.getMaterialTitle(manifestDoc);

				    MaterialData materialData = new MaterialData();
				    materialData.setMaterialID(manfestMaterialID);
				    materialData.setTitle(manfestMaterialTitle);
				    materialList.add(materialData);

				    // o^ȊO͂P΁AIB
				    if (methodType.equals("INSERT") == false) {
				        break;
				    }
				}
			}
			// Vectorރf[^Xg^ɕϊ
			materialArray = new MaterialData[materialList.size()];
			materialList.copyInto(materialArray);
		}
		catch (Exception e) {
			// ލ\[hs
			DebugLog.write(this.getClass(), e.getMessage(), DebugLog.HIGHT);
			message = createSystemErrMessage(e.getMessage());
		}
		returnValue.add(message);
		returnValue.add(materialArray);

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL getMaterialList(" +  params + ") return " + returnValue,
			DebugLog.ROW);
		return returnValue;
	}

	/**
	 * f[^擾܂B<br>
	 * f[^x[XɃANZXAp[^Ɏw肳ꂽScorm LOf[^擾܂B
	 * ڍׂ́A{@link ScormLoDataAccess#getLoData(Hashtable)}QƂĂB
	 *
	 * @param params p[^B
	 * @return {@link ScormLoDataAccess#getLoData(Hashtable)}ԋplB
	 * @see ScormLoDataAccess#getLoData(Hashtable)
	 * @see jp.co.ntt.lms.lo.LoTop#getData(java.util.Hashtable)
	 */
	public Vector getData(Hashtable params) {
		// \bhJnO
		DebugLog.write(
			this.getClass(), "HEAD getData(" +  params + ")",
			DebugLog.ROW);

		Vector returnValue = new Vector();
		MessageData message = null;
		Object body = null;
		try {
			ScormLoDataAccess dataAccess = new ScormLoDataAccess();
			body = dataAccess.getLoData(params);
		}
		catch (LOException e) {
			// bZ[Wf[^IuWFNg擾łȂꍇ
			// VXeG[bZ[WIuWFNg𐶐
			message = createSystemErrMessage(e.getMessage());
		}
		// ߂IuWFNg𐶐
		returnValue.add(message);
		returnValue.add(body);

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL getData(" +  params + ") return " + returnValue,
			DebugLog.ROW);
		return returnValue;
	}

	/**
	 * SCORM LOʃO폜܂B<br>
	 * f[^x[XɃANZXAp[^Ɏw肳ꂽScorm LOf[^擾܂B
	 *
	 * @param params p[^B
	 * @return MessageDataPvfƂVectorBꍇ͗vf̒lnullB
	 * @see jp.co.ntt.lms.lo.LoTop#deleteIndividualLog(Hashtable)
	 * @see MessageData
	 */
	public Vector deleteIndividualLog(Hashtable params) {
		// \bhJnO
		DebugLog.write(
			getClass(), "HEAD deleteIndividualLog(" +  params + ")",
			DebugLog.ROW);

		Vector returnValue = new Vector();
		MessageData message = null;
		DataAccess dataAccess = new DataAccess();
		try {
			// p[^̎擾
			String userID = (String)params.get(LoPropertyDef.USER);
			String loID = (String)params.get(LoPropertyDef.LOID);
			// gUNVJn
			dataAccess.trans();

			// Scorm_Attempte[u烍O폜
			ScormAttemptDataAccess.delete(dataAccess, userID, loID);
			// Scorm_Interactione[u烍O폜
			ScormInteractionDataAccess.delete(dataAccess, userID, loID);
			// Scorm_LearnerCommente[u烍O폜
			ScormLearnerCommentDataAccess.delete(dataAccess, userID, loID);
			// Scorm_LMSCommente[u烍O폜
			ScormLMSCommentDataAccess.delete(dataAccess, userID, loID);
			// Scorm_Objectivee[u烍O폜
			ScormObjectiveDataAccess.delete(dataAccess, userID, loID);
			// Scorm_Sessione[u烍O폜
			ScormSessionDataAccess.delete(dataAccess, userID, loID);

			//gUNVR~bg
			dataAccess.commit();
		}
		catch (Exception e) {
			// Oꍇ̓gUNV[obN
			try {
				dataAccess.rollback();
			}
			catch (SQLException e1) {
				// \bhJnO
				DebugLog.write( getClass(), e1, DebugLog.ROW);
			}
			message = createSystemErrMessage(e.getMessage());
		}

		returnValue.add(message);

		// \bhIO
		DebugLog.write( getClass(),
			"TAIL deleteIndividualLog(" +  params + ")"
				+ " return " + returnValue,
			DebugLog.ROW);

		return returnValue;
	}

	/**
	 * ScormLoʃOXV
	 *
	 * @param htbParam p[^Xg
	 * @return Vector bZ[Wf[^
	 */
	public Vector changeTypeUpdateIndividualLog(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		MessageData objMd = null;
		try {
			changeTypeUpdate( htbParam );
		}
		catch(LOException le)
		{
			// bZ[Wf[^IuWFNg擾łȂꍇ
			// VXeG[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(le.getMessage());
		}
		catch(Exception e)
		{
			// bZ[Wf[^IuWFNg擾łȂꍇ
			// VXeG[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(e.getMessage());
		}

		vecRet.add(objMd);
		return vecRet;
	}

	/**
	 * Scorm ʃOe[u֍XVs܂B
	 *
	 * @param htbParam
	 * @exception LOException LOƎO
	 */
	public synchronized void changeTypeUpdate( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess();
		try {
			// gUNVJn
			objDataAccess.trans(htbParam);

			changeTypeUpdateAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Scorm ʃOe[uւ̍XVs܂B
	 *
	 * @param htbParam p[^
	 * @param objDataAccess
	 * @exception SQLException DBG[
	 */
	private void changeTypeUpdateAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{

		// 폜Ώۂ̎擾
		String loID = (String)htbParam.get( LOID );
		String condition = (String)htbParam.get( CONDITION_KEY );

		// Scorm_Attempte[u̍XV
		ScormAttemptDataAccess objAttempt = new ScormAttemptDataAccess();
		objAttempt.changeTypeUpdate( loID, condition, objDataAccess );

		// Scorm_Interactione[u̍XV
		ScormInteractionDataAccess objInteraction = new ScormInteractionDataAccess();
		objInteraction.changeTypeUpdate( loID, condition, objDataAccess );

		// Scorm_LearnerCommente[u̍XV
		ScormLearnerCommentDataAccess objComment = new ScormLearnerCommentDataAccess();
		objComment.changeTypeUpdate( loID, condition, objDataAccess );

		// Scorm_LMSCommente[u̍XV
		ScormLMSCommentDataAccess objLMSComment = new ScormLMSCommentDataAccess();
		objLMSComment.changeTypeUpdate( loID, condition, objDataAccess );

		// Scorm_Objectivee[u̍XV
		ScormObjectiveDataAccess objObjectives = new ScormObjectiveDataAccess();
		objObjectives.changeTypeUpdate( loID, condition, objDataAccess );

		// Scorm_Sessione[u̍XV
		ScormSessionDataAccess objSession = new ScormSessionDataAccess();
		objSession.changeTypeUpdate( loID, condition, objDataAccess );
	}

	/**
	 * ލ\`t@C̓e擾܂B<br>
	 *
	 * @param params p[^B
	 *                ȉ̃f[^܂܂Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>&quot;MATID&quot;</td>
	 * 		<td>IDBMETHODINSERT̏ꍇAsvB</td>
	 * 	</tr>
	 * </table>
	 * <br>
	 * @return OԖڂ̗vfɏbZ[WA
	 *          PԖڂɋލ\`XMLi[ꂽVectorB
	 * @see jp.co.ntt.lms.lo.LoTop#getMaterialStructFile(Hashtable)
	 */
	public Vector getMaterialStructFile(Hashtable params) {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD getMaterialStructFile(" + params + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		Vector returnValue = new Vector();
		// bZ[W
		MessageData message = null;
		// ލ\XML
		String manifestXmlString = null;

		try {
			// ID擾
			String materialID = (String) params.get("MATID");
			DebugLog.write(
				this.getClass(),
				"materialID =\"" + materialID + "\"",
				DebugLog.ROW);
			// o^ς݂̋ނ̍\`mF܂B
			ScormLoEnv env = new ScormLoEnv();
			String materialListPath = env.getMaterialPath();
			String[] strFileList =
				FileControl.getFileList(
					materialListPath,
					FileControl.DIR_LIST);
			boolean found = false;
			for (int i = 0; i < strFileList.length; i++) {
				if (strFileList[i].equals(materialID)) {
					found = true;
					break;
				}
			}
			// ȂꍇAOB
			if (found == false) {
				DebugLog.write(
					this.getClass(),
					"Manifest File[" + materialID + "] not Found.",
					DebugLog.ROW);
				throw new Exception();
			}
			// ލ\ǂݍ݁A
			manifestXmlString =
				ScormManifestUtil.getManifestXmlString(
					materialListPath, materialID, null);
		}
		catch (Exception e) {
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			// VXeG[bZ[WIuWFNg𐶐
			message = createSystemErrMessage(
						"ލ\t@C̓ǂݍ݂Ɏs܂B");
			manifestXmlString = "";
		}
		// ߂lɊi[
		returnValue.add(message);
		returnValue.add(manifestXmlString);

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL getMaterialStructFile(" + params + ") return " + returnValue,
			DebugLog.ROW);
		return returnValue;
	}

// 2004.09.14 M004 ADD start NTTR(N)
	/**
	 * ʃO(CSV)̎擾s܂
	 *
	 * @param htbParam p[^
	 * @return Vector bZ[Wf[^ƌʃO擾
	 */
	public Vector getIndividualLogCSV( Hashtable htbParam ) {

		Vector vecRet = new Vector();
		MessageData objMd = null;
		Object objRet = null;

		try {
			ScormLoDataAccess objDataAccess = new ScormLoDataAccess();
			objRet = objDataAccess.selectCSV( htbParam );
		} catch ( Exception le ) {
			// bZ[Wf[^IuWFNg擾łȂꍇ
			// VXeG[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage( le.getMessage() );
		}
		vecRet.add( objMd );
		vecRet.add( objRet );
		return vecRet;
	}

	/**
	 * ʃO̎擾s܂
	 *
	 * @param htbParam p[^
	 * @return Vector bZ[Wf[^ƌʃO擾
	 */
	public Vector getIndividualLog( Hashtable htbParam ) {

		Vector vecRet = new Vector();
		MessageData objMd = null;
		Object objRet = null;

		try {
			ScormLoDataAccess objDataAccess = new ScormLoDataAccess();
			objRet = objDataAccess.select( htbParam );
		} catch ( LOException le ) {
			// bZ[Wf[^IuWFNg擾łȂꍇ
			// VXeG[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage( le.getMessage() );
		}
		vecRet.add( objMd );
		vecRet.add( objRet );
		return vecRet;
	}
// 2004.09.14 M004 ADD end
}