/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormLearnerCommentDataAccess
//	ύX
//		2004.02.01	VK쐬
//      2006.12.01@ύX T.Kiyokawa
//                  IMOXMLeLXg`ɕύXA
//

package jp.co.ntt.lms.lo.scorm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.DebugLog;

//@CommentOut Start 2006.11.24 T.Kiyokawa wKOCSV̂
//import org.w3c.dom.Node;
// CommentOut End

/**
 * ScormLearnerCommente[uւ̃ANZXENXB
 * @author T.Nishiki
 */
public class ScormLearnerCommentDataAccess extends ScormDataAccess {
	/**
	 * e[uB
	 */
	public static final String TABLE_NAME = "Scorm_LearnerComment";

	/**
	 * e[uE񖼁F[UIDB
	 */
	public static final String USERID = "UserID";

	/**
	 * e[uE񖼁FLOIDB
	 */
	public static final String LOID = "LOID";

	/**
	 * e[uE񖼁FwKZbV񐔁B
	 */
	public static final String STUDY_SESSION_COUNT = "StudySessionCount";

	/**
	 * e[uE񖼁FANeBreBIDB
	 */
	public static final String ACTIVITYID = "ActivityID";

	/**
	 * e[uE񖼁Fs񐔁B
	 */
	public static final String ATTEMPT_COUNT = "AttemptCount";

	/**
	 * e[uE񖼁FLearnZbV񐔁B
	 */
	public static final String LEARN_SESSION_COUNT = "LearnSessionCount";

	/**
	 * e[uE񖼁FRgB
	 */
	public static final String LEARNERCOMMENTCOUNT = "LearnerCommentCount";

	/**
	 * e[uE񖼁FZbVIDB
	 */
	public static final String SESSIONID = "SessionID";

	/**
	 * e[uE񖼁FRgB
	 */
	public static final String LEARNER_COMMENT = "LearnerComment";

	/**
	 * e[uE񖼁FP[VB
	 */
	public static final String LEARNER_COMMENT_LOCATION
			= "LearnerCommentLocation";

	/**
	 * e[uE񖼁FԁB
	 */
	public static final String LEARNER_COMMENT_TIME = "LearnerCommentTime";

	/**
	 * &lt;Rg&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_COMMENT_VALUE =
		"./comment/text()";

	/**
	 * &lt;P[V&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_LOCATION_VALUE =
		"./location/text()";

	/**
	 * &lt;&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_TIME_VALUE =
		"./datetime/text()";

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_MAX;

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_UNIT;
	
//	ADD start 2006.11.22 T.Kiyokawa
	/** 
	CSVEԍFwK҃Rg
	 */
	public static final int CSVCOL_LE_COMMENT = 4 ;


	/** 
	CSVEԍFwK҃RgSCȌꏊ 
	 */
	public static final int CSVCOL_LE_LOCATION = 5 ;


	/** 
	CSVEԍFwK҃RgL^
	 */
	public static final int CSVCOL_LE_DATETIME = 6 ;
	
//	ADD end 
	
	/**
	 * X^eBbNECjVCUB
	 * f[^x[X̎ʂɊÂAJ̍őTCY萔肵܂B
	 */
	static {
		// f[^x[XɂăJTCYETCYʂݒ
		int columnSizeMax = 0;
		int columnSizeUnit = 0;
		try {
			Environment environment = new Environment();
			String dbType = environment.getDBType();
			if (dbType.equals(Environment.DB_SQLSERVER)) {
				columnSizeMax = 4096;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_SQLSERVER;
			}
			else if (dbType.equals(Environment.DB_ORACLE)) {
				columnSizeMax = 4000;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_ORACLE;
			}
			else if (dbType.equals(Environment.DB_POSTGRE)) {
				columnSizeMax = 4096;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_POSTGRE;
			}
		}
		catch (Exception e) {
		}
		COLUMN_SIZE_MAX = columnSizeMax;
		COLUMN_SIZE_UNIT = columnSizeUnit;
	}

	/**
	 * RXgN^
	 **/
	public ScormLearnerCommentDataAccess() {
		super( TABLE_NAME );
	}

	// Add Start T.Kiyoakwa 2006.11.24

	/**
	 * ScormLearnerCommente[uւ݂̏s܂B<br>
	 * &lt;learnercomment&gt;vfƂɌĂяoAR[hǉ܂B<br>
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 * @param learnerCommentCSV &lt;learnercomment&gt;CSVf[^B
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param learnerCommentCount wK҃Rg񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnercomment&gt;vf̈ʒuiPȏ̐jB
	 *
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	public static void insert(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData learnerCommentCSV,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		int learnerCommentCount)
		throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormLearnerCommentDataAccess.class,
			"HEAD insert("
				+ "dataAccess,endLearnData"
				+ "," + learnerCommentCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + learnerCommentCount + ")",
			DebugLog.ROW);

		try {
			////////////////////////////////////////////////////////////////////
			// eJ̒l擾
			//==================================================================
			// Jƒl̃}bv
			ScormColumnInfo[] columnInfos =
				makeColumnInfos(
					endLearnData, learnerCommentCSV,
					activityID,	attemptCount,
					learnSessionCount, learnerCommentCount);
			////////////////////////////////////////////////////////////////////
			// SQL̐
			String query =
				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
			////////////////////////////////////////////////////////////////////
			// SQL̎s
			dataAccess.execute(query.toString());
		}
		catch (LOException e) {
			throw e;
		}
		catch (SQLException e) {
			DebugLog.write(
				ScormInteractionDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormLearnerCommentDataAccess.class,
			"TAIL insert("
				+ "dataAccess,endLearnData"
				+ "," + learnerCommentCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + learnerCommentCount + ")",
			DebugLog.ROW);
	}

	/**
	 * ScormLearnerCommente[ũJz𐶐܂B<br>
	 * @param endLearnData wKIB
	 * @param learnerCommentCSV &lt;learnercomment&gt;CSVf[^B
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param learnerCommentCount wK҃Rg񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnercomment&gt;vf̈ʒuiPȏ̐jB
	 *
	 * @return ScormLearnerCommente[ũJzB
	 * @throws LOException m[hŃf[^擾sꍇB
	 */
	private static ScormColumnInfo[] makeColumnInfos(
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData learnerCommentCSV,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		int learnerCommentCount)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormLearnerCommentDataAccess.class,
			"HEAD makeColumnInfos(endLearnData"
				+ "," + learnerCommentCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + learnerCommentCount + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		ScormColumnInfo[] columnInfos = null;
		// z񐶐pXg
		List columnInfoList = new ArrayList();
		try {
			////////////////////////////////////////////////////////////////////
			// endLearnData擾łf[^JƂĐݒ
			//==================================================================
			// [UID
			String userID = endLearnData.getUserID();
			ScormColumnInfo userIDColumn = new ScormColumnInfo(
				USERID, userID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(userIDColumn);
			// LOID
			String loID = endLearnData.getLoID();
			ScormColumnInfo loIDColumn = new ScormColumnInfo(
				LOID, loID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(loIDColumn);
			// wKZbV
			int studySessionCount = endLearnData.getStudySession();
			ScormColumnInfo studySessionCountColumn = new ScormColumnInfo(
				STUDY_SESSION_COUNT, Integer.toString(studySessionCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(studySessionCountColumn);
			// ZbVID
			int sessionID = endLearnData.getLoginSession();
			ScormColumnInfo sessionIDColumn = new ScormColumnInfo(
				SESSIONID, Integer.toString(sessionID),
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(sessionIDColumn);
			////////////////////////////////////////////////////////////////////
			// endLearnDataAattemptNodeȊO擾łf[^JƂĐݒ
			//==================================================================
			// ANeBreBID
			ScormColumnInfo activityIDColumn = new ScormColumnInfo(
				ACTIVITYID, activityID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
			columnInfoList.add(activityIDColumn);
			// s
			ScormColumnInfo attemptCountColumn = new ScormColumnInfo(
				ATTEMPT_COUNT, Integer.toString(attemptCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(attemptCountColumn);
			// LearnZbV
			ScormColumnInfo learnSessionCountColumn = new ScormColumnInfo(
				LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnSessionCountColumn);
			// Rg
			ScormColumnInfo learnerCommentCountColumn = new ScormColumnInfo(
				LEARNERCOMMENTCOUNT, Integer.toString(learnerCommentCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnerCommentCountColumn);
			////////////////////////////////////////////////////////////////////
			// attemptNode擾łf[^JƂĐݒ
			//==================================================================
			// Rg
			String learnerComment =
				learnerCommentCSV.getData(CSVCOL_LE_COMMENT);
			if (learnerComment != null) {
				ScormColumnInfo learnerCommentColumn = new ScormColumnInfo(
					LEARNER_COMMENT, learnerComment,
					ScormColumnInfo.COLUMN_TYPE_STRING,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(learnerCommentColumn);
			}
			// P[V
			String learnerCommentLocation =
				learnerCommentCSV.getData(CSVCOL_LE_LOCATION);
			if (learnerCommentLocation != null) {
				ScormColumnInfo learnerCommentLocationColumn
					= new ScormColumnInfo(
						LEARNER_COMMENT_LOCATION, learnerCommentLocation,
						ScormColumnInfo.COLUMN_TYPE_STRING,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(learnerCommentLocationColumn);
			}
			// RgL^
			String commentTime =
				learnerCommentCSV.getData(CSVCOL_LE_DATETIME);
			if (commentTime != null) {
				// DBp̃tH[}bgɕϊĂݒ
				String commentTimeDBString = commentTime;
				ScormColumnInfo learnerCommentTimeColumn
					= new ScormColumnInfo(
						LEARNER_COMMENT_TIME, commentTimeDBString,
						ScormColumnInfo.COLUMN_TYPE_STRING,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(learnerCommentTimeColumn);
			}
			////////////////////////////////////////////////////////////////////
			// Xgzɕϊ
			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
			columnInfoList.toArray(columnInfos);
		}
		catch (LOException e) {
			throw e;
		}

		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormLearnerCommentDataAccess.class,
			"TAIL makeColumnInfos(endLearnData"
				+ "," + learnerCommentCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + learnerCommentCount + ")"
				+ " return " + columnInfos,
			DebugLog.ROW);
		return columnInfos;
	}
	// Add End

// CommentOut Start 2006.11.24 T.Kiyokawa wKOCSV̂
//	/**
//	 * ScormLearnerCommente[uւ݂̏s܂B<br>
//	 * &lt;learnercomment&gt;vfƂɌĂяoAR[hǉ܂B<br>
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param learnerCommentNode &lt;learnercomment&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnerCommentCount wK҃Rg񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnercomment&gt;vf̈ʒuiPȏ̐jB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	public static void insert(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Node learnerCommentNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		int learnerCommentCount)
//		throws LOException {
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormLearnerCommentDataAccess.class,
//			"HEAD insert("
//				+ "dataAccess,endLearnData"
//				+ "," + learnerCommentNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + learnerCommentCount + ")",
//			DebugLog.ROW);
//
//		try {
//			////////////////////////////////////////////////////////////////////
//			// eJ̒l擾
//			//==================================================================
//			// Jƒl̃}bv
//			ScormColumnInfo[] columnInfos =
//				makeColumnInfos(
//					endLearnData, learnerCommentNode,
//					activityID,	attemptCount,
//					learnSessionCount, learnerCommentCount);
//			////////////////////////////////////////////////////////////////////
//			// SQL̐
//			String query =
//				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
//			////////////////////////////////////////////////////////////////////
//			// SQL̎s
//			dataAccess.execute(query.toString());
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (SQLException e) {
//			DebugLog.write(
//				ScormInteractionDataAccess.class, e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormLearnerCommentDataAccess.class,
//			"TAIL insert("
//				+ "dataAccess,endLearnData"
//				+ "," + learnerCommentNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + learnerCommentCount + ")",
//			DebugLog.ROW);
//	}
//
//	/**
//	 * ScormLearnerCommente[ũJz𐶐܂B<br>
//	 * @param endLearnData wKIB
//	 * @param learnerCommentNode &lt;learnercomment&gt;vf\m[hB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnerCommentCount wK҃Rg񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnercomment&gt;vf̈ʒuiPȏ̐jB
//	 *
//	 * @return ScormLearnerCommente[ũJzB
//	 * @throws LOException m[hŃf[^擾sꍇB
//	 */
//	private static ScormColumnInfo[] makeColumnInfos(
//		ScormLoEndLearnData endLearnData,
//		Node learnerCommentNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		int learnerCommentCount)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormLearnerCommentDataAccess.class,
//			"HEAD makeColumnInfos(endLearnData"
//				+ "," + learnerCommentNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + learnerCommentCount + ")",
//			DebugLog.ROW);
//
//		// ̃\bh̖߂l
//		ScormColumnInfo[] columnInfos = null;
//		// z񐶐pXg
//		List columnInfoList = new ArrayList();
//		try {
//			////////////////////////////////////////////////////////////////////
//			// endLearnData擾łf[^JƂĐݒ
//			//==================================================================
//			// [UID
//			String userID = endLearnData.getUserID();
//			ScormColumnInfo userIDColumn = new ScormColumnInfo(
//				USERID, userID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(userIDColumn);
//			// LOID
//			String loID = endLearnData.getLoID();
//			ScormColumnInfo loIDColumn = new ScormColumnInfo(
//				LOID, loID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(loIDColumn);
//			// wKZbV
//			int studySessionCount = endLearnData.getStudySession();
//			ScormColumnInfo studySessionCountColumn = new ScormColumnInfo(
//				STUDY_SESSION_COUNT, Integer.toString(studySessionCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(studySessionCountColumn);
//			// ZbVID
//			int sessionID = endLearnData.getLoginSession();
//			ScormColumnInfo sessionIDColumn = new ScormColumnInfo(
//				SESSIONID, Integer.toString(sessionID),
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(sessionIDColumn);
//			////////////////////////////////////////////////////////////////////
//			// endLearnDataAattemptNodeȊO擾łf[^JƂĐݒ
//			//==================================================================
//			// ANeBreBID
//			ScormColumnInfo activityIDColumn = new ScormColumnInfo(
//				ACTIVITYID, activityID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
//				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
//			columnInfoList.add(activityIDColumn);
//			// s
//			ScormColumnInfo attemptCountColumn = new ScormColumnInfo(
//				ATTEMPT_COUNT, Integer.toString(attemptCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(attemptCountColumn);
//			// LearnZbV
//			ScormColumnInfo learnSessionCountColumn = new ScormColumnInfo(
//				LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnSessionCountColumn);
//			// Rg
//			ScormColumnInfo learnerCommentCountColumn = new ScormColumnInfo(
//				LEARNERCOMMENTCOUNT, Integer.toString(learnerCommentCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnerCommentCountColumn);
//			////////////////////////////////////////////////////////////////////
//			// attemptNode擾łf[^JƂĐݒ
//			//==================================================================
//			// Rg
//			String learnerComment =
//				ScormLoUtil.getNodeValue(
//					learnerCommentNode, PATH_COMMENT_VALUE);
//			if (learnerComment != null) {
//				ScormColumnInfo learnerCommentColumn = new ScormColumnInfo(
//					LEARNER_COMMENT, learnerComment,
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(learnerCommentColumn);
//			}
//			// P[V
//			String learnerCommentLocation =
//				ScormLoUtil.getNodeValue(
//					learnerCommentNode, PATH_LOCATION_VALUE);
//			if (learnerCommentLocation != null) {
//				ScormColumnInfo learnerCommentLocationColumn
//					= new ScormColumnInfo(
//						LEARNER_COMMENT_LOCATION, learnerCommentLocation,
//						ScormColumnInfo.COLUMN_TYPE_STRING,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(learnerCommentLocationColumn);
//			}
//			// RgL^
//			String commentTime =
//				ScormLoUtil.getNodeValue(
//					learnerCommentNode, PATH_TIME_VALUE);
//			if (commentTime != null) {
//				// DBp̃tH[}bgɕϊĂݒ
//				String commentTimeDBString = commentTime;
//				ScormColumnInfo learnerCommentTimeColumn
//					= new ScormColumnInfo(
//						LEARNER_COMMENT_TIME, commentTimeDBString,
//						ScormColumnInfo.COLUMN_TYPE_STRING,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(learnerCommentTimeColumn);
//			}
//			////////////////////////////////////////////////////////////////////
//			// Xgzɕϊ
//			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
//			columnInfoList.toArray(columnInfos);
//		}
//		catch (LOException e) {
//			throw e;
//		}
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormLearnerCommentDataAccess.class,
//			"TAIL makeColumnInfos(endLearnData"
//				+ "," + learnerCommentNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + learnerCommentCount + ")"
//				+ " return " + columnInfos,
//			DebugLog.ROW);
//		return columnInfos;
//	}
	// CommentOut End
	
	/**
	 * w肳ꂽ[UAނ̑gݍ킹̃O폜܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID 폜Ώۂ̃[UIDB
	 * @param loID 폜Ώۂ̋ނLOIDB
	 * @throws LOException f[^x[XANZXɗOꍇB
	 */
	public static void delete(
		DataAccess dataAccess, String userID, String loID)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormLearnerCommentDataAccess.class,
			"HEAD delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
		try {
			// WHERE̐
			StringBuffer queryWhere = new StringBuffer();
			if (loID != null) {
				queryWhere.append(" and " + LOID + "='" + loID + "'" );
			}
			if (userID != null) {
				queryWhere.append(" and " + USERID + "='" + userID + "'" );
			}
			// 폜NG̐
			StringBuffer query = new StringBuffer();
			query.append("delete from " + TABLE_NAME );
			if (queryWhere.length() > 0) {
				query.append(" where " + queryWhere.substring(5) );
			}
			// 폜NG̎s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			dataAccess.execute(queryString);
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
		}
		// \bhIO
		DebugLog.write(
			ScormLearnerCommentDataAccess.class,
			"TAIL delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
	}

	/**
	 * LearnZbV񐔍ől擾܂B<br>
	 * w肵[UIDALOIDAwK񐔂̑gݍ킹ŁA
	 * ANeBreBʂɍő厎s񐔂̍őLearnZbV񐔂
	 * ̂QzƂĖ߂܂B
	 * Y郌R[h݂ȂꍇAvfO̔z߂܂B
	 * <br>
	 * @param dataAccess f[^ANZXIuWFNgB
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param studySession wK񐔁iJn|IłPPʂ̉񐔁j
	 * @return ȉ̂PzvfƂz߂܂B
	 * <table border="1">
	 * 	<tr>
	 * 		<th>CfbNX</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">0</td>
	 * 		<td>ANeBreBID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">1</td>
	 * 		<td>ANeBreB̒ōő̎s</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">2</td>
	 * 		<td>
	 * 			ANeBreB̒ōő̎s񐔂̒
	 * 			őLearnZbV
	 * 		</td>
	 * 	</tr>
	 * </table>
	 * <br>
	 * @throws LOException if[^x[XANZXjɃG[ꍇB
	 */
	public static String[][] getMaxLearnSessionCount(
			DataAccess dataAccess, String userID,
			String loID, int studySession)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String[][] matrix = null;
		// NGʃZbg
		ResultSet resultSet = null;
		// tryubNɗOĂȂtOitrueOȂj
		boolean successFlag = false;
		try {
			////////////////////////////////////////////////////////////////////
			// NG̐
			StringBuffer query = new StringBuffer();
			query.append("select");
			// ANeBreBID
			query.append(" a." + ACTIVITYID + " as " + ACTIVITYID);
			// ő厎s
			query.append(",a." + ATTEMPT_COUNT + " as " + ATTEMPT_COUNT);
			// ̒̍őLearnZbV
			query.append(",max(a." + LEARN_SESSION_COUNT + ")"
							+ " as " + LEARN_SESSION_COUNT);
			query.append(" from " + TABLE_NAME + " a");
			query.append(" inner join (");
			// =================================================================
			// ő厎s񐔂擾邽߂̃TuNG
			query.append(	"select");
			query.append(	" " + USERID + " as " + USERID);
			query.append(	"," + LOID + " as " + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(			" as " + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID + " as " + ACTIVITYID);
			query.append(	",max(" + ATTEMPT_COUNT + ") as " + ATTEMPT_COUNT);
			query.append(	" from " + TABLE_NAME);
			// TuNGł̏
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(	" where " + USERID + "='" + userID + "'");
			query.append(	" and " + LOID + "='" + loID + "'");
			query.append(	" and " + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// TuNGmax(AttemptCount)gp邽߂group by
			query.append(	" group by ");
			query.append(	" " + USERID);
			query.append(	"," + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID);
			query.append(") b");
			// =================================================================
			// TuNGƂ̌
			// [UIDALOIDAwK񐔁AANeBreBIDvāA
			// s񐔂ől̃R[h
			query.append(" on a." + USERID + "=b." + USERID );
			query.append(" and a." + LOID + "=b." + LOID );
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=b." + STUDY_SESSION_COUNT );
			query.append(" and a." + ACTIVITYID + "=b." + ACTIVITYID );
			query.append(" and a." + ATTEMPT_COUNT + "=b." + ATTEMPT_COUNT );
			// =================================================================
			// where
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(" where a." + USERID + "='" + userID + "'");
			query.append(" and a." + LOID + "='" + loID + "'");
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// =================================================================
			// max(LearnSessionCount)gp邽߂group by
			query.append(" group by");
			query.append(" a." + ACTIVITYID);
			query.append(",a." + ATTEMPT_COUNT);
			////////////////////////////////////////////////////////////////////
			// NGs
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			resultSet = dataAccess.executeQuery(queryString);
			////////////////////////////////////////////////////////////////////
			// NGʂ̃Xg
			List list = new ArrayList();
			while (resultSet.next()) {
				String[] record = new String[3];
				record[0] = resultSet.getString(ACTIVITYID).trim();
				record[1] = resultSet.getString(ATTEMPT_COUNT);
				record[2] = resultSet.getString(LEARN_SESSION_COUNT);

				list.add(record);
			}
			//Xgz
			matrix = new String[list.size()][];
			list.toArray(matrix);

			// tryubNŌ܂œB̂ŃtOtrueɕύX
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			if (resultSet != null) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					DebugLog.write(ScormAttemptDataAccess.class,
						e, DebugLog.HIGHT);
					// tryubNɂėOȂ΁AX[
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);
		return matrix;
	}
}
