/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	[Ui̊Kw\\zNX
//
//		ύX
//			2005.01.27  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NX̓[Ui̊Kw\\zNXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress;

import java.util.Iterator;
import java.util.List;

import jp.co.ntt.lms.lo.progress.util.XMOInformationGetter;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.Groups.GroupsData;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;

/**
 * [Ui̊Kw\\zNXłB
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public class PeopleProgressTreeFactory extends AbstractXMOProgressTreeFactory {

	/**
	 * RXgN^łB
	 * 
	 * @param parentID Kw\̐eO[vID
	 * @param targetLOID ΏۂƂȂLOID
	 * @param loginID OC[UID
	 */
	public PeopleProgressTreeFactory(String parentID, String targetLOID, String loginID) {
		super(parentID, targetLOID, loginID);
	}

	/**
	 * LoiKw\𐶐܂B
	 * 
	 * @param parentID 	Kw\̐eO[vID
	 * @param targetLOID ΏۂƂȂLOID
	 * @param loginUserID OC[UID
	 * @param level Kwx
	 * @return XMOProgress [UiKw\̃[g
	 * @exception Exception
	 */
	protected XMOProgress createProgressTree( String parentID, String targetLOID, String loginUserID ,int level ) throws Exception {

		XMOProgress rootProgress = null;
		
		// [U[g̏ꍇ
		if( /*loginUserID.equals("PE000000")==false && */  
				( parentID.equals("GR000000") || parentID.equals("grouptreeroot") ) ) {
			
			rootProgress = new GroupProgress( parentID, targetLOID, level, super.getConfigManager() );

			LoRelationClient relationClient = XMOInformationGetter.getLORelation(targetLOID);
			
			//wLOɃATCĂ郆[U擾
			AssignmentsClient assignmentsClient = new AssignmentsClient();
			assignmentsClient.setWhereMaterialID( relationClient.getmaterialID() );
			if ( assignmentsClient.select() == false ) return rootProgress;
			
			// OC[UɊǗATCĂ郋[g[U擾
			List rootGroupList = XMOInformationGetter.getRootGroupIDList(loginUserID);
			
			// OC[U[g[ȔꍇAēx[g[U擾
			if (loginUserID.equals("PE000000")){
				rootGroupList = XMOInformationGetter.getChildGroupIDList((rootGroupList.get(0)).toString());
			}

			XMOProgress progress = null;
			while( assignmentsClient.next() ) {

				// wKȂ[UȂ珈Ȃ
				if ( assignmentsClient.getLearnAuthority().equals("1") == false ) continue;
				
				String memberShipID = assignmentsClient.getMemberShipID();

				GroupAndPeopleClient groupAndPeople = this.getGroupAndPeopleFromMembershipID(memberShipID);
				String childID = groupAndPeople.getChildID();

				if (childID == null) continue;
				
				// OC[UɊǗATCĂ郋[g[UłȂΏȂ
				if (rootGroupList.contains(childID) == false ) continue;
				
				// O[v̏ꍇ
				if (childID.startsWith("GR")) {
					
					progress = new GroupProgress( childID, targetLOID, level, super.getConfigManager() );
					
					// q̃[U擾
					GroupAndPeopleClient childGroupAndPeopleClient = new GroupAndPeopleClient();
					childGroupAndPeopleClient.setWhereParentID(childID);
					if ( childGroupAndPeopleClient.select() == false ) continue;
					
					// KwJEgAbv
					int childUserlevel = level + 1 ;

					while(childGroupAndPeopleClient.next()) {
						XMOProgress childProgress = 
							this.createProgressTree( childGroupAndPeopleClient.getChildID(), 
														targetLOID, loginUserID, childUserlevel );
						progress.add( childProgress );
					}
					
				// [Ȕꍇ
				} else {
					progress = new PeopleProgress( childID, targetLOID, level, super.getConfigManager() );
				}
				
				rootProgress.add(progress);
			}

		} else {
			
			// eID[UO[v𔻒肵A[gXMOProgress쐬
			// O[v̏ꍇ
			if ( parentID.startsWith( "GR" ) ){
	
				rootProgress = new GroupProgress( parentID, targetLOID, level, super.getConfigManager() );
	
				GroupAndPeopleClient groupAndPeople = new GroupAndPeopleClient();
				
				// ɐeIDZbg
				groupAndPeople.setWhereParentID( parentID );
				
				// {
				if ( groupAndPeople.select() == false ){
					throw new Exception();
				}
				
				// KwxJEgAbv
				level++;
				
				// 
				while( groupAndPeople.next() ) {
	
					XMOProgress xmoProgress = this.createProgressTree( groupAndPeople.getChildID(), targetLOID, loginUserID ,level );
					rootProgress.add( xmoProgress );
				}
				
			// [Ȕꍇ
			}else{
				
				rootProgress = new PeopleProgress( parentID, targetLOID, level, super.getConfigManager() );
			}
		}
		
		return rootProgress;
	}
	
	/**
	 * o[IDO[vE[UKw擾܂B
	 * 
	 * @param membershipID@o[ID
	 * @return GroupAndPeopleClient O[vE[UKw
	 * @throws Exception
	 */
	private GroupAndPeopleClient getGroupAndPeopleFromMembershipID(String membershipID) throws Exception {

		GroupAndPeopleClient groupAndPeopleClient = new GroupAndPeopleClient();
		groupAndPeopleClient.setMemberShipID( membershipID );
		
		if( groupAndPeopleClient.select() == false ) return null;
		if( groupAndPeopleClient.next() == false ) return null;
		
		return groupAndPeopleClient;
	}

	/**
	 * w肳ꂽO[vIDw肳ꂽO[ṽXgɊ܂܂邩𔻕ʂ܂B
	 * 
	 * @param groupID O[vID
	 * @param targetList O[ṽXg
	 * @return boolean O[vXgɊ܂܂邩 True:܂܂
	 */
	private boolean containsGroupID(String groupID, List targetList) {
		Iterator ite = targetList.iterator();
		while(ite.hasNext()){
			GroupsData groupData = (GroupsData)ite.next();
			if ( groupData.getGroupID().equals(groupID) ) return true;
		}
		return false;
	}
}
