/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	AICCOp[XNX
//			ύX
//				2004.01.08	VK쐬	R 땶
//

package jp.co.ntt.lms.lo.WBT.Aicc;

import java.io.*;
import java.util.Vector;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.*;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;

import jp.co.ntt.lms.Common.RDF.*;

/**
 * AICCOp[XNX
 * <PRE>
 * eF͂ꂽAiccLogXMLf[^p[XADB̃R[h
 * NXɕϊB
 * </PRE>
 */

public class AiccLogConverter implements AiccConst
{

	//////////////////////////////////////////////////////////
	//	NXϐ
	//////////////////////////////////////////////////////////

	/** LOID */
	private String mstrLoID = null;

	/** USERID */
	private String mstrUserID = null;

	/** SessionID */
	private String mstrSessionID = null;

	/** XMLhLg */
	private	Document mDoc = null;

	/** XML\[X */
	private	String mSource = null;

	/** [gGg */
	private Element mRootElement = null;

	/** ލ\}eAOID */
	private	String mstrMaterialLogID = null;

	/** AiccCoreRecord */
	private AiccCoreRecord[] mobjAiccCoreRecords = null ;

	/** SectionLogRecord */
	private SectionLogRecord[] mobjSectionLogRecords = null ;

	/** AiccInteractionRecord */
	private AiccInteractionRecord[] mobjAiccInteractionRecords = null;

	/** AiccCommentRecord */
	private AiccCommentRecord[] mobjAiccCommentRecords = null;

	/** AiccObjectivesRecord */
	private AiccObjectivesRecord[] mobjAiccObjectivesRecords = null;

	/** Aicc̋ID */
	private String mstrCourseID = null;

	/** AiccBLOCKID */
	private String mstrBlockID = null;

	/** Aicc̃bXID */
	private String mstrLessonID = null;

	/** AiccUID */
	private String mstrUid = null;

	/** ލ\ێ܂ */
	private RDFNode mobjRDFNode = null;

	/** UIDXgێ܂ */
	private Vector mvecUidList = new Vector();

	//G[bZ[W
	private static final String WRONG_ARGUMENT = "słB";
	private static final String FAIL_PARSE = "p[XɎs܂B";
	private static final String NO_EXIST_MATERIALTAG = "Material^O݂܂B";
	private static final String WRONG_MATERIAL_ID = "Material^OIDsłB";

	/**
	*	RXgN^<br>
	*	XMLf[^p[XăCX^X𐶐܂B
	*	@param strInput XMLf[^
	*/
	public AiccLogConverter(String strInput){
		mSource = strInput;
	}


	/**
	 *	XMLf[^p[X܂B<BR>
	 *	R[h쐬܂̂ŁAOLoID,SessionID,UesrIDݒ肵ĂB
	 *	@exception SAXException p[XɎsꍇ
	 *	@exception IOException f[^ǂݍ݂Ɏsꍇ
	 *	@exception AiccParseException ُ̏ꍇ
	 */
	public void parse() throws SAXException,AiccParseException,IOException
	{
		if ( mSource == null || mstrLoID == null || mstrUserID == null || mstrSessionID == null ){
			throw new AiccParseException(WRONG_ARGUMENT);
		}


		//p[T̃CX^X𐶐
		DOMParser parser = new DOMParser();

		//XMLf[^ǂݍ
		StringReader mSr = new StringReader(mSource);

		//Xg[𐶐
		InputSource is = new InputSource(mSr);

		//p[X
		parser.parse(is);

		//hLg擾
		mDoc = parser.getDocument();

		//hLg擾łA
		try {
			// ލ\ǂݍ
			RDFDocument objDoc = new RDFDocument();
			mobjRDFNode = objDoc.load( new StringBuffer( mSource ) );
			// ID̐ݒ
			mstrCourseID = mobjRDFNode.getID();

			mstrMaterialLogID = mobjRDFNode.getChildNodes().getNode(0).getID();

		}
		catch( RDFParseException rp ) {
			throw new AiccParseException(rp.getMessage());
		}

		if(mDoc != null) {
			Element elementRoot = mDoc.getDocumentElement();
			mRootElement = elementRoot;
			mRootElement.normalize();

			Vector vecCores = new Vector();
			Vector vecInteractions = new Vector();
			Vector vecComments = new Vector();
			Vector vecObjectives = new Vector();
			Vector vecMaterials = new Vector();
			NodeList AiccLogList = getElementsByTagName(mRootElement, AICCLOG_ELM );
			Node AiccLog;
			NodeList MaterialLogList = getElementsByTagName(mRootElement, MATERIALLOG_ELM );
			Node MaterialLog;

			for ( int i=0; i<AiccLogList.getLength(); i++ ){

				AiccLog = AiccLogList.item(i);

				// Aicc̑擾
				String strAiccID = ((Element)AiccLog).getAttribute( AICC_ID );

				// ݓǂݍݒAicc^OBlockAuݒ肵܂
				setBaseInfo( strAiccID );

				// AiccLogGgz̑SCore擾 */
				makeAiccCoreRecords((Element)AiccLog,vecCores);
				// AiccLogGgz̑SInteraction擾 */
				makeAiccInteractionRecords((Element)AiccLog,vecInteractions);
				// AiccLogGgz̑SComment擾 */
				makeAiccCommentRecords((Element)AiccLog,vecComments);
				// AiccLogGgz̑SObjectives擾 */
				makeAiccObjectivesRecords((Element)AiccLog,vecObjectives);
			}
			if ( vecCores.size() > 0 ){
				mobjAiccCoreRecords = new AiccCoreRecord[vecCores.size()];
				vecCores.copyInto( mobjAiccCoreRecords );
			}
			if ( vecInteractions.size() > 0 ){
				mobjAiccInteractionRecords = new AiccInteractionRecord[vecInteractions.size()];
				vecInteractions.copyInto( mobjAiccInteractionRecords );
			}
			if ( vecComments.size() > 0 ){
				mobjAiccCommentRecords = new AiccCommentRecord[vecComments.size()];
				vecComments.copyInto( mobjAiccCommentRecords );
			}
			if ( vecObjectives.size() > 0 ){
				mobjAiccObjectivesRecords = new AiccObjectivesRecord[vecObjectives.size()];
				vecObjectives.copyInto( mobjAiccObjectivesRecords );
			}

			for ( int i=0; i<MaterialLogList.getLength(); i++ ){

				MaterialLog = MaterialLogList.item(i);

				// Material̑擾
				String strMaterialLogID = getMaterialLogID(((Element)MaterialLog).getAttribute( MATERIAL_ID ));

				// MaterialLogGgz̑S擾 */
				vecMaterials.add( makeSectionLogRecord( MaterialLog, strMaterialLogID ) );
			}
			if ( vecMaterials.size() > 0 ){
				mobjSectionLogRecords = new SectionLogRecord[vecMaterials.size()];
				vecMaterials.copyInto( mobjSectionLogRecords );
			}
		}
	}

	/**
	 * AiccO̍ŏɌ<AiccLog>^OID
	 * UserIDƋID擾܂B<BR>
	 * CX^XɎgpł悤Ƀ\bh static
	 * Ő錾Ă܂B
	 * ID":"؂ňȉ̂悤ɒ`܂B<BR>
	 * Count擾Ēǉ܂B<BR>
	 * <PRE>
	 *       ID:[UID:BLOCK܂AUID
	 * <PRE>
	 * @param strInput XMLAiccOf[^
	 * @return String[] UserIDƋIDƊwK񐔂zŕԂ܂B
	 *                  [0]: UserID
	 *                  [1]: ID
	 *                  [2]: wK
	 * @exception SAXException p[XɎsꍇ
	 * @exception IOException f[^ǂݍ݂Ɏsꍇ
	 * @exception AiccParseException ُ̏ꍇ
	 */
	public static String[] getIDInfo( String strInput )
		throws SAXException,AiccParseException,IOException
	{
		if ( strInput == null ) {
			throw new AiccParseException();
		}

		//p[T̃CX^X𐶐
		DOMParser parser = new DOMParser();

		//XMLf[^ǂݍ
		StringReader mSr = new StringReader(strInput);

		//Xg[𐶐
		InputSource is = new InputSource(mSr);

		//p[X
		parser.parse(is);

		//hLg擾
		Document pDoc = parser.getDocument();


		if(pDoc != null) {
			Element elementRoot = pDoc.getDocumentElement();
			elementRoot.normalize();
			NodeList AiccLogList = getElementsByTagName(elementRoot,MATERIALLOG_ELM );
			Node AiccLog;
			if( AiccLogList.getLength() > 0 ) {
				// Material^O̐擪擾
				AiccLog = AiccLogList.item(0);
				// Material^OID擾
				String strAiccID = ((Element)AiccLog).getAttribute( MATERIAL_ID );
				// [UID擾
				String[] strTmp = tokenID( strAiccID );
				// wK񐔂擾
				String strCountID = ((Element)AiccLog).getAttribute( MATERIAL_COUNT );
				String[] strRes = new String[3];
				strRes[0] = strTmp[0];
				strRes[1] = strTmp[1];
				strRes[2] = strCountID;
				return strRes;
			}
			else {
				// Aicc^O݂Ȃꍇ
				throw new AiccParseException(NO_EXIST_MATERIALTAG);
			}
		}
		else {
			// hLg擾łȂꍇ
			throw new AiccParseException(FAIL_PARSE);
		}
	}

	/**
	 * AiccOID烆[UIDƋIDoĕԂ܂B
	 * ID":"؂ňȉ̂悤ɒ`܂B<BR>
	 * <PRE>
	 *       ID:[UID:BLOCK܂AUID
	 * <PRE>
	 * @param strAiccID ID
	 * @return String[] UserIDƋIDzŕԂ܂B
	 *                  [0]: UserID
	 *                  [1]: ID
	 * @exception AiccParseException ُ̏ꍇ
	 */
	private static String[] tokenID( String strAiccID )
		throws AiccParseException
	{
		// ":" Ńg[N܂
		StringTokenizer objToken = new StringTokenizer( strAiccID, ":" );

		String[] strRes = new String[2];
		int i = 0;
		while( objToken.hasMoreElements() ) {
			switch(i) {
				case 0:
					// ID̎擾
					strRes[1] = objToken.nextToken();
					break;
				case 1:
					// [UID̎擾
					strRes[0] = objToken.nextToken();
					break;
				case 2:
					objToken.nextToken();
					break;
				default:
					objToken.nextToken();
					break;
			}
			i++;
		}
		// g[N̐s̏ꍇ
		if( i < 2 ) {
			throw new AiccParseException(WRONG_MATERIAL_ID);
		}

		return strRes;
	}

	/**
	 * IDԋp܂
	 * @return String ID
	 */
	public String getCourseID() {
		return mstrCourseID;
	}

	/**
	*	AiccCoreRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccCoreRecord[] AiccCoreRecordz
	*/
	public AiccCoreRecord[] getAiccCoreRecords()
	{
		return mobjAiccCoreRecords;
	}

	/**
	*	SectionLogRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return SectionLogRecord[] SectionLogRecordz
	*/
	public SectionLogRecord[] getSectionLogRecords()
	{
		return mobjSectionLogRecords;
	}

	/**
	 *	AiccCoreRecordԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccCoreRecord AiccCoreRecord
	*/
	public AiccCoreRecord getAiccCoreRecord()
	{
		if( mobjAiccCoreRecords == null ) {
			return null;
		}
		if( mobjAiccCoreRecords.length > 0 ) {
			return mobjAiccCoreRecords[0];
		}
		return null;
	}

	/**
	*	AiccInteractionRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccCoreRecord[] AiccInteractionRecordz
	*/
	public AiccInteractionRecord[] getAiccInteractionRecords()
	{
		return mobjAiccInteractionRecords;
	}

	/**
	*	AiccCommentRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccCommentRecord[] AiccCommentRecordz
	*/
	public AiccCommentRecord[] getAiccCommentRecords()
	{
		return mobjAiccCommentRecords;
	}

	/**
	*	AiccObjectivesRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccObjectivesRecord[] AiccObjectivesRecordz
	*/
	public AiccObjectivesRecord[] getAiccObjectivesRecords()
	{
		return mobjAiccObjectivesRecords;
	}

	/**
	 * [UIDݒ肵܂B
	 * @param String
	 */
	public void setUserID(String strUserID ){
		mstrUserID = strUserID;
	}
	/**
	 * LoIDݒ肵܂B
	 * @param String
	 */
	public void setLoID(String strLoID ){
		mstrLoID = strLoID;
	}
	/**
	 * ZbVIDݒ肵܂B
	 * @param String
	 */
	public void setSessionID(String strSessionID ){
		mstrSessionID = strSessionID;
	}


	/**
	 *	AiccLogvfz̑SCoreR[h܂B<br>
 	 *	@param Element AiccLogPvf
	 *	@param Vector  Corei[Vector
	 *
	 */
	private void makeAiccCoreRecords (Element Parent, Vector vecWork)
												throws SAXException, AiccParseException{
		if ( Parent == null || vecWork == null){
			throw new AiccParseException();
		}

		NodeList CoreList = getElementsByTagName( Parent,CORE_ELM );
		Node CoreNode;

		if ( CoreList.getLength() == 0 ){
			return ;
		}

		for ( int i=0; i < CoreList.getLength(); i++ ){
			CoreNode = CoreList.item(i);
			vecWork.add( makeAiccCoreRecord( CoreNode ) );
		}

		return;
	}

	/**
	 *	AiccLogvfz̑SInteractionR[h܂B<br>
	 *	@param Element AiccLogPvf
	 *	@param Vector  Interactioni[Vector
	 *
	 */
	private void makeAiccInteractionRecords (Element Parent,Vector vecWork)
												throws SAXException, AiccParseException{
		if ( Parent == null || vecWork == null){
			throw new AiccParseException();
		}
		NodeList InteractList = getElementsByTagName( Parent,INTERACTION_ELM );
		Node InteractNode;

		if ( InteractList.getLength() == 0 ){
			return ;
		}

		// 𓚉񐔒`@ftHgP
		int intResponseTimes = 1;
		for ( int i=0; i < InteractList.getLength(); i++ ){
			InteractNode = InteractList.item(i);
			AiccInteractionRecord objInteTemp = makeAiccInteractionRecord( InteractNode );
			// 𓚉񐔂Zbg
			objInteTemp.setResponseTimes( new Integer(intResponseTimes++).toString() );
			vecWork.add( objInteTemp );
		}

		AiccInteractionRecord[] result = new AiccInteractionRecord[vecWork.size()];
		vecWork.copyInto( result );

		return ;
	}

	/**
	 *	AiccLogvfz̑SCommentR[h܂B<br>
 	 *	@param Element AiccLogPvf
	 *	@param Vector  Commenti[Vector
	 *
	 */
	private void makeAiccCommentRecords (Element Parent,Vector vecWork)
									throws SAXException, AiccParseException{
		if ( Parent == null || vecWork == null){
			throw new AiccParseException();
		}

		NodeList CommentList = getElementsByTagName(Parent, COMMENT_ELM );
		if ( CommentList.getLength() == 0 ){
			return ;
		}

		Node CommentNode;
		for ( int i=0; i < CommentList.getLength(); i++ ){
			CommentNode = CommentList.item(i);
			vecWork.add( makeAiccCommentRecord( CommentNode ) );
		}

		return ;
	}

	/**
	 *	AiccLogvfz̑SObjectivesR[h܂B<br>
 	 *	@param Element AiccLogPvf
	 *	@param Vector  Objectivesi[Vector
	 *
	 */
	private void makeAiccObjectivesRecords (Element Parent,Vector vecWork)
										throws SAXException, AiccParseException{
		if ( Parent == null || vecWork == null){
			throw new AiccParseException();
		}
		NodeList ObjectivesList = getElementsByTagName(Parent, OBJECTIVES_ELM );
		if ( ObjectivesList.getLength() == 0 ){
			return ;
		}

		Node ObjectivesNode;
		for ( int i=0; i < ObjectivesList.getLength(); i++ ){
			ObjectivesNode = ObjectivesList.item(i);
			vecWork.add( makeAiccObjectivesRecord( ObjectivesNode ) );
		}

		return ;
	}

	/**
	 *	CoreR[h𐶐܂B<br>
	 *	^O݂ꍇA擪̃^OLɂȂ܂B
	 *	^O݂ȂꍇAΏۂ̏null̂܂܂łB
	 *	@param childElementName Gg<br>
	 *	@return 擾m[hBm[h擾łȂꍇnullԂB
	 *
	 */
	private AiccCoreRecord makeAiccCoreRecord (Node CoreNode) throws SAXException, AiccParseException {
		if ( CoreNode == null ){
			throw new AiccParseException();
		}

		AiccCoreRecord result = new AiccCoreRecord();

		result.setUserID(mstrUserID);
		result.setLoID(mstrLoID);
		result.setSessionID(mstrSessionID);
		result.setBlockID(mstrBlockID);
		result.setCourseID(mstrCourseID);
		result.setUid( mstrUid );

		NodeList children = CoreNode.getChildNodes();
		if ( children.getLength() == 0 ){
			return result;
		}

		String LessonStatus = getNodeValueByName( children, LESSON_STATUS );
		if ( LessonStatus != null ){
			result.setLessonStatus( LessonStatus );
		}

		String Score = getNodeValueByName( children, LESSON_SCORE );
		if ( Score != null ){
			result.setScore( Score );
		}

		String StayTime = getNodeValueByName( children, STAY_TIME );
		if ( StayTime != null ){
			result.setStayTime( StayTime );
		}

		String LessonLocation = getNodeValueByName( children, LESSON_LOCATION );
		if ( LessonLocation != null ){
			result.setLessonLocation( LessonLocation );
		}

		String Exist = getNodeValueByName( children, EXIST );
		if ( Exist != null ){
			result.setExist( Exist );
		}

		return result;
	}

	/**
	 *	SectionLogR[h𐶐܂B<br>
	 *	^O݂ꍇA擪̃^OLɂȂ܂B
	 *	^O݂ȂꍇAΏۂ̏null̂܂܂łB
	 *	@param childElementName Gg<br>
	 *	@return 擾m[hBm[h擾łȂꍇnullԂB
	 *
	 */
	private SectionLogRecord makeSectionLogRecord (Node MateriNode, String strMaterialLogID) throws SAXException, AiccParseException {

		if ( MateriNode == null ){
			throw new AiccParseException();
		}

		SectionLogRecord result = new SectionLogRecord();

		result.setUserID(mstrUserID);
		result.setLoID(mstrLoID);
		result.setSessionID(mstrSessionID);
		result.setBlockID(mstrBlockID);
		result.setCourseID(mstrCourseID);
		result.setUid( strMaterialLogID );
		result.setMaterialLogID( strMaterialLogID );

		NodeList children = MateriNode.getChildNodes();
		if ( children.getLength() == 0 ){
			return result;
		}

		String LessonStatus = getNodeValueByName( children, LESSON_STATUS );
		if ( LessonStatus != null ){
			result.setLessonStatus( LessonStatus );
		}

		String StayTime = getNodeValueByName( children, STAY_TIME );
		if ( StayTime != null ){
			result.setTime( StayTime );
		}

		return result;
	}

	/**
	 *	InteractionR[h𐶐܂B<br>
	 *	^O݂ꍇA擪̃^OLɂȂ܂B
	 *	^O݂ȂꍇAΏۂ̏null̂܂܂łB
	 *	@param childElementName Gg<br>
	 *	@return 擾m[hBm[h擾łȂꍇnullԂB
	 *
	 */
	private AiccInteractionRecord makeAiccInteractionRecord (Node InteractNode) throws SAXException, AiccParseException{
		if ( InteractNode == null ){
			throw new AiccParseException();
		}

		AiccInteractionRecord result = new AiccInteractionRecord();

		result.setUserID(mstrUserID);
		result.setLoID(mstrLoID);
		result.setSessionID(mstrSessionID);
		result.setBlockID(mstrBlockID);
		result.setUid( mstrUid );

		NodeList children = InteractNode.getChildNodes();
		if ( children.getLength() == 0 ){
			return result;
		}

		String CourseID = getNodeValueByName( children, COURSE_ID );
		if ( CourseID != null ){
			result.setCourseID( CourseID );
		}

		String StudentID = getNodeValueByName( children, STUDENT_ID );
		if ( StudentID != null ){
			result.setStudentID( StudentID );
		}

		String LessonID = getNodeValueByName( children, LESSON_ID );
		if ( LessonID != null ){
			result.setLessonID( LessonID );
		}

		String Date = getNodeValueByName( children, DATE );
		if ( Date != null ){
			result.setDate( Date );
		}

		String Time = getNodeValueByName( children, TIME );
		if ( Time != null ){
			result.setTime( Time );
		}

		String InteractionID = getNodeValueByName( children, INTERACTION_ID );
		if ( InteractionID != null ){
			result.setInteractionID( InteractionID );
		}

		String ObjectiveID = getNodeValueByName( children, OBJECTIVE_ID );
		if ( ObjectiveID != null ){
			result.setObjectiveID( ObjectiveID );
		}

		String TypeInteraction = getNodeValueByName( children, TYPE_INTERACTION );
		if ( TypeInteraction != null ){
			result.setTypeInteraction( TypeInteraction );
		}

		String CorrectResponse = getNodeValueByName( children, CORRECT_RESPONSE );
		if ( CorrectResponse != null ){
			result.setCorrectResponse( CorrectResponse );
		}

		String ResponseValue = getNodeValueByName( children, RESPONSE_VALUE );
		if ( ResponseValue != null ){
			result.setResponseValue( ResponseValue );
		}

		String StudentResponse = getNodeValueByName( children, STUDENT_RESPONSE );
		if ( StudentResponse != null ){
			result.setStudentResponse( StudentResponse );
		}

		String Result = getNodeValueByName( children, RESULT );
		if ( Result != null ){
			result.setResult( Result );
		}

		String Weighting = getNodeValueByName( children, WEIGHTING );
		if ( Weighting != null ){
			result.setWeighting( Weighting );
		}

		String Latency = getNodeValueByName( children, LATENCY );
		if ( Latency != null ){
			result.setLatency( Latency );
		}

		return result;
	}

	/**
	 *	CommentR[h𐶐܂B<br>
	 *	^O݂ꍇA擪̃^OLɂȂ܂B
	 *	^O݂ȂꍇAΏۂ̏null̂܂܂łB
	 *	@param childElementName Gg<br>
	 *	@return 擾m[hBm[h擾łȂꍇnullԂB
	 *
	 */
	private AiccCommentRecord makeAiccCommentRecord (Node CommentNode) throws SAXException, AiccParseException{
		if ( CommentNode == null ){
			throw new AiccParseException();
		}

		AiccCommentRecord result = new AiccCommentRecord();

		result.setUserID(mstrUserID);
		result.setLoID(mstrLoID);
		result.setSessionID(mstrSessionID);
		result.setBlockID(mstrBlockID);
		result.setUid( mstrUid );

		NodeList children = CommentNode.getChildNodes();
		if ( children.getLength() == 0 ){
			return result;
		}

		String CourseID = getNodeValueByName( children, COURSE_ID );
		if ( CourseID != null ){
			result.setCourseID( CourseID );
		}

		String StudentID = getNodeValueByName( children, STUDENT_ID );
		if ( StudentID != null ){
			result.setStudentID( StudentID );
		}

		String LessonID = getNodeValueByName( children, LESSON_ID );
		if ( LessonID != null ){
			result.setLessonID( LessonID );
		}

		String Date = getNodeValueByName( children, DATE );
		if ( Date != null ){
			result.setDate( Date );
		}

		String Time = getNodeValueByName( children, TIME );
		if ( Time != null ){
			result.setTime( Time );
		}

		String Location = getNodeValueByName( children, LOCATION );
		if ( Location != null ){
			result.setLocation( Location );
		}

		String Comment = getNodeValueByName( children, COMMENT );
		if ( Comment != null ){
			result.setComment( Comment );
		}


		return result;
	}

	/**
	 *	ObjectivesR[h𐶐܂B<br>
	 *	^O݂ꍇA擪̃^OLɂȂ܂B
	 *	^O݂ȂꍇAΏۂ̏null̂܂܂łB
	 *	@param childElementName Gg<br>
	 *	@return 擾m[hBm[h擾łȂꍇnullԂB
	 *
	 */
	private AiccObjectivesRecord makeAiccObjectivesRecord (Node ObjectivesNode) throws SAXException, AiccParseException{
		if ( ObjectivesNode == null ){
			throw new AiccParseException();
		}

		AiccObjectivesRecord result = new AiccObjectivesRecord();

		result.setUserID(mstrUserID);
		result.setLoID(mstrLoID);
		result.setSessionID(mstrSessionID);
		result.setBlockID(mstrBlockID);
		result.setUid( mstrUid );

		NodeList children = ObjectivesNode.getChildNodes();
		if ( children.getLength() == 0 ){
			return result;
		}

		String CourseID = getNodeValueByName( children, COURSE_ID );
		if ( CourseID != null ){
			result.setCourseID( CourseID );
		}

		String StudentID = getNodeValueByName( children, STUDENT_ID );
		if ( StudentID != null ){
			result.setStudentID( StudentID );
		}

		String LessonID = getNodeValueByName( children, LESSON_ID );
		if ( LessonID != null ){
			result.setLessonID( LessonID );
		}

		String Date = getNodeValueByName( children, DATE );
		if ( Date != null ){
			result.setDate( Date );
		}

		String Time = getNodeValueByName( children, TIME );
		if ( Time != null ){
			result.setTime( Time );
		}

		String ObjectiveID = getNodeValueByName( children, OBJECTIVE_ID );
		if ( ObjectiveID != null ){
			result.setObjectiveID( ObjectiveID );
		}

		String Score = getNodeValueByName( children, SCORE );
		if ( Score != null ){
			result.setScore( Score );
		}

		String Status = getNodeValueByName( children, STATUS );
		if ( Status != null ){
			result.setStatus( Status );
		}


		String MasteryTime = getNodeValueByName( children, MASTERY_TIME );
		if ( MasteryTime != null ){
			result.setMasteryTime( MasteryTime );
		}


		return result;
	}
	/**
	 * AiccLogIDl狳IDBlockIDAuIDݒ肵܂B<BR>
	 * AiccLogIDl͈ȉ̂悤Ȍ`łB
	 * <PRE>
	 *    ID:[UID:LessonID
	 * </PRE>
	 * BlockIDɊւĂAu̒߂̐eBlockIDƂ܂B
	 * @param strAiccID AiccID
	 */
	private void setBaseInfo( String strAiccID ) {
		// ":" Ńg[N܂
		StringTokenizer objToken = new StringTokenizer( strAiccID, ":" );

		//
		int i = 0;
		while( objToken.hasMoreElements() ) {
			switch(i) {
				case 0:
					// ID̎擾( ID͋ލ\擾B
					objToken.nextToken();
					break;
				case 1:
					// [UID̎擾
					objToken.nextToken();
					break;
				case 2:
					// LessonID̎擾
					mstrLessonID = objToken.nextToken();
					break;
				default:
					objToken.nextToken();
					break;
			}
			i++;
		}

		// bXIDɒ߂BlockID擾܂
		RDFNode objNode = mobjRDFNode.searchNode( mstrLessonID );
		if( objNode != null ) {
			RDFNode objParentNode = objNode.getParentNode();

			// UID̎擾
			mstrUid = objNode.getID();
			// UIDXgɒǉ
			mvecUidList.add( mstrUid );

			// ubNIDݒ肵܂
			mstrBlockID = objParentNode.getID();
		}
	}
	/**
	 * MaterialLogIDlMaterialLogID擾܂B<BR>
	 * @param strMaterialLogAttribute ID
	 * @return String MaterialLogID
	 */
	private String getMaterialLogID( String strMaterialLogAttribute ) {

		// ":" Ńg[N܂
		StringTokenizer objToken = new StringTokenizer( strMaterialLogAttribute, ":" );

		int i = 0;
		while( objToken.hasMoreElements() ) {
			switch(i) {
				case 0:
				case 1:
					i++;
					objToken.nextToken();
					continue;
				case 2:
					// MaterialLogID̎擾
					return objToken.nextToken();
				default:
					return "";
			}
		}
		return "";
	}
	/**
	 * MaterialLogIDlMaterialLogID擾܂B<BR>
	 * @param strMaterialLogAttribute ID
	 * @return String MaterialLogID
	 */
	public SectionLogRecord getMaterialMaterialLog() {

		if (mobjSectionLogRecords == null || mstrMaterialLogID == null) {
			return null;
		}

		SectionLogRecord objResult = null;

		for(int i = 0;i < mobjSectionLogRecords.length; i++) {

			if( mobjSectionLogRecords[i].getMaterialLogID().equals( mstrMaterialLogID ) ) {
				objResult = mobjSectionLogRecords[i];
				break;
			}
		}
		return objResult;
	}

	/**
	 * UIDXg擾܂
	 * @return String[] UIDXg
	 */
	public String[] getUidList() {
		Vector vecList = getUidList( mobjRDFNode );
		String[] strRes = new String[vecList.size()];
		vecList.copyInto(strRes);
		return strRes;
	}

	/**
	 * UIDXg擾܂B
	 * @return Vector UIDXg
	 */
	public Vector getUidList(RDFNode objNode) {
		Vector vecList = new Vector();

		RDFNodeList objNodeList = objNode.getChildNodes();
		int intLength = objNodeList.getLength();
		for( int i = 0; i < intLength; i++ ) {
			RDFNode objChildNode = objNodeList.getNode(i);
			if( objChildNode.getNodeType() == RDFNode.AU_NODE ) {
				// m[h^CvAȔꍇ
				vecList.add( objChildNode.getID() );
			}
			else {
				// m[h^CvAUȊȌꍇ͍ċAĂяo
				Vector vecChildList = getUidList(objChildNode);
				vecList.addAll( vecChildList );
			}
		}

		return vecList;
	}

	/**
	 *	w肳ꂽvf̒lԋp܂B<br>
	 *	@param InputNode m[hIuWFNg<br>
 	 *	@param NodeName Gg<br>
	 *	@return lBm[h擾łȂꍇnullԂB
	 *
	 */
	private String getNodeValueByName( NodeList InputNodeList, String NodeName ){
		String result = null;

		for ( int i=0; i < InputNodeList.getLength(); i++ ){
			if ( InputNodeList.item(i).getNodeName().equalsIgnoreCase( NodeName ) == true ){
				Node FirstChild = InputNodeList.item(i).getFirstChild();
				if ( FirstChild != null ){
					result = FirstChild.getNodeValue();
					break;
				}
			}
		}

		return result;
	}

	/**
	 *	Aiccm[hXgԋp܂B<br>
	 *	@param objElement GgIuWFNg<br>
 	 *	@param strTagName ^O<br>
	 *	@return lBAiccm[hXgԂB
	 *
	 */

	private static NodeList getElementsByTagName( Element objElement, String strTagName ) {
		AiccNodeList objList = new AiccNodeList();

		// null`FbN
		if( objElement == null ) {
			return objList;
		}

		// qXgċAsB
		NodeList objChildList = objElement.getChildNodes();
		Node objChildNode = null;
		for( int i = 0; i < objChildList.getLength(); i++ ) {
			objChildNode = objChildList.item(i);
			getElementsByTagNameReflex( objList, objChildNode, strTagName );
		}

		return objList;
	}
	/**
	 *	ċÅ_\bhB<br>
	 *	@param objList Aiccm[hIuWFNg<br>
 	 *	@param objNode GgIuWFNg<br>
	 *	@param strTagName ^O
	 *
	 */
	private static void getElementsByTagNameReflex( AiccNodeList objList, Node objNode, String strTagName ) {

		// null`FbN
		if( objList == null || objNode == null ) {
			return;
		}

		// eLXgm[h̏ꍇ͉return
		if(objNode.getNodeType() == Node.TEXT_NODE) {
			return;
		}


		// Element疼O擾啶𖳎ē`FbNs
		String NodeName = objNode.getNodeName();

		if( NodeName.equalsIgnoreCase(strTagName) ) {
			// }b`烊Xgɒǉ
			objList.add( objNode );
		}

		// qXgċAsB
		NodeList objChildList = objNode.getChildNodes();
		Node objChildNode = null;
		for( int i = 0; i < objChildList.getLength(); i++ ) {
			objChildNode = objChildList.item(i);
			getElementsByTagNameReflex( objList, objChildNode, strTagName );
		}
	}
	/**
	 * AiccNodeListCi[NX
	 * <PRE>
	 * eFNodeListC^tF[X̎Ci[NXōsB
	 * </PRE>
	 */

	static class AiccNodeList implements NodeList {

		// m[hێ
		private Vector vecNodeList = new Vector();

		/**
		 * getLength\bh
		 * @return m[hXgTCY
		 */
		public int getLength() {
			// Ɏ
			return vecNodeList.size();
		}

		/**
		 * item\bh̎
		 * @return index̒l
		 */
		public Node item(int index) {
			return (Node)vecNodeList.get(index);
		}

		/**
		 * Nodeǉ\bh
		 * m[hǉ
		 */
		public void add(Node node) {
			vecNodeList.add(node);
		}
	}
}

